// components/browser_apis/tab_strip/tab_strip_api_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_TYPES_MOJOM_DATA_VIEW_H_
#define COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/browser_apis/tab_strip/tab_strip_api_types.mojom-shared-internal.h"


namespace tabs_api::mojom {
class NodeIdDataView;

class PositionDataView;



}  // tabs_api::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tabs_api::mojom::NodeIdDataView> {
  using Data = ::tabs_api::mojom::internal::NodeId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::PositionDataView> {
  using Data = ::tabs_api::mojom::internal::Position_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace tabs_api::mojom {


enum class NodeId_Type : int32_t {
  
  kUnknown = 0,
  
  kContent = 1,
  
  kCollection = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, NodeId_Type value);
inline bool IsKnownEnumValue(NodeId_Type value) {
  return internal::NodeId_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class NodeIdDataView {
 public:
  NodeIdDataView() = default;

  NodeIdDataView(
      internal::NodeId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::tabs_api::mojom::NodeId_Type>(
        data_value, output);
  }
  NodeId_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tabs_api::mojom::NodeId_Type>(data_->type));
  }
 private:
  internal::NodeId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PositionDataView {
 public:
  PositionDataView() = default;

  PositionDataView(
      internal::Position_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParentIdDataView(
      NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParentId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::tabs_api::mojom::NodeIdDataView, UserType>(),
    "Attempting to read the optional `parent_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParentId` instead "
    "of `ReadParentId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->parent_id.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  uint32_t index() const {
    return data_->index;
  }
 private:
  internal::Position_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // tabs_api::mojom

#endif  // COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_TYPES_MOJOM_DATA_VIEW_H_