// components/browser_apis/tab_strip/tab_strip_api_data_model.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-params-data.h"
#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-shared-message-ids.h"

#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-import-headers.h"
#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-test-utils.h"


namespace tabs_api::mojom {
Image::Image()
    : data_url() {}

Image::Image(
    const ::GURL& data_url_in)
    : data_url(std::move(data_url_in)) {}

Image::~Image() = default;

void Image::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_url"), this->data_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Image::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Tab::Tab()
    : id(),
      title(),
      url(),
      favicon(),
      alert_states(),
      network_state(),
      is_active(),
      is_selected(),
      is_blocked() {}

Tab::Tab(
    const ::tabs_api::NodeId& id_in,
    const std::string& title_in,
    const ::GURL& url_in,
    const ::gfx::ImageSkia& favicon_in,
    std::vector<AlertState> alert_states_in,
    NetworkState network_state_in,
    bool is_active_in,
    bool is_selected_in,
    bool is_blocked_in)
    : id(std::move(id_in)),
      title(std::move(title_in)),
      url(std::move(url_in)),
      favicon(std::move(favicon_in)),
      alert_states(std::move(alert_states_in)),
      network_state(std::move(network_state_in)),
      is_active(std::move(is_active_in)),
      is_selected(std::move(is_selected_in)),
      is_blocked(std::move(is_blocked_in)) {}

Tab::~Tab() = default;

void Tab::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::tabs_api::NodeId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon"), this->favicon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ImageSkia&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alert_states"), this->alert_states,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<AlertState>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "network_state"), this->network_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NetworkState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_active"), this->is_active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_selected"), this->is_selected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_blocked"), this->is_blocked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Tab::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabStrip::TabStrip()
    : id() {}

TabStrip::TabStrip(
    const ::tabs_api::NodeId& id_in)
    : id(std::move(id_in)) {}

TabStrip::~TabStrip() = default;

void TabStrip::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::tabs_api::NodeId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabStrip::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PinnedTabs::PinnedTabs()
    : id() {}

PinnedTabs::PinnedTabs(
    const ::tabs_api::NodeId& id_in)
    : id(std::move(id_in)) {}

PinnedTabs::~PinnedTabs() = default;

void PinnedTabs::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::tabs_api::NodeId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinnedTabs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UnpinnedTabs::UnpinnedTabs()
    : id() {}

UnpinnedTabs::UnpinnedTabs(
    const ::tabs_api::NodeId& id_in)
    : id(std::move(id_in)) {}

UnpinnedTabs::~UnpinnedTabs() = default;

void UnpinnedTabs::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::tabs_api::NodeId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UnpinnedTabs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabGroup::TabGroup()
    : id(),
      data() {}

TabGroup::TabGroup(
    const ::tabs_api::NodeId& id_in,
    const ::tab_groups::TabGroupVisualData& data_in)
    : id(std::move(id_in)),
      data(std::move(data_in)) {}

TabGroup::~TabGroup() = default;

void TabGroup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::tabs_api::NodeId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::tab_groups::TabGroupVisualData&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabGroupVisualData::TabGroupVisualData()
    : title(),
      color(),
      is_collapsed() {}

TabGroupVisualData::TabGroupVisualData(
    const std::string& title_in,
    ::tab_groups::TabGroupColorId color_in,
    bool is_collapsed_in)
    : title(std::move(title_in)),
      color(std::move(color_in)),
      is_collapsed(std::move(is_collapsed_in)) {}

TabGroupVisualData::~TabGroupVisualData() = default;

void TabGroupVisualData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::tab_groups::TabGroupColorId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_collapsed"), this->is_collapsed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabGroupVisualData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SplitTab::SplitTab()
    : id(),
      data() {}

SplitTab::SplitTab(
    const ::tabs_api::NodeId& id_in,
    const ::split_tabs::SplitTabVisualData& data_in)
    : id(std::move(id_in)),
      data(std::move(data_in)) {}

SplitTab::~SplitTab() = default;

void SplitTab::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::tabs_api::NodeId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::split_tabs::SplitTabVisualData&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SplitTab::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SplitTabVisualData::SplitTabVisualData()
    : layout(),
      split_ratio() {}

SplitTabVisualData::SplitTabVisualData(
    SplitTabVisualData::Layout layout_in,
    double split_ratio_in)
    : layout(std::move(layout_in)),
      split_ratio(std::move(split_ratio_in)) {}

SplitTabVisualData::~SplitTabVisualData() = default;

void SplitTabVisualData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout"), this->layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SplitTabVisualData::Layout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "split_ratio"), this->split_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SplitTabVisualData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Container::Container()
    : data(),
      children() {}

Container::Container(
    DataPtr data_in,
    std::vector<ContainerPtr> children_in)
    : data(std::move(data_in)),
      children(std::move(children_in)) {}

Container::~Container() = default;

void Container::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children"), this->children,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ContainerPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Container::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabCreatedContainer::TabCreatedContainer()
    : tab(),
      position() {}

TabCreatedContainer::TabCreatedContainer(
    TabPtr tab_in,
    const ::tabs_api::Position& position_in)
    : tab(std::move(tab_in)),
      position(std::move(position_in)) {}

TabCreatedContainer::~TabCreatedContainer() = default;

void TabCreatedContainer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab"), this->tab,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position"), this->position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::tabs_api::Position&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabCreatedContainer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataPtr
Data::NewTab(
    TabPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTab)>,
      std::move(value));
}

DataPtr
Data::NewTabStrip(
    TabStripPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTabStrip)>,
      std::move(value));
}

DataPtr
Data::NewPinnedTabs(
    PinnedTabsPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPinnedTabs)>,
      std::move(value));
}

DataPtr
Data::NewUnpinnedTabs(
    UnpinnedTabsPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUnpinnedTabs)>,
      std::move(value));
}

DataPtr
Data::NewTabGroup(
    TabGroupPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTabGroup)>,
      std::move(value));
}

DataPtr
Data::NewSplitTab(
    SplitTabPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSplitTab)>,
      std::move(value));
}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kTab)>,
    TabPtr value)
    : tag_(Tag::kTab),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTab)>,
            std::move(value)) {}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabStrip)>,
    TabStripPtr value)
    : tag_(Tag::kTabStrip),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTabStrip)>,
            std::move(value)) {}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kPinnedTabs)>,
    PinnedTabsPtr value)
    : tag_(Tag::kPinnedTabs),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPinnedTabs)>,
            std::move(value)) {}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnpinnedTabs)>,
    UnpinnedTabsPtr value)
    : tag_(Tag::kUnpinnedTabs),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUnpinnedTabs)>,
            std::move(value)) {}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabGroup)>,
    TabGroupPtr value)
    : tag_(Tag::kTabGroup),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTabGroup)>,
            std::move(value)) {}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kSplitTab)>,
    SplitTabPtr value)
    : tag_(Tag::kSplitTab),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSplitTab)>,
            std::move(value)) {}
Data::~Data() {
  DestroyActive();
}

void Data::set_tab(TabPtr tab) {
  if (tag_ == Tag::kTab) {
    data_.tab = std::move(tab);
  } else {
    DestroyActive();
    tag_ = Tag::kTab;
    new (&data_.tab) TabPtr(
        std::move(tab));
  }
}

void Data::set_tab_strip(TabStripPtr tab_strip) {
  if (tag_ == Tag::kTabStrip) {
    data_.tab_strip = std::move(tab_strip);
  } else {
    DestroyActive();
    tag_ = Tag::kTabStrip;
    new (&data_.tab_strip) TabStripPtr(
        std::move(tab_strip));
  }
}

void Data::set_pinned_tabs(PinnedTabsPtr pinned_tabs) {
  if (tag_ == Tag::kPinnedTabs) {
    data_.pinned_tabs = std::move(pinned_tabs);
  } else {
    DestroyActive();
    tag_ = Tag::kPinnedTabs;
    new (&data_.pinned_tabs) PinnedTabsPtr(
        std::move(pinned_tabs));
  }
}

void Data::set_unpinned_tabs(UnpinnedTabsPtr unpinned_tabs) {
  if (tag_ == Tag::kUnpinnedTabs) {
    data_.unpinned_tabs = std::move(unpinned_tabs);
  } else {
    DestroyActive();
    tag_ = Tag::kUnpinnedTabs;
    new (&data_.unpinned_tabs) UnpinnedTabsPtr(
        std::move(unpinned_tabs));
  }
}

void Data::set_tab_group(TabGroupPtr tab_group) {
  if (tag_ == Tag::kTabGroup) {
    data_.tab_group = std::move(tab_group);
  } else {
    DestroyActive();
    tag_ = Tag::kTabGroup;
    new (&data_.tab_group) TabGroupPtr(
        std::move(tab_group));
  }
}

void Data::set_split_tab(SplitTabPtr split_tab) {
  if (tag_ == Tag::kSplitTab) {
    data_.split_tab = std::move(split_tab);
  } else {
    DestroyActive();
    tag_ = Tag::kSplitTab;
    new (&data_.split_tab) SplitTabPtr(
        std::move(split_tab));
  }
}


Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTab)>,
    TabPtr value)
    : tab(std::move(value)) {}

Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabStrip)>,
    TabStripPtr value)
    : tab_strip(std::move(value)) {}

Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPinnedTabs)>,
    PinnedTabsPtr value)
    : pinned_tabs(std::move(value)) {}

Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnpinnedTabs)>,
    UnpinnedTabsPtr value)
    : unpinned_tabs(std::move(value)) {}

Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabGroup)>,
    TabGroupPtr value)
    : tab_group(std::move(value)) {}

Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSplitTab)>,
    SplitTabPtr value)
    : split_tab(std::move(value)) {}

void Data::DestroyActive() {
  switch (tag_) {

    case Tag::kTab:
      std::destroy_at(&data_.tab);
      break;
    case Tag::kTabStrip:
      std::destroy_at(&data_.tab_strip);
      break;
    case Tag::kPinnedTabs:
      std::destroy_at(&data_.pinned_tabs);
      break;
    case Tag::kUnpinnedTabs:
      std::destroy_at(&data_.unpinned_tabs);
      break;
    case Tag::kTabGroup:
      std::destroy_at(&data_.tab_group);
      break;
    case Tag::kSplitTab:
      std::destroy_at(&data_.split_tab);
      break;
  }
}

bool Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // tabs_api::mojom


namespace mojo {


// static
bool StructTraits<::tabs_api::mojom::Image::DataView, ::tabs_api::mojom::ImagePtr>::Read(
    ::tabs_api::mojom::Image::DataView input,
    ::tabs_api::mojom::ImagePtr* output) {
  bool success = true;
  ::tabs_api::mojom::ImagePtr result(::tabs_api::mojom::Image::New());
  
      if (success && !input.ReadDataUrl(&result->data_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tabs_api::mojom::Tab::DataView, ::tabs_api::mojom::TabPtr>::Read(
    ::tabs_api::mojom::Tab::DataView input,
    ::tabs_api::mojom::TabPtr* output) {
  bool success = true;
  ::tabs_api::mojom::TabPtr result(::tabs_api::mojom::Tab::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadFavicon(&result->favicon))
        success = false;
      if (success && !input.ReadAlertStates(&result->alert_states))
        success = false;
      if (success && !input.ReadNetworkState(&result->network_state))
        success = false;
      if (success)
        result->is_active = input.is_active();
      if (success)
        result->is_selected = input.is_selected();
      if (success)
        result->is_blocked = input.is_blocked();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tabs_api::mojom::TabStrip::DataView, ::tabs_api::mojom::TabStripPtr>::Read(
    ::tabs_api::mojom::TabStrip::DataView input,
    ::tabs_api::mojom::TabStripPtr* output) {
  bool success = true;
  ::tabs_api::mojom::TabStripPtr result(::tabs_api::mojom::TabStrip::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tabs_api::mojom::PinnedTabs::DataView, ::tabs_api::mojom::PinnedTabsPtr>::Read(
    ::tabs_api::mojom::PinnedTabs::DataView input,
    ::tabs_api::mojom::PinnedTabsPtr* output) {
  bool success = true;
  ::tabs_api::mojom::PinnedTabsPtr result(::tabs_api::mojom::PinnedTabs::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tabs_api::mojom::UnpinnedTabs::DataView, ::tabs_api::mojom::UnpinnedTabsPtr>::Read(
    ::tabs_api::mojom::UnpinnedTabs::DataView input,
    ::tabs_api::mojom::UnpinnedTabsPtr* output) {
  bool success = true;
  ::tabs_api::mojom::UnpinnedTabsPtr result(::tabs_api::mojom::UnpinnedTabs::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tabs_api::mojom::TabGroup::DataView, ::tabs_api::mojom::TabGroupPtr>::Read(
    ::tabs_api::mojom::TabGroup::DataView input,
    ::tabs_api::mojom::TabGroupPtr* output) {
  bool success = true;
  ::tabs_api::mojom::TabGroupPtr result(::tabs_api::mojom::TabGroup::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tabs_api::mojom::TabGroupVisualData::DataView, ::tabs_api::mojom::TabGroupVisualDataPtr>::Read(
    ::tabs_api::mojom::TabGroupVisualData::DataView input,
    ::tabs_api::mojom::TabGroupVisualDataPtr* output) {
  bool success = true;
  ::tabs_api::mojom::TabGroupVisualDataPtr result(::tabs_api::mojom::TabGroupVisualData::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success)
        result->is_collapsed = input.is_collapsed();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tabs_api::mojom::SplitTab::DataView, ::tabs_api::mojom::SplitTabPtr>::Read(
    ::tabs_api::mojom::SplitTab::DataView input,
    ::tabs_api::mojom::SplitTabPtr* output) {
  bool success = true;
  ::tabs_api::mojom::SplitTabPtr result(::tabs_api::mojom::SplitTab::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tabs_api::mojom::SplitTabVisualData::DataView, ::tabs_api::mojom::SplitTabVisualDataPtr>::Read(
    ::tabs_api::mojom::SplitTabVisualData::DataView input,
    ::tabs_api::mojom::SplitTabVisualDataPtr* output) {
  bool success = true;
  ::tabs_api::mojom::SplitTabVisualDataPtr result(::tabs_api::mojom::SplitTabVisualData::New());
  
      if (success && !input.ReadLayout(&result->layout))
        success = false;
      if (success)
        result->split_ratio = input.split_ratio();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tabs_api::mojom::Container::DataView, ::tabs_api::mojom::ContainerPtr>::Read(
    ::tabs_api::mojom::Container::DataView input,
    ::tabs_api::mojom::ContainerPtr* output) {
  bool success = true;
  ::tabs_api::mojom::ContainerPtr result(::tabs_api::mojom::Container::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadChildren(&result->children))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tabs_api::mojom::TabCreatedContainer::DataView, ::tabs_api::mojom::TabCreatedContainerPtr>::Read(
    ::tabs_api::mojom::TabCreatedContainer::DataView input,
    ::tabs_api::mojom::TabCreatedContainerPtr* output) {
  bool success = true;
  ::tabs_api::mojom::TabCreatedContainerPtr result(::tabs_api::mojom::TabCreatedContainer::New());
  
      if (success && !input.ReadTab(&result->tab))
        success = false;
      if (success && !input.ReadPosition(&result->position))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::tabs_api::mojom::Data::DataView, ::tabs_api::mojom::DataPtr>::Read(
    ::tabs_api::mojom::Data::DataView input,
    ::tabs_api::mojom::DataPtr* output) {
  using UnionType = ::tabs_api::mojom::Data;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kTab: {
      ::tabs_api::mojom::TabPtr result_tab{};
      if (!input.ReadTab(&result_tab))
        return false;

      *output = UnionType::NewTab(
          std::move(result_tab));
      break;
    }
    case Tag::kTabStrip: {
      ::tabs_api::mojom::TabStripPtr result_tab_strip{};
      if (!input.ReadTabStrip(&result_tab_strip))
        return false;

      *output = UnionType::NewTabStrip(
          std::move(result_tab_strip));
      break;
    }
    case Tag::kPinnedTabs: {
      ::tabs_api::mojom::PinnedTabsPtr result_pinned_tabs{};
      if (!input.ReadPinnedTabs(&result_pinned_tabs))
        return false;

      *output = UnionType::NewPinnedTabs(
          std::move(result_pinned_tabs));
      break;
    }
    case Tag::kUnpinnedTabs: {
      ::tabs_api::mojom::UnpinnedTabsPtr result_unpinned_tabs{};
      if (!input.ReadUnpinnedTabs(&result_unpinned_tabs))
        return false;

      *output = UnionType::NewUnpinnedTabs(
          std::move(result_unpinned_tabs));
      break;
    }
    case Tag::kTabGroup: {
      ::tabs_api::mojom::TabGroupPtr result_tab_group{};
      if (!input.ReadTabGroup(&result_tab_group))
        return false;

      *output = UnionType::NewTabGroup(
          std::move(result_tab_group));
      break;
    }
    case Tag::kSplitTab: {
      ::tabs_api::mojom::SplitTabPtr result_split_tab{};
      if (!input.ReadSplitTab(&result_split_tab))
        return false;

      *output = UnionType::NewSplitTab(
          std::move(result_split_tab));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace tabs_api::mojom {




}  // tabs_api::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif