// components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_DATA_MODEL_MOJOM_DATA_VIEW_H_
#define COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_DATA_MODEL_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-shared-internal.h"
#include "components/browser_apis/tab_strip/tab_strip_api_types.mojom-shared.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace tabs_api::mojom {
class ImageDataView;

class TabDataView;

class TabStripDataView;

class PinnedTabsDataView;

class UnpinnedTabsDataView;

class TabGroupDataView;

class TabGroupVisualDataDataView;

class SplitTabDataView;

class SplitTabVisualDataDataView;

class ContainerDataView;

class TabCreatedContainerDataView;

class DataDataView;


}  // tabs_api::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tabs_api::mojom::ImageDataView> {
  using Data = ::tabs_api::mojom::internal::Image_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabDataView> {
  using Data = ::tabs_api::mojom::internal::Tab_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabStripDataView> {
  using Data = ::tabs_api::mojom::internal::TabStrip_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::PinnedTabsDataView> {
  using Data = ::tabs_api::mojom::internal::PinnedTabs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::UnpinnedTabsDataView> {
  using Data = ::tabs_api::mojom::internal::UnpinnedTabs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabGroupDataView> {
  using Data = ::tabs_api::mojom::internal::TabGroup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabGroupVisualDataDataView> {
  using Data = ::tabs_api::mojom::internal::TabGroupVisualData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::SplitTabDataView> {
  using Data = ::tabs_api::mojom::internal::SplitTab_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::SplitTabVisualDataDataView> {
  using Data = ::tabs_api::mojom::internal::SplitTabVisualData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::ContainerDataView> {
  using Data = ::tabs_api::mojom::internal::Container_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabCreatedContainerDataView> {
  using Data = ::tabs_api::mojom::internal::TabCreatedContainer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::DataDataView> {
  using Data = ::tabs_api::mojom::internal::Data_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace tabs_api::mojom {


enum class AlertState : int32_t {
  
  kAudioMuting = 0,
  
  kAudioRecording = 1,
  
  kAudioPlaying = 2,
  
  kBluetoothConnected = 3,
  
  kBluetoothScanActive = 4,
  
  kDesktopCapturing = 5,
  
  kActorAccessing = 6,
  
  kActorWaitingOnUser = 7,
  
  kGlicAccessing = 8,
  
  kGlicSharing = 9,
  
  kHidConnected = 10,
  
  kMediaRecording = 11,
  
  kPipPlaying = 12,
  
  kSerialConnected = 13,
  
  kTabCapturing = 14,
  
  kUsbConnected = 15,
  
  kVideoRecording = 16,
  
  kVrPresentingInHeadset = 17,
  kMinValue = 0,
  kMaxValue = 17,
};

 std::ostream& operator<<(std::ostream& os, AlertState value);
inline bool IsKnownEnumValue(AlertState value) {
  return internal::AlertState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NetworkState : int32_t {
  
  kNone = 0,
  
  kWaiting = 1,
  
  kLoading = 2,
  
  kError = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, NetworkState value);
inline bool IsKnownEnumValue(NetworkState value) {
  return internal::NetworkState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SplitTabVisualData_Layout : int32_t {
  
  kVertical = 0,
  
  kHorizontal = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SplitTabVisualData_Layout value);
inline bool IsKnownEnumValue(SplitTabVisualData_Layout value) {
  return internal::SplitTabVisualData_Layout_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ImageDataView {
 public:
  ImageDataView() = default;

  ImageDataView(
      internal::Image_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataUrl(UserType* output) {
    
    auto* pointer = data_->data_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::Image_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabDataView {
 public:
  TabDataView() = default;

  TabDataView(
      internal::Tab_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::tabs_api::mojom::NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetFaviconDataView(
      ImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFavicon(UserType* output) {
    
    auto* pointer = data_->favicon.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::ImageDataView>(
        pointer, output, message_);
  }
  inline void GetAlertStatesDataView(
      mojo::ArrayDataView<AlertState>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlertStates(UserType* output) {
    
    auto* pointer = data_->alert_states.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tabs_api::mojom::AlertState>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNetworkState(UserType* output) const {
    auto data_value = data_->network_state;
    return mojo::internal::Deserialize<::tabs_api::mojom::NetworkState>(
        data_value, output);
  }
  NetworkState network_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tabs_api::mojom::NetworkState>(data_->network_state));
  }
  bool is_active() const {
    return data_->is_active;
  }
  bool is_selected() const {
    return data_->is_selected;
  }
  bool is_blocked() const {
    return data_->is_blocked;
  }
 private:
  internal::Tab_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabStripDataView {
 public:
  TabStripDataView() = default;

  TabStripDataView(
      internal::TabStrip_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::tabs_api::mojom::NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabStrip_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PinnedTabsDataView {
 public:
  PinnedTabsDataView() = default;

  PinnedTabsDataView(
      internal::PinnedTabs_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::tabs_api::mojom::NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::PinnedTabs_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UnpinnedTabsDataView {
 public:
  UnpinnedTabsDataView() = default;

  UnpinnedTabsDataView(
      internal::UnpinnedTabs_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::tabs_api::mojom::NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::UnpinnedTabs_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabGroupDataView {
 public:
  TabGroupDataView() = default;

  TabGroupDataView(
      internal::TabGroup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::tabs_api::mojom::NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      TabGroupVisualDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::TabGroupVisualDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabGroup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabGroupVisualDataDataView {
 public:
  TabGroupVisualDataDataView() = default;

  TabGroupVisualDataDataView(
      internal::TabGroupVisualData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) const {
    auto data_value = data_->color;
    return mojo::internal::Deserialize<::tab_groups::mojom::Color>(
        data_value, output);
  }
  ::tab_groups::mojom::Color color() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tab_groups::mojom::Color>(data_->color));
  }
  bool is_collapsed() const {
    return data_->is_collapsed;
  }
 private:
  internal::TabGroupVisualData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SplitTabDataView {
 public:
  SplitTabDataView() = default;

  SplitTabDataView(
      internal::SplitTab_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::tabs_api::mojom::NodeIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::NodeIdDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      SplitTabVisualDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::SplitTabVisualDataDataView>(
        pointer, output, message_);
  }
 private:
  internal::SplitTab_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SplitTabVisualDataDataView {
 public:
  SplitTabVisualDataDataView() = default;

  SplitTabVisualDataDataView(
      internal::SplitTabVisualData_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadLayout(UserType* output) const {
    auto data_value = data_->layout;
    return mojo::internal::Deserialize<::tabs_api::mojom::SplitTabVisualData_Layout>(
        data_value, output);
  }
  SplitTabVisualData_Layout layout() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tabs_api::mojom::SplitTabVisualData_Layout>(data_->layout));
  }
  double split_ratio() const {
    return data_->split_ratio;
  }
 private:
  internal::SplitTabVisualData_Data* data_ = nullptr;
};


class ContainerDataView {
 public:
  ContainerDataView() = default;

  ContainerDataView(
      internal::Container_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      DataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::tabs_api::mojom::DataDataView>(
        pointer, output, message_);
  }
  inline void GetChildrenDataView(
      mojo::ArrayDataView<ContainerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tabs_api::mojom::ContainerDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Container_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabCreatedContainerDataView {
 public:
  TabCreatedContainerDataView() = default;

  TabCreatedContainerDataView(
      internal::TabCreatedContainer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabDataView(
      TabDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTab(UserType* output) {
    
    auto* pointer = data_->tab.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::TabDataView>(
        pointer, output, message_);
  }
  inline void GetPositionDataView(
      ::tabs_api::mojom::PositionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::PositionDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabCreatedContainer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataDataView {
 public:
  using Tag = internal::Data_Data::Data_Tag;

  DataDataView() = default;

  DataDataView(
      internal::Data_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_tab() const { return data_->tag == Tag::kTab; }
  inline void GetTabDataView(
      TabDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTab(UserType* output) const {
    
    CHECK(is_tab());
    return mojo::internal::Deserialize<::tabs_api::mojom::TabDataView>(
        data_->data.f_tab.Get(), output, message_);
  }
  bool is_tab_strip() const { return data_->tag == Tag::kTabStrip; }
  inline void GetTabStripDataView(
      TabStripDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTabStrip(UserType* output) const {
    
    CHECK(is_tab_strip());
    return mojo::internal::Deserialize<::tabs_api::mojom::TabStripDataView>(
        data_->data.f_tab_strip.Get(), output, message_);
  }
  bool is_pinned_tabs() const { return data_->tag == Tag::kPinnedTabs; }
  inline void GetPinnedTabsDataView(
      PinnedTabsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPinnedTabs(UserType* output) const {
    
    CHECK(is_pinned_tabs());
    return mojo::internal::Deserialize<::tabs_api::mojom::PinnedTabsDataView>(
        data_->data.f_pinned_tabs.Get(), output, message_);
  }
  bool is_unpinned_tabs() const { return data_->tag == Tag::kUnpinnedTabs; }
  inline void GetUnpinnedTabsDataView(
      UnpinnedTabsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUnpinnedTabs(UserType* output) const {
    
    CHECK(is_unpinned_tabs());
    return mojo::internal::Deserialize<::tabs_api::mojom::UnpinnedTabsDataView>(
        data_->data.f_unpinned_tabs.Get(), output, message_);
  }
  bool is_tab_group() const { return data_->tag == Tag::kTabGroup; }
  inline void GetTabGroupDataView(
      TabGroupDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTabGroup(UserType* output) const {
    
    CHECK(is_tab_group());
    return mojo::internal::Deserialize<::tabs_api::mojom::TabGroupDataView>(
        data_->data.f_tab_group.Get(), output, message_);
  }
  bool is_split_tab() const { return data_->tag == Tag::kSplitTab; }
  inline void GetSplitTabDataView(
      SplitTabDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSplitTab(UserType* output) const {
    
    CHECK(is_split_tab());
    return mojo::internal::Deserialize<::tabs_api::mojom::SplitTabDataView>(
        data_->data.f_split_tab.Get(), output, message_);
  }

 private:
  internal::Data_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // tabs_api::mojom

#endif  // COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_DATA_MODEL_MOJOM_DATA_VIEW_H_