// components/browser_apis/tab_strip/tab_strip_api.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_SHARED_H_
#define COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/browser_apis/tab_strip/tab_strip_api.mojom-shared-internal.h"
#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-shared.h"
#include "components/browser_apis/tab_strip/tab_strip_api_events.mojom-shared.h"
#include "components/browser_apis/tab_strip/tab_strip_api_types.mojom-shared.h"
#include "mojo/public/mojom/base/empty.mojom-shared.h"
#include "mojo/public/mojom/base/error.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/browser_apis/tab_strip/tab_strip_api.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabsSnapshotDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabsSnapshotDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::TabsSnapshot_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tab_strip(input)) in_tab_strip = Traits::tab_strip(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_strip)::BaseType> tab_strip_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::ContainerDataView>(
      in_tab_strip,
      tab_strip_fragment);

    fragment->tab_strip.Set(
        tab_strip_fragment.is_null() ? nullptr : tab_strip_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tab_strip.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tab_strip in TabsSnapshot struct");

    decltype(Traits::stream(input)) in_stream = Traits::stream(input);

    
    mojo::internal::Serialize<::tabs_api::mojom::TabsObserverAssociatedRequestDataView>(
      in_stream,
      &fragment->stream,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->stream)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid stream in TabsSnapshot struct");
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabsSnapshot_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabsSnapshotDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabsEventDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabsEventDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabsEvent_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabsEventDataView::Tag::kTabsCreatedEvent: {
    decltype(Traits::tabs_created_event(input))
    in_tabs_created_event = Traits::tabs_created_event(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tabs_created_event)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::OnTabsCreatedEventDataView>(
  in_tabs_created_event,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tabs_created_event in TabsEvent union");
    fragment->data.f_tabs_created_event.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabsEventDataView::Tag::kTabsClosedEvent: {
    decltype(Traits::tabs_closed_event(input))
    in_tabs_closed_event = Traits::tabs_closed_event(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tabs_closed_event)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::OnTabsClosedEventDataView>(
  in_tabs_closed_event,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tabs_closed_event in TabsEvent union");
    fragment->data.f_tabs_closed_event.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabsEventDataView::Tag::kNodeMovedEvent: {
    decltype(Traits::node_moved_event(input))
    in_node_moved_event = Traits::node_moved_event(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_node_moved_event)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::OnNodeMovedEventDataView>(
  in_node_moved_event,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null node_moved_event in TabsEvent union");
    fragment->data.f_node_moved_event.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabsEventDataView::Tag::kDataChangedEvent: {
    decltype(Traits::data_changed_event(input))
    in_data_changed_event = Traits::data_changed_event(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data_changed_event)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::OnDataChangedEventDataView>(
  in_data_changed_event,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data_changed_event in TabsEvent union");
    fragment->data.f_data_changed_event.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabsEventDataView::Tag::kCollectionCreatedEvent: {
    decltype(Traits::collection_created_event(input))
    in_collection_created_event = Traits::collection_created_event(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_collection_created_event)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::OnCollectionCreatedEventDataView>(
  in_collection_created_event,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null collection_created_event in TabsEvent union");
    fragment->data.f_collection_created_event.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabsEvent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabsEventDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_GetTabs_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabsSnapshotDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_GetTabs_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_GetTabs_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabStripService_GetTabs_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_GetTab_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_GetTab_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_GetTab_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabStripService_GetTab_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_CreateTabAt_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_CreateTabAt_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_CreateTabAt_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabStripService_CreateTabAt_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_CloseTabs_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::EmptyDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_CloseTabs_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_CloseTabs_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabStripService_CloseTabs_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_ActivateTab_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::EmptyDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_ActivateTab_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_ActivateTab_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabStripService_ActivateTab_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_SetSelectedTabs_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::EmptyDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_SetSelectedTabs_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_SetSelectedTabs_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabStripService_SetSelectedTabs_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::TabStripService_MoveNode_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::EmptyDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in TabStripService_MoveNode_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_failure)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::ErrorDataView>(
  in_failure,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null failure in TabStripService_MoveNode_ResponseParam_Result union");
    fragment->data.f_failure.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabStripService_MoveNode_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tabs_api::mojom {

inline void TabsSnapshotDataView::GetTabStripDataView(
    ::tabs_api::mojom::ContainerDataView* output) {
  auto pointer = data_->tab_strip.Get();
  *output = ::tabs_api::mojom::ContainerDataView(pointer, message_);
}


inline void TabsEventDataView::GetTabsCreatedEventDataView(
    ::tabs_api::mojom::OnTabsCreatedEventDataView* output) const {
  CHECK(is_tabs_created_event());
  *output = ::tabs_api::mojom::OnTabsCreatedEventDataView(data_->data.f_tabs_created_event.Get(), message_);
}
inline void TabsEventDataView::GetTabsClosedEventDataView(
    ::tabs_api::mojom::OnTabsClosedEventDataView* output) const {
  CHECK(is_tabs_closed_event());
  *output = ::tabs_api::mojom::OnTabsClosedEventDataView(data_->data.f_tabs_closed_event.Get(), message_);
}
inline void TabsEventDataView::GetNodeMovedEventDataView(
    ::tabs_api::mojom::OnNodeMovedEventDataView* output) const {
  CHECK(is_node_moved_event());
  *output = ::tabs_api::mojom::OnNodeMovedEventDataView(data_->data.f_node_moved_event.Get(), message_);
}
inline void TabsEventDataView::GetDataChangedEventDataView(
    ::tabs_api::mojom::OnDataChangedEventDataView* output) const {
  CHECK(is_data_changed_event());
  *output = ::tabs_api::mojom::OnDataChangedEventDataView(data_->data.f_data_changed_event.Get(), message_);
}
inline void TabsEventDataView::GetCollectionCreatedEventDataView(
    ::tabs_api::mojom::OnCollectionCreatedEventDataView* output) const {
  CHECK(is_collection_created_event());
  *output = ::tabs_api::mojom::OnCollectionCreatedEventDataView(data_->data.f_collection_created_event.Get(), message_);
}

inline void TabStripService_GetTabs_ResponseParam_ResultDataView::GetSuccessDataView(
    TabsSnapshotDataView* output) const {
  CHECK(is_success());
  *output = TabsSnapshotDataView(data_->data.f_success.Get(), message_);
}
inline void TabStripService_GetTabs_ResponseParam_ResultDataView::GetFailureDataView(
    ::mojo_base::mojom::ErrorDataView* output) const {
  CHECK(is_failure());
  *output = ::mojo_base::mojom::ErrorDataView(data_->data.f_failure.Get(), message_);
}

inline void TabStripService_GetTab_ResponseParam_ResultDataView::GetSuccessDataView(
    ::tabs_api::mojom::TabDataView* output) const {
  CHECK(is_success());
  *output = ::tabs_api::mojom::TabDataView(data_->data.f_success.Get(), message_);
}
inline void TabStripService_GetTab_ResponseParam_ResultDataView::GetFailureDataView(
    ::mojo_base::mojom::ErrorDataView* output) const {
  CHECK(is_failure());
  *output = ::mojo_base::mojom::ErrorDataView(data_->data.f_failure.Get(), message_);
}

inline void TabStripService_CreateTabAt_ResponseParam_ResultDataView::GetSuccessDataView(
    ::tabs_api::mojom::TabDataView* output) const {
  CHECK(is_success());
  *output = ::tabs_api::mojom::TabDataView(data_->data.f_success.Get(), message_);
}
inline void TabStripService_CreateTabAt_ResponseParam_ResultDataView::GetFailureDataView(
    ::mojo_base::mojom::ErrorDataView* output) const {
  CHECK(is_failure());
  *output = ::mojo_base::mojom::ErrorDataView(data_->data.f_failure.Get(), message_);
}

inline void TabStripService_CloseTabs_ResponseParam_ResultDataView::GetSuccessDataView(
    ::mojo_base::mojom::EmptyDataView* output) const {
  CHECK(is_success());
  *output = ::mojo_base::mojom::EmptyDataView(data_->data.f_success.Get(), message_);
}
inline void TabStripService_CloseTabs_ResponseParam_ResultDataView::GetFailureDataView(
    ::mojo_base::mojom::ErrorDataView* output) const {
  CHECK(is_failure());
  *output = ::mojo_base::mojom::ErrorDataView(data_->data.f_failure.Get(), message_);
}

inline void TabStripService_ActivateTab_ResponseParam_ResultDataView::GetSuccessDataView(
    ::mojo_base::mojom::EmptyDataView* output) const {
  CHECK(is_success());
  *output = ::mojo_base::mojom::EmptyDataView(data_->data.f_success.Get(), message_);
}
inline void TabStripService_ActivateTab_ResponseParam_ResultDataView::GetFailureDataView(
    ::mojo_base::mojom::ErrorDataView* output) const {
  CHECK(is_failure());
  *output = ::mojo_base::mojom::ErrorDataView(data_->data.f_failure.Get(), message_);
}

inline void TabStripService_SetSelectedTabs_ResponseParam_ResultDataView::GetSuccessDataView(
    ::mojo_base::mojom::EmptyDataView* output) const {
  CHECK(is_success());
  *output = ::mojo_base::mojom::EmptyDataView(data_->data.f_success.Get(), message_);
}
inline void TabStripService_SetSelectedTabs_ResponseParam_ResultDataView::GetFailureDataView(
    ::mojo_base::mojom::ErrorDataView* output) const {
  CHECK(is_failure());
  *output = ::mojo_base::mojom::ErrorDataView(data_->data.f_failure.Get(), message_);
}

inline void TabStripService_MoveNode_ResponseParam_ResultDataView::GetSuccessDataView(
    ::mojo_base::mojom::EmptyDataView* output) const {
  CHECK(is_success());
  *output = ::mojo_base::mojom::EmptyDataView(data_->data.f_success.Get(), message_);
}
inline void TabStripService_MoveNode_ResponseParam_ResultDataView::GetFailureDataView(
    ::mojo_base::mojom::ErrorDataView* output) const {
  CHECK(is_failure());
  *output = ::mojo_base::mojom::ErrorDataView(data_->data.f_failure.Get(), message_);
}


}  // tabs_api::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_SHARED_H_