// components/browser_apis/tab_strip/tab_strip_api.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_DATA_VIEW_H_
#define COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/browser_apis/tab_strip/tab_strip_api.mojom-shared-internal.h"
#include "components/browser_apis/tab_strip/tab_strip_api_data_model.mojom-shared.h"
#include "components/browser_apis/tab_strip/tab_strip_api_events.mojom-shared.h"
#include "components/browser_apis/tab_strip/tab_strip_api_types.mojom-shared.h"
#include "mojo/public/mojom/base/empty.mojom-shared.h"
#include "mojo/public/mojom/base/error.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace tabs_api::mojom {
class TabsSnapshotDataView;

class TabsEventDataView;
class TabStripService_GetTabs_ResponseParam_ResultDataView;
class TabStripService_GetTab_ResponseParam_ResultDataView;
class TabStripService_CreateTabAt_ResponseParam_ResultDataView;
class TabStripService_CloseTabs_ResponseParam_ResultDataView;
class TabStripService_ActivateTab_ResponseParam_ResultDataView;
class TabStripService_SetSelectedTabs_ResponseParam_ResultDataView;
class TabStripService_MoveNode_ResponseParam_ResultDataView;


}  // tabs_api::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabsSnapshotDataView> {
  using Data = ::tabs_api::mojom::internal::TabsSnapshot_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabsEventDataView> {
  using Data = ::tabs_api::mojom::internal::TabsEvent_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabStripService_GetTabs_ResponseParam_ResultDataView> {
  using Data = ::tabs_api::mojom::internal::TabStripService_GetTabs_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabStripService_GetTab_ResponseParam_ResultDataView> {
  using Data = ::tabs_api::mojom::internal::TabStripService_GetTab_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabStripService_CreateTabAt_ResponseParam_ResultDataView> {
  using Data = ::tabs_api::mojom::internal::TabStripService_CreateTabAt_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabStripService_CloseTabs_ResponseParam_ResultDataView> {
  using Data = ::tabs_api::mojom::internal::TabStripService_CloseTabs_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabStripService_ActivateTab_ResponseParam_ResultDataView> {
  using Data = ::tabs_api::mojom::internal::TabStripService_ActivateTab_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabStripService_SetSelectedTabs_ResponseParam_ResultDataView> {
  using Data = ::tabs_api::mojom::internal::TabStripService_SetSelectedTabs_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::tabs_api::mojom::TabStripService_MoveNode_ResponseParam_ResultDataView> {
  using Data = ::tabs_api::mojom::internal::TabStripService_MoveNode_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace tabs_api::mojom {
// Interface base classes. They are used for type safety check.
class TabStripServiceInterfaceBase {};

using TabStripServicePtrDataView =
    mojo::InterfacePtrDataView<TabStripServiceInterfaceBase>;
using TabStripServiceRequestDataView =
    mojo::InterfaceRequestDataView<TabStripServiceInterfaceBase>;
using TabStripServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TabStripServiceInterfaceBase>;
using TabStripServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TabStripServiceInterfaceBase>;
class TabsObserverInterfaceBase {};

using TabsObserverPtrDataView =
    mojo::InterfacePtrDataView<TabsObserverInterfaceBase>;
using TabsObserverRequestDataView =
    mojo::InterfaceRequestDataView<TabsObserverInterfaceBase>;
using TabsObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TabsObserverInterfaceBase>;
using TabsObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TabsObserverInterfaceBase>;


class TabsSnapshotDataView {
 public:
  TabsSnapshotDataView() = default;

  TabsSnapshotDataView(
      internal::TabsSnapshot_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTabStripDataView(
      ::tabs_api::mojom::ContainerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabStrip(UserType* output) {
    
    auto* pointer = data_->tab_strip.Get();
    return mojo::internal::Deserialize<::tabs_api::mojom::ContainerDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeStream() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::tabs_api::mojom::TabsObserverAssociatedRequestDataView>(
            &data_->stream, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::TabsSnapshot_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabsEventDataView {
 public:
  using Tag = internal::TabsEvent_Data::TabsEvent_Tag;

  TabsEventDataView() = default;

  TabsEventDataView(
      internal::TabsEvent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_tabs_created_event() const { return data_->tag == Tag::kTabsCreatedEvent; }
  inline void GetTabsCreatedEventDataView(
      ::tabs_api::mojom::OnTabsCreatedEventDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTabsCreatedEvent(UserType* output) const {
    
    CHECK(is_tabs_created_event());
    return mojo::internal::Deserialize<::tabs_api::mojom::OnTabsCreatedEventDataView>(
        data_->data.f_tabs_created_event.Get(), output, message_);
  }
  bool is_tabs_closed_event() const { return data_->tag == Tag::kTabsClosedEvent; }
  inline void GetTabsClosedEventDataView(
      ::tabs_api::mojom::OnTabsClosedEventDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTabsClosedEvent(UserType* output) const {
    
    CHECK(is_tabs_closed_event());
    return mojo::internal::Deserialize<::tabs_api::mojom::OnTabsClosedEventDataView>(
        data_->data.f_tabs_closed_event.Get(), output, message_);
  }
  bool is_node_moved_event() const { return data_->tag == Tag::kNodeMovedEvent; }
  inline void GetNodeMovedEventDataView(
      ::tabs_api::mojom::OnNodeMovedEventDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNodeMovedEvent(UserType* output) const {
    
    CHECK(is_node_moved_event());
    return mojo::internal::Deserialize<::tabs_api::mojom::OnNodeMovedEventDataView>(
        data_->data.f_node_moved_event.Get(), output, message_);
  }
  bool is_data_changed_event() const { return data_->tag == Tag::kDataChangedEvent; }
  inline void GetDataChangedEventDataView(
      ::tabs_api::mojom::OnDataChangedEventDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDataChangedEvent(UserType* output) const {
    
    CHECK(is_data_changed_event());
    return mojo::internal::Deserialize<::tabs_api::mojom::OnDataChangedEventDataView>(
        data_->data.f_data_changed_event.Get(), output, message_);
  }
  bool is_collection_created_event() const { return data_->tag == Tag::kCollectionCreatedEvent; }
  inline void GetCollectionCreatedEventDataView(
      ::tabs_api::mojom::OnCollectionCreatedEventDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCollectionCreatedEvent(UserType* output) const {
    
    CHECK(is_collection_created_event());
    return mojo::internal::Deserialize<::tabs_api::mojom::OnCollectionCreatedEventDataView>(
        data_->data.f_collection_created_event.Get(), output, message_);
  }

 private:
  internal::TabsEvent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class TabStripService_GetTabs_ResponseParam_ResultDataView {
 public:
  using Tag = internal::TabStripService_GetTabs_ResponseParam_Result_Data::TabStripService_GetTabs_ResponseParam_Result_Tag;

  TabStripService_GetTabs_ResponseParam_ResultDataView() = default;

  TabStripService_GetTabs_ResponseParam_ResultDataView(
      internal::TabStripService_GetTabs_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      TabsSnapshotDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::tabs_api::mojom::TabsSnapshotDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  inline void GetFailureDataView(
      ::mojo_base::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    
    CHECK(is_failure());
    return mojo::internal::Deserialize<::mojo_base::mojom::ErrorDataView>(
        data_->data.f_failure.Get(), output, message_);
  }

 private:
  internal::TabStripService_GetTabs_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class TabStripService_GetTab_ResponseParam_ResultDataView {
 public:
  using Tag = internal::TabStripService_GetTab_ResponseParam_Result_Data::TabStripService_GetTab_ResponseParam_Result_Tag;

  TabStripService_GetTab_ResponseParam_ResultDataView() = default;

  TabStripService_GetTab_ResponseParam_ResultDataView(
      internal::TabStripService_GetTab_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      ::tabs_api::mojom::TabDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::tabs_api::mojom::TabDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  inline void GetFailureDataView(
      ::mojo_base::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    
    CHECK(is_failure());
    return mojo::internal::Deserialize<::mojo_base::mojom::ErrorDataView>(
        data_->data.f_failure.Get(), output, message_);
  }

 private:
  internal::TabStripService_GetTab_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class TabStripService_CreateTabAt_ResponseParam_ResultDataView {
 public:
  using Tag = internal::TabStripService_CreateTabAt_ResponseParam_Result_Data::TabStripService_CreateTabAt_ResponseParam_Result_Tag;

  TabStripService_CreateTabAt_ResponseParam_ResultDataView() = default;

  TabStripService_CreateTabAt_ResponseParam_ResultDataView(
      internal::TabStripService_CreateTabAt_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      ::tabs_api::mojom::TabDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::tabs_api::mojom::TabDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  inline void GetFailureDataView(
      ::mojo_base::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    
    CHECK(is_failure());
    return mojo::internal::Deserialize<::mojo_base::mojom::ErrorDataView>(
        data_->data.f_failure.Get(), output, message_);
  }

 private:
  internal::TabStripService_CreateTabAt_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class TabStripService_CloseTabs_ResponseParam_ResultDataView {
 public:
  using Tag = internal::TabStripService_CloseTabs_ResponseParam_Result_Data::TabStripService_CloseTabs_ResponseParam_Result_Tag;

  TabStripService_CloseTabs_ResponseParam_ResultDataView() = default;

  TabStripService_CloseTabs_ResponseParam_ResultDataView(
      internal::TabStripService_CloseTabs_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      ::mojo_base::mojom::EmptyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::mojo_base::mojom::EmptyDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  inline void GetFailureDataView(
      ::mojo_base::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    
    CHECK(is_failure());
    return mojo::internal::Deserialize<::mojo_base::mojom::ErrorDataView>(
        data_->data.f_failure.Get(), output, message_);
  }

 private:
  internal::TabStripService_CloseTabs_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class TabStripService_ActivateTab_ResponseParam_ResultDataView {
 public:
  using Tag = internal::TabStripService_ActivateTab_ResponseParam_Result_Data::TabStripService_ActivateTab_ResponseParam_Result_Tag;

  TabStripService_ActivateTab_ResponseParam_ResultDataView() = default;

  TabStripService_ActivateTab_ResponseParam_ResultDataView(
      internal::TabStripService_ActivateTab_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      ::mojo_base::mojom::EmptyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::mojo_base::mojom::EmptyDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  inline void GetFailureDataView(
      ::mojo_base::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    
    CHECK(is_failure());
    return mojo::internal::Deserialize<::mojo_base::mojom::ErrorDataView>(
        data_->data.f_failure.Get(), output, message_);
  }

 private:
  internal::TabStripService_ActivateTab_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class TabStripService_SetSelectedTabs_ResponseParam_ResultDataView {
 public:
  using Tag = internal::TabStripService_SetSelectedTabs_ResponseParam_Result_Data::TabStripService_SetSelectedTabs_ResponseParam_Result_Tag;

  TabStripService_SetSelectedTabs_ResponseParam_ResultDataView() = default;

  TabStripService_SetSelectedTabs_ResponseParam_ResultDataView(
      internal::TabStripService_SetSelectedTabs_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      ::mojo_base::mojom::EmptyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::mojo_base::mojom::EmptyDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  inline void GetFailureDataView(
      ::mojo_base::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    
    CHECK(is_failure());
    return mojo::internal::Deserialize<::mojo_base::mojom::ErrorDataView>(
        data_->data.f_failure.Get(), output, message_);
  }

 private:
  internal::TabStripService_SetSelectedTabs_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class TabStripService_MoveNode_ResponseParam_ResultDataView {
 public:
  using Tag = internal::TabStripService_MoveNode_ResponseParam_Result_Data::TabStripService_MoveNode_ResponseParam_Result_Tag;

  TabStripService_MoveNode_ResponseParam_ResultDataView() = default;

  TabStripService_MoveNode_ResponseParam_ResultDataView(
      internal::TabStripService_MoveNode_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      ::mojo_base::mojom::EmptyDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::mojo_base::mojom::EmptyDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  inline void GetFailureDataView(
      ::mojo_base::mojom::ErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    
    CHECK(is_failure());
    return mojo::internal::Deserialize<::mojo_base::mojom::ErrorDataView>(
        data_->data.f_failure.Get(), output, message_);
  }

 private:
  internal::TabStripService_MoveNode_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // tabs_api::mojom

#endif  // COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_MOJOM_DATA_VIEW_H_