// components/browser_apis/tab_strip/tab_strip_api.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ContainerSpec as tabsApi_mojom_ContainerSpec,
  Container as tabsApi_mojom_Container,
  TabSpec as tabsApi_mojom_TabSpec,
  Tab as tabsApi_mojom_Tab
} from './tab_strip_api_data_model.mojom-webui.js';
import {
  OnCollectionCreatedEventSpec as tabsApi_mojom_OnCollectionCreatedEventSpec,
  OnCollectionCreatedEvent as tabsApi_mojom_OnCollectionCreatedEvent,
  OnDataChangedEventSpec as tabsApi_mojom_OnDataChangedEventSpec,
  OnDataChangedEvent as tabsApi_mojom_OnDataChangedEvent,
  OnNodeMovedEventSpec as tabsApi_mojom_OnNodeMovedEventSpec,
  OnNodeMovedEvent as tabsApi_mojom_OnNodeMovedEvent,
  OnTabsClosedEventSpec as tabsApi_mojom_OnTabsClosedEventSpec,
  OnTabsClosedEvent as tabsApi_mojom_OnTabsClosedEvent,
  OnTabsCreatedEventSpec as tabsApi_mojom_OnTabsCreatedEventSpec,
  OnTabsCreatedEvent as tabsApi_mojom_OnTabsCreatedEvent
} from './tab_strip_api_events.mojom-webui.js';
import {
  NodeIdSpec as tabsApi_mojom_NodeIdSpec,
  PositionSpec as tabsApi_mojom_PositionSpec,
  Position as tabsApi_mojom_Position
} from './tab_strip_api_types.mojom-webui.js';
import {
  EmptySpec as mojoBase_mojom_EmptySpec,
  Empty as mojoBase_mojom_Empty
} from '//resources/mojo/mojo/public/mojom/base/empty.mojom-webui.js';
import {
  ErrorSpec as mojoBase_mojom_ErrorSpec,
  Error as mojoBase_mojom_Error
} from '//resources/mojo/mojo/public/mojom/base/error.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type TabStripServicePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<TabStripServicePendingReceiver>;

export class TabStripServicePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<TabStripService> {

  handle: mojo.internal.interfaceSupport.Endpoint<TabStripServicePendingReceiver>;
  constructor(handle: MojoHandle|TabStripServicePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'tabs_api.mojom.TabStripService',
        scope);
  }
}

export interface TabStripServiceInterface {
  getTabs(): Promise<TabsSnapshot>;
  getTab(id: string): Promise<tabsApi_mojom_Tab>;
  createTabAt(pos: (tabsApi_mojom_Position | null), url: (url_mojom_Url | null)): Promise<tabsApi_mojom_Tab>;
  closeTabs(id: string[]): Promise<mojoBase_mojom_Empty>;
  activateTab(id: string): Promise<mojoBase_mojom_Empty>;
  setSelectedTabs(selection: string[], tabToActivate: string): Promise<mojoBase_mojom_Empty>;
  moveNode(id: string, position: tabsApi_mojom_Position): Promise<mojoBase_mojom_Empty>;
}

export class TabStripServiceRemote implements TabStripServiceInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<TabStripServicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<TabStripServicePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|TabStripServicePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TabStripServicePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getTabs(): Promise<TabsSnapshot> {
    return this.proxy.sendMessage(
        0,
        TabStripService_GetTabs_ParamsSpec.$,
        TabStripService_GetTabs_ResponseParamsSpec.$,
        [
        ],
        true);
  }

  getTab(
      id: string): Promise<tabsApi_mojom_Tab> {
    return this.proxy.sendMessage(
        1,
        TabStripService_GetTab_ParamsSpec.$,
        TabStripService_GetTab_ResponseParamsSpec.$,
        [
          id
        ],
        true);
  }

  createTabAt(
      pos: (tabsApi_mojom_Position | null),
      url: (url_mojom_Url | null)): Promise<tabsApi_mojom_Tab> {
    return this.proxy.sendMessage(
        2,
        TabStripService_CreateTabAt_ParamsSpec.$,
        TabStripService_CreateTabAt_ResponseParamsSpec.$,
        [
          pos,
          url
        ],
        true);
  }

  closeTabs(
      id: string[]): Promise<mojoBase_mojom_Empty> {
    return this.proxy.sendMessage(
        3,
        TabStripService_CloseTabs_ParamsSpec.$,
        TabStripService_CloseTabs_ResponseParamsSpec.$,
        [
          id
        ],
        true);
  }

  activateTab(
      id: string): Promise<mojoBase_mojom_Empty> {
    return this.proxy.sendMessage(
        4,
        TabStripService_ActivateTab_ParamsSpec.$,
        TabStripService_ActivateTab_ResponseParamsSpec.$,
        [
          id
        ],
        true);
  }

  setSelectedTabs(
      selection: string[],
      tabToActivate: string): Promise<mojoBase_mojom_Empty> {
    return this.proxy.sendMessage(
        5,
        TabStripService_SetSelectedTabs_ParamsSpec.$,
        TabStripService_SetSelectedTabs_ResponseParamsSpec.$,
        [
          selection,
          tabToActivate
        ],
        true);
  }

  moveNode(
      id: string,
      position: tabsApi_mojom_Position): Promise<mojoBase_mojom_Empty> {
    return this.proxy.sendMessage(
        6,
        TabStripService_MoveNode_ParamsSpec.$,
        TabStripService_MoveNode_ResponseParamsSpec.$,
        [
          id,
          position
        ],
        true);
  }
};

/**
 * An object which receives request messages for the TabStripService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TabStripServiceReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TabStripServiceRemote, TabStripServicePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TabStripServiceRemote, TabStripServicePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: TabStripServiceInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TabStripServiceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TabStripService_GetTabs_ParamsSpec.$,
        TabStripService_GetTabs_ResponseParamsSpec.$,
        impl.getTabs.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        1,
        TabStripService_GetTab_ParamsSpec.$,
        TabStripService_GetTab_ResponseParamsSpec.$,
        impl.getTab.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        2,
        TabStripService_CreateTabAt_ParamsSpec.$,
        TabStripService_CreateTabAt_ResponseParamsSpec.$,
        impl.createTabAt.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        3,
        TabStripService_CloseTabs_ParamsSpec.$,
        TabStripService_CloseTabs_ResponseParamsSpec.$,
        impl.closeTabs.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        4,
        TabStripService_ActivateTab_ParamsSpec.$,
        TabStripService_ActivateTab_ResponseParamsSpec.$,
        impl.activateTab.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        5,
        TabStripService_SetSelectedTabs_ParamsSpec.$,
        TabStripService_SetSelectedTabs_ResponseParamsSpec.$,
        impl.setSelectedTabs.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        6,
        TabStripService_MoveNode_ParamsSpec.$,
        TabStripService_MoveNode_ResponseParamsSpec.$,
        impl.moveNode.bind(impl),
        true);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TabStripService {
  static get $interfaceName(): string {
    return "tabs_api.mojom.TabStripService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): TabStripServiceRemote {
    let remote = new TabStripServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the TabStripService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TabStripServiceCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TabStripServiceRemote, TabStripServicePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TabStripServiceRemote, TabStripServicePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  createTabAt: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  closeTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  activateTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setSelectedTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  moveNode: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TabStripServiceRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TabStripService_GetTabs_ParamsSpec.$,
        TabStripService_GetTabs_ResponseParamsSpec.$,
        this.getTabs.createReceiverHandler(true /* expectsResponse */),
        true);
    this.getTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TabStripService_GetTab_ParamsSpec.$,
        TabStripService_GetTab_ResponseParamsSpec.$,
        this.getTab.createReceiverHandler(true /* expectsResponse */),
        true);
    this.createTabAt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        TabStripService_CreateTabAt_ParamsSpec.$,
        TabStripService_CreateTabAt_ResponseParamsSpec.$,
        this.createTabAt.createReceiverHandler(true /* expectsResponse */),
        true);
    this.closeTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        TabStripService_CloseTabs_ParamsSpec.$,
        TabStripService_CloseTabs_ResponseParamsSpec.$,
        this.closeTabs.createReceiverHandler(true /* expectsResponse */),
        true);
    this.activateTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        TabStripService_ActivateTab_ParamsSpec.$,
        TabStripService_ActivateTab_ResponseParamsSpec.$,
        this.activateTab.createReceiverHandler(true /* expectsResponse */),
        true);
    this.setSelectedTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        TabStripService_SetSelectedTabs_ParamsSpec.$,
        TabStripService_SetSelectedTabs_ResponseParamsSpec.$,
        this.setSelectedTabs.createReceiverHandler(true /* expectsResponse */),
        true);
    this.moveNode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        TabStripService_MoveNode_ParamsSpec.$,
        TabStripService_MoveNode_ResponseParamsSpec.$,
        this.moveNode.createReceiverHandler(true /* expectsResponse */),
        true);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type TabsObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<TabsObserverPendingReceiver>;

export class TabsObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<TabsObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<TabsObserverPendingReceiver>;
  constructor(handle: MojoHandle|TabsObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'tabs_api.mojom.TabsObserver',
        scope);
  }
}

export interface TabsObserverInterface {
  onTabEvents(events: TabsEvent[]): void;
}

export class TabsObserverRemote implements TabsObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<TabsObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<TabsObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|TabsObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TabsObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onTabEvents(
      events: TabsEvent[]): void {
    this.proxy.sendMessage(
        0,
        TabsObserver_OnTabEvents_ParamsSpec.$,
        null,
        [
          events
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TabsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TabsObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TabsObserverRemote, TabsObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TabsObserverRemote, TabsObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: TabsObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TabsObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TabsObserver_OnTabEvents_ParamsSpec.$,
        null,
        impl.onTabEvents.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TabsObserver {
  static get $interfaceName(): string {
    return "tabs_api.mojom.TabsObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): TabsObserverRemote {
    let remote = new TabsObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the TabsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TabsObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    TabsObserverRemote, TabsObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    TabsObserverRemote, TabsObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onTabEvents: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TabsObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onTabEvents =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TabsObserver_OnTabEvents_ParamsSpec.$,
        null,
        this.onTabEvents.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const TabsSnapshotSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_GetTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_GetTabs_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_GetTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_GetTab_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_CreateTabAt_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_CreateTabAt_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_CloseTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_CloseTabs_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_ActivateTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_ActivateTab_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_SetSelectedTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_SetSelectedTabs_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_MoveNode_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_MoveNode_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabsObserver_OnTabEvents_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabsEventSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_GetTabs_ResponseParam_ResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_GetTab_ResponseParam_ResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_CreateTabAt_ResponseParam_ResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_CloseTabs_ResponseParam_ResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_ActivateTab_ResponseParam_ResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_SetSelectedTabs_ResponseParam_ResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const TabStripService_MoveNode_ResponseParam_ResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface TabsSnapshotMojoType {
  tabStrip: tabsApi_mojom_Container;
  stream: TabsObserverPendingReceiver;
}


export type TabsSnapshot = TabsSnapshotMojoType;
mojo.internal.Struct<TabsSnapshotMojoType>(
    TabsSnapshotSpec.$,
    'TabsSnapshot',
    [
      mojo.internal.StructField<TabsSnapshotMojoType, tabsApi_mojom_Container>(
        'tabStrip', 0,
        0,
        tabsApi_mojom_ContainerSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabsSnapshotMojoType, TabsObserverPendingReceiver>(
        'stream', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(TabsObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabStripService_GetTabs_ParamsMojoType {
}


export type TabStripService_GetTabs_Params = TabStripService_GetTabs_ParamsMojoType;
mojo.internal.Struct<TabStripService_GetTabs_ParamsMojoType>(
    TabStripService_GetTabs_ParamsSpec.$,
    'TabStripService_GetTabs_Params',
    [
    ],
    [[0, 8],]);





export interface TabStripService_GetTabs_ResponseParamsMojoType {
  result: TabStripService_GetTabs_ResponseParam_Result;
}


export type TabStripService_GetTabs_ResponseParams = TabStripService_GetTabs_ResponseParamsMojoType;
mojo.internal.Struct<TabStripService_GetTabs_ResponseParamsMojoType>(
    TabStripService_GetTabs_ResponseParamsSpec.$,
    'TabStripService_GetTabs_ResponseParams',
    [
      mojo.internal.StructField<TabStripService_GetTabs_ResponseParamsMojoType, TabStripService_GetTabs_ResponseParam_Result>(
        'result', 0,
        0,
        TabStripService_GetTabs_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabStripService_GetTab_ParamsMojoType {
  id: string;
}


export type TabStripService_GetTab_Params = TabStripService_GetTab_ParamsMojoType;
mojo.internal.Struct<TabStripService_GetTab_ParamsMojoType>(
    TabStripService_GetTab_ParamsSpec.$,
    'TabStripService_GetTab_Params',
    [
      mojo.internal.StructField<TabStripService_GetTab_ParamsMojoType, string>(
        'id', 0,
        0,
        tabsApi_mojom_NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TabStripService_GetTab_ResponseParamsMojoType {
  result: TabStripService_GetTab_ResponseParam_Result;
}


export type TabStripService_GetTab_ResponseParams = TabStripService_GetTab_ResponseParamsMojoType;
mojo.internal.Struct<TabStripService_GetTab_ResponseParamsMojoType>(
    TabStripService_GetTab_ResponseParamsSpec.$,
    'TabStripService_GetTab_ResponseParams',
    [
      mojo.internal.StructField<TabStripService_GetTab_ResponseParamsMojoType, TabStripService_GetTab_ResponseParam_Result>(
        'result', 0,
        0,
        TabStripService_GetTab_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabStripService_CreateTabAt_ParamsMojoType {
  pos: (tabsApi_mojom_Position | null);
  url: (url_mojom_Url | null);
}


export type TabStripService_CreateTabAt_Params = TabStripService_CreateTabAt_ParamsMojoType;
mojo.internal.Struct<TabStripService_CreateTabAt_ParamsMojoType>(
    TabStripService_CreateTabAt_ParamsSpec.$,
    'TabStripService_CreateTabAt_Params',
    [
      mojo.internal.StructField<TabStripService_CreateTabAt_ParamsMojoType, tabsApi_mojom_Position>(
        'pos', 0,
        0,
        tabsApi_mojom_PositionSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabStripService_CreateTabAt_ParamsMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabStripService_CreateTabAt_ResponseParamsMojoType {
  result: TabStripService_CreateTabAt_ResponseParam_Result;
}


export type TabStripService_CreateTabAt_ResponseParams = TabStripService_CreateTabAt_ResponseParamsMojoType;
mojo.internal.Struct<TabStripService_CreateTabAt_ResponseParamsMojoType>(
    TabStripService_CreateTabAt_ResponseParamsSpec.$,
    'TabStripService_CreateTabAt_ResponseParams',
    [
      mojo.internal.StructField<TabStripService_CreateTabAt_ResponseParamsMojoType, TabStripService_CreateTabAt_ResponseParam_Result>(
        'result', 0,
        0,
        TabStripService_CreateTabAt_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabStripService_CloseTabs_ParamsMojoType {
  id: string[];
}


export type TabStripService_CloseTabs_Params = TabStripService_CloseTabs_ParamsMojoType;
mojo.internal.Struct<TabStripService_CloseTabs_ParamsMojoType>(
    TabStripService_CloseTabs_ParamsSpec.$,
    'TabStripService_CloseTabs_Params',
    [
      mojo.internal.StructField<TabStripService_CloseTabs_ParamsMojoType, string[]>(
        'id', 0,
        0,
        mojo.internal.Array(tabsApi_mojom_NodeIdSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TabStripService_CloseTabs_ResponseParamsMojoType {
  result: TabStripService_CloseTabs_ResponseParam_Result;
}


export type TabStripService_CloseTabs_ResponseParams = TabStripService_CloseTabs_ResponseParamsMojoType;
mojo.internal.Struct<TabStripService_CloseTabs_ResponseParamsMojoType>(
    TabStripService_CloseTabs_ResponseParamsSpec.$,
    'TabStripService_CloseTabs_ResponseParams',
    [
      mojo.internal.StructField<TabStripService_CloseTabs_ResponseParamsMojoType, TabStripService_CloseTabs_ResponseParam_Result>(
        'result', 0,
        0,
        TabStripService_CloseTabs_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabStripService_ActivateTab_ParamsMojoType {
  id: string;
}


export type TabStripService_ActivateTab_Params = TabStripService_ActivateTab_ParamsMojoType;
mojo.internal.Struct<TabStripService_ActivateTab_ParamsMojoType>(
    TabStripService_ActivateTab_ParamsSpec.$,
    'TabStripService_ActivateTab_Params',
    [
      mojo.internal.StructField<TabStripService_ActivateTab_ParamsMojoType, string>(
        'id', 0,
        0,
        tabsApi_mojom_NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface TabStripService_ActivateTab_ResponseParamsMojoType {
  result: TabStripService_ActivateTab_ResponseParam_Result;
}


export type TabStripService_ActivateTab_ResponseParams = TabStripService_ActivateTab_ResponseParamsMojoType;
mojo.internal.Struct<TabStripService_ActivateTab_ResponseParamsMojoType>(
    TabStripService_ActivateTab_ResponseParamsSpec.$,
    'TabStripService_ActivateTab_ResponseParams',
    [
      mojo.internal.StructField<TabStripService_ActivateTab_ResponseParamsMojoType, TabStripService_ActivateTab_ResponseParam_Result>(
        'result', 0,
        0,
        TabStripService_ActivateTab_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabStripService_SetSelectedTabs_ParamsMojoType {
  selection: string[];
  tabToActivate: string;
}


export type TabStripService_SetSelectedTabs_Params = TabStripService_SetSelectedTabs_ParamsMojoType;
mojo.internal.Struct<TabStripService_SetSelectedTabs_ParamsMojoType>(
    TabStripService_SetSelectedTabs_ParamsSpec.$,
    'TabStripService_SetSelectedTabs_Params',
    [
      mojo.internal.StructField<TabStripService_SetSelectedTabs_ParamsMojoType, string[]>(
        'selection', 0,
        0,
        mojo.internal.Array(tabsApi_mojom_NodeIdSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabStripService_SetSelectedTabs_ParamsMojoType, string>(
        'tabToActivate', 8,
        0,
        tabsApi_mojom_NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabStripService_SetSelectedTabs_ResponseParamsMojoType {
  result: TabStripService_SetSelectedTabs_ResponseParam_Result;
}


export type TabStripService_SetSelectedTabs_ResponseParams = TabStripService_SetSelectedTabs_ResponseParamsMojoType;
mojo.internal.Struct<TabStripService_SetSelectedTabs_ResponseParamsMojoType>(
    TabStripService_SetSelectedTabs_ResponseParamsSpec.$,
    'TabStripService_SetSelectedTabs_ResponseParams',
    [
      mojo.internal.StructField<TabStripService_SetSelectedTabs_ResponseParamsMojoType, TabStripService_SetSelectedTabs_ResponseParam_Result>(
        'result', 0,
        0,
        TabStripService_SetSelectedTabs_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabStripService_MoveNode_ParamsMojoType {
  id: string;
  position: tabsApi_mojom_Position;
}


export type TabStripService_MoveNode_Params = TabStripService_MoveNode_ParamsMojoType;
mojo.internal.Struct<TabStripService_MoveNode_ParamsMojoType>(
    TabStripService_MoveNode_ParamsSpec.$,
    'TabStripService_MoveNode_Params',
    [
      mojo.internal.StructField<TabStripService_MoveNode_ParamsMojoType, string>(
        'id', 0,
        0,
        tabsApi_mojom_NodeIdSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TabStripService_MoveNode_ParamsMojoType, tabsApi_mojom_Position>(
        'position', 8,
        0,
        tabsApi_mojom_PositionSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabStripService_MoveNode_ResponseParamsMojoType {
  result: TabStripService_MoveNode_ResponseParam_Result;
}


export type TabStripService_MoveNode_ResponseParams = TabStripService_MoveNode_ResponseParamsMojoType;
mojo.internal.Struct<TabStripService_MoveNode_ResponseParamsMojoType>(
    TabStripService_MoveNode_ResponseParamsSpec.$,
    'TabStripService_MoveNode_ResponseParams',
    [
      mojo.internal.StructField<TabStripService_MoveNode_ResponseParamsMojoType, TabStripService_MoveNode_ResponseParam_Result>(
        'result', 0,
        0,
        TabStripService_MoveNode_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface TabsObserver_OnTabEvents_ParamsMojoType {
  events: TabsEvent[];
}


export type TabsObserver_OnTabEvents_Params = TabsObserver_OnTabEvents_ParamsMojoType;
mojo.internal.Struct<TabsObserver_OnTabEvents_ParamsMojoType>(
    TabsObserver_OnTabEvents_ParamsSpec.$,
    'TabsObserver_OnTabEvents_Params',
    [
      mojo.internal.StructField<TabsObserver_OnTabEvents_ParamsMojoType, TabsEvent[]>(
        'events', 0,
        0,
        mojo.internal.Array(TabsEventSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



mojo.internal.Union(
    TabsEventSpec.$, 'TabsEvent',
    {
      'tabsCreatedEvent': {
        'ordinal': 0,
        'type': tabsApi_mojom_OnTabsCreatedEventSpec.$,
      },
      'tabsClosedEvent': {
        'ordinal': 1,
        'type': tabsApi_mojom_OnTabsClosedEventSpec.$,
      },
      'nodeMovedEvent': {
        'ordinal': 2,
        'type': tabsApi_mojom_OnNodeMovedEventSpec.$,
      },
      'dataChangedEvent': {
        'ordinal': 3,
        'type': tabsApi_mojom_OnDataChangedEventSpec.$,
      },
      'collectionCreatedEvent': {
        'ordinal': 4,
        'type': tabsApi_mojom_OnCollectionCreatedEventSpec.$,
      },
    });

export interface TabsEvent {
  tabsCreatedEvent?: tabsApi_mojom_OnTabsCreatedEvent,
  tabsClosedEvent?: tabsApi_mojom_OnTabsClosedEvent,
  nodeMovedEvent?: tabsApi_mojom_OnNodeMovedEvent,
  dataChangedEvent?: tabsApi_mojom_OnDataChangedEvent,
  collectionCreatedEvent?: tabsApi_mojom_OnCollectionCreatedEvent,
}

export enum TabsEventFieldTags {
  TABS_CREATED_EVENT,
  TABS_CLOSED_EVENT,
  NODE_MOVED_EVENT,
  DATA_CHANGED_EVENT,
  COLLECTION_CREATED_EVENT,
}

export function whichTabsEvent(u: TabsEvent): TabsEventFieldTags {
  if (u.tabsCreatedEvent !== null && u.tabsCreatedEvent !== undefined) {
    return TabsEventFieldTags.TABS_CREATED_EVENT;
  }
  if (u.tabsClosedEvent !== null && u.tabsClosedEvent !== undefined) {
    return TabsEventFieldTags.TABS_CLOSED_EVENT;
  }
  if (u.nodeMovedEvent !== null && u.nodeMovedEvent !== undefined) {
    return TabsEventFieldTags.NODE_MOVED_EVENT;
  }
  if (u.dataChangedEvent !== null && u.dataChangedEvent !== undefined) {
    return TabsEventFieldTags.DATA_CHANGED_EVENT;
  }
  if (u.collectionCreatedEvent !== null && u.collectionCreatedEvent !== undefined) {
    return TabsEventFieldTags.COLLECTION_CREATED_EVENT;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    TabStripService_GetTabs_ResponseParam_ResultSpec.$, 'TabStripService_GetTabs_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': TabsSnapshotSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': mojoBase_mojom_ErrorSpec.$,
      },
    });

export interface TabStripService_GetTabs_ResponseParam_Result {
  success?: TabsSnapshot,
  failure?: mojoBase_mojom_Error,
}

export enum TabStripService_GetTabs_ResponseParam_ResultFieldTags {
  SUCCESS,
  FAILURE,
}

export function whichTabStripService_GetTabs_ResponseParam_Result(u: TabStripService_GetTabs_ResponseParam_Result): TabStripService_GetTabs_ResponseParam_ResultFieldTags {
  if (u.success !== null && u.success !== undefined) {
    return TabStripService_GetTabs_ResponseParam_ResultFieldTags.SUCCESS;
  }
  if (u.failure !== null && u.failure !== undefined) {
    return TabStripService_GetTabs_ResponseParam_ResultFieldTags.FAILURE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    TabStripService_GetTab_ResponseParam_ResultSpec.$, 'TabStripService_GetTab_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': tabsApi_mojom_TabSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': mojoBase_mojom_ErrorSpec.$,
      },
    });

export interface TabStripService_GetTab_ResponseParam_Result {
  success?: tabsApi_mojom_Tab,
  failure?: mojoBase_mojom_Error,
}

export enum TabStripService_GetTab_ResponseParam_ResultFieldTags {
  SUCCESS,
  FAILURE,
}

export function whichTabStripService_GetTab_ResponseParam_Result(u: TabStripService_GetTab_ResponseParam_Result): TabStripService_GetTab_ResponseParam_ResultFieldTags {
  if (u.success !== null && u.success !== undefined) {
    return TabStripService_GetTab_ResponseParam_ResultFieldTags.SUCCESS;
  }
  if (u.failure !== null && u.failure !== undefined) {
    return TabStripService_GetTab_ResponseParam_ResultFieldTags.FAILURE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    TabStripService_CreateTabAt_ResponseParam_ResultSpec.$, 'TabStripService_CreateTabAt_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': tabsApi_mojom_TabSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': mojoBase_mojom_ErrorSpec.$,
      },
    });

export interface TabStripService_CreateTabAt_ResponseParam_Result {
  success?: tabsApi_mojom_Tab,
  failure?: mojoBase_mojom_Error,
}

export enum TabStripService_CreateTabAt_ResponseParam_ResultFieldTags {
  SUCCESS,
  FAILURE,
}

export function whichTabStripService_CreateTabAt_ResponseParam_Result(u: TabStripService_CreateTabAt_ResponseParam_Result): TabStripService_CreateTabAt_ResponseParam_ResultFieldTags {
  if (u.success !== null && u.success !== undefined) {
    return TabStripService_CreateTabAt_ResponseParam_ResultFieldTags.SUCCESS;
  }
  if (u.failure !== null && u.failure !== undefined) {
    return TabStripService_CreateTabAt_ResponseParam_ResultFieldTags.FAILURE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    TabStripService_CloseTabs_ResponseParam_ResultSpec.$, 'TabStripService_CloseTabs_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojoBase_mojom_EmptySpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': mojoBase_mojom_ErrorSpec.$,
      },
    });

export interface TabStripService_CloseTabs_ResponseParam_Result {
  success?: mojoBase_mojom_Empty,
  failure?: mojoBase_mojom_Error,
}

export enum TabStripService_CloseTabs_ResponseParam_ResultFieldTags {
  SUCCESS,
  FAILURE,
}

export function whichTabStripService_CloseTabs_ResponseParam_Result(u: TabStripService_CloseTabs_ResponseParam_Result): TabStripService_CloseTabs_ResponseParam_ResultFieldTags {
  if (u.success !== null && u.success !== undefined) {
    return TabStripService_CloseTabs_ResponseParam_ResultFieldTags.SUCCESS;
  }
  if (u.failure !== null && u.failure !== undefined) {
    return TabStripService_CloseTabs_ResponseParam_ResultFieldTags.FAILURE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    TabStripService_ActivateTab_ResponseParam_ResultSpec.$, 'TabStripService_ActivateTab_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojoBase_mojom_EmptySpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': mojoBase_mojom_ErrorSpec.$,
      },
    });

export interface TabStripService_ActivateTab_ResponseParam_Result {
  success?: mojoBase_mojom_Empty,
  failure?: mojoBase_mojom_Error,
}

export enum TabStripService_ActivateTab_ResponseParam_ResultFieldTags {
  SUCCESS,
  FAILURE,
}

export function whichTabStripService_ActivateTab_ResponseParam_Result(u: TabStripService_ActivateTab_ResponseParam_Result): TabStripService_ActivateTab_ResponseParam_ResultFieldTags {
  if (u.success !== null && u.success !== undefined) {
    return TabStripService_ActivateTab_ResponseParam_ResultFieldTags.SUCCESS;
  }
  if (u.failure !== null && u.failure !== undefined) {
    return TabStripService_ActivateTab_ResponseParam_ResultFieldTags.FAILURE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    TabStripService_SetSelectedTabs_ResponseParam_ResultSpec.$, 'TabStripService_SetSelectedTabs_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojoBase_mojom_EmptySpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': mojoBase_mojom_ErrorSpec.$,
      },
    });

export interface TabStripService_SetSelectedTabs_ResponseParam_Result {
  success?: mojoBase_mojom_Empty,
  failure?: mojoBase_mojom_Error,
}

export enum TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags {
  SUCCESS,
  FAILURE,
}

export function whichTabStripService_SetSelectedTabs_ResponseParam_Result(u: TabStripService_SetSelectedTabs_ResponseParam_Result): TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags {
  if (u.success !== null && u.success !== undefined) {
    return TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags.SUCCESS;
  }
  if (u.failure !== null && u.failure !== undefined) {
    return TabStripService_SetSelectedTabs_ResponseParam_ResultFieldTags.FAILURE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(
    TabStripService_MoveNode_ResponseParam_ResultSpec.$, 'TabStripService_MoveNode_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': mojoBase_mojom_EmptySpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': mojoBase_mojom_ErrorSpec.$,
      },
    });

export interface TabStripService_MoveNode_ResponseParam_Result {
  success?: mojoBase_mojom_Empty,
  failure?: mojoBase_mojom_Error,
}

export enum TabStripService_MoveNode_ResponseParam_ResultFieldTags {
  SUCCESS,
  FAILURE,
}

export function whichTabStripService_MoveNode_ResponseParam_Result(u: TabStripService_MoveNode_ResponseParam_Result): TabStripService_MoveNode_ResponseParam_ResultFieldTags {
  if (u.success !== null && u.success !== undefined) {
    return TabStripService_MoveNode_ResponseParam_ResultFieldTags.SUCCESS;
  }
  if (u.failure !== null && u.failure !== undefined) {
    return TabStripService_MoveNode_ResponseParam_ResultFieldTags.FAILURE;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
