// components/autofill/core/common/mojom/autofill_types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/autofill/core/common/mojom/autofill_types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/autofill/core/common/mojom/autofill_types.mojom-params-data.h"
#include "components/autofill/core/common/mojom/autofill_types.mojom-shared-message-ids.h"

#include "components/autofill/core/common/mojom/autofill_types.mojom-import-headers.h"
#include "components/autofill/core/common/mojom/autofill_types.mojom-test-utils.h"


namespace autofill::mojom {
FrameToken::FrameToken()
    : token(),
      is_local() {}

FrameToken::FrameToken(
    const ::base::UnguessableToken& token_in,
    bool is_local_in)
    : token(std::move(token_in)),
      is_local(std::move(is_local_in)) {}

FrameToken::~FrameToken() = default;

void FrameToken::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_local"), this->is_local,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameToken::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FrameTokenWithPredecessor::FrameTokenWithPredecessor()
    : token(),
      predecessor() {}

FrameTokenWithPredecessor::FrameTokenWithPredecessor(
    FrameTokenPtr token_in,
    int32_t predecessor_in)
    : token(std::move(token_in)),
      predecessor(std::move(predecessor_in)) {}

FrameTokenWithPredecessor::~FrameTokenWithPredecessor() = default;

void FrameTokenWithPredecessor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FrameTokenPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "predecessor"), this->predecessor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameTokenWithPredecessor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FormRendererId::FormRendererId()
    : id() {}

FormRendererId::FormRendererId(
    uint64_t id_in)
    : id(std::move(id_in)) {}

FormRendererId::~FormRendererId() = default;

void FormRendererId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FormRendererId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FieldRendererId::FieldRendererId()
    : id() {}

FieldRendererId::FieldRendererId(
    uint64_t id_in)
    : id(std::move(id_in)) {}

FieldRendererId::~FieldRendererId() = default;

void FieldRendererId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FieldRendererId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectOption::SelectOption()
    : value(),
      text() {}

SelectOption::SelectOption(
    const ::std::u16string& value_in,
    const ::std::u16string& text_in)
    : value(std::move(value_in)),
      text(std::move(text_in)) {}

SelectOption::~SelectOption() = default;

void SelectOption::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectOption::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AutocompleteParsingResult::AutocompleteParsingResult()
    : section(),
      mode(),
      field_type(),
      webauthn(),
      webidentity() {}

AutocompleteParsingResult::AutocompleteParsingResult(
    const std::string& section_in,
    HtmlFieldMode mode_in,
    HtmlFieldType field_type_in,
    bool webauthn_in,
    bool webidentity_in)
    : section(std::move(section_in)),
      mode(std::move(mode_in)),
      field_type(std::move(field_type_in)),
      webauthn(std::move(webauthn_in)),
      webidentity(std::move(webidentity_in)) {}

AutocompleteParsingResult::~AutocompleteParsingResult() = default;
size_t AutocompleteParsingResult::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->section);
  seed = mojo::internal::Hash(seed, this->mode);
  seed = mojo::internal::Hash(seed, this->field_type);
  seed = mojo::internal::Hash(seed, this->webauthn);
  seed = mojo::internal::Hash(seed, this->webidentity);
  return seed;
}

void AutocompleteParsingResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "section"), this->section,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HtmlFieldMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "field_type"), this->field_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HtmlFieldType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webauthn"), this->webauthn,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "webidentity"), this->webidentity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutocompleteParsingResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FormFieldData::FormFieldData()
    : label(),
      name(),
      id_attribute(),
      name_attribute(),
      value(),
      selected_text(),
      form_control_type(),
      autocomplete_attribute(),
      parsed_autocomplete(),
      pattern(),
      placeholder(),
      css_classes(),
      aria_label(),
      aria_description(),
      nonce(),
      renderer_id(),
      host_form_id(),
      properties_mask(),
      form_control_ax_id(),
      max_length(),
      is_user_edited(),
      is_autofilled(),
      check_status(),
      is_focusable(),
      is_visible(),
      should_autocomplete(),
      role(),
      text_direction(),
      is_enabled(),
      is_readonly(),
      user_input(),
      allows_writing_suggestions(),
      options(),
      label_source(),
      bounds(),
      datalist_options(),
      force_override() {}

FormFieldData::FormFieldData(
    const ::std::u16string& label_in,
    const ::std::u16string& name_in,
    const ::std::u16string& id_attribute_in,
    const ::std::u16string& name_attribute_in,
    const ::std::u16string& value_in,
    const ::std::u16string& selected_text_in,
    FormControlType form_control_type_in,
    const std::string& autocomplete_attribute_in,
    AutocompleteParsingResultPtr parsed_autocomplete_in,
    const ::std::u16string& pattern_in,
    const ::std::u16string& placeholder_in,
    const ::std::u16string& css_classes_in,
    const ::std::u16string& aria_label_in,
    const ::std::u16string& aria_description_in,
    const ::std::u16string& nonce_in,
    ::autofill::FieldRendererId renderer_id_in,
    ::autofill::FormRendererId host_form_id_in,
    uint32_t properties_mask_in,
    int32_t form_control_ax_id_in,
    uint64_t max_length_in,
    bool is_user_edited_in,
    bool is_autofilled_in,
    FormFieldData::CheckStatus check_status_in,
    bool is_focusable_in,
    bool is_visible_in,
    bool should_autocomplete_in,
    FormFieldData::RoleAttribute role_in,
    ::base::i18n::TextDirection text_direction_in,
    bool is_enabled_in,
    bool is_readonly_in,
    const ::std::u16string& user_input_in,
    bool allows_writing_suggestions_in,
    std::vector<SelectOptionPtr> options_in,
    FormFieldData::LabelSource label_source_in,
    const ::gfx::RectF& bounds_in,
    std::vector<SelectOptionPtr> datalist_options_in,
    bool force_override_in)
    : label(std::move(label_in)),
      name(std::move(name_in)),
      id_attribute(std::move(id_attribute_in)),
      name_attribute(std::move(name_attribute_in)),
      value(std::move(value_in)),
      selected_text(std::move(selected_text_in)),
      form_control_type(std::move(form_control_type_in)),
      autocomplete_attribute(std::move(autocomplete_attribute_in)),
      parsed_autocomplete(std::move(parsed_autocomplete_in)),
      pattern(std::move(pattern_in)),
      placeholder(std::move(placeholder_in)),
      css_classes(std::move(css_classes_in)),
      aria_label(std::move(aria_label_in)),
      aria_description(std::move(aria_description_in)),
      nonce(std::move(nonce_in)),
      renderer_id(std::move(renderer_id_in)),
      host_form_id(std::move(host_form_id_in)),
      properties_mask(std::move(properties_mask_in)),
      form_control_ax_id(std::move(form_control_ax_id_in)),
      max_length(std::move(max_length_in)),
      is_user_edited(std::move(is_user_edited_in)),
      is_autofilled(std::move(is_autofilled_in)),
      check_status(std::move(check_status_in)),
      is_focusable(std::move(is_focusable_in)),
      is_visible(std::move(is_visible_in)),
      should_autocomplete(std::move(should_autocomplete_in)),
      role(std::move(role_in)),
      text_direction(std::move(text_direction_in)),
      is_enabled(std::move(is_enabled_in)),
      is_readonly(std::move(is_readonly_in)),
      user_input(std::move(user_input_in)),
      allows_writing_suggestions(std::move(allows_writing_suggestions_in)),
      options(std::move(options_in)),
      label_source(std::move(label_source_in)),
      bounds(std::move(bounds_in)),
      datalist_options(std::move(datalist_options_in)),
      force_override(std::move(force_override_in)) {}

FormFieldData::~FormFieldData() = default;

void FormFieldData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id_attribute"), this->id_attribute,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name_attribute"), this->name_attribute,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_text"), this->selected_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_control_type"), this->form_control_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FormControlType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "autocomplete_attribute"), this->autocomplete_attribute,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parsed_autocomplete"), this->parsed_autocomplete,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AutocompleteParsingResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pattern"), this->pattern,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "placeholder"), this->placeholder,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "css_classes"), this->css_classes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aria_label"), this->aria_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aria_description"), this->aria_description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nonce"), this->nonce,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_id"), this->renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_form_id"), this->host_form_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FormRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "properties_mask"), this->properties_mask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_control_ax_id"), this->form_control_ax_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_length"), this->max_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_user_edited"), this->is_user_edited,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_autofilled"), this->is_autofilled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "check_status"), this->check_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FormFieldData::CheckStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_focusable"), this->is_focusable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_visible"), this->is_visible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_autocomplete"), this->should_autocomplete,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "role"), this->role,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FormFieldData::RoleAttribute>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_direction"), this->text_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::i18n::TextDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_enabled"), this->is_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_readonly"), this->is_readonly,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_input"), this->user_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allows_writing_suggestions"), this->allows_writing_suggestions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "options"), this->options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SelectOptionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label_source"), this->label_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FormFieldData::LabelSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "datalist_options"), this->datalist_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SelectOptionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_override"), this->force_override,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FormFieldData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FormFieldData_FillData::FormFieldData_FillData()
    : value(),
      renderer_id(),
      host_form_id(),
      is_autofilled(),
      force_override() {}

FormFieldData_FillData::FormFieldData_FillData(
    const ::std::u16string& value_in,
    ::autofill::FieldRendererId renderer_id_in,
    ::autofill::FormRendererId host_form_id_in,
    bool is_autofilled_in,
    bool force_override_in)
    : value(std::move(value_in)),
      renderer_id(std::move(renderer_id_in)),
      host_form_id(std::move(host_form_id_in)),
      is_autofilled(std::move(is_autofilled_in)),
      force_override(std::move(force_override_in)) {}

FormFieldData_FillData::~FormFieldData_FillData() = default;

void FormFieldData_FillData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_id"), this->renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_form_id"), this->host_form_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FormRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_autofilled"), this->is_autofilled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_override"), this->force_override,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FormFieldData_FillData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ButtonTitleInfo::ButtonTitleInfo()
    : title(),
      type() {}

ButtonTitleInfo::ButtonTitleInfo(
    const ::std::u16string& title_in,
    ButtonTitleType type_in)
    : title(std::move(title_in)),
      type(std::move(type_in)) {}

ButtonTitleInfo::~ButtonTitleInfo() = default;

void ButtonTitleInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ButtonTitleType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ButtonTitleInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FormData::FormData()
    : id_attribute(),
      name_attribute(),
      name(),
      button_titles(),
      action(),
      is_action_empty(),
      renderer_id(),
      child_frames(),
      submission_event(),
      fields(),
      username_predictions(),
      is_gaia_with_skip_save_password_form(),
      likely_contains_captcha() {}

FormData::FormData(
    const ::std::u16string& id_attribute_in,
    const ::std::u16string& name_attribute_in,
    const ::std::u16string& name_in,
    std::vector<ButtonTitleInfoPtr> button_titles_in,
    const ::GURL& action_in,
    bool is_action_empty_in,
    ::autofill::FormRendererId renderer_id_in,
    std::vector<FrameTokenWithPredecessorPtr> child_frames_in,
    SubmissionIndicatorEvent submission_event_in,
    std::vector<::autofill::FormFieldData> fields_in,
    std::vector<::autofill::FieldRendererId> username_predictions_in,
    bool is_gaia_with_skip_save_password_form_in,
    bool likely_contains_captcha_in)
    : id_attribute(std::move(id_attribute_in)),
      name_attribute(std::move(name_attribute_in)),
      name(std::move(name_in)),
      button_titles(std::move(button_titles_in)),
      action(std::move(action_in)),
      is_action_empty(std::move(is_action_empty_in)),
      renderer_id(std::move(renderer_id_in)),
      child_frames(std::move(child_frames_in)),
      submission_event(std::move(submission_event_in)),
      fields(std::move(fields_in)),
      username_predictions(std::move(username_predictions_in)),
      is_gaia_with_skip_save_password_form(std::move(is_gaia_with_skip_save_password_form_in)),
      likely_contains_captcha(std::move(likely_contains_captcha_in)) {}

FormData::~FormData() = default;

void FormData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id_attribute"), this->id_attribute,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name_attribute"), this->name_attribute,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "button_titles"), this->button_titles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ButtonTitleInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_action_empty"), this->is_action_empty,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "renderer_id"), this->renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FormRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "child_frames"), this->child_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FrameTokenWithPredecessorPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "submission_event"), this->submission_event,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SubmissionIndicatorEvent>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fields"), this->fields,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::autofill::FormFieldData>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username_predictions"), this->username_predictions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::autofill::FieldRendererId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_gaia_with_skip_save_password_form"), this->is_gaia_with_skip_save_password_form,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "likely_contains_captcha"), this->likely_contains_captcha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FormData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FormFieldDataPredictions::FormFieldDataPredictions()
    : host_form_signature(),
      signature(),
      heuristic_type(),
      pwm_ml_type(),
      server_type(),
      html_type(),
      overall_type(),
      attribute_types(),
      format_string(),
      parseable_name(),
      parseable_label(),
      section(),
      rank(),
      rank_in_signature_group(),
      rank_in_host_form(),
      rank_in_host_form_signature_group() {}

FormFieldDataPredictions::FormFieldDataPredictions(
    const std::string& host_form_signature_in,
    const std::string& signature_in,
    const std::string& heuristic_type_in,
    const std::string& pwm_ml_type_in,
    const std::optional<std::string>& server_type_in,
    const std::string& html_type_in,
    const std::string& overall_type_in,
    const std::string& attribute_types_in,
    const std::string& format_string_in,
    const std::string& parseable_name_in,
    const std::string& parseable_label_in,
    const std::string& section_in,
    uint32_t rank_in,
    uint32_t rank_in_signature_group_in,
    uint32_t rank_in_host_form_in,
    uint32_t rank_in_host_form_signature_group_in)
    : host_form_signature(std::move(host_form_signature_in)),
      signature(std::move(signature_in)),
      heuristic_type(std::move(heuristic_type_in)),
      pwm_ml_type(std::move(pwm_ml_type_in)),
      server_type(std::move(server_type_in)),
      html_type(std::move(html_type_in)),
      overall_type(std::move(overall_type_in)),
      attribute_types(std::move(attribute_types_in)),
      format_string(std::move(format_string_in)),
      parseable_name(std::move(parseable_name_in)),
      parseable_label(std::move(parseable_label_in)),
      section(std::move(section_in)),
      rank(std::move(rank_in)),
      rank_in_signature_group(std::move(rank_in_signature_group_in)),
      rank_in_host_form(std::move(rank_in_host_form_in)),
      rank_in_host_form_signature_group(std::move(rank_in_host_form_signature_group_in)) {}

FormFieldDataPredictions::~FormFieldDataPredictions() = default;

void FormFieldDataPredictions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_form_signature"), this->host_form_signature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature"), this->signature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "heuristic_type"), this->heuristic_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pwm_ml_type"), this->pwm_ml_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_type"), this->server_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "html_type"), this->html_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overall_type"), this->overall_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attribute_types"), this->attribute_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format_string"), this->format_string,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parseable_name"), this->parseable_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parseable_label"), this->parseable_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "section"), this->section,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rank"), this->rank,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rank_in_signature_group"), this->rank_in_signature_group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rank_in_host_form"), this->rank_in_host_form,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rank_in_host_form_signature_group"), this->rank_in_host_form_signature_group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FormFieldDataPredictions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FormDataPredictions::FormDataPredictions()
    : data(),
      signature(),
      alternative_signature(),
      fields() {}

FormDataPredictions::FormDataPredictions(
    const ::autofill::FormData& data_in,
    const std::string& signature_in,
    const std::string& alternative_signature_in,
    std::vector<::autofill::FormFieldDataPredictions> fields_in)
    : data(std::move(data_in)),
      signature(std::move(signature_in)),
      alternative_signature(std::move(alternative_signature_in)),
      fields(std::move(fields_in)) {}

FormDataPredictions::~FormDataPredictions() = default;

void FormDataPredictions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::autofill::FormData&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature"), this->signature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alternative_signature"), this->alternative_signature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fields"), this->fields,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::autofill::FormFieldDataPredictions>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FormDataPredictions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PasswordAndMetadata::PasswordAndMetadata()
    : username_value(),
      password_value(),
      realm(),
      uses_account_store(),
      is_grouped_affiliation() {}

PasswordAndMetadata::PasswordAndMetadata(
    const ::std::u16string& username_value_in,
    const ::std::u16string& password_value_in,
    const std::string& realm_in,
    bool uses_account_store_in,
    bool is_grouped_affiliation_in)
    : username_value(std::move(username_value_in)),
      password_value(std::move(password_value_in)),
      realm(std::move(realm_in)),
      uses_account_store(std::move(uses_account_store_in)),
      is_grouped_affiliation(std::move(is_grouped_affiliation_in)) {}

PasswordAndMetadata::~PasswordAndMetadata() = default;

void PasswordAndMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username_value"), this->username_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "password_value"), this->password_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "realm"), this->realm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uses_account_store"), this->uses_account_store,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_grouped_affiliation"), this->is_grouped_affiliation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PasswordAndMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PasswordFormFillData::PasswordFormFillData()
    : form_renderer_id(),
      url(),
      username_element_renderer_id(),
      password_element_renderer_id(),
      preferred_login(),
      additional_logins(),
      wait_for_username(),
      suggestion_banned_fields(),
      notify_browser_of_successful_filling() {}

PasswordFormFillData::PasswordFormFillData(
    ::autofill::FormRendererId form_renderer_id_in,
    const ::GURL& url_in,
    ::autofill::FieldRendererId username_element_renderer_id_in,
    ::autofill::FieldRendererId password_element_renderer_id_in,
    const ::autofill::PasswordAndMetadata& preferred_login_in,
    std::vector<::autofill::PasswordAndMetadata> additional_logins_in,
    bool wait_for_username_in,
    std::vector<::autofill::FieldRendererId> suggestion_banned_fields_in,
    bool notify_browser_of_successful_filling_in)
    : form_renderer_id(std::move(form_renderer_id_in)),
      url(std::move(url_in)),
      username_element_renderer_id(std::move(username_element_renderer_id_in)),
      password_element_renderer_id(std::move(password_element_renderer_id_in)),
      preferred_login(std::move(preferred_login_in)),
      additional_logins(std::move(additional_logins_in)),
      wait_for_username(std::move(wait_for_username_in)),
      suggestion_banned_fields(std::move(suggestion_banned_fields_in)),
      notify_browser_of_successful_filling(std::move(notify_browser_of_successful_filling_in)) {}

PasswordFormFillData::~PasswordFormFillData() = default;

void PasswordFormFillData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_renderer_id"), this->form_renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FormRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username_element_renderer_id"), this->username_element_renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "password_element_renderer_id"), this->password_element_renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preferred_login"), this->preferred_login,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::autofill::PasswordAndMetadata&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_logins"), this->additional_logins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::autofill::PasswordAndMetadata>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_username"), this->wait_for_username,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestion_banned_fields"), this->suggestion_banned_fields,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::autofill::FieldRendererId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "notify_browser_of_successful_filling"), this->notify_browser_of_successful_filling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PasswordFormFillData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PasswordFormGenerationData::PasswordFormGenerationData()
    : new_password_renderer_id(),
      confirmation_password_renderer_id() {}

PasswordFormGenerationData::PasswordFormGenerationData(
    ::autofill::FieldRendererId new_password_renderer_id_in,
    ::autofill::FieldRendererId confirmation_password_renderer_id_in)
    : new_password_renderer_id(std::move(new_password_renderer_id_in)),
      confirmation_password_renderer_id(std::move(confirmation_password_renderer_id_in)) {}

PasswordFormGenerationData::~PasswordFormGenerationData() = default;

void PasswordFormGenerationData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_password_renderer_id"), this->new_password_renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "confirmation_password_renderer_id"), this->confirmation_password_renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PasswordFormGenerationData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PasswordGenerationUIData::PasswordGenerationUIData()
    : bounds(),
      max_length(),
      generation_element(),
      generation_element_id(),
      is_generation_element_password_type(),
      text_direction(),
      form_data(),
      generation_rejected() {}

PasswordGenerationUIData::PasswordGenerationUIData(
    const ::gfx::RectF& bounds_in,
    int32_t max_length_in,
    const ::std::u16string& generation_element_in,
    ::autofill::FieldRendererId generation_element_id_in,
    bool is_generation_element_password_type_in,
    ::base::i18n::TextDirection text_direction_in,
    const ::autofill::FormData& form_data_in,
    bool generation_rejected_in)
    : bounds(std::move(bounds_in)),
      max_length(std::move(max_length_in)),
      generation_element(std::move(generation_element_in)),
      generation_element_id(std::move(generation_element_id_in)),
      is_generation_element_password_type(std::move(is_generation_element_password_type_in)),
      text_direction(std::move(text_direction_in)),
      form_data(std::move(form_data_in)),
      generation_rejected(std::move(generation_rejected_in)) {}

PasswordGenerationUIData::~PasswordGenerationUIData() = default;

void PasswordGenerationUIData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_length"), this->max_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generation_element"), this->generation_element,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generation_element_id"), this->generation_element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_generation_element_password_type"), this->is_generation_element_password_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_direction"), this->text_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::i18n::TextDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_data"), this->form_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::autofill::FormData&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "generation_rejected"), this->generation_rejected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PasswordGenerationUIData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TriggeringField::TriggeringField()
    : element_id(),
      trigger_source(),
      text_direction(),
      typed_username(),
      show_webauthn_credentials(),
      show_identity_credentials(),
      bounds() {}

TriggeringField::TriggeringField(
    ::autofill::FieldRendererId element_id_in,
    AutofillSuggestionTriggerSource trigger_source_in,
    ::base::i18n::TextDirection text_direction_in,
    const ::std::u16string& typed_username_in,
    bool show_webauthn_credentials_in,
    bool show_identity_credentials_in,
    const ::gfx::RectF& bounds_in)
    : element_id(std::move(element_id_in)),
      trigger_source(std::move(trigger_source_in)),
      text_direction(std::move(text_direction_in)),
      typed_username(std::move(typed_username_in)),
      show_webauthn_credentials(std::move(show_webauthn_credentials_in)),
      show_identity_credentials(std::move(show_identity_credentials_in)),
      bounds(std::move(bounds_in)) {}

TriggeringField::~TriggeringField() = default;

void TriggeringField::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "element_id"), this->element_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trigger_source"), this->trigger_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AutofillSuggestionTriggerSource>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_direction"), this->text_direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::i18n::TextDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "typed_username"), this->typed_username,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_webauthn_credentials"), this->show_webauthn_credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_identity_credentials"), this->show_identity_credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::RectF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TriggeringField::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PasswordSuggestionRequest::PasswordSuggestionRequest()
    : field(),
      form_data(),
      username_field_index(),
      password_field_index() {}

PasswordSuggestionRequest::PasswordSuggestionRequest(
    TriggeringFieldPtr field_in,
    const ::autofill::FormData& form_data_in,
    uint64_t username_field_index_in,
    uint64_t password_field_index_in)
    : field(std::move(field_in)),
      form_data(std::move(form_data_in)),
      username_field_index(std::move(username_field_index_in)),
      password_field_index(std::move(password_field_index_in)) {}

PasswordSuggestionRequest::~PasswordSuggestionRequest() = default;

void PasswordSuggestionRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "field"), this->field,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TriggeringFieldPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_data"), this->form_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::autofill::FormData&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username_field_index"), this->username_field_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "password_field_index"), this->password_field_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PasswordSuggestionRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ParsingResult::ParsingResult()
    : username_renderer_id(),
      password_renderer_id(),
      new_password_renderer_id(),
      confirm_password_renderer_id() {}

ParsingResult::ParsingResult(
    ::autofill::FieldRendererId username_renderer_id_in,
    ::autofill::FieldRendererId password_renderer_id_in,
    ::autofill::FieldRendererId new_password_renderer_id_in,
    ::autofill::FieldRendererId confirm_password_renderer_id_in)
    : username_renderer_id(std::move(username_renderer_id_in)),
      password_renderer_id(std::move(password_renderer_id_in)),
      new_password_renderer_id(std::move(new_password_renderer_id_in)),
      confirm_password_renderer_id(std::move(confirm_password_renderer_id_in)) {}

ParsingResult::~ParsingResult() = default;

void ParsingResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username_renderer_id"), this->username_renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "password_renderer_id"), this->password_renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "new_password_renderer_id"), this->new_password_renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "confirm_password_renderer_id"), this->confirm_password_renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::autofill::FieldRendererId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ParsingResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // autofill::mojom


namespace mojo {


// static
bool StructTraits<::autofill::mojom::FrameToken::DataView, ::autofill::mojom::FrameTokenPtr>::Read(
    ::autofill::mojom::FrameToken::DataView input,
    ::autofill::mojom::FrameTokenPtr* output) {
  bool success = true;
  ::autofill::mojom::FrameTokenPtr result(::autofill::mojom::FrameToken::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success)
        result->is_local = input.is_local();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::FrameTokenWithPredecessor::DataView, ::autofill::mojom::FrameTokenWithPredecessorPtr>::Read(
    ::autofill::mojom::FrameTokenWithPredecessor::DataView input,
    ::autofill::mojom::FrameTokenWithPredecessorPtr* output) {
  bool success = true;
  ::autofill::mojom::FrameTokenWithPredecessorPtr result(::autofill::mojom::FrameTokenWithPredecessor::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success)
        result->predecessor = input.predecessor();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::FormRendererId::DataView, ::autofill::mojom::FormRendererIdPtr>::Read(
    ::autofill::mojom::FormRendererId::DataView input,
    ::autofill::mojom::FormRendererIdPtr* output) {
  bool success = true;
  ::autofill::mojom::FormRendererIdPtr result(::autofill::mojom::FormRendererId::New());
  
      if (success)
        result->id = input.id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::FieldRendererId::DataView, ::autofill::mojom::FieldRendererIdPtr>::Read(
    ::autofill::mojom::FieldRendererId::DataView input,
    ::autofill::mojom::FieldRendererIdPtr* output) {
  bool success = true;
  ::autofill::mojom::FieldRendererIdPtr result(::autofill::mojom::FieldRendererId::New());
  
      if (success)
        result->id = input.id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::SelectOption::DataView, ::autofill::mojom::SelectOptionPtr>::Read(
    ::autofill::mojom::SelectOption::DataView input,
    ::autofill::mojom::SelectOptionPtr* output) {
  bool success = true;
  ::autofill::mojom::SelectOptionPtr result(::autofill::mojom::SelectOption::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadText(&result->text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::AutocompleteParsingResult::DataView, ::autofill::mojom::AutocompleteParsingResultPtr>::Read(
    ::autofill::mojom::AutocompleteParsingResult::DataView input,
    ::autofill::mojom::AutocompleteParsingResultPtr* output) {
  bool success = true;
  ::autofill::mojom::AutocompleteParsingResultPtr result(::autofill::mojom::AutocompleteParsingResult::New());
  
      if (success && !input.ReadSection(&result->section))
        success = false;
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadFieldType(&result->field_type))
        success = false;
      if (success)
        result->webauthn = input.webauthn();
      if (success)
        result->webidentity = input.webidentity();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::FormFieldData::DataView, ::autofill::mojom::FormFieldDataPtr>::Read(
    ::autofill::mojom::FormFieldData::DataView input,
    ::autofill::mojom::FormFieldDataPtr* output) {
  bool success = true;
  ::autofill::mojom::FormFieldDataPtr result(::autofill::mojom::FormFieldData::New());
  
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIdAttribute(&result->id_attribute))
        success = false;
      if (success && !input.ReadNameAttribute(&result->name_attribute))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadSelectedText(&result->selected_text))
        success = false;
      if (success && !input.ReadFormControlType(&result->form_control_type))
        success = false;
      if (success && !input.ReadAutocompleteAttribute(&result->autocomplete_attribute))
        success = false;
      if (success && !input.ReadParsedAutocomplete(&result->parsed_autocomplete))
        success = false;
      if (success && !input.ReadPattern(&result->pattern))
        success = false;
      if (success && !input.ReadPlaceholder(&result->placeholder))
        success = false;
      if (success && !input.ReadCssClasses(&result->css_classes))
        success = false;
      if (success && !input.ReadAriaLabel(&result->aria_label))
        success = false;
      if (success && !input.ReadAriaDescription(&result->aria_description))
        success = false;
      if (success && !input.ReadNonce(&result->nonce))
        success = false;
      if (success && !input.ReadRendererId(&result->renderer_id))
        success = false;
      if (success && !input.ReadHostFormId(&result->host_form_id))
        success = false;
      if (success)
        result->properties_mask = input.properties_mask();
      if (success)
        result->form_control_ax_id = input.form_control_ax_id();
      if (success)
        result->max_length = input.max_length();
      if (success)
        result->is_user_edited = input.is_user_edited();
      if (success)
        result->is_autofilled = input.is_autofilled();
      if (success && !input.ReadCheckStatus(&result->check_status))
        success = false;
      if (success)
        result->is_focusable = input.is_focusable();
      if (success)
        result->is_visible = input.is_visible();
      if (success)
        result->should_autocomplete = input.should_autocomplete();
      if (success && !input.ReadRole(&result->role))
        success = false;
      if (success && !input.ReadTextDirection(&result->text_direction))
        success = false;
      if (success)
        result->is_enabled = input.is_enabled();
      if (success)
        result->is_readonly = input.is_readonly();
      if (success && !input.ReadUserInput(&result->user_input))
        success = false;
      if (success)
        result->allows_writing_suggestions = input.allows_writing_suggestions();
      if (success && !input.ReadOptions(&result->options))
        success = false;
      if (success && !input.ReadLabelSource(&result->label_source))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
      if (success && !input.ReadDatalistOptions(&result->datalist_options))
        success = false;
      if (success)
        result->force_override = input.force_override();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::FormFieldData_FillData::DataView, ::autofill::mojom::FormFieldData_FillDataPtr>::Read(
    ::autofill::mojom::FormFieldData_FillData::DataView input,
    ::autofill::mojom::FormFieldData_FillDataPtr* output) {
  bool success = true;
  ::autofill::mojom::FormFieldData_FillDataPtr result(::autofill::mojom::FormFieldData_FillData::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadRendererId(&result->renderer_id))
        success = false;
      if (success && !input.ReadHostFormId(&result->host_form_id))
        success = false;
      if (success)
        result->is_autofilled = input.is_autofilled();
      if (success)
        result->force_override = input.force_override();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::ButtonTitleInfo::DataView, ::autofill::mojom::ButtonTitleInfoPtr>::Read(
    ::autofill::mojom::ButtonTitleInfo::DataView input,
    ::autofill::mojom::ButtonTitleInfoPtr* output) {
  bool success = true;
  ::autofill::mojom::ButtonTitleInfoPtr result(::autofill::mojom::ButtonTitleInfo::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::FormData::DataView, ::autofill::mojom::FormDataPtr>::Read(
    ::autofill::mojom::FormData::DataView input,
    ::autofill::mojom::FormDataPtr* output) {
  bool success = true;
  ::autofill::mojom::FormDataPtr result(::autofill::mojom::FormData::New());
  
      if (success && !input.ReadIdAttribute(&result->id_attribute))
        success = false;
      if (success && !input.ReadNameAttribute(&result->name_attribute))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadButtonTitles(&result->button_titles))
        success = false;
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success)
        result->is_action_empty = input.is_action_empty();
      if (success && !input.ReadRendererId(&result->renderer_id))
        success = false;
      if (success && !input.ReadChildFrames(&result->child_frames))
        success = false;
      if (success && !input.ReadSubmissionEvent(&result->submission_event))
        success = false;
      if (success && !input.ReadFields(&result->fields))
        success = false;
      if (success && !input.ReadUsernamePredictions(&result->username_predictions))
        success = false;
      if (success)
        result->is_gaia_with_skip_save_password_form = input.is_gaia_with_skip_save_password_form();
      if (success)
        result->likely_contains_captcha = input.likely_contains_captcha();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::FormFieldDataPredictions::DataView, ::autofill::mojom::FormFieldDataPredictionsPtr>::Read(
    ::autofill::mojom::FormFieldDataPredictions::DataView input,
    ::autofill::mojom::FormFieldDataPredictionsPtr* output) {
  bool success = true;
  ::autofill::mojom::FormFieldDataPredictionsPtr result(::autofill::mojom::FormFieldDataPredictions::New());
  
      if (success && !input.ReadHostFormSignature(&result->host_form_signature))
        success = false;
      if (success && !input.ReadSignature(&result->signature))
        success = false;
      if (success && !input.ReadHeuristicType(&result->heuristic_type))
        success = false;
      if (success && !input.ReadPwmMlType(&result->pwm_ml_type))
        success = false;
      if (success && !input.ReadServerType(&result->server_type))
        success = false;
      if (success && !input.ReadHtmlType(&result->html_type))
        success = false;
      if (success && !input.ReadOverallType(&result->overall_type))
        success = false;
      if (success && !input.ReadAttributeTypes(&result->attribute_types))
        success = false;
      if (success && !input.ReadFormatString(&result->format_string))
        success = false;
      if (success && !input.ReadParseableName(&result->parseable_name))
        success = false;
      if (success && !input.ReadParseableLabel(&result->parseable_label))
        success = false;
      if (success && !input.ReadSection(&result->section))
        success = false;
      if (success)
        result->rank = input.rank();
      if (success)
        result->rank_in_signature_group = input.rank_in_signature_group();
      if (success)
        result->rank_in_host_form = input.rank_in_host_form();
      if (success)
        result->rank_in_host_form_signature_group = input.rank_in_host_form_signature_group();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::FormDataPredictions::DataView, ::autofill::mojom::FormDataPredictionsPtr>::Read(
    ::autofill::mojom::FormDataPredictions::DataView input,
    ::autofill::mojom::FormDataPredictionsPtr* output) {
  bool success = true;
  ::autofill::mojom::FormDataPredictionsPtr result(::autofill::mojom::FormDataPredictions::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadSignature(&result->signature))
        success = false;
      if (success && !input.ReadAlternativeSignature(&result->alternative_signature))
        success = false;
      if (success && !input.ReadFields(&result->fields))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::PasswordAndMetadata::DataView, ::autofill::mojom::PasswordAndMetadataPtr>::Read(
    ::autofill::mojom::PasswordAndMetadata::DataView input,
    ::autofill::mojom::PasswordAndMetadataPtr* output) {
  bool success = true;
  ::autofill::mojom::PasswordAndMetadataPtr result(::autofill::mojom::PasswordAndMetadata::New());
  
      if (success && !input.ReadUsernameValue(&result->username_value))
        success = false;
      if (success && !input.ReadPasswordValue(&result->password_value))
        success = false;
      if (success && !input.ReadRealm(&result->realm))
        success = false;
      if (success)
        result->uses_account_store = input.uses_account_store();
      if (success)
        result->is_grouped_affiliation = input.is_grouped_affiliation();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::PasswordFormFillData::DataView, ::autofill::mojom::PasswordFormFillDataPtr>::Read(
    ::autofill::mojom::PasswordFormFillData::DataView input,
    ::autofill::mojom::PasswordFormFillDataPtr* output) {
  bool success = true;
  ::autofill::mojom::PasswordFormFillDataPtr result(::autofill::mojom::PasswordFormFillData::New());
  
      if (success && !input.ReadFormRendererId(&result->form_renderer_id))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadUsernameElementRendererId(&result->username_element_renderer_id))
        success = false;
      if (success && !input.ReadPasswordElementRendererId(&result->password_element_renderer_id))
        success = false;
      if (success && !input.ReadPreferredLogin(&result->preferred_login))
        success = false;
      if (success && !input.ReadAdditionalLogins(&result->additional_logins))
        success = false;
      if (success)
        result->wait_for_username = input.wait_for_username();
      if (success && !input.ReadSuggestionBannedFields(&result->suggestion_banned_fields))
        success = false;
      if (success)
        result->notify_browser_of_successful_filling = input.notify_browser_of_successful_filling();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::PasswordFormGenerationData::DataView, ::autofill::mojom::PasswordFormGenerationDataPtr>::Read(
    ::autofill::mojom::PasswordFormGenerationData::DataView input,
    ::autofill::mojom::PasswordFormGenerationDataPtr* output) {
  bool success = true;
  ::autofill::mojom::PasswordFormGenerationDataPtr result(::autofill::mojom::PasswordFormGenerationData::New());
  
      if (success && !input.ReadNewPasswordRendererId(&result->new_password_renderer_id))
        success = false;
      if (success && !input.ReadConfirmationPasswordRendererId(&result->confirmation_password_renderer_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::PasswordGenerationUIData::DataView, ::autofill::mojom::PasswordGenerationUIDataPtr>::Read(
    ::autofill::mojom::PasswordGenerationUIData::DataView input,
    ::autofill::mojom::PasswordGenerationUIDataPtr* output) {
  bool success = true;
  ::autofill::mojom::PasswordGenerationUIDataPtr result(::autofill::mojom::PasswordGenerationUIData::New());
  
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
      if (success)
        result->max_length = input.max_length();
      if (success && !input.ReadGenerationElement(&result->generation_element))
        success = false;
      if (success && !input.ReadGenerationElementId(&result->generation_element_id))
        success = false;
      if (success)
        result->is_generation_element_password_type = input.is_generation_element_password_type();
      if (success && !input.ReadTextDirection(&result->text_direction))
        success = false;
      if (success && !input.ReadFormData(&result->form_data))
        success = false;
      if (success)
        result->generation_rejected = input.generation_rejected();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::TriggeringField::DataView, ::autofill::mojom::TriggeringFieldPtr>::Read(
    ::autofill::mojom::TriggeringField::DataView input,
    ::autofill::mojom::TriggeringFieldPtr* output) {
  bool success = true;
  ::autofill::mojom::TriggeringFieldPtr result(::autofill::mojom::TriggeringField::New());
  
      if (success && !input.ReadElementId(&result->element_id))
        success = false;
      if (success && !input.ReadTriggerSource(&result->trigger_source))
        success = false;
      if (success && !input.ReadTextDirection(&result->text_direction))
        success = false;
      if (success && !input.ReadTypedUsername(&result->typed_username))
        success = false;
      if (success)
        result->show_webauthn_credentials = input.show_webauthn_credentials();
      if (success)
        result->show_identity_credentials = input.show_identity_credentials();
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::PasswordSuggestionRequest::DataView, ::autofill::mojom::PasswordSuggestionRequestPtr>::Read(
    ::autofill::mojom::PasswordSuggestionRequest::DataView input,
    ::autofill::mojom::PasswordSuggestionRequestPtr* output) {
  bool success = true;
  ::autofill::mojom::PasswordSuggestionRequestPtr result(::autofill::mojom::PasswordSuggestionRequest::New());
  
      if (success && !input.ReadField(&result->field))
        success = false;
      if (success && !input.ReadFormData(&result->form_data))
        success = false;
      if (success)
        result->username_field_index = input.username_field_index();
      if (success)
        result->password_field_index = input.password_field_index();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::autofill::mojom::ParsingResult::DataView, ::autofill::mojom::ParsingResultPtr>::Read(
    ::autofill::mojom::ParsingResult::DataView input,
    ::autofill::mojom::ParsingResultPtr* output) {
  bool success = true;
  ::autofill::mojom::ParsingResultPtr result(::autofill::mojom::ParsingResult::New());
  
      if (success && !input.ReadUsernameRendererId(&result->username_renderer_id))
        success = false;
      if (success && !input.ReadPasswordRendererId(&result->password_renderer_id))
        success = false;
      if (success && !input.ReadNewPasswordRendererId(&result->new_password_renderer_id))
        success = false;
      if (success && !input.ReadConfirmPasswordRendererId(&result->confirm_password_renderer_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace autofill::mojom {




}  // autofill::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif