// components/autofill/core/common/mojom/autofill_types.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_SEND_VALIDATION_H_

#include "components/autofill/core/common/mojom/autofill_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "components/autofill/core/common/mojom/autofill_types.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::FormControlType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::HtmlFieldMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::HtmlFieldType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::SubmissionIndicatorEvent, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::SubmissionSource, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::FocusedFieldType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::ButtonTitleType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::SubmissionReadinessState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::AutofillSuggestionAvailability, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::ActionPersistence, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::FormActionType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::FieldActionType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::autofill::mojom::AutofillSuggestionTriggerSource, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::FrameTokenDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FrameTokenDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FrameToken_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::token(input)) in_token = Traits::token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->token)::BaseType> token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_token,
        token_fragment);

      fragment->token.Set(
          token_fragment.is_null() ? nullptr : token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in FrameToken struct");

      fragment->is_local = Traits::is_local(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::FrameTokenWithPredecessorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FrameTokenWithPredecessorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FrameTokenWithPredecessor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::token(input)) in_token = Traits::token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->token)::BaseType> token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FrameTokenDataView, send_validation>(
        in_token,
        token_fragment);

      fragment->token.Set(
          token_fragment.is_null() ? nullptr : token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in FrameTokenWithPredecessor struct");

      fragment->predecessor = Traits::predecessor(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::FormRendererIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormRendererIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormRendererId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::FieldRendererIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FieldRendererIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FieldRendererId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::SelectOptionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::SelectOptionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::SelectOption_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in SelectOption struct");

      decltype(Traits::text(input)) in_text = Traits::text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text)::BaseType> text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_text,
        text_fragment);

      fragment->text.Set(
          text_fragment.is_null() ? nullptr : text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text in SelectOption struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::AutocompleteParsingResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::AutocompleteParsingResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::AutocompleteParsingResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::section(input)) in_section = Traits::section(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->section)::BaseType> section_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_section,
        section_fragment);

      fragment->section.Set(
          section_fragment.is_null() ? nullptr : section_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->section.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null section in AutocompleteParsingResult struct");

      
      mojo::internal::Serialize<::autofill::mojom::HtmlFieldMode>(
        Traits::mode(input),
        &fragment->mode);

      
      mojo::internal::Serialize<::autofill::mojom::HtmlFieldType>(
        Traits::field_type(input),
        &fragment->field_type);

      fragment->webauthn = Traits::webauthn(input);

      fragment->webidentity = Traits::webidentity(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::FormFieldDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormFieldDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormFieldData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in FormFieldData struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in FormFieldData struct");

      decltype(Traits::id_attribute(input)) in_id_attribute = Traits::id_attribute(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id_attribute)::BaseType> id_attribute_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_id_attribute,
        id_attribute_fragment);

      fragment->id_attribute.Set(
          id_attribute_fragment.is_null() ? nullptr : id_attribute_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id_attribute.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id_attribute in FormFieldData struct");

      decltype(Traits::name_attribute(input)) in_name_attribute = Traits::name_attribute(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name_attribute)::BaseType> name_attribute_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name_attribute,
        name_attribute_fragment);

      fragment->name_attribute.Set(
          name_attribute_fragment.is_null() ? nullptr : name_attribute_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name_attribute.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name_attribute in FormFieldData struct");

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in FormFieldData struct");

      decltype(Traits::selected_text(input)) in_selected_text = Traits::selected_text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->selected_text)::BaseType> selected_text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_selected_text,
        selected_text_fragment);

      fragment->selected_text.Set(
          selected_text_fragment.is_null() ? nullptr : selected_text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->selected_text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null selected_text in FormFieldData struct");

      
      mojo::internal::Serialize<::autofill::mojom::FormControlType>(
        Traits::form_control_type(input),
        &fragment->form_control_type);

      decltype(Traits::autocomplete_attribute(input)) in_autocomplete_attribute = Traits::autocomplete_attribute(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->autocomplete_attribute)::BaseType> autocomplete_attribute_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_autocomplete_attribute,
        autocomplete_attribute_fragment);

      fragment->autocomplete_attribute.Set(
          autocomplete_attribute_fragment.is_null() ? nullptr : autocomplete_attribute_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->autocomplete_attribute.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null autocomplete_attribute in FormFieldData struct");

      decltype(Traits::parsed_autocomplete(input)) in_parsed_autocomplete = Traits::parsed_autocomplete(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parsed_autocomplete)::BaseType> parsed_autocomplete_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::AutocompleteParsingResultDataView, send_validation>(
        in_parsed_autocomplete,
        parsed_autocomplete_fragment);

      fragment->parsed_autocomplete.Set(
          parsed_autocomplete_fragment.is_null() ? nullptr : parsed_autocomplete_fragment.data());

      decltype(Traits::pattern(input)) in_pattern = Traits::pattern(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pattern)::BaseType> pattern_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_pattern,
        pattern_fragment);

      fragment->pattern.Set(
          pattern_fragment.is_null() ? nullptr : pattern_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pattern.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pattern in FormFieldData struct");

      decltype(Traits::placeholder(input)) in_placeholder = Traits::placeholder(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->placeholder)::BaseType> placeholder_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_placeholder,
        placeholder_fragment);

      fragment->placeholder.Set(
          placeholder_fragment.is_null() ? nullptr : placeholder_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->placeholder.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null placeholder in FormFieldData struct");

      decltype(Traits::css_classes(input)) in_css_classes = Traits::css_classes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->css_classes)::BaseType> css_classes_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_css_classes,
        css_classes_fragment);

      fragment->css_classes.Set(
          css_classes_fragment.is_null() ? nullptr : css_classes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->css_classes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null css_classes in FormFieldData struct");

      decltype(Traits::aria_label(input)) in_aria_label = Traits::aria_label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aria_label)::BaseType> aria_label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_aria_label,
        aria_label_fragment);

      fragment->aria_label.Set(
          aria_label_fragment.is_null() ? nullptr : aria_label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aria_label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aria_label in FormFieldData struct");

      decltype(Traits::aria_description(input)) in_aria_description = Traits::aria_description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aria_description)::BaseType> aria_description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_aria_description,
        aria_description_fragment);

      fragment->aria_description.Set(
          aria_description_fragment.is_null() ? nullptr : aria_description_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aria_description.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aria_description in FormFieldData struct");

      decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nonce)::BaseType> nonce_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_nonce,
        nonce_fragment);

      fragment->nonce.Set(
          nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->nonce.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null nonce in FormFieldData struct");

      decltype(Traits::renderer_id(input)) in_renderer_id = Traits::renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->renderer_id)::BaseType> renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_renderer_id,
        renderer_id_fragment);

      fragment->renderer_id.Set(
          renderer_id_fragment.is_null() ? nullptr : renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null renderer_id in FormFieldData struct");

      decltype(Traits::host_form_id(input)) in_host_form_id = Traits::host_form_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host_form_id)::BaseType> host_form_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FormRendererIdDataView, send_validation>(
        in_host_form_id,
        host_form_id_fragment);

      fragment->host_form_id.Set(
          host_form_id_fragment.is_null() ? nullptr : host_form_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->host_form_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_form_id in FormFieldData struct");

      fragment->properties_mask = Traits::properties_mask(input);

      fragment->form_control_ax_id = Traits::form_control_ax_id(input);

      fragment->max_length = Traits::max_length(input);

      fragment->is_user_edited = Traits::is_user_edited(input);

      fragment->is_autofilled = Traits::is_autofilled(input);

      
      mojo::internal::Serialize<::autofill::mojom::FormFieldData_CheckStatus>(
        Traits::check_status(input),
        &fragment->check_status);

      fragment->is_focusable = Traits::is_focusable(input);

      fragment->is_visible = Traits::is_visible(input);

      fragment->should_autocomplete = Traits::should_autocomplete(input);

      
      mojo::internal::Serialize<::autofill::mojom::FormFieldData_RoleAttribute>(
        Traits::role(input),
        &fragment->role);

      
      mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
        Traits::text_direction(input),
        &fragment->text_direction);

      fragment->is_enabled = Traits::is_enabled(input);

      fragment->is_readonly = Traits::is_readonly(input);

      decltype(Traits::user_input(input)) in_user_input = Traits::user_input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->user_input)::BaseType> user_input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_user_input,
        user_input_fragment);

      fragment->user_input.Set(
          user_input_fragment.is_null() ? nullptr : user_input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->user_input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_input in FormFieldData struct");

      fragment->allows_writing_suggestions = Traits::allows_writing_suggestions(input);

      decltype(Traits::options(input)) in_options = Traits::options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->options)::BaseType>
          options_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& options_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::SelectOptionDataView>, send_validation>(
        in_options,
        options_fragment,
        &options_validate_params);

      fragment->options.Set(
          options_fragment.is_null() ? nullptr : options_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->options.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null options in FormFieldData struct");

      
      mojo::internal::Serialize<::autofill::mojom::FormFieldData_LabelSource>(
        Traits::label_source(input),
        &fragment->label_source);

      decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounds)::BaseType> bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_bounds,
        bounds_fragment);

      fragment->bounds.Set(
          bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in FormFieldData struct");

      decltype(Traits::datalist_options(input)) in_datalist_options = Traits::datalist_options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->datalist_options)::BaseType>
          datalist_options_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& datalist_options_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::SelectOptionDataView>, send_validation>(
        in_datalist_options,
        datalist_options_fragment,
        &datalist_options_validate_params);

      fragment->datalist_options.Set(
          datalist_options_fragment.is_null() ? nullptr : datalist_options_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->datalist_options.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null datalist_options in FormFieldData struct");

      fragment->force_override = Traits::force_override(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::FormFieldData_FillDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormFieldData_FillDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormFieldData_FillData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in FormFieldData_FillData struct");

      decltype(Traits::renderer_id(input)) in_renderer_id = Traits::renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->renderer_id)::BaseType> renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_renderer_id,
        renderer_id_fragment);

      fragment->renderer_id.Set(
          renderer_id_fragment.is_null() ? nullptr : renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null renderer_id in FormFieldData_FillData struct");

      decltype(Traits::host_form_id(input)) in_host_form_id = Traits::host_form_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host_form_id)::BaseType> host_form_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FormRendererIdDataView, send_validation>(
        in_host_form_id,
        host_form_id_fragment);

      fragment->host_form_id.Set(
          host_form_id_fragment.is_null() ? nullptr : host_form_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->host_form_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_form_id in FormFieldData_FillData struct");

      fragment->is_autofilled = Traits::is_autofilled(input);

      fragment->force_override = Traits::force_override(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::ButtonTitleInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::ButtonTitleInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::ButtonTitleInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in ButtonTitleInfo struct");

      
      mojo::internal::Serialize<::autofill::mojom::ButtonTitleType>(
        Traits::type(input),
        &fragment->type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::FormDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id_attribute(input)) in_id_attribute = Traits::id_attribute(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id_attribute)::BaseType> id_attribute_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_id_attribute,
        id_attribute_fragment);

      fragment->id_attribute.Set(
          id_attribute_fragment.is_null() ? nullptr : id_attribute_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id_attribute.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id_attribute in FormData struct");

      decltype(Traits::name_attribute(input)) in_name_attribute = Traits::name_attribute(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name_attribute)::BaseType> name_attribute_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name_attribute,
        name_attribute_fragment);

      fragment->name_attribute.Set(
          name_attribute_fragment.is_null() ? nullptr : name_attribute_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name_attribute.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name_attribute in FormData struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in FormData struct");

      decltype(Traits::button_titles(input)) in_button_titles = Traits::button_titles(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->button_titles)::BaseType>
          button_titles_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& button_titles_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::ButtonTitleInfoDataView>, send_validation>(
        in_button_titles,
        button_titles_fragment,
        &button_titles_validate_params);

      fragment->button_titles.Set(
          button_titles_fragment.is_null() ? nullptr : button_titles_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->button_titles.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null button_titles in FormData struct");

      decltype(Traits::action(input)) in_action = Traits::action(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->action)::BaseType> action_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_action,
        action_fragment);

      fragment->action.Set(
          action_fragment.is_null() ? nullptr : action_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->action.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null action in FormData struct");

      fragment->is_action_empty = Traits::is_action_empty(input);

      decltype(Traits::renderer_id(input)) in_renderer_id = Traits::renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->renderer_id)::BaseType> renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FormRendererIdDataView, send_validation>(
        in_renderer_id,
        renderer_id_fragment);

      fragment->renderer_id.Set(
          renderer_id_fragment.is_null() ? nullptr : renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null renderer_id in FormData struct");

      decltype(Traits::child_frames(input)) in_child_frames = Traits::child_frames(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->child_frames)::BaseType>
          child_frames_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& child_frames_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FrameTokenWithPredecessorDataView>, send_validation>(
        in_child_frames,
        child_frames_fragment,
        &child_frames_validate_params);

      fragment->child_frames.Set(
          child_frames_fragment.is_null() ? nullptr : child_frames_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->child_frames.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null child_frames in FormData struct");

      
      mojo::internal::Serialize<::autofill::mojom::SubmissionIndicatorEvent>(
        Traits::submission_event(input),
        &fragment->submission_event);

      decltype(Traits::fields(input)) in_fields = Traits::fields(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fields)::BaseType>
          fields_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FormFieldDataDataView>, send_validation>(
        in_fields,
        fields_fragment,
        &fields_validate_params);

      fragment->fields.Set(
          fields_fragment.is_null() ? nullptr : fields_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fields.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fields in FormData struct");

      decltype(Traits::username_predictions(input)) in_username_predictions = Traits::username_predictions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->username_predictions)::BaseType>
          username_predictions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& username_predictions_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FieldRendererIdDataView>, send_validation>(
        in_username_predictions,
        username_predictions_fragment,
        &username_predictions_validate_params);

      fragment->username_predictions.Set(
          username_predictions_fragment.is_null() ? nullptr : username_predictions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->username_predictions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username_predictions in FormData struct");

      fragment->is_gaia_with_skip_save_password_form = Traits::is_gaia_with_skip_save_password_form(input);

      fragment->likely_contains_captcha = Traits::likely_contains_captcha(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::FormFieldDataPredictionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormFieldDataPredictionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormFieldDataPredictions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::host_form_signature(input)) in_host_form_signature = Traits::host_form_signature(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host_form_signature)::BaseType> host_form_signature_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_host_form_signature,
        host_form_signature_fragment);

      fragment->host_form_signature.Set(
          host_form_signature_fragment.is_null() ? nullptr : host_form_signature_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->host_form_signature.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_form_signature in FormFieldDataPredictions struct");

      decltype(Traits::signature(input)) in_signature = Traits::signature(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->signature)::BaseType> signature_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_signature,
        signature_fragment);

      fragment->signature.Set(
          signature_fragment.is_null() ? nullptr : signature_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->signature.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature in FormFieldDataPredictions struct");

      decltype(Traits::heuristic_type(input)) in_heuristic_type = Traits::heuristic_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->heuristic_type)::BaseType> heuristic_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_heuristic_type,
        heuristic_type_fragment);

      fragment->heuristic_type.Set(
          heuristic_type_fragment.is_null() ? nullptr : heuristic_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->heuristic_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null heuristic_type in FormFieldDataPredictions struct");

      decltype(Traits::pwm_ml_type(input)) in_pwm_ml_type = Traits::pwm_ml_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pwm_ml_type)::BaseType> pwm_ml_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_pwm_ml_type,
        pwm_ml_type_fragment);

      fragment->pwm_ml_type.Set(
          pwm_ml_type_fragment.is_null() ? nullptr : pwm_ml_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pwm_ml_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pwm_ml_type in FormFieldDataPredictions struct");

      decltype(Traits::server_type(input)) in_server_type = Traits::server_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->server_type)::BaseType> server_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_server_type,
        server_type_fragment);

      fragment->server_type.Set(
          server_type_fragment.is_null() ? nullptr : server_type_fragment.data());

      decltype(Traits::html_type(input)) in_html_type = Traits::html_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->html_type)::BaseType> html_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_html_type,
        html_type_fragment);

      fragment->html_type.Set(
          html_type_fragment.is_null() ? nullptr : html_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->html_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null html_type in FormFieldDataPredictions struct");

      decltype(Traits::overall_type(input)) in_overall_type = Traits::overall_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->overall_type)::BaseType> overall_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_overall_type,
        overall_type_fragment);

      fragment->overall_type.Set(
          overall_type_fragment.is_null() ? nullptr : overall_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->overall_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null overall_type in FormFieldDataPredictions struct");

      decltype(Traits::attribute_types(input)) in_attribute_types = Traits::attribute_types(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->attribute_types)::BaseType> attribute_types_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_attribute_types,
        attribute_types_fragment);

      fragment->attribute_types.Set(
          attribute_types_fragment.is_null() ? nullptr : attribute_types_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->attribute_types.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attribute_types in FormFieldDataPredictions struct");

      decltype(Traits::format_string(input)) in_format_string = Traits::format_string(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->format_string)::BaseType> format_string_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_format_string,
        format_string_fragment);

      fragment->format_string.Set(
          format_string_fragment.is_null() ? nullptr : format_string_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->format_string.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null format_string in FormFieldDataPredictions struct");

      decltype(Traits::parseable_name(input)) in_parseable_name = Traits::parseable_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parseable_name)::BaseType> parseable_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_parseable_name,
        parseable_name_fragment);

      fragment->parseable_name.Set(
          parseable_name_fragment.is_null() ? nullptr : parseable_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->parseable_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parseable_name in FormFieldDataPredictions struct");

      decltype(Traits::parseable_label(input)) in_parseable_label = Traits::parseable_label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parseable_label)::BaseType> parseable_label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_parseable_label,
        parseable_label_fragment);

      fragment->parseable_label.Set(
          parseable_label_fragment.is_null() ? nullptr : parseable_label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->parseable_label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null parseable_label in FormFieldDataPredictions struct");

      decltype(Traits::section(input)) in_section = Traits::section(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->section)::BaseType> section_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_section,
        section_fragment);

      fragment->section.Set(
          section_fragment.is_null() ? nullptr : section_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->section.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null section in FormFieldDataPredictions struct");

      fragment->rank = Traits::rank(input);

      fragment->rank_in_signature_group = Traits::rank_in_signature_group(input);

      fragment->rank_in_host_form = Traits::rank_in_host_form(input);

      fragment->rank_in_host_form_signature_group = Traits::rank_in_host_form_signature_group(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::FormDataPredictionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::FormDataPredictionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::FormDataPredictions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::data(input)) in_data = Traits::data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->data)::BaseType> data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FormDataDataView, send_validation>(
        in_data,
        data_fragment);

      fragment->data.Set(
          data_fragment.is_null() ? nullptr : data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in FormDataPredictions struct");

      decltype(Traits::signature(input)) in_signature = Traits::signature(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->signature)::BaseType> signature_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_signature,
        signature_fragment);

      fragment->signature.Set(
          signature_fragment.is_null() ? nullptr : signature_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->signature.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature in FormDataPredictions struct");

      decltype(Traits::alternative_signature(input)) in_alternative_signature = Traits::alternative_signature(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->alternative_signature)::BaseType> alternative_signature_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_alternative_signature,
        alternative_signature_fragment);

      fragment->alternative_signature.Set(
          alternative_signature_fragment.is_null() ? nullptr : alternative_signature_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->alternative_signature.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alternative_signature in FormDataPredictions struct");

      decltype(Traits::fields(input)) in_fields = Traits::fields(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fields)::BaseType>
          fields_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FormFieldDataPredictionsDataView>, send_validation>(
        in_fields,
        fields_fragment,
        &fields_validate_params);

      fragment->fields.Set(
          fields_fragment.is_null() ? nullptr : fields_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fields.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fields in FormDataPredictions struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::PasswordAndMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::PasswordAndMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::PasswordAndMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::username_value(input)) in_username_value = Traits::username_value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->username_value)::BaseType> username_value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_username_value,
        username_value_fragment);

      fragment->username_value.Set(
          username_value_fragment.is_null() ? nullptr : username_value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->username_value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username_value in PasswordAndMetadata struct");

      decltype(Traits::password_value(input)) in_password_value = Traits::password_value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->password_value)::BaseType> password_value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_password_value,
        password_value_fragment);

      fragment->password_value.Set(
          password_value_fragment.is_null() ? nullptr : password_value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->password_value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null password_value in PasswordAndMetadata struct");

      decltype(Traits::realm(input)) in_realm = Traits::realm(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->realm)::BaseType> realm_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_realm,
        realm_fragment);

      fragment->realm.Set(
          realm_fragment.is_null() ? nullptr : realm_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->realm.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null realm in PasswordAndMetadata struct");

      fragment->uses_account_store = Traits::uses_account_store(input);

      fragment->is_grouped_affiliation = Traits::is_grouped_affiliation(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::PasswordFormFillDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::PasswordFormFillDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::PasswordFormFillData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::form_renderer_id(input)) in_form_renderer_id = Traits::form_renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->form_renderer_id)::BaseType> form_renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FormRendererIdDataView, send_validation>(
        in_form_renderer_id,
        form_renderer_id_fragment);

      fragment->form_renderer_id.Set(
          form_renderer_id_fragment.is_null() ? nullptr : form_renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->form_renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null form_renderer_id in PasswordFormFillData struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in PasswordFormFillData struct");

      decltype(Traits::username_element_renderer_id(input)) in_username_element_renderer_id = Traits::username_element_renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->username_element_renderer_id)::BaseType> username_element_renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_username_element_renderer_id,
        username_element_renderer_id_fragment);

      fragment->username_element_renderer_id.Set(
          username_element_renderer_id_fragment.is_null() ? nullptr : username_element_renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->username_element_renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username_element_renderer_id in PasswordFormFillData struct");

      decltype(Traits::password_element_renderer_id(input)) in_password_element_renderer_id = Traits::password_element_renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->password_element_renderer_id)::BaseType> password_element_renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_password_element_renderer_id,
        password_element_renderer_id_fragment);

      fragment->password_element_renderer_id.Set(
          password_element_renderer_id_fragment.is_null() ? nullptr : password_element_renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->password_element_renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null password_element_renderer_id in PasswordFormFillData struct");

      decltype(Traits::preferred_login(input)) in_preferred_login = Traits::preferred_login(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->preferred_login)::BaseType> preferred_login_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::PasswordAndMetadataDataView, send_validation>(
        in_preferred_login,
        preferred_login_fragment);

      fragment->preferred_login.Set(
          preferred_login_fragment.is_null() ? nullptr : preferred_login_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->preferred_login.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null preferred_login in PasswordFormFillData struct");

      decltype(Traits::additional_logins(input)) in_additional_logins = Traits::additional_logins(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->additional_logins)::BaseType>
          additional_logins_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& additional_logins_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::PasswordAndMetadataDataView>, send_validation>(
        in_additional_logins,
        additional_logins_fragment,
        &additional_logins_validate_params);

      fragment->additional_logins.Set(
          additional_logins_fragment.is_null() ? nullptr : additional_logins_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->additional_logins.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null additional_logins in PasswordFormFillData struct");

      fragment->wait_for_username = Traits::wait_for_username(input);

      decltype(Traits::suggestion_banned_fields(input)) in_suggestion_banned_fields = Traits::suggestion_banned_fields(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->suggestion_banned_fields)::BaseType>
          suggestion_banned_fields_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& suggestion_banned_fields_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::autofill::mojom::FieldRendererIdDataView>, send_validation>(
        in_suggestion_banned_fields,
        suggestion_banned_fields_fragment,
        &suggestion_banned_fields_validate_params);

      fragment->suggestion_banned_fields.Set(
          suggestion_banned_fields_fragment.is_null() ? nullptr : suggestion_banned_fields_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->suggestion_banned_fields.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null suggestion_banned_fields in PasswordFormFillData struct");

      fragment->notify_browser_of_successful_filling = Traits::notify_browser_of_successful_filling(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::PasswordFormGenerationDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::PasswordFormGenerationDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::PasswordFormGenerationData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::new_password_renderer_id(input)) in_new_password_renderer_id = Traits::new_password_renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->new_password_renderer_id)::BaseType> new_password_renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_new_password_renderer_id,
        new_password_renderer_id_fragment);

      fragment->new_password_renderer_id.Set(
          new_password_renderer_id_fragment.is_null() ? nullptr : new_password_renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->new_password_renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_password_renderer_id in PasswordFormGenerationData struct");

      decltype(Traits::confirmation_password_renderer_id(input)) in_confirmation_password_renderer_id = Traits::confirmation_password_renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->confirmation_password_renderer_id)::BaseType> confirmation_password_renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_confirmation_password_renderer_id,
        confirmation_password_renderer_id_fragment);

      fragment->confirmation_password_renderer_id.Set(
          confirmation_password_renderer_id_fragment.is_null() ? nullptr : confirmation_password_renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->confirmation_password_renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null confirmation_password_renderer_id in PasswordFormGenerationData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::PasswordGenerationUIDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::PasswordGenerationUIDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::PasswordGenerationUIData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounds)::BaseType> bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_bounds,
        bounds_fragment);

      fragment->bounds.Set(
          bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in PasswordGenerationUIData struct");

      fragment->max_length = Traits::max_length(input);

      decltype(Traits::generation_element(input)) in_generation_element = Traits::generation_element(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->generation_element)::BaseType> generation_element_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_generation_element,
        generation_element_fragment);

      fragment->generation_element.Set(
          generation_element_fragment.is_null() ? nullptr : generation_element_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->generation_element.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null generation_element in PasswordGenerationUIData struct");

      decltype(Traits::generation_element_id(input)) in_generation_element_id = Traits::generation_element_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->generation_element_id)::BaseType> generation_element_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_generation_element_id,
        generation_element_id_fragment);

      fragment->generation_element_id.Set(
          generation_element_id_fragment.is_null() ? nullptr : generation_element_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->generation_element_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null generation_element_id in PasswordGenerationUIData struct");

      fragment->is_generation_element_password_type = Traits::is_generation_element_password_type(input);

      
      mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
        Traits::text_direction(input),
        &fragment->text_direction);

      decltype(Traits::form_data(input)) in_form_data = Traits::form_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->form_data)::BaseType> form_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FormDataDataView, send_validation>(
        in_form_data,
        form_data_fragment);

      fragment->form_data.Set(
          form_data_fragment.is_null() ? nullptr : form_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->form_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null form_data in PasswordGenerationUIData struct");

      fragment->generation_rejected = Traits::generation_rejected(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::TriggeringFieldDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::TriggeringFieldDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::TriggeringField_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->element_id)::BaseType> element_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_element_id,
        element_id_fragment);

      fragment->element_id.Set(
          element_id_fragment.is_null() ? nullptr : element_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->element_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null element_id in TriggeringField struct");

      
      mojo::internal::Serialize<::autofill::mojom::AutofillSuggestionTriggerSource>(
        Traits::trigger_source(input),
        &fragment->trigger_source);

      
      mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
        Traits::text_direction(input),
        &fragment->text_direction);

      decltype(Traits::typed_username(input)) in_typed_username = Traits::typed_username(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->typed_username)::BaseType> typed_username_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_typed_username,
        typed_username_fragment);

      fragment->typed_username.Set(
          typed_username_fragment.is_null() ? nullptr : typed_username_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->typed_username.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null typed_username in TriggeringField struct");

      fragment->show_webauthn_credentials = Traits::show_webauthn_credentials(input);

      fragment->show_identity_credentials = Traits::show_identity_credentials(input);

      decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounds)::BaseType> bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_bounds,
        bounds_fragment);

      fragment->bounds.Set(
          bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in TriggeringField struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::PasswordSuggestionRequestDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::PasswordSuggestionRequestDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::PasswordSuggestionRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::field(input)) in_field = Traits::field(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->field)::BaseType> field_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::TriggeringFieldDataView, send_validation>(
        in_field,
        field_fragment);

      fragment->field.Set(
          field_fragment.is_null() ? nullptr : field_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->field.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null field in PasswordSuggestionRequest struct");

      decltype(Traits::form_data(input)) in_form_data = Traits::form_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->form_data)::BaseType> form_data_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FormDataDataView, send_validation>(
        in_form_data,
        form_data_fragment);

      fragment->form_data.Set(
          form_data_fragment.is_null() ? nullptr : form_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->form_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null form_data in PasswordSuggestionRequest struct");

      fragment->username_field_index = Traits::username_field_index(input);

      fragment->password_field_index = Traits::password_field_index(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::autofill::mojom::ParsingResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::autofill::mojom::ParsingResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::autofill::mojom::internal::ParsingResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::username_renderer_id(input)) in_username_renderer_id = Traits::username_renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->username_renderer_id)::BaseType> username_renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_username_renderer_id,
        username_renderer_id_fragment);

      fragment->username_renderer_id.Set(
          username_renderer_id_fragment.is_null() ? nullptr : username_renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->username_renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null username_renderer_id in ParsingResult struct");

      decltype(Traits::password_renderer_id(input)) in_password_renderer_id = Traits::password_renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->password_renderer_id)::BaseType> password_renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_password_renderer_id,
        password_renderer_id_fragment);

      fragment->password_renderer_id.Set(
          password_renderer_id_fragment.is_null() ? nullptr : password_renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->password_renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null password_renderer_id in ParsingResult struct");

      decltype(Traits::new_password_renderer_id(input)) in_new_password_renderer_id = Traits::new_password_renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->new_password_renderer_id)::BaseType> new_password_renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_new_password_renderer_id,
        new_password_renderer_id_fragment);

      fragment->new_password_renderer_id.Set(
          new_password_renderer_id_fragment.is_null() ? nullptr : new_password_renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->new_password_renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_password_renderer_id in ParsingResult struct");

      decltype(Traits::confirm_password_renderer_id(input)) in_confirm_password_renderer_id = Traits::confirm_password_renderer_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->confirm_password_renderer_id)::BaseType> confirm_password_renderer_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::autofill::mojom::FieldRendererIdDataView, send_validation>(
        in_confirm_password_renderer_id,
        confirm_password_renderer_id_fragment);

      fragment->confirm_password_renderer_id.Set(
          confirm_password_renderer_id_fragment.is_null() ? nullptr : confirm_password_renderer_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->confirm_password_renderer_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null confirm_password_renderer_id in ParsingResult struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_AUTOFILL_CORE_COMMON_MOJOM_AUTOFILL_TYPES_MOJOM_SEND_VALIDATION_H_