// components/autofill/content/common/mojom/autofill_agent.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_AGENT_MOJOM_H_
#define COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_AGENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/autofill/content/common/mojom/autofill_agent.mojom-features.h"  // IWYU pragma: export
#include "components/autofill/content/common/mojom/autofill_agent.mojom-shared.h"  // IWYU pragma: export
#include "components/autofill/content/common/mojom/autofill_agent.mojom-forward.h"  // IWYU pragma: export
#include "components/autofill/core/common/mojom/autofill_types.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace autofill::mojom {

class AutofillAgentProxy;

template <typename ImplRefTraits>
class AutofillAgentStub;

class AutofillAgentRequestValidator;
class AutofillAgentResponseValidator;


class AutofillAgent
    : public AutofillAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "autofill.mojom.AutofillAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AutofillAgentInterfaceBase;
  using Proxy_ = AutofillAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = AutofillAgentStub<ImplRefTraits>;

  using RequestValidator_ = AutofillAgentRequestValidator;
  using ResponseValidator_ = AutofillAgentResponseValidator;
  enum MethodMinVersions : uint32_t {
    kTriggerFormExtractionMinVersion = 0,
    kTriggerFormExtractionWithResponseMinVersion = 0,
    kApplyFieldsActionMinVersion = 0,
    kApplyFieldActionMinVersion = 0,
    kExtractFormWithFieldMinVersion = 0,
    kExtractLabeledTextNodeValueMinVersion = 0,
    kFieldTypePredictionsAvailableMinVersion = 0,
    kExposeDomNodeIdsMinVersion = 0,
    kClearPreviewedFormMinVersion = 0,
    kTriggerSuggestionsMinVersion = 0,
    kSetSuggestionAvailabilityMinVersion = 0,
    kAcceptDataListSuggestionMinVersion = 0,
    kPreviewPasswordSuggestionMinVersion = 0,
    kPreviewPasswordGenerationSuggestionMinVersion = 0,
    kGetPotentialLastFourCombinationsForStandaloneCvcMinVersion = 0,
    kDispatchEmailVerifiedEventMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct TriggerFormExtraction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TriggerFormExtractionWithResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ApplyFieldsAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ApplyFieldAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExtractFormWithField_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExtractLabeledTextNodeValue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FieldTypePredictionsAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExposeDomNodeIds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearPreviewedForm_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TriggerSuggestions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSuggestionAvailability_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AcceptDataListSuggestion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreviewPasswordSuggestion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreviewPasswordGenerationSuggestion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPotentialLastFourCombinationsForStandaloneCvc_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchEmailVerifiedEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AutofillAgent() = default;

  virtual void TriggerFormExtraction() = 0;

  using TriggerFormExtractionWithResponseCallback = base::OnceCallback<void(bool)>;
  using TriggerFormExtractionWithResponseMojoCallback = base::OnceCallback<void(bool)>;

  virtual void TriggerFormExtractionWithResponse(TriggerFormExtractionWithResponseCallback callback) = 0;

  virtual void ApplyFieldsAction(::autofill::mojom::FormActionType action_type, ::autofill::mojom::ActionPersistence action_persistence, const std::vector<::autofill::FormFieldData::FillData>& fields) = 0;

  virtual void ApplyFieldAction(::autofill::mojom::FieldActionType action_type, ::autofill::mojom::ActionPersistence action_persistence, ::autofill::FieldRendererId field, const ::std::u16string& value) = 0;

  using ExtractFormWithFieldCallback = base::OnceCallback<void(const std::optional<::autofill::FormData>&)>;
  using ExtractFormWithFieldMojoCallback = base::OnceCallback<void(const std::optional<::autofill::FormData>&)>;

  virtual void ExtractFormWithField(::autofill::FieldRendererId field_id, ExtractFormWithFieldCallback callback) = 0;

  using ExtractLabeledTextNodeValueCallback = base::OnceCallback<void(const std::string&)>;
  using ExtractLabeledTextNodeValueMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void ExtractLabeledTextNodeValue(const ::std::u16string& value_regex, const ::std::u16string& label_regex, uint32_t number_of_ancestor_levels_to_search, ExtractLabeledTextNodeValueCallback callback) = 0;

  virtual void FieldTypePredictionsAvailable(const std::vector<::autofill::FormDataPredictions>& forms) = 0;

  virtual void ExposeDomNodeIds() = 0;

  virtual void ClearPreviewedForm() = 0;

  virtual void TriggerSuggestions(::autofill::FieldRendererId field, ::autofill::mojom::AutofillSuggestionTriggerSource trigger_source) = 0;

  virtual void SetSuggestionAvailability(::autofill::FieldRendererId field, ::autofill::mojom::AutofillSuggestionAvailability suggestion_availability) = 0;

  virtual void AcceptDataListSuggestion(::autofill::FieldRendererId field, const ::std::u16string& value) = 0;

  virtual void PreviewPasswordSuggestion(const ::std::u16string& username, const ::std::u16string& password) = 0;

  virtual void PreviewPasswordGenerationSuggestion(const ::std::u16string& password) = 0;

  using GetPotentialLastFourCombinationsForStandaloneCvcCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  using GetPotentialLastFourCombinationsForStandaloneCvcMojoCallback = base::OnceCallback<void(const std::vector<std::string>&)>;

  virtual void GetPotentialLastFourCombinationsForStandaloneCvc(GetPotentialLastFourCombinationsForStandaloneCvcCallback callback) = 0;

  virtual void DispatchEmailVerifiedEvent(::autofill::FieldRendererId field_id, const std::string& presentation_token) = 0;
};

class PasswordAutofillAgentProxy;

template <typename ImplRefTraits>
class PasswordAutofillAgentStub;

class PasswordAutofillAgentRequestValidator;
class PasswordAutofillAgentResponseValidator;


class PasswordAutofillAgent
    : public PasswordAutofillAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "autofill.mojom.PasswordAutofillAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PasswordAutofillAgentInterfaceBase;
  using Proxy_ = PasswordAutofillAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = PasswordAutofillAgentStub<ImplRefTraits>;

  using RequestValidator_ = PasswordAutofillAgentRequestValidator;
  using ResponseValidator_ = PasswordAutofillAgentResponseValidator;
  enum MethodMinVersions : uint32_t {
    kApplyFillDataOnParsingCompletionMinVersion = 0,
    kFillPasswordSuggestionMinVersion = 0,
    kFillPasswordSuggestionByIdMinVersion = 0,
    kPreviewPasswordSuggestionByIdMinVersion = 0,
    kInformNoSavedCredentialsMinVersion = 0,
    kFillIntoFocusedFieldMinVersion = 0,
    kPreviewFieldMinVersion = 0,
    kFillFieldMinVersion = 0,
    kFillChangePasswordFormMinVersion = 0,
    kSetLoggingStateMinVersion = 0,
    kAnnotateFieldsWithParsingResultMinVersion = 0,
    kCheckViewAreaVisibleMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ApplyFillDataOnParsingCompletion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FillPasswordSuggestion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FillPasswordSuggestionById_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreviewPasswordSuggestionById_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InformNoSavedCredentials_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FillIntoFocusedField_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreviewField_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FillField_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FillChangePasswordForm_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetLoggingState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AnnotateFieldsWithParsingResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CheckViewAreaVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PasswordAutofillAgent() = default;

  virtual void ApplyFillDataOnParsingCompletion(const ::autofill::PasswordFormFillData& form_data) = 0;

  using FillPasswordSuggestionCallback = base::OnceCallback<void(bool)>;
  using FillPasswordSuggestionMojoCallback = base::OnceCallback<void(bool)>;

  virtual void FillPasswordSuggestion(const ::std::u16string& username, const ::std::u16string& password, FillPasswordSuggestionCallback callback) = 0;

  virtual void FillPasswordSuggestionById(::autofill::FieldRendererId username_element_id, ::autofill::FieldRendererId password_element_id, const ::std::u16string& username, const ::std::u16string& password, ::autofill::mojom::AutofillSuggestionTriggerSource suggestion_source) = 0;

  virtual void PreviewPasswordSuggestionById(::autofill::FieldRendererId username_element_id, ::autofill::FieldRendererId password_element_id, const ::std::u16string& username, const ::std::u16string& password) = 0;

  virtual void InformNoSavedCredentials(bool should_show_popup_without_passwords) = 0;

  virtual void FillIntoFocusedField(bool is_password, const ::std::u16string& credential) = 0;

  virtual void PreviewField(::autofill::FieldRendererId field_id, const ::std::u16string& value) = 0;

  using FillFieldCallback = base::OnceCallback<void(bool)>;
  using FillFieldMojoCallback = base::OnceCallback<void(bool)>;

  virtual void FillField(::autofill::FieldRendererId field_id, const ::std::u16string& value, uint32_t field_properties, FillFieldCallback callback) = 0;

  using FillChangePasswordFormCallback = base::OnceCallback<void(const std::optional<::autofill::FormData>&)>;
  using FillChangePasswordFormMojoCallback = base::OnceCallback<void(const std::optional<::autofill::FormData>&)>;

  virtual void FillChangePasswordForm(::autofill::FieldRendererId password_element_id, ::autofill::FieldRendererId new_password_element_id, ::autofill::FieldRendererId confirm_password_element_id, const ::std::u16string& old_password, const ::std::u16string& new_password, FillChangePasswordFormCallback callback) = 0;

  virtual void SetLoggingState(bool active) = 0;

  virtual void AnnotateFieldsWithParsingResult(const ::autofill::ParsingResult& parsing_result) = 0;

  using CheckViewAreaVisibleCallback = base::OnceCallback<void(bool)>;
  using CheckViewAreaVisibleMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CheckViewAreaVisible(::autofill::FieldRendererId field_id, CheckViewAreaVisibleCallback callback) = 0;
};

class PasswordGenerationAgentProxy;

template <typename ImplRefTraits>
class PasswordGenerationAgentStub;

class PasswordGenerationAgentRequestValidator;
class PasswordGenerationAgentResponseValidator;


class PasswordGenerationAgent
    : public PasswordGenerationAgentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "autofill.mojom.PasswordGenerationAgent";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PasswordGenerationAgentInterfaceBase;
  using Proxy_ = PasswordGenerationAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = PasswordGenerationAgentStub<ImplRefTraits>;

  using RequestValidator_ = PasswordGenerationAgentRequestValidator;
  using ResponseValidator_ = PasswordGenerationAgentResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGeneratedPasswordAcceptedMinVersion = 0,
    kGeneratedPasswordRejectedMinVersion = 0,
    kTriggeredGeneratePasswordMinVersion = 0,
    kFoundFormEligibleForGenerationMinVersion = 0,
    kFocusNextFieldAfterPasswordsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GeneratedPasswordAccepted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GeneratedPasswordRejected_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TriggeredGeneratePassword_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FoundFormEligibleForGeneration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusNextFieldAfterPasswords_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PasswordGenerationAgent() = default;

  virtual void GeneratedPasswordAccepted(const ::std::u16string& generated_password) = 0;

  virtual void GeneratedPasswordRejected() = 0;

  using TriggeredGeneratePasswordCallback = base::OnceCallback<void(const std::optional<::autofill::password_generation::PasswordGenerationUIData>&)>;
  using TriggeredGeneratePasswordMojoCallback = base::OnceCallback<void(const std::optional<::autofill::password_generation::PasswordGenerationUIData>&)>;

  virtual void TriggeredGeneratePassword(TriggeredGeneratePasswordCallback callback) = 0;

  virtual void FoundFormEligibleForGeneration(const ::autofill::PasswordFormGenerationData& form) = 0;

  virtual void FocusNextFieldAfterPasswords() = 0;
};



class  AutofillAgentProxy
    : public AutofillAgent {
 public:
  using InterfaceType = AutofillAgent;

  explicit AutofillAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void TriggerFormExtraction() final;
  
  void TriggerFormExtractionWithResponse(TriggerFormExtractionWithResponseCallback callback) final;
  
  void ApplyFieldsAction(::autofill::mojom::FormActionType action_type, ::autofill::mojom::ActionPersistence action_persistence, const std::vector<::autofill::FormFieldData::FillData>& fields) final;
  
  void ApplyFieldAction(::autofill::mojom::FieldActionType action_type, ::autofill::mojom::ActionPersistence action_persistence, ::autofill::FieldRendererId field, const ::std::u16string& value) final;
  
  void ExtractFormWithField(::autofill::FieldRendererId field_id, ExtractFormWithFieldCallback callback) final;
  
  void ExtractLabeledTextNodeValue(const ::std::u16string& value_regex, const ::std::u16string& label_regex, uint32_t number_of_ancestor_levels_to_search, ExtractLabeledTextNodeValueCallback callback) final;
  
  void FieldTypePredictionsAvailable(const std::vector<::autofill::FormDataPredictions>& forms) final;
  
  void ExposeDomNodeIds() final;
  
  void ClearPreviewedForm() final;
  
  void TriggerSuggestions(::autofill::FieldRendererId field, ::autofill::mojom::AutofillSuggestionTriggerSource trigger_source) final;
  
  void SetSuggestionAvailability(::autofill::FieldRendererId field, ::autofill::mojom::AutofillSuggestionAvailability suggestion_availability) final;
  
  void AcceptDataListSuggestion(::autofill::FieldRendererId field, const ::std::u16string& value) final;
  
  void PreviewPasswordSuggestion(const ::std::u16string& username, const ::std::u16string& password) final;
  
  void PreviewPasswordGenerationSuggestion(const ::std::u16string& password) final;
  
  void GetPotentialLastFourCombinationsForStandaloneCvc(GetPotentialLastFourCombinationsForStandaloneCvcCallback callback) final;
  
  void DispatchEmailVerifiedEvent(::autofill::FieldRendererId field_id, const std::string& presentation_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PasswordAutofillAgentProxy
    : public PasswordAutofillAgent {
 public:
  using InterfaceType = PasswordAutofillAgent;

  explicit PasswordAutofillAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ApplyFillDataOnParsingCompletion(const ::autofill::PasswordFormFillData& form_data) final;
  
  void FillPasswordSuggestion(const ::std::u16string& username, const ::std::u16string& password, FillPasswordSuggestionCallback callback) final;
  
  void FillPasswordSuggestionById(::autofill::FieldRendererId username_element_id, ::autofill::FieldRendererId password_element_id, const ::std::u16string& username, const ::std::u16string& password, ::autofill::mojom::AutofillSuggestionTriggerSource suggestion_source) final;
  
  void PreviewPasswordSuggestionById(::autofill::FieldRendererId username_element_id, ::autofill::FieldRendererId password_element_id, const ::std::u16string& username, const ::std::u16string& password) final;
  
  void InformNoSavedCredentials(bool should_show_popup_without_passwords) final;
  
  void FillIntoFocusedField(bool is_password, const ::std::u16string& credential) final;
  
  void PreviewField(::autofill::FieldRendererId field_id, const ::std::u16string& value) final;
  
  void FillField(::autofill::FieldRendererId field_id, const ::std::u16string& value, uint32_t field_properties, FillFieldCallback callback) final;
  
  void FillChangePasswordForm(::autofill::FieldRendererId password_element_id, ::autofill::FieldRendererId new_password_element_id, ::autofill::FieldRendererId confirm_password_element_id, const ::std::u16string& old_password, const ::std::u16string& new_password, FillChangePasswordFormCallback callback) final;
  
  void SetLoggingState(bool active) final;
  
  void AnnotateFieldsWithParsingResult(const ::autofill::ParsingResult& parsing_result) final;
  
  void CheckViewAreaVisible(::autofill::FieldRendererId field_id, CheckViewAreaVisibleCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PasswordGenerationAgentProxy
    : public PasswordGenerationAgent {
 public:
  using InterfaceType = PasswordGenerationAgent;

  explicit PasswordGenerationAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GeneratedPasswordAccepted(const ::std::u16string& generated_password) final;
  
  void GeneratedPasswordRejected() final;
  
  void TriggeredGeneratePassword(TriggeredGeneratePasswordCallback callback) final;
  
  void FoundFormEligibleForGeneration(const ::autofill::PasswordFormGenerationData& form) final;
  
  void FocusNextFieldAfterPasswords() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AutofillAgentStubDispatch {
 public:
  static bool Accept(AutofillAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AutofillAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AutofillAgent>>
class AutofillAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AutofillAgentStub() = default;
  ~AutofillAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutofillAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PasswordAutofillAgentStubDispatch {
 public:
  static bool Accept(PasswordAutofillAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PasswordAutofillAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PasswordAutofillAgent>>
class PasswordAutofillAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PasswordAutofillAgentStub() = default;
  ~PasswordAutofillAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PasswordAutofillAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PasswordAutofillAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PasswordGenerationAgentStubDispatch {
 public:
  static bool Accept(PasswordGenerationAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PasswordGenerationAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PasswordGenerationAgent>>
class PasswordGenerationAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PasswordGenerationAgentStub() = default;
  ~PasswordGenerationAgentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PasswordGenerationAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PasswordGenerationAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AutofillAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PasswordAutofillAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PasswordGenerationAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AutofillAgentResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PasswordAutofillAgentResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PasswordGenerationAgentResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // autofill::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_AGENT_MOJOM_H_