// components/autofill/content/common/mojom/autofill_agent.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_AGENT_MOJOM_TEST_UTILS_H_
#define COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_AGENT_MOJOM_TEST_UTILS_H_

#include "components/autofill/content/common/mojom/autofill_agent.mojom.h"


namespace autofill::mojom {


class  AutofillAgentInterceptorForTesting : public AutofillAgent {
  virtual AutofillAgent* GetForwardingInterface() = 0;
  void TriggerFormExtraction() override;
  void TriggerFormExtractionWithResponse(TriggerFormExtractionWithResponseCallback callback) override;
  void ApplyFieldsAction(::autofill::mojom::FormActionType action_type, ::autofill::mojom::ActionPersistence action_persistence, const std::vector<::autofill::FormFieldData::FillData>& fields) override;
  void ApplyFieldAction(::autofill::mojom::FieldActionType action_type, ::autofill::mojom::ActionPersistence action_persistence, ::autofill::FieldRendererId field, const ::std::u16string& value) override;
  void ExtractFormWithField(::autofill::FieldRendererId field_id, ExtractFormWithFieldCallback callback) override;
  void ExtractLabeledTextNodeValue(const ::std::u16string& value_regex, const ::std::u16string& label_regex, uint32_t number_of_ancestor_levels_to_search, ExtractLabeledTextNodeValueCallback callback) override;
  void FieldTypePredictionsAvailable(const std::vector<::autofill::FormDataPredictions>& forms) override;
  void ExposeDomNodeIds() override;
  void ClearPreviewedForm() override;
  void TriggerSuggestions(::autofill::FieldRendererId field, ::autofill::mojom::AutofillSuggestionTriggerSource trigger_source) override;
  void SetSuggestionAvailability(::autofill::FieldRendererId field, ::autofill::mojom::AutofillSuggestionAvailability suggestion_availability) override;
  void AcceptDataListSuggestion(::autofill::FieldRendererId field, const ::std::u16string& value) override;
  void PreviewPasswordSuggestion(const ::std::u16string& username, const ::std::u16string& password) override;
  void PreviewPasswordGenerationSuggestion(const ::std::u16string& password) override;
  void GetPotentialLastFourCombinationsForStandaloneCvc(GetPotentialLastFourCombinationsForStandaloneCvcCallback callback) override;
  void DispatchEmailVerifiedEvent(::autofill::FieldRendererId field_id, const std::string& presentation_token) override;
};
class  AutofillAgentAsyncWaiter {
 public:
  explicit AutofillAgentAsyncWaiter(AutofillAgent* proxy);

  AutofillAgentAsyncWaiter(const AutofillAgentAsyncWaiter&) = delete;
  AutofillAgentAsyncWaiter& operator=(const AutofillAgentAsyncWaiter&) = delete;

  ~AutofillAgentAsyncWaiter();
  void TriggerFormExtractionWithResponse(
      bool* out_success);
  bool TriggerFormExtractionWithResponse();
  void ExtractFormWithField(
      ::autofill::FieldRendererId field_id, std::optional<::autofill::FormData>* out_form);
  std::optional<::autofill::FormData> ExtractFormWithField(::autofill::FieldRendererId field_id);
  void ExtractLabeledTextNodeValue(
      const ::std::u16string& value_regex, const ::std::u16string& label_regex, uint32_t number_of_ancestor_levels_to_search, std::string* out_value);
  std::string ExtractLabeledTextNodeValue(const ::std::u16string& value_regex, const ::std::u16string& label_regex, uint32_t number_of_ancestor_levels_to_search);
  void GetPotentialLastFourCombinationsForStandaloneCvc(
      std::vector<std::string>* out_potential_matches);
  std::vector<std::string> GetPotentialLastFourCombinationsForStandaloneCvc();

 private:
  AutofillAgent* const proxy_;
};


class  PasswordAutofillAgentInterceptorForTesting : public PasswordAutofillAgent {
  virtual PasswordAutofillAgent* GetForwardingInterface() = 0;
  void ApplyFillDataOnParsingCompletion(const ::autofill::PasswordFormFillData& form_data) override;
  void FillPasswordSuggestion(const ::std::u16string& username, const ::std::u16string& password, FillPasswordSuggestionCallback callback) override;
  void FillPasswordSuggestionById(::autofill::FieldRendererId username_element_id, ::autofill::FieldRendererId password_element_id, const ::std::u16string& username, const ::std::u16string& password, ::autofill::mojom::AutofillSuggestionTriggerSource suggestion_source) override;
  void PreviewPasswordSuggestionById(::autofill::FieldRendererId username_element_id, ::autofill::FieldRendererId password_element_id, const ::std::u16string& username, const ::std::u16string& password) override;
  void InformNoSavedCredentials(bool should_show_popup_without_passwords) override;
  void FillIntoFocusedField(bool is_password, const ::std::u16string& credential) override;
  void PreviewField(::autofill::FieldRendererId field_id, const ::std::u16string& value) override;
  void FillField(::autofill::FieldRendererId field_id, const ::std::u16string& value, uint32_t field_properties, FillFieldCallback callback) override;
  void FillChangePasswordForm(::autofill::FieldRendererId password_element_id, ::autofill::FieldRendererId new_password_element_id, ::autofill::FieldRendererId confirm_password_element_id, const ::std::u16string& old_password, const ::std::u16string& new_password, FillChangePasswordFormCallback callback) override;
  void SetLoggingState(bool active) override;
  void AnnotateFieldsWithParsingResult(const ::autofill::ParsingResult& parsing_result) override;
  void CheckViewAreaVisible(::autofill::FieldRendererId field_id, CheckViewAreaVisibleCallback callback) override;
};
class  PasswordAutofillAgentAsyncWaiter {
 public:
  explicit PasswordAutofillAgentAsyncWaiter(PasswordAutofillAgent* proxy);

  PasswordAutofillAgentAsyncWaiter(const PasswordAutofillAgentAsyncWaiter&) = delete;
  PasswordAutofillAgentAsyncWaiter& operator=(const PasswordAutofillAgentAsyncWaiter&) = delete;

  ~PasswordAutofillAgentAsyncWaiter();
  void FillPasswordSuggestion(
      const ::std::u16string& username, const ::std::u16string& password, bool* out_success);
  bool FillPasswordSuggestion(const ::std::u16string& username, const ::std::u16string& password);
  void FillField(
      ::autofill::FieldRendererId field_id, const ::std::u16string& value, uint32_t field_properties, bool* out_success);
  bool FillField(::autofill::FieldRendererId field_id, const ::std::u16string& value, uint32_t field_properties);
  void FillChangePasswordForm(
      ::autofill::FieldRendererId password_element_id, ::autofill::FieldRendererId new_password_element_id, ::autofill::FieldRendererId confirm_password_element_id, const ::std::u16string& old_password, const ::std::u16string& new_password, std::optional<::autofill::FormData>* out_form_data);
  std::optional<::autofill::FormData> FillChangePasswordForm(::autofill::FieldRendererId password_element_id, ::autofill::FieldRendererId new_password_element_id, ::autofill::FieldRendererId confirm_password_element_id, const ::std::u16string& old_password, const ::std::u16string& new_password);
  void CheckViewAreaVisible(
      ::autofill::FieldRendererId field_id, bool* out_is_visible);
  bool CheckViewAreaVisible(::autofill::FieldRendererId field_id);

 private:
  PasswordAutofillAgent* const proxy_;
};


class  PasswordGenerationAgentInterceptorForTesting : public PasswordGenerationAgent {
  virtual PasswordGenerationAgent* GetForwardingInterface() = 0;
  void GeneratedPasswordAccepted(const ::std::u16string& generated_password) override;
  void GeneratedPasswordRejected() override;
  void TriggeredGeneratePassword(TriggeredGeneratePasswordCallback callback) override;
  void FoundFormEligibleForGeneration(const ::autofill::PasswordFormGenerationData& form) override;
  void FocusNextFieldAfterPasswords() override;
};
class  PasswordGenerationAgentAsyncWaiter {
 public:
  explicit PasswordGenerationAgentAsyncWaiter(PasswordGenerationAgent* proxy);

  PasswordGenerationAgentAsyncWaiter(const PasswordGenerationAgentAsyncWaiter&) = delete;
  PasswordGenerationAgentAsyncWaiter& operator=(const PasswordGenerationAgentAsyncWaiter&) = delete;

  ~PasswordGenerationAgentAsyncWaiter();
  void TriggeredGeneratePassword(
      std::optional<::autofill::password_generation::PasswordGenerationUIData>* out_data);
  std::optional<::autofill::password_generation::PasswordGenerationUIData> TriggeredGeneratePassword();

 private:
  PasswordGenerationAgent* const proxy_;
};




}  // autofill::mojom

#endif  // COMPONENTS_AUTOFILL_CONTENT_COMMON_MOJOM_AUTOFILL_AGENT_MOJOM_TEST_UTILS_H_