// components/attribution_reporting/registration_header_error.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_H_
#define COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/attribution_reporting/registration_header_error.mojom-features.h"  // IWYU pragma: export
#include "components/attribution_reporting/registration_header_error.mojom-shared.h"  // IWYU pragma: export
#include "components/attribution_reporting/registration_header_error.mojom-forward.h"  // IWYU pragma: export
#include "components/attribution_reporting/os_registration_error.mojom-forward.h"
#include "components/attribution_reporting/source_registration_error.mojom-forward.h"
#include "components/attribution_reporting/trigger_registration_error.mojom-forward.h"
#include <string>
#include <vector>




#include "components/attribution_reporting/registration_header_error_mojom_traits.h"




namespace attribution_reporting::mojom {






class  RegistrationHeaderErrorDetails {
 public:
  using DataView = RegistrationHeaderErrorDetailsDataView;
  using Data_ = internal::RegistrationHeaderErrorDetails_Data;
  using Tag = Data_::RegistrationHeaderErrorDetails_Tag;

  template <typename... Args>
  static RegistrationHeaderErrorDetailsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |source_error|.
  static RegistrationHeaderErrorDetailsPtr NewSourceError(
      ::attribution_reporting::mojom::SourceRegistrationError value);
  // Construct an instance holding |trigger_error|.
  static RegistrationHeaderErrorDetailsPtr NewTriggerError(
      ::attribution_reporting::mojom::TriggerRegistrationError value);
  // Construct an instance holding |os_source_error|.
  static RegistrationHeaderErrorDetailsPtr NewOsSourceError(
      ::attribution_reporting::mojom::OsRegistrationError value);
  // Construct an instance holding |os_trigger_error|.
  static RegistrationHeaderErrorDetailsPtr NewOsTriggerError(
      ::attribution_reporting::mojom::OsRegistrationError value);

  template <typename U>
  static RegistrationHeaderErrorDetailsPtr From(const U& u) {
    return mojo::TypeConverter<RegistrationHeaderErrorDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RegistrationHeaderErrorDetails>::Convert(*this);
  }
  ~RegistrationHeaderErrorDetails();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = RegistrationHeaderErrorDetailsPtr>
  RegistrationHeaderErrorDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RegistrationHeaderErrorDetails>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, RegistrationHeaderErrorDetails>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_source_error() const { return tag_ == Tag::kSourceError; }
  ::attribution_reporting::mojom::SourceRegistrationError get_source_error() const {
    CHECK(tag_ == Tag::kSourceError);
    return data_.source_error;
  }
  void set_source_error(::attribution_reporting::mojom::SourceRegistrationError source_error);

  bool is_trigger_error() const { return tag_ == Tag::kTriggerError; }
  ::attribution_reporting::mojom::TriggerRegistrationError get_trigger_error() const {
    CHECK(tag_ == Tag::kTriggerError);
    return data_.trigger_error;
  }
  void set_trigger_error(::attribution_reporting::mojom::TriggerRegistrationError trigger_error);

  bool is_os_source_error() const { return tag_ == Tag::kOsSourceError; }
  ::attribution_reporting::mojom::OsRegistrationError get_os_source_error() const {
    CHECK(tag_ == Tag::kOsSourceError);
    return data_.os_source_error;
  }
  void set_os_source_error(::attribution_reporting::mojom::OsRegistrationError os_source_error);

  bool is_os_trigger_error() const { return tag_ == Tag::kOsTriggerError; }
  ::attribution_reporting::mojom::OsRegistrationError get_os_trigger_error() const {
    CHECK(tag_ == Tag::kOsTriggerError);
    return data_.os_trigger_error;
  }
  void set_os_trigger_error(::attribution_reporting::mojom::OsRegistrationError os_trigger_error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RegistrationHeaderErrorDetails::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<RegistrationHeaderErrorDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSourceError)>,
        ::attribution_reporting::mojom::SourceRegistrationError value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTriggerError)>,
        ::attribution_reporting::mojom::TriggerRegistrationError value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOsSourceError)>,
        ::attribution_reporting::mojom::OsRegistrationError value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOsTriggerError)>,
        ::attribution_reporting::mojom::OsRegistrationError value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::attribution_reporting::mojom::SourceRegistrationError source_error;
    ::attribution_reporting::mojom::TriggerRegistrationError trigger_error;
    ::attribution_reporting::mojom::OsRegistrationError os_source_error;
    ::attribution_reporting::mojom::OsRegistrationError os_trigger_error;
  };

  RegistrationHeaderErrorDetails(
      std::in_place_index_t<static_cast<size_t>(Tag::kSourceError)>,
      ::attribution_reporting::mojom::SourceRegistrationError value);
  RegistrationHeaderErrorDetails(
      std::in_place_index_t<static_cast<size_t>(Tag::kTriggerError)>,
      ::attribution_reporting::mojom::TriggerRegistrationError value);
  RegistrationHeaderErrorDetails(
      std::in_place_index_t<static_cast<size_t>(Tag::kOsSourceError)>,
      ::attribution_reporting::mojom::OsRegistrationError value);
  RegistrationHeaderErrorDetails(
      std::in_place_index_t<static_cast<size_t>(Tag::kOsTriggerError)>,
      ::attribution_reporting::mojom::OsRegistrationError value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  RegistrationHeaderError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RegistrationHeaderError, T>::value>;
  using DataView = RegistrationHeaderErrorDataView;
  using Data_ = internal::RegistrationHeaderError_Data;

  template <typename... Args>
  static RegistrationHeaderErrorPtr New(Args&&... args) {
    return RegistrationHeaderErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RegistrationHeaderErrorPtr From(const U& u) {
    return mojo::TypeConverter<RegistrationHeaderErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RegistrationHeaderError>::Convert(*this);
  }


  RegistrationHeaderError();

  RegistrationHeaderError(
      const std::string& header_value,
      const ::attribution_reporting::RegistrationHeaderErrorDetails& error_details);


  ~RegistrationHeaderError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RegistrationHeaderErrorPtr>
  RegistrationHeaderErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RegistrationHeaderError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RegistrationHeaderError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RegistrationHeaderError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RegistrationHeaderError::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RegistrationHeaderError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RegistrationHeaderError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RegistrationHeaderError_UnserializedMessageContext<
            UserType, RegistrationHeaderError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RegistrationHeaderError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RegistrationHeaderError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RegistrationHeaderError_UnserializedMessageContext<
            UserType, RegistrationHeaderError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RegistrationHeaderError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string header_value;
  
  ::attribution_reporting::RegistrationHeaderErrorDetails error_details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RegistrationHeaderError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RegistrationHeaderError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RegistrationHeaderError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RegistrationHeaderError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
RegistrationHeaderErrorDetailsPtr RegistrationHeaderErrorDetails::Clone() const {
  switch (tag_) {
    case Tag::kSourceError:
      return NewSourceError(
          mojo::Clone(data_.source_error));
    case Tag::kTriggerError:
      return NewTriggerError(
          mojo::Clone(data_.trigger_error));
    case Tag::kOsSourceError:
      return NewOsSourceError(
          mojo::Clone(data_.os_source_error));
    case Tag::kOsTriggerError:
      return NewOsTriggerError(
          mojo::Clone(data_.os_trigger_error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RegistrationHeaderErrorDetails>::value>::type*>
bool RegistrationHeaderErrorDetails::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSourceError:
      return mojo::Equals(data_.source_error, other.data_.source_error);
    case Tag::kTriggerError:
      return mojo::Equals(data_.trigger_error, other.data_.trigger_error);
    case Tag::kOsSourceError:
      return mojo::Equals(data_.os_source_error, other.data_.os_source_error);
    case Tag::kOsTriggerError:
      return mojo::Equals(data_.os_trigger_error, other.data_.os_trigger_error);
  }

  return false;
}
template <typename StructPtrType>
RegistrationHeaderErrorPtr RegistrationHeaderError::Clone() const {
  return New(
      mojo::Clone(header_value),
      mojo::Clone(error_details)
  );
}

template <typename T, RegistrationHeaderError::EnableIfSame<T>*>
bool RegistrationHeaderError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->header_value, other_struct.header_value))
    return false;
  if (!mojo::Equals(this->error_details, other_struct.error_details))
    return false;
  return true;
}

template <typename T, RegistrationHeaderError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.header_value < rhs.header_value)
    return true;
  if (rhs.header_value < lhs.header_value)
    return false;
  if (lhs.error_details < rhs.error_details)
    return true;
  if (rhs.error_details < lhs.error_details)
    return false;
  return false;
}


}  // attribution_reporting::mojom

namespace mojo {


template <>
struct  StructTraits<::attribution_reporting::mojom::RegistrationHeaderError::DataView,
                                         ::attribution_reporting::mojom::RegistrationHeaderErrorPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::RegistrationHeaderErrorPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::RegistrationHeaderErrorPtr* output) { output->reset(); }

  static const decltype(::attribution_reporting::mojom::RegistrationHeaderError::header_value)& header_value(
      const ::attribution_reporting::mojom::RegistrationHeaderErrorPtr& input) {
    return input->header_value;
  }

  static const decltype(::attribution_reporting::mojom::RegistrationHeaderError::error_details)& error_details(
      const ::attribution_reporting::mojom::RegistrationHeaderErrorPtr& input) {
    return input->error_details;
  }

  static bool Read(::attribution_reporting::mojom::RegistrationHeaderError::DataView input, ::attribution_reporting::mojom::RegistrationHeaderErrorPtr* output);
};


template <>
struct  UnionTraits<::attribution_reporting::mojom::RegistrationHeaderErrorDetails::DataView,
                                        ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsPtr> {
  static bool IsNull(const ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsPtr& input) { return !input; }
  static void SetToNull(::attribution_reporting::mojom::RegistrationHeaderErrorDetailsPtr* output) { output->reset(); }

  static ::attribution_reporting::mojom::RegistrationHeaderErrorDetails::Tag GetTag(const ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsPtr& input) {
    return input->which();
  }

  static  ::attribution_reporting::mojom::SourceRegistrationError source_error(const ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsPtr& input) {
    return input->get_source_error();
  }

  static  ::attribution_reporting::mojom::TriggerRegistrationError trigger_error(const ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsPtr& input) {
    return input->get_trigger_error();
  }

  static  ::attribution_reporting::mojom::OsRegistrationError os_source_error(const ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsPtr& input) {
    return input->get_os_source_error();
  }

  static  ::attribution_reporting::mojom::OsRegistrationError os_trigger_error(const ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsPtr& input) {
    return input->get_os_trigger_error();
  }

  static bool Read(::attribution_reporting::mojom::RegistrationHeaderErrorDetails::DataView input, ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_H_