// components/attribution_reporting/registration_header_error.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_SHARED_H_
#define COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/attribution_reporting/registration_header_error.mojom-shared-internal.h"
#include "components/attribution_reporting/os_registration_error.mojom-shared.h"
#include "components/attribution_reporting/source_registration_error.mojom-shared.h"
#include "components/attribution_reporting/trigger_registration_error.mojom-shared.h"




#include "components/attribution_reporting/registration_header_error.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::attribution_reporting::mojom::RegistrationHeaderErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::RegistrationHeaderErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::RegistrationHeaderError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::header_value(input)) in_header_value = Traits::header_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->header_value)::BaseType> header_value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_header_value,
      header_value_fragment);

    fragment->header_value.Set(
        header_value_fragment.is_null() ? nullptr : header_value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->header_value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null header_value in RegistrationHeaderError struct");

    decltype(Traits::error_details(input)) in_error_details = Traits::error_details(input);
    mojo::internal::MessageFragment<decltype(fragment->error_details)>
        error_details_fragment(fragment.message());
    error_details_fragment.Claim(&fragment->error_details);
    
    mojo::internal::Serialize<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView>(
      in_error_details,
      error_details_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->error_details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_details in RegistrationHeaderError struct");
  }

  static bool Deserialize(::attribution_reporting::mojom::internal::RegistrationHeaderError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::attribution_reporting::mojom::RegistrationHeaderErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::attribution_reporting::mojom::internal::RegistrationHeaderErrorDetails_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kSourceError: {
    decltype(Traits::source_error(input))
    in_source_error = Traits::source_error(input);
        
mojo::internal::Serialize<::attribution_reporting::mojom::SourceRegistrationError>(
  in_source_error,
  &fragment->data.f_source_error);
    break;
  }
  case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kTriggerError: {
    decltype(Traits::trigger_error(input))
    in_trigger_error = Traits::trigger_error(input);
        
mojo::internal::Serialize<::attribution_reporting::mojom::TriggerRegistrationError>(
  in_trigger_error,
  &fragment->data.f_trigger_error);
    break;
  }
  case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kOsSourceError: {
    decltype(Traits::os_source_error(input))
    in_os_source_error = Traits::os_source_error(input);
        
mojo::internal::Serialize<::attribution_reporting::mojom::OsRegistrationError>(
  in_os_source_error,
  &fragment->data.f_os_source_error);
    break;
  }
  case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kOsTriggerError: {
    decltype(Traits::os_trigger_error(input))
    in_os_trigger_error = Traits::os_trigger_error(input);
        
mojo::internal::Serialize<::attribution_reporting::mojom::OsRegistrationError>(
  in_os_trigger_error,
  &fragment->data.f_os_trigger_error);
    break;
  }
}
  }

  static bool Deserialize(::attribution_reporting::mojom::internal::RegistrationHeaderErrorDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace attribution_reporting::mojom {

inline void RegistrationHeaderErrorDataView::GetHeaderValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header_value.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RegistrationHeaderErrorDataView::GetErrorDetailsDataView(
    RegistrationHeaderErrorDetailsDataView* output) {
  auto pointer = &data_->error_details;
  *output = RegistrationHeaderErrorDetailsDataView(pointer, message_);
}




}  // attribution_reporting::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_SHARED_H_