// components/attribution_reporting/registration_header_error.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_SEND_VALIDATION_H_

#include "components/attribution_reporting/registration_header_error.mojom-shared-internal.h"
#include "components/attribution_reporting/os_registration_error.mojom-shared.h"
#include "components/attribution_reporting/source_registration_error.mojom-shared.h"
#include "components/attribution_reporting/trigger_registration_error.mojom-shared.h"

#include "components/attribution_reporting/registration_header_error.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::RegistrationHeaderErrorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::attribution_reporting::mojom::RegistrationHeaderErrorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::attribution_reporting::mojom::internal::RegistrationHeaderError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::header_value(input)) in_header_value = Traits::header_value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->header_value)::BaseType> header_value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_header_value,
        header_value_fragment);

      fragment->header_value.Set(
          header_value_fragment.is_null() ? nullptr : header_value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->header_value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null header_value in RegistrationHeaderError struct");

      decltype(Traits::error_details(input)) in_error_details = Traits::error_details(input);
      mojo::internal::MessageFragment<decltype(fragment->error_details)>
          error_details_fragment(fragment.message());
      error_details_fragment.Claim(&fragment->error_details);
      
      mojo::internal::Serialize<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView, send_validation>(
        in_error_details,
        error_details_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->error_details.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null error_details in RegistrationHeaderError struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::attribution_reporting::mojom::internal::RegistrationHeaderErrorDetails_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kSourceError: {
    decltype(Traits::source_error(input))
    in_source_error = Traits::source_error(input);
        
mojo::internal::Serialize<::attribution_reporting::mojom::SourceRegistrationError, send_validation>(
  in_source_error,
  &fragment->data.f_source_error);
    break;
  }
  case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kTriggerError: {
    decltype(Traits::trigger_error(input))
    in_trigger_error = Traits::trigger_error(input);
        
mojo::internal::Serialize<::attribution_reporting::mojom::TriggerRegistrationError, send_validation>(
  in_trigger_error,
  &fragment->data.f_trigger_error);
    break;
  }
  case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kOsSourceError: {
    decltype(Traits::os_source_error(input))
    in_os_source_error = Traits::os_source_error(input);
        
mojo::internal::Serialize<::attribution_reporting::mojom::OsRegistrationError, send_validation>(
  in_os_source_error,
  &fragment->data.f_os_source_error);
    break;
  }
  case ::attribution_reporting::mojom::RegistrationHeaderErrorDetailsDataView::Tag::kOsTriggerError: {
    decltype(Traits::os_trigger_error(input))
    in_os_trigger_error = Traits::os_trigger_error(input);
        
mojo::internal::Serialize<::attribution_reporting::mojom::OsRegistrationError, send_validation>(
  in_os_trigger_error,
  &fragment->data.f_os_trigger_error);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_HEADER_ERROR_MOJOM_SEND_VALIDATION_H_