// components/attribution_reporting/registration_header_error.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/attribution_reporting/registration_header_error.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/attribution_reporting/registration_header_error.mojom-params-data.h"
#include "components/attribution_reporting/registration_header_error.mojom-shared-message-ids.h"

#include "components/attribution_reporting/registration_header_error.mojom-blink-import-headers.h"
#include "components/attribution_reporting/registration_header_error.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace attribution_reporting::mojom::blink {
RegistrationHeaderError::RegistrationHeaderError()
    : header_value(),
      error_details() {}

RegistrationHeaderError::RegistrationHeaderError(
    const ::blink::String& header_value_in,
    const ::attribution_reporting::RegistrationHeaderErrorDetails& error_details_in)
    : header_value(std::move(header_value_in)),
      error_details(std::move(error_details_in)) {}

RegistrationHeaderError::~RegistrationHeaderError() = default;

void RegistrationHeaderError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "header_value"), this->header_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_details"), this->error_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::attribution_reporting::RegistrationHeaderErrorDetails&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RegistrationHeaderError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RegistrationHeaderErrorDetailsPtr
RegistrationHeaderErrorDetails::NewSourceError(
    ::attribution_reporting::mojom::blink::SourceRegistrationError value) {
  return RegistrationHeaderErrorDetailsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSourceError)>,
      std::move(value));
}

RegistrationHeaderErrorDetailsPtr
RegistrationHeaderErrorDetails::NewTriggerError(
    ::attribution_reporting::mojom::blink::TriggerRegistrationError value) {
  return RegistrationHeaderErrorDetailsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTriggerError)>,
      std::move(value));
}

RegistrationHeaderErrorDetailsPtr
RegistrationHeaderErrorDetails::NewOsSourceError(
    ::attribution_reporting::mojom::blink::OsRegistrationError value) {
  return RegistrationHeaderErrorDetailsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kOsSourceError)>,
      std::move(value));
}

RegistrationHeaderErrorDetailsPtr
RegistrationHeaderErrorDetails::NewOsTriggerError(
    ::attribution_reporting::mojom::blink::OsRegistrationError value) {
  return RegistrationHeaderErrorDetailsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kOsTriggerError)>,
      std::move(value));
}

RegistrationHeaderErrorDetails::RegistrationHeaderErrorDetails(
    std::in_place_index_t<static_cast<size_t>(Tag::kSourceError)>,
    ::attribution_reporting::mojom::blink::SourceRegistrationError value)
    : tag_(Tag::kSourceError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSourceError)>,
            std::move(value)) {}

RegistrationHeaderErrorDetails::RegistrationHeaderErrorDetails(
    std::in_place_index_t<static_cast<size_t>(Tag::kTriggerError)>,
    ::attribution_reporting::mojom::blink::TriggerRegistrationError value)
    : tag_(Tag::kTriggerError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTriggerError)>,
            std::move(value)) {}

RegistrationHeaderErrorDetails::RegistrationHeaderErrorDetails(
    std::in_place_index_t<static_cast<size_t>(Tag::kOsSourceError)>,
    ::attribution_reporting::mojom::blink::OsRegistrationError value)
    : tag_(Tag::kOsSourceError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kOsSourceError)>,
            std::move(value)) {}

RegistrationHeaderErrorDetails::RegistrationHeaderErrorDetails(
    std::in_place_index_t<static_cast<size_t>(Tag::kOsTriggerError)>,
    ::attribution_reporting::mojom::blink::OsRegistrationError value)
    : tag_(Tag::kOsTriggerError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kOsTriggerError)>,
            std::move(value)) {}
RegistrationHeaderErrorDetails::~RegistrationHeaderErrorDetails() {
  DestroyActive();
}

void RegistrationHeaderErrorDetails::set_source_error(::attribution_reporting::mojom::blink::SourceRegistrationError source_error) {
  if (tag_ != Tag::kSourceError) {
    DestroyActive();
    tag_ = Tag::kSourceError;
  }
  data_.source_error = source_error;
}

void RegistrationHeaderErrorDetails::set_trigger_error(::attribution_reporting::mojom::blink::TriggerRegistrationError trigger_error) {
  if (tag_ != Tag::kTriggerError) {
    DestroyActive();
    tag_ = Tag::kTriggerError;
  }
  data_.trigger_error = trigger_error;
}

void RegistrationHeaderErrorDetails::set_os_source_error(::attribution_reporting::mojom::blink::OsRegistrationError os_source_error) {
  if (tag_ != Tag::kOsSourceError) {
    DestroyActive();
    tag_ = Tag::kOsSourceError;
  }
  data_.os_source_error = os_source_error;
}

void RegistrationHeaderErrorDetails::set_os_trigger_error(::attribution_reporting::mojom::blink::OsRegistrationError os_trigger_error) {
  if (tag_ != Tag::kOsTriggerError) {
    DestroyActive();
    tag_ = Tag::kOsTriggerError;
  }
  data_.os_trigger_error = os_trigger_error;
}


RegistrationHeaderErrorDetails::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSourceError)>,
    ::attribution_reporting::mojom::blink::SourceRegistrationError value)
    : source_error(std::move(value)) {}

RegistrationHeaderErrorDetails::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTriggerError)>,
    ::attribution_reporting::mojom::blink::TriggerRegistrationError value)
    : trigger_error(std::move(value)) {}

RegistrationHeaderErrorDetails::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kOsSourceError)>,
    ::attribution_reporting::mojom::blink::OsRegistrationError value)
    : os_source_error(std::move(value)) {}

RegistrationHeaderErrorDetails::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kOsTriggerError)>,
    ::attribution_reporting::mojom::blink::OsRegistrationError value)
    : os_trigger_error(std::move(value)) {}

void RegistrationHeaderErrorDetails::DestroyActive() {
  switch (tag_) {

    case Tag::kSourceError:
      std::destroy_at(&data_.source_error);
      break;
    case Tag::kTriggerError:
      std::destroy_at(&data_.trigger_error);
      break;
    case Tag::kOsSourceError:
      std::destroy_at(&data_.os_source_error);
      break;
    case Tag::kOsTriggerError:
      std::destroy_at(&data_.os_trigger_error);
      break;
  }
}

bool RegistrationHeaderErrorDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // attribution_reporting::mojom::blink


namespace mojo {


// static
bool StructTraits<::attribution_reporting::mojom::blink::RegistrationHeaderError::DataView, ::attribution_reporting::mojom::blink::RegistrationHeaderErrorPtr>::Read(
    ::attribution_reporting::mojom::blink::RegistrationHeaderError::DataView input,
    ::attribution_reporting::mojom::blink::RegistrationHeaderErrorPtr* output) {
  bool success = true;
  ::attribution_reporting::mojom::blink::RegistrationHeaderErrorPtr result(::attribution_reporting::mojom::blink::RegistrationHeaderError::New());
  
      if (success && !input.ReadHeaderValue(&result->header_value))
        success = false;
      if (success && !input.ReadErrorDetails(&result->error_details))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::attribution_reporting::mojom::blink::RegistrationHeaderErrorDetails::DataView, ::attribution_reporting::mojom::blink::RegistrationHeaderErrorDetailsPtr>::Read(
    ::attribution_reporting::mojom::blink::RegistrationHeaderErrorDetails::DataView input,
    ::attribution_reporting::mojom::blink::RegistrationHeaderErrorDetailsPtr* output) {
  using UnionType = ::attribution_reporting::mojom::blink::RegistrationHeaderErrorDetails;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSourceError: {
      ::attribution_reporting::mojom::blink::SourceRegistrationError result_source_error;
      if (!input.ReadSourceError(&result_source_error))
        return false;

      *output = UnionType::NewSourceError(result_source_error);
      break;
    }
    case Tag::kTriggerError: {
      ::attribution_reporting::mojom::blink::TriggerRegistrationError result_trigger_error;
      if (!input.ReadTriggerError(&result_trigger_error))
        return false;

      *output = UnionType::NewTriggerError(result_trigger_error);
      break;
    }
    case Tag::kOsSourceError: {
      ::attribution_reporting::mojom::blink::OsRegistrationError result_os_source_error;
      if (!input.ReadOsSourceError(&result_os_source_error))
        return false;

      *output = UnionType::NewOsSourceError(result_os_source_error);
      break;
    }
    case Tag::kOsTriggerError: {
      ::attribution_reporting::mojom::blink::OsRegistrationError result_os_trigger_error;
      if (!input.ReadOsTriggerError(&result_os_trigger_error))
        return false;

      *output = UnionType::NewOsTriggerError(result_os_trigger_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace attribution_reporting::mojom::blink {




}  // attribution_reporting::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif