// components/attribution_reporting/registration.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_MOJOM_DATA_VIEW_H_
#define COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/attribution_reporting/registration.mojom-shared-internal.h"
#include "components/attribution_reporting/source_registration_time_config.mojom-shared.h"
#include "components/attribution_reporting/trigger_data_matching.mojom-shared.h"
#include "components/attribution_reporting/debug_types.mojom-shared.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace attribution_reporting::mojom {
class SuitableOriginDataView;

class FilterDataDataView;

class FilterConfigDataView;

class FilterPairDataView;

class AggregationKeysDataView;

class AggregatableTriggerDataDataView;

class DestinationSetDataView;

class EventReportWindowsDataView;

class TriggerDataSetDataView;

class AggregatableDebugReportingContributionDataView;

class AggregatableDebugReportingConfigDataView;

class SourceAggregatableDebugReportingConfigDataView;

class AttributionScopesSetDataView;

class AttributionScopesDataDataView;

class AggregatableNamedBudgetDefsDataView;

class SourceRegistrationDataView;

class EventTriggerDataDataView;

class AggregatableDedupKeyDataView;

class AggregatableValuesValueDataView;

class AggregatableValuesDataView;

class AggregatableNamedBudgetCandidateDataView;

class TriggerRegistrationDataView;

class OsRegistrationItemDataView;

class OsRegistrationDataView;



}  // attribution_reporting::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::SuitableOriginDataView> {
  using Data = ::attribution_reporting::mojom::internal::SuitableOrigin_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::FilterDataDataView> {
  using Data = ::attribution_reporting::mojom::internal::FilterData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::FilterConfigDataView> {
  using Data = ::attribution_reporting::mojom::internal::FilterConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::FilterPairDataView> {
  using Data = ::attribution_reporting::mojom::internal::FilterPair_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::AggregationKeysDataView> {
  using Data = ::attribution_reporting::mojom::internal::AggregationKeys_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::AggregatableTriggerDataDataView> {
  using Data = ::attribution_reporting::mojom::internal::AggregatableTriggerData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::DestinationSetDataView> {
  using Data = ::attribution_reporting::mojom::internal::DestinationSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::EventReportWindowsDataView> {
  using Data = ::attribution_reporting::mojom::internal::EventReportWindows_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::TriggerDataSetDataView> {
  using Data = ::attribution_reporting::mojom::internal::TriggerDataSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::AggregatableDebugReportingContributionDataView> {
  using Data = ::attribution_reporting::mojom::internal::AggregatableDebugReportingContribution_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::AggregatableDebugReportingConfigDataView> {
  using Data = ::attribution_reporting::mojom::internal::AggregatableDebugReportingConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::SourceAggregatableDebugReportingConfigDataView> {
  using Data = ::attribution_reporting::mojom::internal::SourceAggregatableDebugReportingConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::AttributionScopesSetDataView> {
  using Data = ::attribution_reporting::mojom::internal::AttributionScopesSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::AttributionScopesDataDataView> {
  using Data = ::attribution_reporting::mojom::internal::AttributionScopesData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::AggregatableNamedBudgetDefsDataView> {
  using Data = ::attribution_reporting::mojom::internal::AggregatableNamedBudgetDefs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::SourceRegistrationDataView> {
  using Data = ::attribution_reporting::mojom::internal::SourceRegistration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::EventTriggerDataDataView> {
  using Data = ::attribution_reporting::mojom::internal::EventTriggerData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::AggregatableDedupKeyDataView> {
  using Data = ::attribution_reporting::mojom::internal::AggregatableDedupKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::AggregatableValuesValueDataView> {
  using Data = ::attribution_reporting::mojom::internal::AggregatableValuesValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::AggregatableValuesDataView> {
  using Data = ::attribution_reporting::mojom::internal::AggregatableValues_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::AggregatableNamedBudgetCandidateDataView> {
  using Data = ::attribution_reporting::mojom::internal::AggregatableNamedBudgetCandidate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::TriggerRegistrationDataView> {
  using Data = ::attribution_reporting::mojom::internal::TriggerRegistration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::OsRegistrationItemDataView> {
  using Data = ::attribution_reporting::mojom::internal::OsRegistrationItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::attribution_reporting::mojom::OsRegistrationDataView> {
  using Data = ::attribution_reporting::mojom::internal::OsRegistration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace attribution_reporting::mojom {


class SuitableOriginDataView {
 public:
  SuitableOriginDataView() = default;

  SuitableOriginDataView(
      internal::SuitableOrigin_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::SuitableOrigin_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FilterDataDataView {
 public:
  FilterDataDataView() = default;

  FilterDataDataView(
      internal::FilterData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilterValuesDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilterValues(UserType* output) {
    
    auto* pointer = data_->filter_values.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::FilterData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FilterConfigDataView {
 public:
  FilterConfigDataView() = default;

  FilterConfigDataView(
      internal::FilterConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLookbackWindowDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLookbackWindow(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `lookback_window` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLookbackWindow` instead "
    "of `ReadLookbackWindow if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->lookback_window.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFilterValuesDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilterValues(UserType* output) {
    
    auto* pointer = data_->filter_values.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::FilterConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FilterPairDataView {
 public:
  FilterPairDataView() = default;

  FilterPairDataView(
      internal::FilterPair_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPositiveDataView(
      mojo::ArrayDataView<FilterConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPositive(UserType* output) {
    
    auto* pointer = data_->positive.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::attribution_reporting::mojom::FilterConfigDataView>>(
        pointer, output, message_);
  }
  inline void GetNegativeDataView(
      mojo::ArrayDataView<FilterConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNegative(UserType* output) {
    
    auto* pointer = data_->negative.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::attribution_reporting::mojom::FilterConfigDataView>>(
        pointer, output, message_);
  }
 private:
  internal::FilterPair_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AggregationKeysDataView {
 public:
  AggregationKeysDataView() = default;

  AggregationKeysDataView(
      internal::AggregationKeys_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeysDataView(
      mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::Uint128DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeys(UserType* output) {
    
    auto* pointer = data_->keys.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::Uint128DataView>>(
        pointer, output, message_);
  }
 private:
  internal::AggregationKeys_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AggregatableTriggerDataDataView {
 public:
  AggregatableTriggerDataDataView() = default;

  AggregatableTriggerDataDataView(
      internal::AggregatableTriggerData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyPieceDataView(
      ::mojo_base::mojom::Uint128DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyPiece(UserType* output) {
    
    auto* pointer = data_->key_piece.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        pointer, output, message_);
  }
  inline void GetSourceKeysDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceKeys(UserType* output) {
    
    auto* pointer = data_->source_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetFiltersDataView(
      FilterPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::FilterPairDataView>(
        pointer, output, message_);
  }
 private:
  internal::AggregatableTriggerData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DestinationSetDataView {
 public:
  DestinationSetDataView() = default;

  DestinationSetDataView(
      internal::DestinationSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDestinationsDataView(
      mojo::ArrayDataView<::network::mojom::SchemefulSiteDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDestinations(UserType* output) {
    
    auto* pointer = data_->destinations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SchemefulSiteDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DestinationSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EventReportWindowsDataView {
 public:
  EventReportWindowsDataView() = default;

  EventReportWindowsDataView(
      internal::EventReportWindows_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetEndTimesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::TimeDeltaDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndTimes(UserType* output) {
    
    auto* pointer = data_->end_times.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::TimeDeltaDataView>>(
        pointer, output, message_);
  }
 private:
  internal::EventReportWindows_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TriggerDataSetDataView {
 public:
  TriggerDataSetDataView() = default;

  TriggerDataSetDataView(
      internal::TriggerDataSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTriggerDataDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTriggerData(UserType* output) {
    
    auto* pointer = data_->trigger_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
 private:
  internal::TriggerDataSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AggregatableDebugReportingContributionDataView {
 public:
  AggregatableDebugReportingContributionDataView() = default;

  AggregatableDebugReportingContributionDataView(
      internal::AggregatableDebugReportingContribution_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyPieceDataView(
      ::mojo_base::mojom::Uint128DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyPiece(UserType* output) {
    
    auto* pointer = data_->key_piece.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        pointer, output, message_);
  }
  uint32_t value() const {
    return data_->value;
  }
 private:
  internal::AggregatableDebugReportingContribution_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AggregatableDebugReportingConfigDataView {
 public:
  AggregatableDebugReportingConfigDataView() = default;

  AggregatableDebugReportingConfigDataView(
      internal::AggregatableDebugReportingConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyPieceDataView(
      ::mojo_base::mojom::Uint128DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyPiece(UserType* output) {
    
    auto* pointer = data_->key_piece.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        pointer, output, message_);
  }
  inline void GetDebugDataDataView(
      mojo::MapDataView<::attribution_reporting::mojom::DebugDataType, AggregatableDebugReportingContributionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugData(UserType* output) {
    
    auto* pointer = data_->debug_data.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::attribution_reporting::mojom::DebugDataType, ::attribution_reporting::mojom::AggregatableDebugReportingContributionDataView>>(
        pointer, output, message_);
  }
  inline void GetAggregationCoordinatorOriginDataView(
      SuitableOriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationCoordinatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::attribution_reporting::mojom::SuitableOriginDataView, UserType>(),
    "Attempting to read the optional `aggregation_coordinator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAggregationCoordinatorOrigin` instead "
    "of `ReadAggregationCoordinatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->aggregation_coordinator_origin.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::SuitableOriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::AggregatableDebugReportingConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SourceAggregatableDebugReportingConfigDataView {
 public:
  SourceAggregatableDebugReportingConfigDataView() = default;

  SourceAggregatableDebugReportingConfigDataView(
      internal::SourceAggregatableDebugReportingConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t budget() const {
    return data_->budget;
  }
  inline void GetConfigDataView(
      AggregatableDebugReportingConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfig(UserType* output) {
    
    auto* pointer = data_->config.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::AggregatableDebugReportingConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::SourceAggregatableDebugReportingConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AttributionScopesSetDataView {
 public:
  AttributionScopesSetDataView() = default;

  AttributionScopesSetDataView(
      internal::AttributionScopesSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetScopesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScopes(UserType* output) {
    
    auto* pointer = data_->scopes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AttributionScopesSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AttributionScopesDataDataView {
 public:
  AttributionScopesDataDataView() = default;

  AttributionScopesDataDataView(
      internal::AttributionScopesData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAttributionScopesSetDataView(
      AttributionScopesSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributionScopesSet(UserType* output) {
    
    auto* pointer = data_->attribution_scopes_set.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::AttributionScopesSetDataView>(
        pointer, output, message_);
  }
  uint32_t attribution_scope_limit() const {
    return data_->attribution_scope_limit;
  }
  uint32_t max_event_states() const {
    return data_->max_event_states;
  }
 private:
  internal::AttributionScopesData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AggregatableNamedBudgetDefsDataView {
 public:
  AggregatableNamedBudgetDefsDataView() = default;

  AggregatableNamedBudgetDefsDataView(
      internal::AggregatableNamedBudgetDefs_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBudgetsDataView(
      mojo::MapDataView<mojo::StringDataView, int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBudgets(UserType* output) {
    
    auto* pointer = data_->budgets.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, int32_t>>(
        pointer, output, message_);
  }
 private:
  internal::AggregatableNamedBudgetDefs_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SourceRegistrationDataView {
 public:
  SourceRegistrationDataView() = default;

  SourceRegistrationDataView(
      internal::SourceRegistration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDestinationsDataView(
      DestinationSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDestinations(UserType* output) {
    
    auto* pointer = data_->destinations.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::DestinationSetDataView>(
        pointer, output, message_);
  }
  uint64_t source_event_id() const {
    return data_->source_event_id;
  }
  inline void GetExpiryDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiry(UserType* output) {
    
    auto* pointer = data_->expiry.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetTriggerDataDataView(
      TriggerDataSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTriggerData(UserType* output) {
    
    auto* pointer = data_->trigger_data.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::TriggerDataSetDataView>(
        pointer, output, message_);
  }
  inline void GetEventReportWindowsDataView(
      EventReportWindowsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventReportWindows(UserType* output) {
    
    auto* pointer = data_->event_report_windows.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::EventReportWindowsDataView>(
        pointer, output, message_);
  }
  int32_t max_event_level_reports() const {
    return data_->max_event_level_reports;
  }
  inline void GetAggregatableReportWindowDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableReportWindow(UserType* output) {
    
    auto* pointer = data_->aggregatable_report_window.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  int64_t priority() const {
    return data_->priority;
  }
  std::optional<uint64_t> debug_key() const {

    return data_->debug_key_$flag
        ? std::make_optional(data_->debug_key_$value)
        : std::nullopt;
  }
  inline void GetFilterDataDataView(
      FilterDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilterData(UserType* output) {
    
    auto* pointer = data_->filter_data.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::FilterDataDataView>(
        pointer, output, message_);
  }
  inline void GetAggregationKeysDataView(
      AggregationKeysDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationKeys(UserType* output) {
    
    auto* pointer = data_->aggregation_keys.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::AggregationKeysDataView>(
        pointer, output, message_);
  }
  bool debug_reporting() const {
    return data_->debug_reporting;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTriggerDataMatching(UserType* output) const {
    auto data_value = data_->trigger_data_matching;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::TriggerDataMatching>(
        data_value, output);
  }
  ::attribution_reporting::mojom::TriggerDataMatching trigger_data_matching() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_reporting::mojom::TriggerDataMatching>(data_->trigger_data_matching));
  }
  double event_level_epsilon() const {
    return data_->event_level_epsilon;
  }
  inline void GetAggregatableDebugReportingConfigDataView(
      SourceAggregatableDebugReportingConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableDebugReportingConfig(UserType* output) {
    
    auto* pointer = data_->aggregatable_debug_reporting_config.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::SourceAggregatableDebugReportingConfigDataView>(
        pointer, output, message_);
  }
  int64_t destination_limit_priority() const {
    return data_->destination_limit_priority;
  }
  inline void GetAttributionScopesDataDataView(
      AttributionScopesDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributionScopesData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::attribution_reporting::mojom::AttributionScopesDataDataView, UserType>(),
    "Attempting to read the optional `attribution_scopes_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAttributionScopesData` instead "
    "of `ReadAttributionScopesData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->attribution_scopes_data.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::AttributionScopesDataDataView>(
        pointer, output, message_);
  }
  inline void GetAggregatableNamedBudgetDefsDataView(
      AggregatableNamedBudgetDefsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableNamedBudgetDefs(UserType* output) {
    
    auto* pointer = data_->aggregatable_named_budget_defs.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::AggregatableNamedBudgetDefsDataView>(
        pointer, output, message_);
  }
 private:
  internal::SourceRegistration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EventTriggerDataDataView {
 public:
  EventTriggerDataDataView() = default;

  EventTriggerDataDataView(
      internal::EventTriggerData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t data() const {
    return data_->data;
  }
  int64_t priority() const {
    return data_->priority;
  }
  std::optional<uint64_t> dedup_key() const {

    return data_->dedup_key_$flag
        ? std::make_optional(data_->dedup_key_$value)
        : std::nullopt;
  }
  inline void GetFiltersDataView(
      FilterPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::FilterPairDataView>(
        pointer, output, message_);
  }
 private:
  internal::EventTriggerData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AggregatableDedupKeyDataView {
 public:
  AggregatableDedupKeyDataView() = default;

  AggregatableDedupKeyDataView(
      internal::AggregatableDedupKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  std::optional<uint64_t> dedup_key() const {

    return data_->dedup_key_$flag
        ? std::make_optional(data_->dedup_key_$value)
        : std::nullopt;
  }
  inline void GetFiltersDataView(
      FilterPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::FilterPairDataView>(
        pointer, output, message_);
  }
 private:
  internal::AggregatableDedupKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AggregatableValuesValueDataView {
 public:
  AggregatableValuesValueDataView() = default;

  AggregatableValuesValueDataView(
      internal::AggregatableValuesValue_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t value() const {
    return data_->value;
  }
  uint64_t filtering_id() const {
    return data_->filtering_id;
  }
 private:
  internal::AggregatableValuesValue_Data* data_ = nullptr;
};


class AggregatableValuesDataView {
 public:
  AggregatableValuesDataView() = default;

  AggregatableValuesDataView(
      internal::AggregatableValues_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValuesDataView(
      mojo::MapDataView<mojo::StringDataView, AggregatableValuesValueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValues(UserType* output) {
    
    auto* pointer = data_->values.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::attribution_reporting::mojom::AggregatableValuesValueDataView>>(
        pointer, output, message_);
  }
  inline void GetFiltersDataView(
      FilterPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::FilterPairDataView>(
        pointer, output, message_);
  }
 private:
  internal::AggregatableValues_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AggregatableNamedBudgetCandidateDataView {
 public:
  AggregatableNamedBudgetCandidateDataView() = default;

  AggregatableNamedBudgetCandidateDataView(
      internal::AggregatableNamedBudgetCandidate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFiltersDataView(
      FilterPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::FilterPairDataView>(
        pointer, output, message_);
  }
 private:
  internal::AggregatableNamedBudgetCandidate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TriggerRegistrationDataView {
 public:
  TriggerRegistrationDataView() = default;

  TriggerRegistrationDataView(
      internal::TriggerRegistration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEventTriggersDataView(
      mojo::ArrayDataView<EventTriggerDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventTriggers(UserType* output) {
    
    auto* pointer = data_->event_triggers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::attribution_reporting::mojom::EventTriggerDataDataView>>(
        pointer, output, message_);
  }
  inline void GetFiltersDataView(
      FilterPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::FilterPairDataView>(
        pointer, output, message_);
  }
  inline void GetAggregatableTriggerDataDataView(
      mojo::ArrayDataView<AggregatableTriggerDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableTriggerData(UserType* output) {
    
    auto* pointer = data_->aggregatable_trigger_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::attribution_reporting::mojom::AggregatableTriggerDataDataView>>(
        pointer, output, message_);
  }
  inline void GetAggregatableValuesDataView(
      mojo::ArrayDataView<AggregatableValuesDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableValues(UserType* output) {
    
    auto* pointer = data_->aggregatable_values.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::attribution_reporting::mojom::AggregatableValuesDataView>>(
        pointer, output, message_);
  }
  std::optional<uint64_t> debug_key() const {

    return data_->debug_key_$flag
        ? std::make_optional(data_->debug_key_$value)
        : std::nullopt;
  }
  inline void GetAggregatableDedupKeysDataView(
      mojo::ArrayDataView<AggregatableDedupKeyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableDedupKeys(UserType* output) {
    
    auto* pointer = data_->aggregatable_dedup_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::attribution_reporting::mojom::AggregatableDedupKeyDataView>>(
        pointer, output, message_);
  }
  bool debug_reporting() const {
    return data_->debug_reporting;
  }
  inline void GetAggregationCoordinatorOriginDataView(
      SuitableOriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationCoordinatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::attribution_reporting::mojom::SuitableOriginDataView, UserType>(),
    "Attempting to read the optional `aggregation_coordinator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAggregationCoordinatorOrigin` instead "
    "of `ReadAggregationCoordinatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->aggregation_coordinator_origin.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::SuitableOriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSourceRegistrationTimeConfig(UserType* output) const {
    auto data_value = data_->source_registration_time_config;
    return mojo::internal::Deserialize<::attribution_reporting::mojom::SourceRegistrationTimeConfig>(
        data_value, output);
  }
  ::attribution_reporting::mojom::SourceRegistrationTimeConfig source_registration_time_config() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::attribution_reporting::mojom::SourceRegistrationTimeConfig>(data_->source_registration_time_config));
  }
  inline void GetTriggerContextIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTriggerContextId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `trigger_context_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTriggerContextId` instead "
    "of `ReadTriggerContextId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trigger_context_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint8_t aggregatable_filtering_id_max_bytes() const {
    return data_->aggregatable_filtering_id_max_bytes;
  }
  inline void GetAggregatableDebugReportingConfigDataView(
      AggregatableDebugReportingConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableDebugReportingConfig(UserType* output) {
    
    auto* pointer = data_->aggregatable_debug_reporting_config.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::AggregatableDebugReportingConfigDataView>(
        pointer, output, message_);
  }
  inline void GetAttributionScopesDataView(
      AttributionScopesSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributionScopes(UserType* output) {
    
    auto* pointer = data_->attribution_scopes.Get();
    return mojo::internal::Deserialize<::attribution_reporting::mojom::AttributionScopesSetDataView>(
        pointer, output, message_);
  }
  inline void GetAggregatableNamedBudgetCandidatesDataView(
      mojo::ArrayDataView<AggregatableNamedBudgetCandidateDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregatableNamedBudgetCandidates(UserType* output) {
    
    auto* pointer = data_->aggregatable_named_budget_candidates.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::attribution_reporting::mojom::AggregatableNamedBudgetCandidateDataView>>(
        pointer, output, message_);
  }
 private:
  internal::TriggerRegistration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OsRegistrationItemDataView {
 public:
  OsRegistrationItemDataView() = default;

  OsRegistrationItemDataView(
      internal::OsRegistrationItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool debug_reporting() const {
    return data_->debug_reporting;
  }
 private:
  internal::OsRegistrationItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OsRegistrationDataView {
 public:
  OsRegistrationDataView() = default;

  OsRegistrationDataView(
      internal::OsRegistration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemsDataView(
      mojo::ArrayDataView<OsRegistrationItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItems(UserType* output) {
    
    auto* pointer = data_->items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::attribution_reporting::mojom::OsRegistrationItemDataView>>(
        pointer, output, message_);
  }
 private:
  internal::OsRegistration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // attribution_reporting::mojom

#endif  // COMPONENTS_ATTRIBUTION_REPORTING_REGISTRATION_MOJOM_DATA_VIEW_H_