// components/attribution_reporting/data_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../mojo/public/js/bindings.js';

import {
  OsRegistration as attributionReporting_mojom_OsRegistration,
  OsRegistrationSpec as attributionReporting_mojom_OsRegistrationSpec,
  SourceRegistration as attributionReporting_mojom_SourceRegistration,
  SourceRegistrationSpec as attributionReporting_mojom_SourceRegistrationSpec,
  SuitableOrigin as attributionReporting_mojom_SuitableOrigin,
  SuitableOriginSpec as attributionReporting_mojom_SuitableOriginSpec,
  TriggerRegistration as attributionReporting_mojom_TriggerRegistration,
  TriggerRegistrationSpec as attributionReporting_mojom_TriggerRegistrationSpec
} from './registration.mojom.m.js';

import {
  RegistrationHeaderError as attributionReporting_mojom_RegistrationHeaderError,
  RegistrationHeaderErrorSpec as attributionReporting_mojom_RegistrationHeaderErrorSpec
} from './registration_header_error.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DataAvailableCallsiteSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DataAvailableCallsite = {
  
  kBlink: 0,
  kBrowser: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DataHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'attribution_reporting.mojom.DataHost', scope);
  }
}

/** @interface */
export class DataHostInterface {
  
  /**
   * @param { !attributionReporting_mojom_SuitableOrigin } reportingOrigin
   * @param { !attributionReporting_mojom_SourceRegistration } data
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  sourceDataAvailable(reportingOrigin, data, wasFetchedViaServiceWorker) {}
  
  /**
   * @param { !attributionReporting_mojom_SuitableOrigin } reportingOrigin
   * @param { !attributionReporting_mojom_TriggerRegistration } data
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  triggerDataAvailable(reportingOrigin, data, wasFetchedViaServiceWorker) {}
  
  /**
   * @param { !attributionReporting_mojom_OsRegistration } registration
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  osSourceDataAvailable(registration, wasFetchedViaServiceWorker) {}
  
  /**
   * @param { !attributionReporting_mojom_OsRegistration } registration
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  osTriggerDataAvailable(registration, wasFetchedViaServiceWorker) {}
  
  /**
   * @param { !attributionReporting_mojom_SuitableOrigin } reportingOrigin
   * @param { !attributionReporting_mojom_RegistrationHeaderError } error
   */

  reportRegistrationHeaderError(reportingOrigin, error) {}
}

/**
 * @implements { DataHostInterface }
 */
export class DataHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DataHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DataHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DataHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !attributionReporting_mojom_SuitableOrigin } reportingOrigin
   * @param { !attributionReporting_mojom_SourceRegistration } data
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  sourceDataAvailable(
      reportingOrigin,
      data,
      wasFetchedViaServiceWorker) {
    this.proxy.sendMessage(
        0,
        DataHost_SourceDataAvailable_ParamsSpec.$,
        null,
        [
          reportingOrigin,
          data,
          wasFetchedViaServiceWorker
        ],
        false);
  }

  
  /**
   * @param { !attributionReporting_mojom_SuitableOrigin } reportingOrigin
   * @param { !attributionReporting_mojom_TriggerRegistration } data
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  triggerDataAvailable(
      reportingOrigin,
      data,
      wasFetchedViaServiceWorker) {
    this.proxy.sendMessage(
        1,
        DataHost_TriggerDataAvailable_ParamsSpec.$,
        null,
        [
          reportingOrigin,
          data,
          wasFetchedViaServiceWorker
        ],
        false);
  }

  
  /**
   * @param { !attributionReporting_mojom_OsRegistration } registration
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  osSourceDataAvailable(
      registration,
      wasFetchedViaServiceWorker) {
    this.proxy.sendMessage(
        2,
        DataHost_OsSourceDataAvailable_ParamsSpec.$,
        null,
        [
          registration,
          wasFetchedViaServiceWorker
        ],
        false);
  }

  
  /**
   * @param { !attributionReporting_mojom_OsRegistration } registration
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  osTriggerDataAvailable(
      registration,
      wasFetchedViaServiceWorker) {
    this.proxy.sendMessage(
        3,
        DataHost_OsTriggerDataAvailable_ParamsSpec.$,
        null,
        [
          registration,
          wasFetchedViaServiceWorker
        ],
        false);
  }

  
  /**
   * @param { !attributionReporting_mojom_SuitableOrigin } reportingOrigin
   * @param { !attributionReporting_mojom_RegistrationHeaderError } error
   */

  reportRegistrationHeaderError(
      reportingOrigin,
      error) {
    this.proxy.sendMessage(
        4,
        DataHost_ReportRegistrationHeaderError_ParamsSpec.$,
        null,
        [
          reportingOrigin,
          error
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DataHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DataHostReceiver {
  /**
   * @param {!DataHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DataHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DataHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DataHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DataHost_SourceDataAvailable_ParamsSpec.$,
        null,
        impl.sourceDataAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DataHost_TriggerDataAvailable_ParamsSpec.$,
        null,
        impl.triggerDataAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DataHost_OsSourceDataAvailable_ParamsSpec.$,
        null,
        impl.osSourceDataAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        DataHost_OsTriggerDataAvailable_ParamsSpec.$,
        null,
        impl.osTriggerDataAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        DataHost_ReportRegistrationHeaderError_ParamsSpec.$,
        null,
        impl.reportRegistrationHeaderError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DataHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "attribution_reporting.mojom.DataHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DataHostRemote}
   */
  static getRemote() {
    let remote = new DataHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DataHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DataHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DataHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DataHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sourceDataAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DataHost_SourceDataAvailable_ParamsSpec.$,
        null,
        this.sourceDataAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.triggerDataAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DataHost_TriggerDataAvailable_ParamsSpec.$,
        null,
        this.triggerDataAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.osSourceDataAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DataHost_OsSourceDataAvailable_ParamsSpec.$,
        null,
        this.osSourceDataAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.osTriggerDataAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        DataHost_OsTriggerDataAvailable_ParamsSpec.$,
        null,
        this.osTriggerDataAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportRegistrationHeaderError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        DataHost_ReportRegistrationHeaderError_ParamsSpec.$,
        null,
        this.reportRegistrationHeaderError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DataHost_SourceDataAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DataHost_TriggerDataAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DataHost_OsSourceDataAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DataHost_OsTriggerDataAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DataHost_ReportRegistrationHeaderError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DataHost_SourceDataAvailable_ParamsSpec.$,
    'DataHost_SourceDataAvailable_Params',
    [
      mojo.internal.StructField(
        'reportingOrigin', 0,
        0,
        attributionReporting_mojom_SuitableOriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        attributionReporting_mojom_SourceRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DataHost_SourceDataAvailable_Params {
  constructor() {
    /** @type { !attributionReporting_mojom_SuitableOrigin } */
    this.reportingOrigin;
    /** @type { !attributionReporting_mojom_SourceRegistration } */
    this.data;
    /** @type { !boolean } */
    this.wasFetchedViaServiceWorker;
  }
}



mojo.internal.Struct(
    DataHost_TriggerDataAvailable_ParamsSpec.$,
    'DataHost_TriggerDataAvailable_Params',
    [
      mojo.internal.StructField(
        'reportingOrigin', 0,
        0,
        attributionReporting_mojom_SuitableOriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        attributionReporting_mojom_TriggerRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DataHost_TriggerDataAvailable_Params {
  constructor() {
    /** @type { !attributionReporting_mojom_SuitableOrigin } */
    this.reportingOrigin;
    /** @type { !attributionReporting_mojom_TriggerRegistration } */
    this.data;
    /** @type { !boolean } */
    this.wasFetchedViaServiceWorker;
  }
}



mojo.internal.Struct(
    DataHost_OsSourceDataAvailable_ParamsSpec.$,
    'DataHost_OsSourceDataAvailable_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        attributionReporting_mojom_OsRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DataHost_OsSourceDataAvailable_Params {
  constructor() {
    /** @type { !attributionReporting_mojom_OsRegistration } */
    this.registration;
    /** @type { !boolean } */
    this.wasFetchedViaServiceWorker;
  }
}



mojo.internal.Struct(
    DataHost_OsTriggerDataAvailable_ParamsSpec.$,
    'DataHost_OsTriggerDataAvailable_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        attributionReporting_mojom_OsRegistrationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DataHost_OsTriggerDataAvailable_Params {
  constructor() {
    /** @type { !attributionReporting_mojom_OsRegistration } */
    this.registration;
    /** @type { !boolean } */
    this.wasFetchedViaServiceWorker;
  }
}



mojo.internal.Struct(
    DataHost_ReportRegistrationHeaderError_ParamsSpec.$,
    'DataHost_ReportRegistrationHeaderError_Params',
    [
      mojo.internal.StructField(
        'reportingOrigin', 0,
        0,
        attributionReporting_mojom_SuitableOriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        attributionReporting_mojom_RegistrationHeaderErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DataHost_ReportRegistrationHeaderError_Params {
  constructor() {
    /** @type { !attributionReporting_mojom_SuitableOrigin } */
    this.reportingOrigin;
    /** @type { !attributionReporting_mojom_RegistrationHeaderError } */
    this.error;
  }
}

