// components/attribution_reporting/data_host.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_ATTRIBUTION_REPORTING_DATA_HOST_MOJOM_H_
#define COMPONENTS_ATTRIBUTION_REPORTING_DATA_HOST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/attribution_reporting/data_host.mojom-features.h"  // IWYU pragma: export
#include "components/attribution_reporting/data_host.mojom-shared.h"  // IWYU pragma: export
#include "components/attribution_reporting/data_host.mojom-forward.h"  // IWYU pragma: export
#include "components/attribution_reporting/registration.mojom.h"
#include "components/attribution_reporting/registration_header_error.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"




namespace attribution_reporting { struct RegistrationHeaderError; }
namespace attribution_reporting { struct SourceRegistration; }
namespace attribution_reporting { class SuitableOrigin; }
namespace attribution_reporting { struct TriggerRegistration; }


namespace attribution_reporting::mojom {

class DataHostProxy;

template <typename ImplRefTraits>
class DataHostStub;

class DataHostRequestValidator;


class DataHost
    : public DataHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "attribution_reporting.mojom.DataHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DataHostInterfaceBase;
  using Proxy_ = DataHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = DataHostStub<ImplRefTraits>;

  using RequestValidator_ = DataHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSourceDataAvailableMinVersion = 0,
    kTriggerDataAvailableMinVersion = 0,
    kOsSourceDataAvailableMinVersion = 0,
    kOsTriggerDataAvailableMinVersion = 0,
    kReportRegistrationHeaderErrorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SourceDataAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TriggerDataAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OsSourceDataAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OsTriggerDataAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReportRegistrationHeaderError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DataHost() = default;

  virtual void SourceDataAvailable(::attribution_reporting::SuitableOrigin reporting_origin, ::attribution_reporting::SourceRegistration data, bool was_fetched_via_service_worker) = 0;

  virtual void TriggerDataAvailable(::attribution_reporting::SuitableOrigin reporting_origin, ::attribution_reporting::TriggerRegistration data, bool was_fetched_via_service_worker) = 0;

  virtual void OsSourceDataAvailable(::std::vector<::attribution_reporting::OsRegistrationItem> registration, bool was_fetched_via_service_worker) = 0;

  virtual void OsTriggerDataAvailable(::std::vector<::attribution_reporting::OsRegistrationItem> registration, bool was_fetched_via_service_worker) = 0;

  virtual void ReportRegistrationHeaderError(::attribution_reporting::SuitableOrigin reporting_origin, ::attribution_reporting::RegistrationHeaderError error) = 0;
};



class  DataHostProxy
    : public DataHost {
 public:
  using InterfaceType = DataHost;

  explicit DataHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SourceDataAvailable(::attribution_reporting::SuitableOrigin reporting_origin, ::attribution_reporting::SourceRegistration data, bool was_fetched_via_service_worker) final;
  
  void TriggerDataAvailable(::attribution_reporting::SuitableOrigin reporting_origin, ::attribution_reporting::TriggerRegistration data, bool was_fetched_via_service_worker) final;
  
  void OsSourceDataAvailable(::std::vector<::attribution_reporting::OsRegistrationItem> registration, bool was_fetched_via_service_worker) final;
  
  void OsTriggerDataAvailable(::std::vector<::attribution_reporting::OsRegistrationItem> registration, bool was_fetched_via_service_worker) final;
  
  void ReportRegistrationHeaderError(::attribution_reporting::SuitableOrigin reporting_origin, ::attribution_reporting::RegistrationHeaderError error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DataHostStubDispatch {
 public:
  static bool Accept(DataHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DataHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DataHost>>
class DataHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DataHostStub() = default;
  ~DataHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DataHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DataHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DataHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // attribution_reporting::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_ATTRIBUTION_REPORTING_DATA_HOST_MOJOM_H_