// components/attribution_reporting/data_host.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('attributionReporting.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
attributionReporting.mojom.DataAvailableCallsiteSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
attributionReporting.mojom.DataAvailableCallsite = {
  
  kBlink: 0,
  kBrowser: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
attributionReporting.mojom.DataHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        attributionReporting.mojom.DataHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { attributionReporting.mojom.DataHostInterface }
 */
attributionReporting.mojom.DataHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!attributionReporting.mojom.DataHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          attributionReporting.mojom.DataHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!attributionReporting.mojom.DataHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !attributionReporting.mojom.SuitableOrigin } reportingOrigin
   * @param { !attributionReporting.mojom.SourceRegistration } data
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  sourceDataAvailable(
      reportingOrigin,
      data,
      wasFetchedViaServiceWorker) {
    this.proxy.sendMessage(
        0,
        attributionReporting.mojom.DataHost_SourceDataAvailable_ParamsSpec.$,
        null,
        [
          reportingOrigin,
          data,
          wasFetchedViaServiceWorker
        ],
        false);
  }

  
  /**
   * @param { !attributionReporting.mojom.SuitableOrigin } reportingOrigin
   * @param { !attributionReporting.mojom.TriggerRegistration } data
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  triggerDataAvailable(
      reportingOrigin,
      data,
      wasFetchedViaServiceWorker) {
    this.proxy.sendMessage(
        1,
        attributionReporting.mojom.DataHost_TriggerDataAvailable_ParamsSpec.$,
        null,
        [
          reportingOrigin,
          data,
          wasFetchedViaServiceWorker
        ],
        false);
  }

  
  /**
   * @param { !attributionReporting.mojom.OsRegistration } registration
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  osSourceDataAvailable(
      registration,
      wasFetchedViaServiceWorker) {
    this.proxy.sendMessage(
        2,
        attributionReporting.mojom.DataHost_OsSourceDataAvailable_ParamsSpec.$,
        null,
        [
          registration,
          wasFetchedViaServiceWorker
        ],
        false);
  }

  
  /**
   * @param { !attributionReporting.mojom.OsRegistration } registration
   * @param { !boolean } wasFetchedViaServiceWorker
   */

  osTriggerDataAvailable(
      registration,
      wasFetchedViaServiceWorker) {
    this.proxy.sendMessage(
        3,
        attributionReporting.mojom.DataHost_OsTriggerDataAvailable_ParamsSpec.$,
        null,
        [
          registration,
          wasFetchedViaServiceWorker
        ],
        false);
  }

  
  /**
   * @param { !attributionReporting.mojom.SuitableOrigin } reportingOrigin
   * @param { !attributionReporting.mojom.RegistrationHeaderError } error
   */

  reportRegistrationHeaderError(
      reportingOrigin,
      error) {
    this.proxy.sendMessage(
        4,
        attributionReporting.mojom.DataHost_ReportRegistrationHeaderError_ParamsSpec.$,
        null,
        [
          reportingOrigin,
          error
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DataHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
attributionReporting.mojom.DataHostReceiver = class {
  /**
   * @param {!attributionReporting.mojom.DataHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!attributionReporting.mojom.DataHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        attributionReporting.mojom.DataHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!attributionReporting.mojom.DataHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        attributionReporting.mojom.DataHost_SourceDataAvailable_ParamsSpec.$,
        null,
        impl.sourceDataAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        attributionReporting.mojom.DataHost_TriggerDataAvailable_ParamsSpec.$,
        null,
        impl.triggerDataAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        attributionReporting.mojom.DataHost_OsSourceDataAvailable_ParamsSpec.$,
        null,
        impl.osSourceDataAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        attributionReporting.mojom.DataHost_OsTriggerDataAvailable_ParamsSpec.$,
        null,
        impl.osTriggerDataAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        attributionReporting.mojom.DataHost_ReportRegistrationHeaderError_ParamsSpec.$,
        null,
        impl.reportRegistrationHeaderError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
attributionReporting.mojom.DataHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "attribution_reporting.mojom.DataHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!attributionReporting.mojom.DataHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new attributionReporting.mojom.DataHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DataHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
attributionReporting.mojom.DataHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      attributionReporting.mojom.DataHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!attributionReporting.mojom.DataHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sourceDataAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        attributionReporting.mojom.DataHost_SourceDataAvailable_ParamsSpec.$,
        null,
        this.sourceDataAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.triggerDataAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        attributionReporting.mojom.DataHost_TriggerDataAvailable_ParamsSpec.$,
        null,
        this.triggerDataAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.osSourceDataAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        attributionReporting.mojom.DataHost_OsSourceDataAvailable_ParamsSpec.$,
        null,
        this.osSourceDataAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.osTriggerDataAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        attributionReporting.mojom.DataHost_OsTriggerDataAvailable_ParamsSpec.$,
        null,
        this.osTriggerDataAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportRegistrationHeaderError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        attributionReporting.mojom.DataHost_ReportRegistrationHeaderError_ParamsSpec.$,
        null,
        this.reportRegistrationHeaderError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
attributionReporting.mojom.DataHost_SourceDataAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
attributionReporting.mojom.DataHost_TriggerDataAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
attributionReporting.mojom.DataHost_OsSourceDataAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
attributionReporting.mojom.DataHost_OsTriggerDataAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
attributionReporting.mojom.DataHost_ReportRegistrationHeaderError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    attributionReporting.mojom.DataHost_SourceDataAvailable_ParamsSpec.$,
    'DataHost_SourceDataAvailable_Params',
    [
      mojo.internal.StructField(
        'reportingOrigin', 0,
        0,
        attributionReporting.mojom.SuitableOriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        attributionReporting.mojom.SourceRegistrationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
attributionReporting.mojom.DataHost_SourceDataAvailable_Params = class {
  constructor() {
    /** @export { !attributionReporting.mojom.SuitableOrigin } */
    this.reportingOrigin;
    /** @export { !attributionReporting.mojom.SourceRegistration } */
    this.data;
    /** @export { !boolean } */
    this.wasFetchedViaServiceWorker;
  }
};



mojo.internal.Struct(
    attributionReporting.mojom.DataHost_TriggerDataAvailable_ParamsSpec.$,
    'DataHost_TriggerDataAvailable_Params',
    [
      mojo.internal.StructField(
        'reportingOrigin', 0,
        0,
        attributionReporting.mojom.SuitableOriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        attributionReporting.mojom.TriggerRegistrationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
attributionReporting.mojom.DataHost_TriggerDataAvailable_Params = class {
  constructor() {
    /** @export { !attributionReporting.mojom.SuitableOrigin } */
    this.reportingOrigin;
    /** @export { !attributionReporting.mojom.TriggerRegistration } */
    this.data;
    /** @export { !boolean } */
    this.wasFetchedViaServiceWorker;
  }
};



mojo.internal.Struct(
    attributionReporting.mojom.DataHost_OsSourceDataAvailable_ParamsSpec.$,
    'DataHost_OsSourceDataAvailable_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        attributionReporting.mojom.OsRegistrationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
attributionReporting.mojom.DataHost_OsSourceDataAvailable_Params = class {
  constructor() {
    /** @export { !attributionReporting.mojom.OsRegistration } */
    this.registration;
    /** @export { !boolean } */
    this.wasFetchedViaServiceWorker;
  }
};



mojo.internal.Struct(
    attributionReporting.mojom.DataHost_OsTriggerDataAvailable_ParamsSpec.$,
    'DataHost_OsTriggerDataAvailable_Params',
    [
      mojo.internal.StructField(
        'registration', 0,
        0,
        attributionReporting.mojom.OsRegistrationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wasFetchedViaServiceWorker', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
attributionReporting.mojom.DataHost_OsTriggerDataAvailable_Params = class {
  constructor() {
    /** @export { !attributionReporting.mojom.OsRegistration } */
    this.registration;
    /** @export { !boolean } */
    this.wasFetchedViaServiceWorker;
  }
};



mojo.internal.Struct(
    attributionReporting.mojom.DataHost_ReportRegistrationHeaderError_ParamsSpec.$,
    'DataHost_ReportRegistrationHeaderError_Params',
    [
      mojo.internal.StructField(
        'reportingOrigin', 0,
        0,
        attributionReporting.mojom.SuitableOriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        attributionReporting.mojom.RegistrationHeaderErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
attributionReporting.mojom.DataHost_ReportRegistrationHeaderError_Params = class {
  constructor() {
    /** @export { !attributionReporting.mojom.SuitableOrigin } */
    this.reportingOrigin;
    /** @export { !attributionReporting.mojom.RegistrationHeaderError } */
    this.error;
  }
};

