// chrome/updater/mojom/updater_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_UPDATER_MOJOM_UPDATER_SERVICE_MOJOM_TEST_UTILS_H_
#define CHROME_UPDATER_MOJOM_UPDATER_SERVICE_MOJOM_TEST_UTILS_H_

#include "chrome/updater/mojom/updater_service.mojom.h"


namespace updater::mojom {


class  UpdateServiceInterceptorForTesting : public UpdateService {
  virtual UpdateService* GetForwardingInterface() = 0;
  void GetVersion(GetVersionCallback callback) override;
  void FetchPolicies(::policy::PolicyFetchReason reason, FetchPoliciesCallback callback) override;
  void RegisterApp(RegistrationRequestPtr request, RegisterAppCallback callback) override;
  void GetAppStates(GetAppStatesCallback callback) override;
  void RunPeriodicTasks(RunPeriodicTasksCallback callback) override;
  void UpdateAll(UpdateAllCallback callback) override;
  void Update(const std::string& app_id, const std::string& install_data_index, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, bool do_update_check_only, const std::optional<std::string>& language, UpdateCallback callback) override;
  void Install(RegistrationRequestPtr registration, const std::string& client_install_data, const std::string& install_data_index, UpdateService::Priority priority, const std::optional<std::string>& language, InstallCallback callback) override;
  void CancelInstalls(const std::string& app_id) override;
  void RunInstaller(const std::string& app_id, const ::base::FilePath& installer_path, const std::string& install_args, const std::string& install_data, const std::string& install_settings, const std::optional<std::string>& language, RunInstallerCallback callback) override;
  void CheckForUpdate(const std::string& app_id, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, const std::optional<std::string>& language, CheckForUpdateCallback callback) override;
};
class  UpdateServiceAsyncWaiter {
 public:
  explicit UpdateServiceAsyncWaiter(UpdateService* proxy);

  UpdateServiceAsyncWaiter(const UpdateServiceAsyncWaiter&) = delete;
  UpdateServiceAsyncWaiter& operator=(const UpdateServiceAsyncWaiter&) = delete;

  ~UpdateServiceAsyncWaiter();
  void GetVersion(
      std::string* out_version);
  std::string GetVersion();
  void FetchPolicies(
      ::policy::PolicyFetchReason reason, int32_t* out_result);
  int32_t FetchPolicies(::policy::PolicyFetchReason reason);
  void RegisterApp(
      RegistrationRequestPtr request, int32_t* out_result);
  int32_t RegisterApp(RegistrationRequestPtr request);
  void GetAppStates(
      std::vector<AppStatePtr>* out_app_states);
  std::vector<AppStatePtr> GetAppStates();
  void RunPeriodicTasks(
      );
  
  void UpdateAll(
      ::mojo::PendingReceiver<StateChangeObserver>* out_observer);
  ::mojo::PendingReceiver<StateChangeObserver> UpdateAll();
  void Update(
      const std::string& app_id, const std::string& install_data_index, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, bool do_update_check_only, const std::optional<std::string>& language, ::mojo::PendingReceiver<StateChangeObserver>* out_observer);
  ::mojo::PendingReceiver<StateChangeObserver> Update(const std::string& app_id, const std::string& install_data_index, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, bool do_update_check_only, const std::optional<std::string>& language);
  void Install(
      RegistrationRequestPtr registration, const std::string& client_install_data, const std::string& install_data_index, UpdateService::Priority priority, const std::optional<std::string>& language, ::mojo::PendingReceiver<StateChangeObserver>* out_observer);
  ::mojo::PendingReceiver<StateChangeObserver> Install(RegistrationRequestPtr registration, const std::string& client_install_data, const std::string& install_data_index, UpdateService::Priority priority, const std::optional<std::string>& language);
  void RunInstaller(
      const std::string& app_id, const ::base::FilePath& installer_path, const std::string& install_args, const std::string& install_data, const std::string& install_settings, const std::optional<std::string>& language, ::mojo::PendingReceiver<StateChangeObserver>* out_observer);
  ::mojo::PendingReceiver<StateChangeObserver> RunInstaller(const std::string& app_id, const ::base::FilePath& installer_path, const std::string& install_args, const std::string& install_data, const std::string& install_settings, const std::optional<std::string>& language);
  void CheckForUpdate(
      const std::string& app_id, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, const std::optional<std::string>& language, ::mojo::PendingReceiver<StateChangeObserver>* out_observer);
  ::mojo::PendingReceiver<StateChangeObserver> CheckForUpdate(const std::string& app_id, UpdateService::Priority priority, UpdateService::PolicySameVersionUpdate policy_same_version_update, const std::optional<std::string>& language);

 private:
  UpdateService* const proxy_;
};


class  StateChangeObserverInterceptorForTesting : public StateChangeObserver {
  virtual StateChangeObserver* GetForwardingInterface() = 0;
  void OnStateChange(UpdateStatePtr state) override;
  void OnComplete(UpdateService::Result result) override;
};
class  StateChangeObserverAsyncWaiter {
 public:
  explicit StateChangeObserverAsyncWaiter(StateChangeObserver* proxy);

  StateChangeObserverAsyncWaiter(const StateChangeObserverAsyncWaiter&) = delete;
  StateChangeObserverAsyncWaiter& operator=(const StateChangeObserverAsyncWaiter&) = delete;

  ~StateChangeObserverAsyncWaiter();

 private:
  StateChangeObserver* const proxy_;
};




}  // updater::mojom

#endif  // CHROME_UPDATER_MOJOM_UPDATER_SERVICE_MOJOM_TEST_UTILS_H_