// chrome/updater/mojom/updater_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/updater/mojom/updater_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/updater/mojom/updater_service.mojom-params-data.h"
namespace updater {
namespace mojom {

NOINLINE static const char* UpdateState_StateToStringHelper(UpdateState_State value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UpdateState_State::kUnknown:
      return "kUnknown";
    case UpdateState_State::kNotStarted:
      return "kNotStarted";
    case UpdateState_State::kCheckingForUpdates:
      return "kCheckingForUpdates";
    case UpdateState_State::kUpdateAvailable:
      return "kUpdateAvailable";
    case UpdateState_State::kDownloading:
      return "kDownloading";
    case UpdateState_State::kInstalling:
      return "kInstalling";
    case UpdateState_State::kUpdated:
      return "kUpdated";
    case UpdateState_State::kNoUpdate:
      return "kNoUpdate";
    case UpdateState_State::kUpdateError:
      return "kUpdateError";
    case UpdateState_State::kDecompressing:
      return "kDecompressing";
    case UpdateState_State::kPatching:
      return "kPatching";
    default:
      return nullptr;
  }
}

std::string UpdateState_StateToString(UpdateState_State value) {
  const char *str = UpdateState_StateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UpdateState_State value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UpdateState_State value) {
  return os << UpdateState_StateToString(value);
}

NOINLINE static const char* UpdateService_PolicySameVersionUpdateToStringHelper(UpdateService_PolicySameVersionUpdate value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UpdateService_PolicySameVersionUpdate::kNotAllowed:
      return "kNotAllowed";
    case UpdateService_PolicySameVersionUpdate::kAllowed:
      return "kAllowed";
    default:
      return nullptr;
  }
}

std::string UpdateService_PolicySameVersionUpdateToString(UpdateService_PolicySameVersionUpdate value) {
  const char *str = UpdateService_PolicySameVersionUpdateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UpdateService_PolicySameVersionUpdate value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UpdateService_PolicySameVersionUpdate value) {
  return os << UpdateService_PolicySameVersionUpdateToString(value);
}

NOINLINE static const char* UpdateService_ResultToStringHelper(UpdateService_Result value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UpdateService_Result::kSuccess:
      return "kSuccess";
    case UpdateService_Result::kUpdateInProgress:
      return "kUpdateInProgress";
    case UpdateService_Result::kUpdateCanceled:
      return "kUpdateCanceled";
    case UpdateService_Result::kRetryLater:
      return "kRetryLater";
    case UpdateService_Result::kServiceFailed:
      return "kServiceFailed";
    case UpdateService_Result::kUpdateCheckFailed:
      return "kUpdateCheckFailed";
    case UpdateService_Result::kAppNotFound:
      return "kAppNotFound";
    case UpdateService_Result::kInvalidArgument:
      return "kInvalidArgument";
    case UpdateService_Result::kInactive:
      return "kInactive";
    case UpdateService_Result::kIPCConnectionFailed:
      return "kIPCConnectionFailed";
    case UpdateService_Result::kInstallFailed:
      return "kInstallFailed";
    case UpdateService_Result::kPermissionDenied:
      return "kPermissionDenied";
    case UpdateService_Result::kUnknown:
      return "kUnknown";
    case UpdateService_Result::kServiceStopped:
      return "kServiceStopped";
    case UpdateService_Result::kEulaRequiredOrOemMode:
      return "kEulaRequiredOrOemMode";
    case UpdateService_Result::kFetchPoliciesFailed:
      return "kFetchPoliciesFailed";
    default:
      return nullptr;
  }
}

std::string UpdateService_ResultToString(UpdateService_Result value) {
  const char *str = UpdateService_ResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UpdateService_Result value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UpdateService_Result value) {
  return os << UpdateService_ResultToString(value);
}

NOINLINE static const char* UpdateService_ErrorCategoryToStringHelper(UpdateService_ErrorCategory value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UpdateService_ErrorCategory::kNone:
      return "kNone";
    case UpdateService_ErrorCategory::kDownload:
      return "kDownload";
    case UpdateService_ErrorCategory::kUnpack:
      return "kUnpack";
    case UpdateService_ErrorCategory::kInstall:
      return "kInstall";
    case UpdateService_ErrorCategory::kService:
      return "kService";
    case UpdateService_ErrorCategory::kUpdateCheck:
      return "kUpdateCheck";
    case UpdateService_ErrorCategory::kUnknown:
      return "kUnknown";
    case UpdateService_ErrorCategory::kInstaller:
      return "kInstaller";
    default:
      return nullptr;
  }
}

std::string UpdateService_ErrorCategoryToString(UpdateService_ErrorCategory value) {
  const char *str = UpdateService_ErrorCategoryToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UpdateService_ErrorCategory value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UpdateService_ErrorCategory value) {
  return os << UpdateService_ErrorCategoryToString(value);
}

NOINLINE static const char* UpdateService_PriorityToStringHelper(UpdateService_Priority value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UpdateService_Priority::kUnknown:
      return "kUnknown";
    case UpdateService_Priority::kBackground:
      return "kBackground";
    case UpdateService_Priority::kForeground:
      return "kForeground";
    default:
      return nullptr;
  }
}

std::string UpdateService_PriorityToString(UpdateService_Priority value) {
  const char *str = UpdateService_PriorityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UpdateService_Priority value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UpdateService_Priority value) {
  return os << UpdateService_PriorityToString(value);
}

namespace internal {


// static
bool RegistrationRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 56 },
    { 1, 88 },
    { 2, 96 },
    { 3, 104 },
    { 4, 144 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RegistrationRequest_Data* object =
      static_cast<const RegistrationRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->brand_code, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& brand_code_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->brand_code, validation_context,
                                         &brand_code_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->brand_path, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->brand_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ap, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ap_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ap, validation_context,
                                         &ap_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->version, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->version, validation_context,
                                         &version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->existence_checker_path, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->existence_checker_path, validation_context))
    return false;
  if (object->header_.version < 1)
    return true;

  if (!mojo::internal::ValidateStruct(object->ap_path, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& ap_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ap_key, validation_context,
                                         &ap_key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->version_path, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& version_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->version_key, validation_context,
                                         &version_key_validate_params)) {
    return false;
  }
  if (object->header_.version < 2)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& install_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->install_id, validation_context,
                                         &install_id_validate_params)) {
    return false;
  }
  if (object->header_.version < 3)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& lang_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->lang, validation_context,
                                         &lang_validate_params)) {
    return false;
  }
  if (object->header_.version < 4)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& cohort_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cohort, validation_context,
                                         &cohort_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& cohort_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cohort_name, validation_context,
                                         &cohort_name_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& cohort_hint_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cohort_hint, validation_context,
                                         &cohort_hint_validate_params)) {
    return false;
  }

  return true;
}

RegistrationRequest_Data::RegistrationRequest_Data()
    : header_({sizeof(*this), 4}) {}


// static
bool UpdateState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateState_Data* object =
      static_cast<const UpdateState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::updater::mojom::internal::UpdateState_State_Data
        ::Validate(object->state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->next_version, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& next_version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->next_version, validation_context,
                                         &next_version_validate_params)) {
    return false;
  }


  if (!::updater::mojom::internal::UpdateService_ErrorCategory_Data
        ::Validate(object->error_category, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->installer_text, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& installer_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->installer_text, validation_context,
                                         &installer_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->installer_cmd_line, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& installer_cmd_line_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->installer_cmd_line, validation_context,
                                         &installer_cmd_line_validate_params)) {
    return false;
  }

  return true;
}

UpdateState_Data::UpdateState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AppState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 56 },
    { 1, 88 },
    { 2, 96 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AppState_Data* object =
      static_cast<const AppState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->version, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->version, validation_context,
                                         &version_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ap, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ap_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ap, validation_context,
                                         &ap_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->brand_code, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& brand_code_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->brand_code, validation_context,
                                         &brand_code_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->brand_path, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->brand_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ecp, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ecp, validation_context))
    return false;
  if (object->header_.version < 1)
    return true;

  if (!mojo::internal::ValidateStruct(object->ap_path, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& ap_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ap_key, validation_context,
                                         &ap_key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->version_path, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& version_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->version_key, validation_context,
                                         &version_key_validate_params)) {
    return false;
  }
  if (object->header_.version < 2)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& cohort_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cohort, validation_context,
                                         &cohort_validate_params)) {
    return false;
  }

  return true;
}

AppState_Data::AppState_Data()
    : header_({sizeof(*this), 2}) {}


// static
bool UpdateService_GetVersion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_GetVersion_Params_Data* object =
      static_cast<const UpdateService_GetVersion_Params_Data*>(data);

  return true;
}

UpdateService_GetVersion_Params_Data::UpdateService_GetVersion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_GetVersion_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_GetVersion_ResponseParams_Data* object =
      static_cast<const UpdateService_GetVersion_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->version, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->version, validation_context,
                                         &version_validate_params)) {
    return false;
  }

  return true;
}

UpdateService_GetVersion_ResponseParams_Data::UpdateService_GetVersion_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_FetchPolicies_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 8 },
    { 4, 16 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_FetchPolicies_Params_Data* object =
      static_cast<const UpdateService_FetchPolicies_Params_Data*>(data);
  if (object->header_.version < 4)
    return true;


  if (!::enterprise_companion::mojom::internal::PolicyFetchReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  return true;
}

UpdateService_FetchPolicies_Params_Data::UpdateService_FetchPolicies_Params_Data()
    : header_({sizeof(*this), 4}) {}


// static
bool UpdateService_FetchPolicies_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_FetchPolicies_ResponseParams_Data* object =
      static_cast<const UpdateService_FetchPolicies_ResponseParams_Data*>(data);

  return true;
}

UpdateService_FetchPolicies_ResponseParams_Data::UpdateService_FetchPolicies_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_RegisterApp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_RegisterApp_Params_Data* object =
      static_cast<const UpdateService_RegisterApp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

UpdateService_RegisterApp_Params_Data::UpdateService_RegisterApp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_RegisterApp_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_RegisterApp_ResponseParams_Data* object =
      static_cast<const UpdateService_RegisterApp_ResponseParams_Data*>(data);

  return true;
}

UpdateService_RegisterApp_ResponseParams_Data::UpdateService_RegisterApp_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_GetAppStates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_GetAppStates_Params_Data* object =
      static_cast<const UpdateService_GetAppStates_Params_Data*>(data);

  return true;
}

UpdateService_GetAppStates_Params_Data::UpdateService_GetAppStates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_GetAppStates_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_GetAppStates_ResponseParams_Data* object =
      static_cast<const UpdateService_GetAppStates_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_states, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_states_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_states, validation_context,
                                         &app_states_validate_params)) {
    return false;
  }

  return true;
}

UpdateService_GetAppStates_ResponseParams_Data::UpdateService_GetAppStates_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_RunPeriodicTasks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_RunPeriodicTasks_Params_Data* object =
      static_cast<const UpdateService_RunPeriodicTasks_Params_Data*>(data);

  return true;
}

UpdateService_RunPeriodicTasks_Params_Data::UpdateService_RunPeriodicTasks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_RunPeriodicTasks_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_RunPeriodicTasks_ResponseParams_Data* object =
      static_cast<const UpdateService_RunPeriodicTasks_ResponseParams_Data*>(data);

  return true;
}

UpdateService_RunPeriodicTasks_ResponseParams_Data::UpdateService_RunPeriodicTasks_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_UpdateAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_UpdateAll_Params_Data* object =
      static_cast<const UpdateService_UpdateAll_Params_Data*>(data);

  return true;
}

UpdateService_UpdateAll_Params_Data::UpdateService_UpdateAll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_UpdateAll_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_UpdateAll_ResponseParams_Data* object =
      static_cast<const UpdateService_UpdateAll_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

UpdateService_UpdateAll_ResponseParams_Data::UpdateService_UpdateAll_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_Update_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 32 },
    { 1, 40 },
    { 3, 48 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_Update_Params_Data* object =
      static_cast<const UpdateService_Update_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->install_data_index, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& install_data_index_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->install_data_index, validation_context,
                                         &install_data_index_validate_params)) {
    return false;
  }


  if (!::updater::mojom::internal::UpdateService_Priority_Data
        ::Validate(object->priority, validation_context))
    return false;


  if (!::updater::mojom::internal::UpdateService_PolicySameVersionUpdate_Data
        ::Validate(object->policy_same_version_update, validation_context))
    return false;
  if (object->header_.version < 3)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

UpdateService_Update_Params_Data::UpdateService_Update_Params_Data()
    : header_({sizeof(*this), 3}) {}


// static
bool UpdateService_Update_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_Update_ResponseParams_Data* object =
      static_cast<const UpdateService_Update_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

UpdateService_Update_ResponseParams_Data::UpdateService_Update_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_Install_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 40 },
    { 3, 48 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_Install_Params_Data* object =
      static_cast<const UpdateService_Install_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_install_data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_install_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_install_data, validation_context,
                                         &client_install_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->install_data_index, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& install_data_index_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->install_data_index, validation_context,
                                         &install_data_index_validate_params)) {
    return false;
  }


  if (!::updater::mojom::internal::UpdateService_Priority_Data
        ::Validate(object->priority, validation_context))
    return false;
  if (object->header_.version < 3)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

UpdateService_Install_Params_Data::UpdateService_Install_Params_Data()
    : header_({sizeof(*this), 3}) {}


// static
bool UpdateService_Install_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_Install_ResponseParams_Data* object =
      static_cast<const UpdateService_Install_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

UpdateService_Install_ResponseParams_Data::UpdateService_Install_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_CancelInstalls_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_CancelInstalls_Params_Data* object =
      static_cast<const UpdateService_CancelInstalls_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  return true;
}

UpdateService_CancelInstalls_Params_Data::UpdateService_CancelInstalls_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_RunInstaller_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 48 },
    { 3, 56 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_RunInstaller_Params_Data* object =
      static_cast<const UpdateService_RunInstaller_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->installer_path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->installer_path, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->install_args, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& install_args_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->install_args, validation_context,
                                         &install_args_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->install_data, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& install_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->install_data, validation_context,
                                         &install_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->install_settings, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& install_settings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->install_settings, validation_context,
                                         &install_settings_validate_params)) {
    return false;
  }
  if (object->header_.version < 3)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

UpdateService_RunInstaller_Params_Data::UpdateService_RunInstaller_Params_Data()
    : header_({sizeof(*this), 3}) {}


// static
bool UpdateService_RunInstaller_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_RunInstaller_ResponseParams_Data* object =
      static_cast<const UpdateService_RunInstaller_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

UpdateService_RunInstaller_ResponseParams_Data::UpdateService_RunInstaller_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UpdateService_CheckForUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 24 },
    { 3, 32 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_CheckForUpdate_Params_Data* object =
      static_cast<const UpdateService_CheckForUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }


  if (!::updater::mojom::internal::UpdateService_Priority_Data
        ::Validate(object->priority, validation_context))
    return false;


  if (!::updater::mojom::internal::UpdateService_PolicySameVersionUpdate_Data
        ::Validate(object->policy_same_version_update, validation_context))
    return false;
  if (object->header_.version < 3)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

UpdateService_CheckForUpdate_Params_Data::UpdateService_CheckForUpdate_Params_Data()
    : header_({sizeof(*this), 3}) {}


// static
bool UpdateService_CheckForUpdate_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UpdateService_CheckForUpdate_ResponseParams_Data* object =
      static_cast<const UpdateService_CheckForUpdate_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

UpdateService_CheckForUpdate_ResponseParams_Data::UpdateService_CheckForUpdate_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StateChangeObserver_OnStateChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StateChangeObserver_OnStateChange_Params_Data* object =
      static_cast<const StateChangeObserver_OnStateChange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

StateChangeObserver_OnStateChange_Params_Data::StateChangeObserver_OnStateChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StateChangeObserver_OnComplete_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StateChangeObserver_OnComplete_Params_Data* object =
      static_cast<const StateChangeObserver_OnComplete_Params_Data*>(data);


  if (!::updater::mojom::internal::UpdateService_Result_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

StateChangeObserver_OnComplete_Params_Data::StateChangeObserver_OnComplete_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace updater

namespace perfetto {

// static
void TraceFormatTraits<::updater::mojom::UpdateState_State>::WriteIntoTrace(
   perfetto::TracedValue context, ::updater::mojom::UpdateState_State value) {
  return std::move(context).WriteString(::updater::mojom::UpdateState_StateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::updater::mojom::UpdateService_PolicySameVersionUpdate>::WriteIntoTrace(
   perfetto::TracedValue context, ::updater::mojom::UpdateService_PolicySameVersionUpdate value) {
  return std::move(context).WriteString(::updater::mojom::UpdateService_PolicySameVersionUpdateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::updater::mojom::UpdateService_Result>::WriteIntoTrace(
   perfetto::TracedValue context, ::updater::mojom::UpdateService_Result value) {
  return std::move(context).WriteString(::updater::mojom::UpdateService_ResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::updater::mojom::UpdateService_ErrorCategory>::WriteIntoTrace(
   perfetto::TracedValue context, ::updater::mojom::UpdateService_ErrorCategory value) {
  return std::move(context).WriteString(::updater::mojom::UpdateService_ErrorCategoryToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::updater::mojom::UpdateService_Priority>::WriteIntoTrace(
   perfetto::TracedValue context, ::updater::mojom::UpdateService_Priority value) {
  return std::move(context).WriteString(::updater::mojom::UpdateService_PriorityToString(value));
}

} // namespace perfetto