// chrome/services/printing/public/mojom/print_backend_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_TEST_UTILS_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_TEST_UTILS_H_

#include "chrome/services/printing/public/mojom/print_backend_service.mojom.h"


namespace printing::mojom {


class  UnsandboxedPrintBackendHostInterceptorForTesting : public UnsandboxedPrintBackendHost {
  virtual UnsandboxedPrintBackendHost* GetForwardingInterface() = 0;
  void BindBackend(::mojo::PendingReceiver<PrintBackendService> service) override;
};
class  UnsandboxedPrintBackendHostAsyncWaiter {
 public:
  explicit UnsandboxedPrintBackendHostAsyncWaiter(UnsandboxedPrintBackendHost* proxy);

  UnsandboxedPrintBackendHostAsyncWaiter(const UnsandboxedPrintBackendHostAsyncWaiter&) = delete;
  UnsandboxedPrintBackendHostAsyncWaiter& operator=(const UnsandboxedPrintBackendHostAsyncWaiter&) = delete;

  ~UnsandboxedPrintBackendHostAsyncWaiter();

 private:
  UnsandboxedPrintBackendHost* const proxy_;
};


class  SandboxedPrintBackendHostInterceptorForTesting : public SandboxedPrintBackendHost {
  virtual SandboxedPrintBackendHost* GetForwardingInterface() = 0;
  void BindBackend(::mojo::PendingReceiver<PrintBackendService> service) override;
};
class  SandboxedPrintBackendHostAsyncWaiter {
 public:
  explicit SandboxedPrintBackendHostAsyncWaiter(SandboxedPrintBackendHost* proxy);

  SandboxedPrintBackendHostAsyncWaiter(const SandboxedPrintBackendHostAsyncWaiter&) = delete;
  SandboxedPrintBackendHostAsyncWaiter& operator=(const SandboxedPrintBackendHostAsyncWaiter&) = delete;

  ~SandboxedPrintBackendHostAsyncWaiter();

 private:
  SandboxedPrintBackendHost* const proxy_;
};


class  PrintBackendServiceInterceptorForTesting : public PrintBackendService {
  virtual PrintBackendService* GetForwardingInterface() = 0;
  void Init(const std::string& locale) override;
  void Poke() override;
  void EnumeratePrinters(EnumeratePrintersCallback callback) override;
  void GetDefaultPrinterName(GetDefaultPrinterNameCallback callback) override;
  void FetchCapabilities(const std::string& printer_name, FetchCapabilitiesCallback callback) override;
  void EstablishPrintingContext(uint32_t context_id) override;
  void UseDefaultSettings(uint32_t context_id, UseDefaultSettingsCallback callback) override;
  void UpdatePrintSettings(uint32_t context_id, ::base::Value::Dict job_settings, UpdatePrintSettingsCallback callback) override;
  void StartPrinting(uint32_t context_id, int32_t document_cookie, const ::std::u16string& document_name, const std::optional<::printing::PrintSettings>& settings, StartPrintingCallback callback) override;
  void RenderPrintedDocument(int32_t document_cookie, uint32_t page_count, ::printing::mojom::MetafileDataType data_type, ::base::ReadOnlySharedMemoryRegion serialized_doc, RenderPrintedDocumentCallback callback) override;
  void DocumentDone(int32_t document_cookie, DocumentDoneCallback callback) override;
  void Cancel(int32_t document_cookie, CancelCallback callback) override;
};
class  PrintBackendServiceAsyncWaiter {
 public:
  explicit PrintBackendServiceAsyncWaiter(PrintBackendService* proxy);

  PrintBackendServiceAsyncWaiter(const PrintBackendServiceAsyncWaiter&) = delete;
  PrintBackendServiceAsyncWaiter& operator=(const PrintBackendServiceAsyncWaiter&) = delete;

  ~PrintBackendServiceAsyncWaiter();
  void EnumeratePrinters(
      
base::expected<
  std::vector<::printing::PrinterBasicInfo>,
  ::printing::mojom::ResultCode>* out_result);
  PrintBackendService_EnumeratePrinters_ResponseParam_ResultPtr EnumeratePrinters();
  void GetDefaultPrinterName(
      
base::expected<
  std::string,
  ::printing::mojom::ResultCode>* out_result);
  PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultPtr GetDefaultPrinterName();
  void FetchCapabilities(
      const std::string& printer_name,
base::expected<
  PrinterCapsAndInfoPtr,
  ::printing::mojom::ResultCode>* out_result);
  PrintBackendService_FetchCapabilities_ResponseParam_ResultPtr FetchCapabilities(const std::string& printer_name);
  void UseDefaultSettings(
      uint32_t context_id,
base::expected<
  ::printing::PrintSettings,
  ::printing::mojom::ResultCode>* out_result);
  PrintBackendService_UseDefaultSettings_ResponseParam_ResultPtr UseDefaultSettings(uint32_t context_id);
  void UpdatePrintSettings(
      uint32_t context_id, ::base::Value::Dict job_settings,
base::expected<
  ::printing::PrintSettings,
  ::printing::mojom::ResultCode>* out_result);
  PrintBackendService_UpdatePrintSettings_ResponseParam_ResultPtr UpdatePrintSettings(uint32_t context_id, ::base::Value::Dict job_settings);
  void StartPrinting(
      uint32_t context_id, int32_t document_cookie, const ::std::u16string& document_name, const std::optional<::printing::PrintSettings>& settings, ::printing::mojom::ResultCode* out_result_code, int32_t* out_job_id);
  
  void RenderPrintedDocument(
      int32_t document_cookie, uint32_t page_count, ::printing::mojom::MetafileDataType data_type, ::base::ReadOnlySharedMemoryRegion serialized_doc, ::printing::mojom::ResultCode* out_result_code);
  ::printing::mojom::ResultCode RenderPrintedDocument(int32_t document_cookie, uint32_t page_count, ::printing::mojom::MetafileDataType data_type, ::base::ReadOnlySharedMemoryRegion serialized_doc);
  void DocumentDone(
      int32_t document_cookie, ::printing::mojom::ResultCode* out_result_code);
  ::printing::mojom::ResultCode DocumentDone(int32_t document_cookie);
  void Cancel(
      int32_t document_cookie);
  

 private:
  PrintBackendService* const proxy_;
};




}  // printing::mojom

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_TEST_UTILS_H_