// chrome/services/printing/public/mojom/print_backend_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_SHARED_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/printing/public/mojom/print_backend_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "printing/backend/mojom/print_backend.mojom-shared.h"
#include "printing/mojom/print.mojom-shared.h"
#include "printing/mojom/printing_context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/services/printing/public/mojom/print_backend_service.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrinterCapsAndInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrinterCapsAndInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrinterCapsAndInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::printer_info(input)) in_printer_info = Traits::printer_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_info)::BaseType> printer_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::PrinterBasicInfoDataView>(
      in_printer_info,
      printer_info_fragment);

    fragment->printer_info.Set(
        printer_info_fragment.is_null() ? nullptr : printer_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printer_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printer_info in PrinterCapsAndInfo struct");

    decltype(Traits::printer_caps(input)) in_printer_caps = Traits::printer_caps(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_caps)::BaseType> printer_caps_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::PrinterSemanticCapsAndDefaultsDataView>(
      in_printer_caps,
      printer_caps_fragment);

    fragment->printer_caps.Set(
        printer_caps_fragment.is_null() ? nullptr : printer_caps_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printer_caps.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printer_caps in PrinterCapsAndInfo struct");
  }

  static bool Deserialize(::printing::mojom::internal::PrinterCapsAndInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrinterCapsAndInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::printing::mojom::internal::PrintBackendService_EnumeratePrinters_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& success_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::PrinterBasicInfoDataView>>(
  in_success,
  value_fragment,
  &success_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in PrintBackendService_EnumeratePrinters_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::printing::mojom::ResultCode>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::printing::mojom::internal::PrintBackendService_EnumeratePrinters_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::printing::mojom::internal::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in PrintBackendService_GetDefaultPrinterName_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::printing::mojom::ResultCode>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::printing::mojom::internal::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::printing::mojom::internal::PrintBackendService_FetchCapabilities_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::printing::mojom::PrinterCapsAndInfoDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in PrintBackendService_FetchCapabilities_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::printing::mojom::ResultCode>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::printing::mojom::internal::PrintBackendService_FetchCapabilities_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::printing::mojom::internal::PrintBackendService_UseDefaultSettings_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::printing::mojom::PrintSettingsDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in PrintBackendService_UseDefaultSettings_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::printing::mojom::ResultCode>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::printing::mojom::internal::PrintBackendService_UseDefaultSettings_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::printing::mojom::internal::PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::printing::mojom::PrintSettingsDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in PrintBackendService_UpdatePrintSettings_ResponseParam_Result union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView::Tag::kFailure: {
    decltype(Traits::failure(input))
    in_failure = Traits::failure(input);
        
mojo::internal::Serialize<::printing::mojom::ResultCode>(
  in_failure,
  &fragment->data.f_failure);
    break;
  }
}
  }

  static bool Deserialize(::printing::mojom::internal::PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace printing::mojom {

inline void PrinterCapsAndInfoDataView::GetPrinterInfoDataView(
    ::printing::mojom::PrinterBasicInfoDataView* output) {
  auto pointer = data_->printer_info.Get();
  *output = ::printing::mojom::PrinterBasicInfoDataView(pointer, message_);
}
inline void PrinterCapsAndInfoDataView::GetPrinterCapsDataView(
    ::printing::mojom::PrinterSemanticCapsAndDefaultsDataView* output) {
  auto pointer = data_->printer_caps.Get();
  *output = ::printing::mojom::PrinterSemanticCapsAndDefaultsDataView(pointer, message_);
}


inline void PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView::GetSuccessDataView(
    mojo::ArrayDataView<::printing::mojom::PrinterBasicInfoDataView>* output) const {
  CHECK(is_success());
  *output = mojo::ArrayDataView<::printing::mojom::PrinterBasicInfoDataView>(data_->data.f_success.Get(), message_);
}

inline void PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView::GetSuccessDataView(
    mojo::StringDataView* output) const {
  CHECK(is_success());
  *output = mojo::StringDataView(data_->data.f_success.Get(), message_);
}

inline void PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView::GetSuccessDataView(
    PrinterCapsAndInfoDataView* output) const {
  CHECK(is_success());
  *output = PrinterCapsAndInfoDataView(data_->data.f_success.Get(), message_);
}

inline void PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView::GetSuccessDataView(
    ::printing::mojom::PrintSettingsDataView* output) const {
  CHECK(is_success());
  *output = ::printing::mojom::PrintSettingsDataView(data_->data.f_success.Get(), message_);
}

inline void PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView::GetSuccessDataView(
    ::printing::mojom::PrintSettingsDataView* output) const {
  CHECK(is_success());
  *output = ::printing::mojom::PrintSettingsDataView(data_->data.f_success.Get(), message_);
}


}  // printing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_SHARED_H_