// chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_TO_PWG_RASTER_CONVERTER_MOJOM_DATA_VIEW_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_TO_PWG_RASTER_CONVERTER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-shared-internal.h"
#include "chrome/services/printing/public/mojom/pdf_render_settings.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"


namespace printing::mojom {
class PwgRasterSettingsDataView;



}  // printing::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::printing::mojom::PwgRasterSettingsDataView> {
  using Data = ::printing::mojom::internal::PwgRasterSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace printing::mojom {


enum class PwgRasterSettings_TransformType : int32_t {
  
  TRANSFORM_NORMAL = 0,
  
  TRANSFORM_ROTATE_180 = 1,
  
  TRANSFORM_FLIP_HORIZONTAL = 2,
  
  TRANSFORM_FLIP_VERTICAL = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, PwgRasterSettings_TransformType value);
inline bool IsKnownEnumValue(PwgRasterSettings_TransformType value) {
  return internal::PwgRasterSettings_TransformType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PwgRasterSettings_DuplexMode : int32_t {
  
  SIMPLEX = 0,
  
  LONG_EDGE = 1,
  
  SHORT_EDGE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PwgRasterSettings_DuplexMode value);
inline bool IsKnownEnumValue(PwgRasterSettings_DuplexMode value) {
  return internal::PwgRasterSettings_DuplexMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PdfToPwgRasterConverterInterfaceBase {};

using PdfToPwgRasterConverterPtrDataView =
    mojo::InterfacePtrDataView<PdfToPwgRasterConverterInterfaceBase>;
using PdfToPwgRasterConverterRequestDataView =
    mojo::InterfaceRequestDataView<PdfToPwgRasterConverterInterfaceBase>;
using PdfToPwgRasterConverterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PdfToPwgRasterConverterInterfaceBase>;
using PdfToPwgRasterConverterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PdfToPwgRasterConverterInterfaceBase>;


class PwgRasterSettingsDataView {
 public:
  PwgRasterSettingsDataView() = default;

  PwgRasterSettingsDataView(
      internal::PwgRasterSettings_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDuplexMode(UserType* output) const {
    auto data_value = data_->duplex_mode;
    return mojo::internal::Deserialize<::printing::mojom::PwgRasterSettings_DuplexMode>(
        data_value, output);
  }
  PwgRasterSettings_DuplexMode duplex_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::PwgRasterSettings_DuplexMode>(data_->duplex_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOddPageTransform(UserType* output) const {
    auto data_value = data_->odd_page_transform;
    return mojo::internal::Deserialize<::printing::mojom::PwgRasterSettings_TransformType>(
        data_value, output);
  }
  PwgRasterSettings_TransformType odd_page_transform() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::PwgRasterSettings_TransformType>(data_->odd_page_transform));
  }
  bool rotate_all_pages() const {
    return data_->rotate_all_pages;
  }
  bool reverse_page_order() const {
    return data_->reverse_page_order;
  }
  bool use_color() const {
    return data_->use_color;
  }
 private:
  internal::PwgRasterSettings_Data* data_ = nullptr;
};


}  // printing::mojom

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_TO_PWG_RASTER_CONVERTER_MOJOM_DATA_VIEW_H_