// chrome/services/printing/public/mojom/pdf_render_settings.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_RENDER_SETTINGS_MOJOM_SHARED_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_RENDER_SETTINGS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/printing/public/mojom/pdf_render_settings.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "chrome/services/printing/public/mojom/pdf_render_settings.mojom-data-view.h"




namespace std {

template <>
struct hash<::printing::mojom::PdfRenderSettings_Mode>
    : public mojo::internal::EnumHashImpl<::printing::mojom::PdfRenderSettings_Mode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PdfRenderSettings_Mode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::PdfRenderSettings_Mode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::PdfRenderSettings_Mode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PdfRenderSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PdfRenderSettingsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PdfRenderSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::area(input)) in_area = Traits::area(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->area)::BaseType> area_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_area,
      area_fragment);

    fragment->area.Set(
        area_fragment.is_null() ? nullptr : area_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->area.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null area in PdfRenderSettings struct");

    decltype(Traits::offsets(input)) in_offsets = Traits::offsets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->offsets)::BaseType> offsets_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_offsets,
      offsets_fragment);

    fragment->offsets.Set(
        offsets_fragment.is_null() ? nullptr : offsets_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->offsets.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null offsets in PdfRenderSettings struct");

    decltype(Traits::dpi(input)) in_dpi = Traits::dpi(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dpi)::BaseType> dpi_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_dpi,
      dpi_fragment);

    fragment->dpi.Set(
        dpi_fragment.is_null() ? nullptr : dpi_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dpi.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dpi in PdfRenderSettings struct");

    fragment->autorotate = Traits::autorotate(input);

    fragment->use_color = Traits::use_color(input);

    
    mojo::internal::Serialize<::printing::mojom::PdfRenderSettings_Mode>(
      Traits::mode(input),
      &fragment->mode);
  }

  static bool Deserialize(::printing::mojom::internal::PdfRenderSettings_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PdfRenderSettingsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace printing::mojom {

inline void PdfRenderSettingsDataView::GetAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void PdfRenderSettingsDataView::GetOffsetsDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->offsets.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void PdfRenderSettingsDataView::GetDpiDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->dpi.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}



}  // printing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::PdfRenderSettings_Mode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::PdfRenderSettings_Mode value);
};

} // namespace perfetto

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_RENDER_SETTINGS_MOJOM_SHARED_H_