// chrome/services/printing/public/mojom/pdf_render_settings.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/services/printing/public/mojom/pdf_render_settings.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/printing/public/mojom/pdf_render_settings.mojom-params-data.h"
namespace printing {
namespace mojom {

NOINLINE static const char* PdfRenderSettings_ModeToStringHelper(PdfRenderSettings_Mode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PdfRenderSettings_Mode::NORMAL:
      return "NORMAL";
    default:
      return nullptr;
  }
}

std::string PdfRenderSettings_ModeToString(PdfRenderSettings_Mode value) {
  const char *str = PdfRenderSettings_ModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PdfRenderSettings_Mode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PdfRenderSettings_Mode value) {
  return os << PdfRenderSettings_ModeToString(value);
}

namespace internal {


// static
bool PdfRenderSettings_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfRenderSettings_Data* object =
      static_cast<const PdfRenderSettings_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->area, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->area, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->offsets, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->offsets, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dpi, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dpi, validation_context))
    return false;


  if (!::printing::mojom::internal::PdfRenderSettings_Mode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

PdfRenderSettings_Data::PdfRenderSettings_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace printing

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PdfRenderSettings_Mode>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::PdfRenderSettings_Mode value) {
  return std::move(context).WriteString(::printing::mojom::PdfRenderSettings_ModeToString(value));
}

} // namespace perfetto