// chrome/services/printing/public/mojom/pdf_nup_converter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/services/printing/public/mojom/pdf_nup_converter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/printing/public/mojom/pdf_nup_converter.mojom-params-data.h"
#include "chrome/services/printing/public/mojom/pdf_nup_converter.mojom-shared-message-ids.h"

#include "chrome/services/printing/public/mojom/pdf_nup_converter.mojom-import-headers.h"
#include "chrome/services/printing/public/mojom/pdf_nup_converter.mojom-test-utils.h"


namespace printing::mojom {
// The declaration includes the definition on other builds.

PdfNupConverter::IPCStableHashFunction PdfNupConverter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PdfNupConverter>(message.name())) {
    case messages::PdfNupConverter::kNupPageConvert: {
      return &PdfNupConverter::NupPageConvert_Sym::IPCStableHash;
    }
    case messages::PdfNupConverter::kNupDocumentConvert: {
      return &PdfNupConverter::NupDocumentConvert_Sym::IPCStableHash;
    }
    case messages::PdfNupConverter::kSetWebContentsURL: {
      return &PdfNupConverter::SetWebContentsURL_Sym::IPCStableHash;
    }
    case messages::PdfNupConverter::kSetUseSkiaRendererPolicy: {
      return &PdfNupConverter::SetUseSkiaRendererPolicy_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PdfNupConverter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PdfNupConverter>(message.name())) {
      case messages::PdfNupConverter::kNupPageConvert:
            return "Receive printing::mojom::PdfNupConverter::NupPageConvert";
      case messages::PdfNupConverter::kNupDocumentConvert:
            return "Receive printing::mojom::PdfNupConverter::NupDocumentConvert";
      case messages::PdfNupConverter::kSetWebContentsURL:
            return "Receive printing::mojom::PdfNupConverter::SetWebContentsURL";
      case messages::PdfNupConverter::kSetUseSkiaRendererPolicy:
            return "Receive printing::mojom::PdfNupConverter::SetUseSkiaRendererPolicy";
    }
  } else {
    switch (static_cast<messages::PdfNupConverter>(message.name())) {
      case messages::PdfNupConverter::kNupPageConvert:
            return "Receive reply printing::mojom::PdfNupConverter::NupPageConvert";
      case messages::PdfNupConverter::kNupDocumentConvert:
            return "Receive reply printing::mojom::PdfNupConverter::NupDocumentConvert";
      case messages::PdfNupConverter::kSetWebContentsURL:
            return "Receive reply printing::mojom::PdfNupConverter::SetWebContentsURL";
      case messages::PdfNupConverter::kSetUseSkiaRendererPolicy:
            return "Receive reply printing::mojom::PdfNupConverter::SetUseSkiaRendererPolicy";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PdfNupConverter::NupPageConvert_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1eb80e9e;  // IPCStableHash for printing::mojom::PdfNupConverter::NupPageConvert
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfNupConverter::NupDocumentConvert_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9eb5e212;  // IPCStableHash for printing::mojom::PdfNupConverter::NupDocumentConvert
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfNupConverter::SetWebContentsURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa73efd85;  // IPCStableHash for printing::mojom::PdfNupConverter::SetWebContentsURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfNupConverter::SetUseSkiaRendererPolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x46f68f0e;  // IPCStableHash for printing::mojom::PdfNupConverter::SetUseSkiaRendererPolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PdfNupConverter_NupPageConvert_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PdfNupConverter_NupPageConvert_ForwardToCallback(
      PdfNupConverter::NupPageConvertCallback callback
      ) : callback_(std::move(callback)) {
  }

  PdfNupConverter_NupPageConvert_ForwardToCallback(const PdfNupConverter_NupPageConvert_ForwardToCallback&) = delete;
  PdfNupConverter_NupPageConvert_ForwardToCallback& operator=(const PdfNupConverter_NupPageConvert_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PdfNupConverter::NupPageConvertCallback callback_;
};

class PdfNupConverter_NupDocumentConvert_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PdfNupConverter_NupDocumentConvert_ForwardToCallback(
      PdfNupConverter::NupDocumentConvertCallback callback
      ) : callback_(std::move(callback)) {
  }

  PdfNupConverter_NupDocumentConvert_ForwardToCallback(const PdfNupConverter_NupDocumentConvert_ForwardToCallback&) = delete;
  PdfNupConverter_NupDocumentConvert_ForwardToCallback& operator=(const PdfNupConverter_NupDocumentConvert_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PdfNupConverter::NupDocumentConvertCallback callback_;
};

PdfNupConverterProxy::PdfNupConverterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PdfNupConverterProxy::NupPageConvert(
    uint32_t in_pages_per_sheet, const ::gfx::Size& in_page_size, const ::gfx::Rect& in_printable_area, std::vector<::base::ReadOnlySharedMemoryRegion> in_pdf_page_regions, NupPageConvertCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PdfNupConverter::NupPageConvert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pages_per_sheet"), in_pages_per_sheet,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_size"), in_page_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("printable_area"), in_printable_area,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pdf_page_regions"), in_pdf_page_regions,
                        "<value of type std::vector<::base::ReadOnlySharedMemoryRegion>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfNupConverter::kNupPageConvert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PdfNupConverter_NupPageConvert_Params_Data> params(
          message);
  params.Allocate();

  params->pages_per_sheet = in_pages_per_sheet;
  mojo::internal::MessageFragment<
      typename decltype(params->page_size)::BaseType> page_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_page_size,
    page_size_fragment);

  params->page_size.Set(
      page_size_fragment.is_null() ? nullptr : page_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page_size in PdfNupConverter.NupPageConvert request");
  mojo::internal::MessageFragment<
      typename decltype(params->printable_area)::BaseType> printable_area_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_printable_area,
    printable_area_fragment);

  params->printable_area.Set(
      printable_area_fragment.is_null() ? nullptr : printable_area_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->printable_area.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null printable_area in PdfNupConverter.NupPageConvert request");
  mojo::internal::MessageFragment<
      typename decltype(params->pdf_page_regions)::BaseType>
      pdf_page_regions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& pdf_page_regions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>>(
    in_pdf_page_regions,
    pdf_page_regions_fragment,
    &pdf_page_regions_validate_params);

  params->pdf_page_regions.Set(
      pdf_page_regions_fragment.is_null() ? nullptr : pdf_page_regions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pdf_page_regions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pdf_page_regions in PdfNupConverter.NupPageConvert request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfNupConverter::Name_);
  message.set_method_name("NupPageConvert");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PdfNupConverter_NupPageConvert_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PdfNupConverterProxy::NupDocumentConvert(
    uint32_t in_pages_per_sheet, const ::gfx::Size& in_page_size, const ::gfx::Rect& in_printable_area, ::base::ReadOnlySharedMemoryRegion in_src_pdf_region, NupDocumentConvertCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PdfNupConverter::NupDocumentConvert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pages_per_sheet"), in_pages_per_sheet,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_size"), in_page_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("printable_area"), in_printable_area,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("src_pdf_region"), in_src_pdf_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfNupConverter::kNupDocumentConvert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PdfNupConverter_NupDocumentConvert_Params_Data> params(
          message);
  params.Allocate();

  params->pages_per_sheet = in_pages_per_sheet;
  mojo::internal::MessageFragment<
      typename decltype(params->page_size)::BaseType> page_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_page_size,
    page_size_fragment);

  params->page_size.Set(
      page_size_fragment.is_null() ? nullptr : page_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page_size in PdfNupConverter.NupDocumentConvert request");
  mojo::internal::MessageFragment<
      typename decltype(params->printable_area)::BaseType> printable_area_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_printable_area,
    printable_area_fragment);

  params->printable_area.Set(
      printable_area_fragment.is_null() ? nullptr : printable_area_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->printable_area.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null printable_area in PdfNupConverter.NupDocumentConvert request");
  mojo::internal::MessageFragment<
      typename decltype(params->src_pdf_region)::BaseType> src_pdf_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_src_pdf_region,
    src_pdf_region_fragment);

  params->src_pdf_region.Set(
      src_pdf_region_fragment.is_null() ? nullptr : src_pdf_region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->src_pdf_region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null src_pdf_region in PdfNupConverter.NupDocumentConvert request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfNupConverter::Name_);
  message.set_method_name("NupDocumentConvert");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PdfNupConverter_NupDocumentConvert_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PdfNupConverterProxy::SetWebContentsURL(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PdfNupConverter::SetWebContentsURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfNupConverter::kSetWebContentsURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PdfNupConverter_SetWebContentsURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PdfNupConverter.SetWebContentsURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfNupConverter::Name_);
  message.set_method_name("SetWebContentsURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PdfNupConverterProxy::SetUseSkiaRendererPolicy(
    bool in_use_skia) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PdfNupConverter::SetUseSkiaRendererPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("use_skia"), in_use_skia,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfNupConverter::kSetUseSkiaRendererPolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data> params(
          message);
  params.Allocate();

  params->use_skia = in_use_skia;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfNupConverter::Name_);
  message.set_method_name("SetUseSkiaRendererPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PdfNupConverter_NupPageConvert_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PdfNupConverter::NupPageConvertCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PdfNupConverter_NupPageConvert_ProxyToResponder> proxy(
        new PdfNupConverter_NupPageConvert_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PdfNupConverter_NupPageConvert_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PdfNupConverter_NupPageConvert_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PdfNupConverter_NupPageConvert_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PdfNupConverter::NupPageConvertCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PdfNupConverter::Status in_status, ::base::ReadOnlySharedMemoryRegion in_pdf_region);
};

bool PdfNupConverter_NupPageConvert_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PdfNupConverter_NupPageConvert_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PdfNupConverter_NupPageConvert_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PdfNupConverter.0
  bool success = true;
  PdfNupConverter::Status p_status{};
  ::base::ReadOnlySharedMemoryRegion p_pdf_region{};
  PdfNupConverter_NupPageConvert_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadPdfRegion(&p_pdf_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PdfNupConverter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_pdf_region));
  }
  return true;
}

void PdfNupConverter_NupPageConvert_ProxyToResponder::Run(
    PdfNupConverter::Status in_status, ::base::ReadOnlySharedMemoryRegion in_pdf_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PdfNupConverter::NupPageConvert", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PdfNupConverter::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pdf_region"), in_pdf_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfNupConverter::kNupPageConvert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PdfNupConverter_NupPageConvert_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::printing::mojom::PdfNupConverter_Status>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->pdf_region)::BaseType> pdf_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_pdf_region,
    pdf_region_fragment);

  params->pdf_region.Set(
      pdf_region_fragment.is_null() ? nullptr : pdf_region_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfNupConverter::Name_);
  message.set_method_name("NupPageConvert");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PdfNupConverter_NupDocumentConvert_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PdfNupConverter::NupDocumentConvertCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PdfNupConverter_NupDocumentConvert_ProxyToResponder> proxy(
        new PdfNupConverter_NupDocumentConvert_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PdfNupConverter_NupDocumentConvert_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PdfNupConverter_NupDocumentConvert_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PdfNupConverter_NupDocumentConvert_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PdfNupConverter::NupDocumentConvertCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PdfNupConverter::Status in_status, ::base::ReadOnlySharedMemoryRegion in_pdf_region);
};

bool PdfNupConverter_NupDocumentConvert_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PdfNupConverter_NupDocumentConvert_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PdfNupConverter_NupDocumentConvert_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PdfNupConverter.1
  bool success = true;
  PdfNupConverter::Status p_status{};
  ::base::ReadOnlySharedMemoryRegion p_pdf_region{};
  PdfNupConverter_NupDocumentConvert_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadPdfRegion(&p_pdf_region))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PdfNupConverter::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_pdf_region));
  }
  return true;
}

void PdfNupConverter_NupDocumentConvert_ProxyToResponder::Run(
    PdfNupConverter::Status in_status, ::base::ReadOnlySharedMemoryRegion in_pdf_region) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PdfNupConverter::NupDocumentConvert", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type PdfNupConverter::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pdf_region"), in_pdf_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfNupConverter::kNupDocumentConvert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PdfNupConverter_NupDocumentConvert_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::printing::mojom::PdfNupConverter_Status>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->pdf_region)::BaseType> pdf_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_pdf_region,
    pdf_region_fragment);

  params->pdf_region.Set(
      pdf_region_fragment.is_null() ? nullptr : pdf_region_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfNupConverter::Name_);
  message.set_method_name("NupDocumentConvert");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PdfNupConverterStubDispatch::Accept(
    PdfNupConverter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PdfNupConverter>(message->header()->name)) {
    case messages::PdfNupConverter::kNupPageConvert: {
      break;
    }
    case messages::PdfNupConverter::kNupDocumentConvert: {
      break;
    }
    case messages::PdfNupConverter::kSetWebContentsURL: {
      DCHECK(message->is_serialized());
      internal::PdfNupConverter_SetWebContentsURL_Params_Data* params =
          reinterpret_cast<internal::PdfNupConverter_SetWebContentsURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfNupConverter.2
      bool success = true;
      ::GURL p_url{};
      PdfNupConverter_SetWebContentsURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfNupConverter::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWebContentsURL(        
        std::move(p_url));
      return true;
    }
    case messages::PdfNupConverter::kSetUseSkiaRendererPolicy: {
      DCHECK(message->is_serialized());
      internal::PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data* params =
          reinterpret_cast<internal::PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfNupConverter.3
      bool success = true;
      bool p_use_skia{};
      PdfNupConverter_SetUseSkiaRendererPolicy_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_use_skia = input_data_view.use_skia();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfNupConverter::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUseSkiaRendererPolicy(        
        std::move(p_use_skia));
      return true;
    }
  }
  return false;
}

// static
bool PdfNupConverterStubDispatch::AcceptWithResponder(
    PdfNupConverter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PdfNupConverter>(message->header()->name)) {
    case messages::PdfNupConverter::kNupPageConvert: {
      internal::PdfNupConverter_NupPageConvert_Params_Data* params =
          reinterpret_cast<
              internal::PdfNupConverter_NupPageConvert_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PdfNupConverter.0
      bool success = true;
      uint32_t p_pages_per_sheet{};
      ::gfx::Size p_page_size{};
      ::gfx::Rect p_printable_area{};
      std::vector<::base::ReadOnlySharedMemoryRegion> p_pdf_page_regions{};
      PdfNupConverter_NupPageConvert_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pages_per_sheet = input_data_view.pages_per_sheet();
      if (success && !input_data_view.ReadPageSize(&p_page_size))
        success = false;
      if (success && !input_data_view.ReadPrintableArea(&p_printable_area))
        success = false;
      if (success && !input_data_view.ReadPdfPageRegions(&p_pdf_page_regions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfNupConverter::Name_, 0, false);
        return false;
      }
      auto callback =
          PdfNupConverter_NupPageConvert_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NupPageConvert(        
        std::move(p_pages_per_sheet), 
        std::move(p_page_size), 
        std::move(p_printable_area), 
        std::move(p_pdf_page_regions), std::move(callback));
      return true;
    }
    case messages::PdfNupConverter::kNupDocumentConvert: {
      internal::PdfNupConverter_NupDocumentConvert_Params_Data* params =
          reinterpret_cast<
              internal::PdfNupConverter_NupDocumentConvert_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PdfNupConverter.1
      bool success = true;
      uint32_t p_pages_per_sheet{};
      ::gfx::Size p_page_size{};
      ::gfx::Rect p_printable_area{};
      ::base::ReadOnlySharedMemoryRegion p_src_pdf_region{};
      PdfNupConverter_NupDocumentConvert_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pages_per_sheet = input_data_view.pages_per_sheet();
      if (success && !input_data_view.ReadPageSize(&p_page_size))
        success = false;
      if (success && !input_data_view.ReadPrintableArea(&p_printable_area))
        success = false;
      if (success && !input_data_view.ReadSrcPdfRegion(&p_src_pdf_region))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfNupConverter::Name_, 1, false);
        return false;
      }
      auto callback =
          PdfNupConverter_NupDocumentConvert_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NupDocumentConvert(        
        std::move(p_pages_per_sheet), 
        std::move(p_page_size), 
        std::move(p_printable_area), 
        std::move(p_src_pdf_region), std::move(callback));
      return true;
    }
    case messages::PdfNupConverter::kSetWebContentsURL: {
      break;
    }
    case messages::PdfNupConverter::kSetUseSkiaRendererPolicy: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPdfNupConverterValidationInfo[] = {
    { &internal::PdfNupConverter_NupPageConvert_Params_Data::Validate,
     &internal::PdfNupConverter_NupPageConvert_ResponseParams_Data::Validate},
    { &internal::PdfNupConverter_NupDocumentConvert_Params_Data::Validate,
     &internal::PdfNupConverter_NupDocumentConvert_ResponseParams_Data::Validate},
    { &internal::PdfNupConverter_SetWebContentsURL_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data::Validate,
     nullptr /* no response */},
};

bool PdfNupConverterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::printing::mojom::PdfNupConverter::Name_,
    kPdfNupConverterValidationInfo);
}

bool PdfNupConverterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::printing::mojom::PdfNupConverter::Name_,
    kPdfNupConverterValidationInfo);
}


}  // printing::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace printing::mojom {


void PdfNupConverterInterceptorForTesting::NupPageConvert(uint32_t pages_per_sheet, const ::gfx::Size& page_size, const ::gfx::Rect& printable_area, std::vector<::base::ReadOnlySharedMemoryRegion> pdf_page_regions, NupPageConvertCallback callback) {
  GetForwardingInterface()->NupPageConvert(
    std::move(pages_per_sheet)
    , 
    std::move(page_size)
    , 
    std::move(printable_area)
    , 
    std::move(pdf_page_regions)
    , std::move(callback));
}
void PdfNupConverterInterceptorForTesting::NupDocumentConvert(uint32_t pages_per_sheet, const ::gfx::Size& page_size, const ::gfx::Rect& printable_area, ::base::ReadOnlySharedMemoryRegion src_pdf_region, NupDocumentConvertCallback callback) {
  GetForwardingInterface()->NupDocumentConvert(
    std::move(pages_per_sheet)
    , 
    std::move(page_size)
    , 
    std::move(printable_area)
    , 
    std::move(src_pdf_region)
    , std::move(callback));
}
void PdfNupConverterInterceptorForTesting::SetWebContentsURL(const ::GURL& url) {
  GetForwardingInterface()->SetWebContentsURL(
    std::move(url)
    );
}
void PdfNupConverterInterceptorForTesting::SetUseSkiaRendererPolicy(bool use_skia) {
  GetForwardingInterface()->SetUseSkiaRendererPolicy(
    std::move(use_skia)
    );
}
PdfNupConverterAsyncWaiter::PdfNupConverterAsyncWaiter(
    PdfNupConverter* proxy) : proxy_(proxy) {}

PdfNupConverterAsyncWaiter::~PdfNupConverterAsyncWaiter() = default;


void PdfNupConverterAsyncWaiter::NupPageConvert(
    uint32_t pages_per_sheet, const ::gfx::Size& page_size, const ::gfx::Rect& printable_area, std::vector<::base::ReadOnlySharedMemoryRegion> pdf_page_regions, PdfNupConverter::Status* out_status, ::base::ReadOnlySharedMemoryRegion* out_pdf_region) {
  base::RunLoop loop;
  proxy_->NupPageConvert(
      std::move(pages_per_sheet),
      std::move(page_size),
      std::move(printable_area),
      std::move(pdf_page_regions),
      base::BindOnce(
          [](base::RunLoop* loop,
             PdfNupConverter::Status* out_status
,
             ::base::ReadOnlySharedMemoryRegion* out_pdf_region
,
             PdfNupConverter::Status status,
             ::base::ReadOnlySharedMemoryRegion pdf_region) {*out_status = std::move(status);*out_pdf_region = std::move(pdf_region);
            loop->Quit();
          },
          &loop,
          out_status,
          out_pdf_region));
  loop.Run();
}



void PdfNupConverterAsyncWaiter::NupDocumentConvert(
    uint32_t pages_per_sheet, const ::gfx::Size& page_size, const ::gfx::Rect& printable_area, ::base::ReadOnlySharedMemoryRegion src_pdf_region, PdfNupConverter::Status* out_status, ::base::ReadOnlySharedMemoryRegion* out_pdf_region) {
  base::RunLoop loop;
  proxy_->NupDocumentConvert(
      std::move(pages_per_sheet),
      std::move(page_size),
      std::move(printable_area),
      std::move(src_pdf_region),
      base::BindOnce(
          [](base::RunLoop* loop,
             PdfNupConverter::Status* out_status
,
             ::base::ReadOnlySharedMemoryRegion* out_pdf_region
,
             PdfNupConverter::Status status,
             ::base::ReadOnlySharedMemoryRegion pdf_region) {*out_status = std::move(status);*out_pdf_region = std::move(pdf_region);
            loop->Quit();
          },
          &loop,
          out_status,
          out_pdf_region));
  loop.Run();
}








}  // printing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif