// chrome/services/media_gallery_util/public/mojom/media_parser.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_SHARED_H_
#define CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/services/media_gallery_util/public/mojom/media_parser.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::MediaStreamInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::MediaStreamInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::MediaStreamInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_type,
      type_fragment);

    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null type in MediaStreamInfo struct");

    decltype(Traits::additional_properties(input)) in_additional_properties = Traits::additional_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->additional_properties)::BaseType> additional_properties_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_additional_properties,
      additional_properties_fragment);

    fragment->additional_properties.Set(
        additional_properties_fragment.is_null() ? nullptr : additional_properties_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->additional_properties.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null additional_properties in MediaStreamInfo struct");
  }

  static bool Deserialize(::chrome::mojom::internal::MediaStreamInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::MediaStreamInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::MediaMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::MediaMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::MediaMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type,
      mime_type_fragment);

    fragment->mime_type.Set(
        mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mime_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in MediaMetadata struct");

    fragment->height = Traits::height(input);

    fragment->width = Traits::width(input);

    fragment->duration = Traits::duration(input);

    fragment->rotation = Traits::rotation(input);

    decltype(Traits::album(input)) in_album = Traits::album(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->album)::BaseType> album_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_album,
      album_fragment);

    fragment->album.Set(
        album_fragment.is_null() ? nullptr : album_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->album.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null album in MediaMetadata struct");

    decltype(Traits::artist(input)) in_artist = Traits::artist(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->artist)::BaseType> artist_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_artist,
      artist_fragment);

    fragment->artist.Set(
        artist_fragment.is_null() ? nullptr : artist_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->artist.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null artist in MediaMetadata struct");

    decltype(Traits::comment(input)) in_comment = Traits::comment(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->comment)::BaseType> comment_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_comment,
      comment_fragment);

    fragment->comment.Set(
        comment_fragment.is_null() ? nullptr : comment_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->comment.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null comment in MediaMetadata struct");

    decltype(Traits::copyright(input)) in_copyright = Traits::copyright(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->copyright)::BaseType> copyright_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_copyright,
      copyright_fragment);

    fragment->copyright.Set(
        copyright_fragment.is_null() ? nullptr : copyright_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->copyright.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null copyright in MediaMetadata struct");

    fragment->disc = Traits::disc(input);

    decltype(Traits::genre(input)) in_genre = Traits::genre(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->genre)::BaseType> genre_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_genre,
      genre_fragment);

    fragment->genre.Set(
        genre_fragment.is_null() ? nullptr : genre_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->genre.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null genre in MediaMetadata struct");

    decltype(Traits::language(input)) in_language = Traits::language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language)::BaseType> language_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_language,
      language_fragment);

    fragment->language.Set(
        language_fragment.is_null() ? nullptr : language_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->language.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null language in MediaMetadata struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in MediaMetadata struct");

    fragment->track = Traits::track(input);

    decltype(Traits::raw_tags(input)) in_raw_tags = Traits::raw_tags(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raw_tags)::BaseType>
        raw_tags_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& raw_tags_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::chrome::mojom::MediaStreamInfoDataView>>(
      in_raw_tags,
      raw_tags_fragment,
      &raw_tags_validate_params);

    fragment->raw_tags.Set(
        raw_tags_fragment.is_null() ? nullptr : raw_tags_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->raw_tags.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_tags in MediaMetadata struct");
  }

  static bool Deserialize(::chrome::mojom::internal::MediaMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::MediaMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::AttachedImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::AttachedImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::AttachedImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_type,
      type_fragment);

    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null type in AttachedImage struct");

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data,
      data_fragment,
      &data_validate_params);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in AttachedImage struct");
  }

  static bool Deserialize(::chrome::mojom::internal::AttachedImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::AttachedImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace chrome::mojom {

inline void MediaStreamInfoDataView::GetTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaStreamInfoDataView::GetAdditionalPropertiesDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->additional_properties.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}


inline void MediaMetadataDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaMetadataDataView::GetAlbumDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->album.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaMetadataDataView::GetArtistDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->artist.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaMetadataDataView::GetCommentDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->comment.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaMetadataDataView::GetCopyrightDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->copyright.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaMetadataDataView::GetGenreDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->genre.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaMetadataDataView::GetLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->language.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaMetadataDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaMetadataDataView::GetRawTagsDataView(
    mojo::ArrayDataView<MediaStreamInfoDataView>* output) {
  auto pointer = data_->raw_tags.Get();
  *output = mojo::ArrayDataView<MediaStreamInfoDataView>(pointer, message_);
}


inline void AttachedImageDataView::GetTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AttachedImageDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // chrome::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_SHARED_H_