// chrome/services/media_gallery_util/public/mojom/media_parser.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_SHARED_INTERNAL_H_
#define CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "media/mojo/mojom/media_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared-internal.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace chrome::mojom {
namespace internal {
class MediaStreamInfo_Data;
class MediaMetadata_Data;
class AttachedImage_Data;

#pragma pack(push, 1)
class  MediaStreamInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> type;
  mojo::internal::Pointer<::mojo_base::mojom::internal::DictionaryValue_Data> additional_properties;

 private:
  friend class mojo::internal::MessageFragment<MediaStreamInfo_Data>;

  MediaStreamInfo_Data();
  ~MediaStreamInfo_Data() = delete;
};
static_assert(sizeof(MediaStreamInfo_Data) == 24,
              "Bad sizeof(MediaStreamInfo_Data)");
// Used by MediaStreamInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MediaStreamInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MediaStreamInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MediaStreamInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<MediaStreamInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MediaStreamInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  MediaMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> mime_type;
  int32_t height;
  int32_t width;
  double duration;
  int32_t rotation;
  int32_t disc;
  mojo::internal::Pointer<mojo::internal::String_Data> album;
  mojo::internal::Pointer<mojo::internal::String_Data> artist;
  mojo::internal::Pointer<mojo::internal::String_Data> comment;
  mojo::internal::Pointer<mojo::internal::String_Data> copyright;
  mojo::internal::Pointer<mojo::internal::String_Data> genre;
  mojo::internal::Pointer<mojo::internal::String_Data> language;
  mojo::internal::Pointer<mojo::internal::String_Data> title;
  int32_t track;
  uint8_t pad13_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::MediaStreamInfo_Data>>> raw_tags;

 private:
  friend class mojo::internal::MessageFragment<MediaMetadata_Data>;

  MediaMetadata_Data();
  ~MediaMetadata_Data() = delete;
};
static_assert(sizeof(MediaMetadata_Data) == 112,
              "Bad sizeof(MediaMetadata_Data)");
// Used by MediaMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MediaMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MediaMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MediaMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<MediaMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MediaMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AttachedImage_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> type;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;

 private:
  friend class mojo::internal::MessageFragment<AttachedImage_Data>;

  AttachedImage_Data();
  ~AttachedImage_Data() = delete;
};
static_assert(sizeof(AttachedImage_Data) == 24,
              "Bad sizeof(AttachedImage_Data)");
// Used by AttachedImage::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AttachedImage_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AttachedImage_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AttachedImage_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<AttachedImage_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AttachedImage_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // chrome::mojom

#endif  // CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_SHARED_INTERNAL_H_