// chrome/services/media_gallery_util/public/mojom/media_parser.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_PARAMS_DATA_H_
#define CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace chrome::mojom {
namespace internal {
class  MediaParser_ParseMediaMetadata_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> mime_type;
  int64_t total_size;
  uint8_t get_attached_images : 1;
  uint8_t pad2_[3];
  mojo::internal::Interface_Data media_data_source;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaParser_ParseMediaMetadata_Params_Data>;

  MediaParser_ParseMediaMetadata_Params_Data();
  ~MediaParser_ParseMediaMetadata_Params_Data() = delete;
};
static_assert(sizeof(MediaParser_ParseMediaMetadata_Params_Data) == 40,
              "Bad sizeof(MediaParser_ParseMediaMetadata_Params_Data)");
class  MediaParser_ParseMediaMetadata_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t parse_success : 1;
  uint8_t pad0_[7];
  mojo::internal::Pointer<internal::MediaMetadata_Data> metadata;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::AttachedImage_Data>>> attached_images;

 private:
  friend class mojo::internal::MessageFragment<MediaParser_ParseMediaMetadata_ResponseParams_Data>;

  MediaParser_ParseMediaMetadata_ResponseParams_Data();
  ~MediaParser_ParseMediaMetadata_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaParser_ParseMediaMetadata_ResponseParams_Data) == 32,
              "Bad sizeof(MediaParser_ParseMediaMetadata_ResponseParams_Data)");
class  MediaParser_CheckMediaFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> decode_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyFile_Data> file;

 private:
  friend class mojo::internal::MessageFragment<MediaParser_CheckMediaFile_Params_Data>;

  MediaParser_CheckMediaFile_Params_Data();
  ~MediaParser_CheckMediaFile_Params_Data() = delete;
};
static_assert(sizeof(MediaParser_CheckMediaFile_Params_Data) == 24,
              "Bad sizeof(MediaParser_CheckMediaFile_Params_Data)");
class  MediaParser_CheckMediaFile_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<MediaParser_CheckMediaFile_ResponseParams_Data>;

  MediaParser_CheckMediaFile_ResponseParams_Data();
  ~MediaParser_CheckMediaFile_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaParser_CheckMediaFile_ResponseParams_Data) == 16,
              "Bad sizeof(MediaParser_CheckMediaFile_ResponseParams_Data)");
class  MediaParser_GetCpuInfo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaParser_GetCpuInfo_Params_Data>;

  MediaParser_GetCpuInfo_Params_Data();
  ~MediaParser_GetCpuInfo_Params_Data() = delete;
};
static_assert(sizeof(MediaParser_GetCpuInfo_Params_Data) == 8,
              "Bad sizeof(MediaParser_GetCpuInfo_Params_Data)");
class  MediaParser_GetCpuInfo_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t libyuv_cpu_flags;
  int64_t ffmpeg_cpu_flags;

 private:
  friend class mojo::internal::MessageFragment<MediaParser_GetCpuInfo_ResponseParams_Data>;

  MediaParser_GetCpuInfo_ResponseParams_Data();
  ~MediaParser_GetCpuInfo_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaParser_GetCpuInfo_ResponseParams_Data) == 24,
              "Bad sizeof(MediaParser_GetCpuInfo_ResponseParams_Data)");
class  MediaParserFactory_CreateMediaParser_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t libyuv_cpu_flags;
  int64_t libavutil_cpu_flags;

 private:
  friend class mojo::internal::MessageFragment<MediaParserFactory_CreateMediaParser_Params_Data>;

  MediaParserFactory_CreateMediaParser_Params_Data();
  ~MediaParserFactory_CreateMediaParser_Params_Data() = delete;
};
static_assert(sizeof(MediaParserFactory_CreateMediaParser_Params_Data) == 24,
              "Bad sizeof(MediaParserFactory_CreateMediaParser_Params_Data)");
class  MediaParserFactory_CreateMediaParser_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data media_parser;

 private:
  friend class mojo::internal::MessageFragment<MediaParserFactory_CreateMediaParser_ResponseParams_Data>;

  MediaParserFactory_CreateMediaParser_ResponseParams_Data();
  ~MediaParserFactory_CreateMediaParser_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaParserFactory_CreateMediaParser_ResponseParams_Data) == 16,
              "Bad sizeof(MediaParserFactory_CreateMediaParser_ResponseParams_Data)");
class  MediaDataSource_Read_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t position;
  int64_t length;

 private:
  friend class mojo::internal::MessageFragment<MediaDataSource_Read_Params_Data>;

  MediaDataSource_Read_Params_Data();
  ~MediaDataSource_Read_Params_Data() = delete;
};
static_assert(sizeof(MediaDataSource_Read_Params_Data) == 24,
              "Bad sizeof(MediaDataSource_Read_Params_Data)");
class  MediaDataSource_Read_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;

 private:
  friend class mojo::internal::MessageFragment<MediaDataSource_Read_ResponseParams_Data>;

  MediaDataSource_Read_ResponseParams_Data();
  ~MediaDataSource_Read_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaDataSource_Read_ResponseParams_Data) == 16,
              "Bad sizeof(MediaDataSource_Read_ResponseParams_Data)");

}  // namespace internal


class MediaParser_ParseMediaMetadata_ParamsDataView {
 public:
  MediaParser_ParseMediaMetadata_ParamsDataView() = default;

  MediaParser_ParseMediaMetadata_ParamsDataView(
      internal::MediaParser_ParseMediaMetadata_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t total_size() const {
    return data_->total_size;
  }
  bool get_attached_images() const {
    return data_->get_attached_images;
  }
  template <typename UserType>
  UserType TakeMediaDataSource() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::chrome::mojom::MediaDataSourceInterfaceBase>>(
            &data_->media_data_source, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaParser_ParseMediaMetadata_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaParser_ParseMediaMetadata_ResponseParamsDataView {
 public:
  MediaParser_ParseMediaMetadata_ResponseParamsDataView() = default;

  MediaParser_ParseMediaMetadata_ResponseParamsDataView(
      internal::MediaParser_ParseMediaMetadata_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool parse_success() const {
    return data_->parse_success;
  }
  inline void GetMetadataDataView(
      MediaMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::chrome::mojom::MediaMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetAttachedImagesDataView(
      mojo::ArrayDataView<AttachedImageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttachedImages(UserType* output) {
    
    auto* pointer = data_->attached_images.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::chrome::mojom::AttachedImageDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MediaParser_ParseMediaMetadata_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaParser_CheckMediaFile_ParamsDataView {
 public:
  MediaParser_CheckMediaFile_ParamsDataView() = default;

  MediaParser_CheckMediaFile_ParamsDataView(
      internal::MediaParser_CheckMediaFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDecodeTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDecodeTime(UserType* output) {
    
    auto* pointer = data_->decode_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFileDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) {
    
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaParser_CheckMediaFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaParser_CheckMediaFile_ResponseParamsDataView {
 public:
  MediaParser_CheckMediaFile_ResponseParamsDataView() = default;

  MediaParser_CheckMediaFile_ResponseParamsDataView(
      internal::MediaParser_CheckMediaFile_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::MediaParser_CheckMediaFile_ResponseParams_Data* data_ = nullptr;
};


class MediaParser_GetCpuInfo_ParamsDataView {
 public:
  MediaParser_GetCpuInfo_ParamsDataView() = default;

  MediaParser_GetCpuInfo_ParamsDataView(
      internal::MediaParser_GetCpuInfo_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaParser_GetCpuInfo_Params_Data* data_ = nullptr;
};


class MediaParser_GetCpuInfo_ResponseParamsDataView {
 public:
  MediaParser_GetCpuInfo_ResponseParamsDataView() = default;

  MediaParser_GetCpuInfo_ResponseParamsDataView(
      internal::MediaParser_GetCpuInfo_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t libyuv_cpu_flags() const {
    return data_->libyuv_cpu_flags;
  }
  int64_t ffmpeg_cpu_flags() const {
    return data_->ffmpeg_cpu_flags;
  }
 private:
  internal::MediaParser_GetCpuInfo_ResponseParams_Data* data_ = nullptr;
};


class MediaParserFactory_CreateMediaParser_ParamsDataView {
 public:
  MediaParserFactory_CreateMediaParser_ParamsDataView() = default;

  MediaParserFactory_CreateMediaParser_ParamsDataView(
      internal::MediaParserFactory_CreateMediaParser_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t libyuv_cpu_flags() const {
    return data_->libyuv_cpu_flags;
  }
  int64_t libavutil_cpu_flags() const {
    return data_->libavutil_cpu_flags;
  }
 private:
  internal::MediaParserFactory_CreateMediaParser_Params_Data* data_ = nullptr;
};


class MediaParserFactory_CreateMediaParser_ResponseParamsDataView {
 public:
  MediaParserFactory_CreateMediaParser_ResponseParamsDataView() = default;

  MediaParserFactory_CreateMediaParser_ResponseParamsDataView(
      internal::MediaParserFactory_CreateMediaParser_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeMediaParser() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::chrome::mojom::MediaParserInterfaceBase>>(
            &data_->media_parser, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaParserFactory_CreateMediaParser_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaDataSource_Read_ParamsDataView {
 public:
  MediaDataSource_Read_ParamsDataView() = default;

  MediaDataSource_Read_ParamsDataView(
      internal::MediaDataSource_Read_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t position() const {
    return data_->position;
  }
  int64_t length() const {
    return data_->length;
  }
 private:
  internal::MediaDataSource_Read_Params_Data* data_ = nullptr;
};


class MediaDataSource_Read_ResponseParamsDataView {
 public:
  MediaDataSource_Read_ResponseParamsDataView() = default;

  MediaDataSource_Read_ResponseParamsDataView(
      internal::MediaDataSource_Read_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::MediaDataSource_Read_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void MediaParser_ParseMediaMetadata_ParamsDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaParser_ParseMediaMetadata_ResponseParamsDataView::GetMetadataDataView(
    MediaMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = MediaMetadataDataView(pointer, message_);
}
inline void MediaParser_ParseMediaMetadata_ResponseParamsDataView::GetAttachedImagesDataView(
    mojo::ArrayDataView<AttachedImageDataView>* output) {
  auto pointer = data_->attached_images.Get();
  *output = mojo::ArrayDataView<AttachedImageDataView>(pointer, message_);
}


inline void MediaParser_CheckMediaFile_ParamsDataView::GetDecodeTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->decode_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void MediaParser_CheckMediaFile_ParamsDataView::GetFileDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}














inline void MediaDataSource_Read_ResponseParamsDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // chrome::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_SERVICES_MEDIA_GALLERY_UTIL_PUBLIC_MOJOM_MEDIA_PARSER_MOJOM_PARAMS_DATA_H_