// chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_SHARED_H_
#define CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-data-view.h"




namespace std {

template <>
struct hash<::mac_notifications::mojom::NotificationOperation>
    : public mojo::internal::EnumHashImpl<::mac_notifications::mojom::NotificationOperation> {};

template <>
struct hash<::mac_notifications::mojom::RequestPermissionResult>
    : public mojo::internal::EnumHashImpl<::mac_notifications::mojom::RequestPermissionResult> {};

template <>
struct hash<::mac_notifications::mojom::PermissionStatus>
    : public mojo::internal::EnumHashImpl<::mac_notifications::mojom::PermissionStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mac_notifications::mojom::NotificationOperation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::mac_notifications::mojom::NotificationOperation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::mac_notifications::mojom::NotificationOperation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mac_notifications::mojom::RequestPermissionResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::mac_notifications::mojom::RequestPermissionResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::mac_notifications::mojom::RequestPermissionResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mac_notifications::mojom::PermissionStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::mac_notifications::mojom::PermissionStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::mac_notifications::mojom::PermissionStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mac_notifications::mojom::ProfileIdentifierDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mac_notifications::mojom::ProfileIdentifierDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mac_notifications::mojom::internal::ProfileIdentifier_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ProfileIdentifier struct");

    fragment->incognito = Traits::incognito(input);
  }

  static bool Deserialize(::mac_notifications::mojom::internal::ProfileIdentifier_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mac_notifications::mojom::ProfileIdentifierDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mac_notifications::mojom::NotificationIdentifierDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mac_notifications::mojom::NotificationIdentifierDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mac_notifications::mojom::internal::NotificationIdentifier_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in NotificationIdentifier struct");

    decltype(Traits::profile(input)) in_profile = Traits::profile(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->profile)::BaseType> profile_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mac_notifications::mojom::ProfileIdentifierDataView>(
      in_profile,
      profile_fragment);

    fragment->profile.Set(
        profile_fragment.is_null() ? nullptr : profile_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->profile.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null profile in NotificationIdentifier struct");
  }

  static bool Deserialize(::mac_notifications::mojom::internal::NotificationIdentifier_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mac_notifications::mojom::NotificationIdentifierDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mac_notifications::mojom::NotificationMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mac_notifications::mojom::NotificationMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mac_notifications::mojom::internal::NotificationMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mac_notifications::mojom::NotificationIdentifierDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in NotificationMetadata struct");

    fragment->type = Traits::type(input);

    decltype(Traits::origin_url(input)) in_origin_url = Traits::origin_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin_url)::BaseType> origin_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_origin_url,
      origin_url_fragment);

    fragment->origin_url.Set(
        origin_url_fragment.is_null() ? nullptr : origin_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin_url in NotificationMetadata struct");

    decltype(Traits::user_data_dir(input)) in_user_data_dir = Traits::user_data_dir(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_data_dir)::BaseType> user_data_dir_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_user_data_dir,
      user_data_dir_fragment);

    fragment->user_data_dir.Set(
        user_data_dir_fragment.is_null() ? nullptr : user_data_dir_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user_data_dir.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_data_dir in NotificationMetadata struct");
  }

  static bool Deserialize(::mac_notifications::mojom::internal::NotificationMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mac_notifications::mojom::NotificationMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mac_notifications::mojom::NotificationActionInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mac_notifications::mojom::NotificationActionInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mac_notifications::mojom::internal::NotificationActionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::meta(input)) in_meta = Traits::meta(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->meta)::BaseType> meta_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mac_notifications::mojom::NotificationMetadataDataView>(
      in_meta,
      meta_fragment);

    fragment->meta.Set(
        meta_fragment.is_null() ? nullptr : meta_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->meta.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null meta in NotificationActionInfo struct");

    
    mojo::internal::Serialize<::mac_notifications::mojom::NotificationOperation>(
      Traits::operation(input),
      &fragment->operation);

    fragment->button_index = Traits::button_index(input);

    decltype(Traits::reply(input)) in_reply = Traits::reply(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reply)::BaseType> reply_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_reply,
      reply_fragment);

    fragment->reply.Set(
        reply_fragment.is_null() ? nullptr : reply_fragment.data());
  }

  static bool Deserialize(::mac_notifications::mojom::internal::NotificationActionInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mac_notifications::mojom::NotificationActionInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mac_notifications::mojom::NotificationActionButtonDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mac_notifications::mojom::NotificationActionButtonDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mac_notifications::mojom::internal::NotificationActionButton_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in NotificationActionButton struct");

    decltype(Traits::placeholder(input)) in_placeholder = Traits::placeholder(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->placeholder)::BaseType> placeholder_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_placeholder,
      placeholder_fragment);

    fragment->placeholder.Set(
        placeholder_fragment.is_null() ? nullptr : placeholder_fragment.data());
  }

  static bool Deserialize(::mac_notifications::mojom::internal::NotificationActionButton_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mac_notifications::mojom::NotificationActionButtonDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mac_notifications::mojom::NotificationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mac_notifications::mojom::NotificationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mac_notifications::mojom::internal::Notification_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::meta(input)) in_meta = Traits::meta(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->meta)::BaseType> meta_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mac_notifications::mojom::NotificationMetadataDataView>(
      in_meta,
      meta_fragment);

    fragment->meta.Set(
        meta_fragment.is_null() ? nullptr : meta_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->meta.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null meta in Notification struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in Notification struct");

    decltype(Traits::subtitle(input)) in_subtitle = Traits::subtitle(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subtitle)::BaseType> subtitle_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_subtitle,
      subtitle_fragment);

    fragment->subtitle.Set(
        subtitle_fragment.is_null() ? nullptr : subtitle_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->subtitle.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null subtitle in Notification struct");

    decltype(Traits::body(input)) in_body = Traits::body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->body)::BaseType> body_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_body,
      body_fragment);

    fragment->body.Set(
        body_fragment.is_null() ? nullptr : body_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->body.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null body in Notification struct");

    fragment->renotify = Traits::renotify(input);

    fragment->show_settings_button = Traits::show_settings_button(input);

    decltype(Traits::buttons(input)) in_buttons = Traits::buttons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->buttons)::BaseType>
        buttons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& buttons_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mac_notifications::mojom::NotificationActionButtonDataView>>(
      in_buttons,
      buttons_fragment,
      &buttons_validate_params);

    fragment->buttons.Set(
        buttons_fragment.is_null() ? nullptr : buttons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->buttons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buttons in Notification struct");

    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon)::BaseType> icon_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
      in_icon,
      icon_fragment);

    fragment->icon.Set(
        icon_fragment.is_null() ? nullptr : icon_fragment.data());
  }

  static bool Deserialize(::mac_notifications::mojom::internal::Notification_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mac_notifications::mojom::NotificationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mac_notifications::mojom {

inline void ProfileIdentifierDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void NotificationIdentifierDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NotificationIdentifierDataView::GetProfileDataView(
    ProfileIdentifierDataView* output) {
  auto pointer = data_->profile.Get();
  *output = ProfileIdentifierDataView(pointer, message_);
}


inline void NotificationMetadataDataView::GetIdDataView(
    NotificationIdentifierDataView* output) {
  auto pointer = data_->id.Get();
  *output = NotificationIdentifierDataView(pointer, message_);
}
inline void NotificationMetadataDataView::GetOriginUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->origin_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void NotificationMetadataDataView::GetUserDataDirDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->user_data_dir.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void NotificationActionInfoDataView::GetMetaDataView(
    NotificationMetadataDataView* output) {
  auto pointer = data_->meta.Get();
  *output = NotificationMetadataDataView(pointer, message_);
}
inline void NotificationActionInfoDataView::GetReplyDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->reply.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void NotificationActionButtonDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void NotificationActionButtonDataView::GetPlaceholderDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->placeholder.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void NotificationDataView::GetMetaDataView(
    NotificationMetadataDataView* output) {
  auto pointer = data_->meta.Get();
  *output = NotificationMetadataDataView(pointer, message_);
}
inline void NotificationDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void NotificationDataView::GetSubtitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->subtitle.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void NotificationDataView::GetBodyDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->body.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void NotificationDataView::GetButtonsDataView(
    mojo::ArrayDataView<NotificationActionButtonDataView>* output) {
  auto pointer = data_->buttons.Get();
  *output = mojo::ArrayDataView<NotificationActionButtonDataView>(pointer, message_);
}
inline void NotificationDataView::GetIconDataView(
    ::gfx::mojom::ImageSkiaDataView* output) {
  auto pointer = data_->icon.Get();
  *output = ::gfx::mojom::ImageSkiaDataView(pointer, message_);
}



}  // mac_notifications::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::mac_notifications::mojom::NotificationOperation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::mac_notifications::mojom::NotificationOperation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::mac_notifications::mojom::RequestPermissionResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::mac_notifications::mojom::RequestPermissionResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::mac_notifications::mojom::PermissionStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::mac_notifications::mojom::PermissionStatus value);
};

} // namespace perfetto

#endif  // CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_SHARED_H_