// chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_PARAMS_DATA_H_
#define CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace mac_notifications::mojom {
namespace internal {
class  MacNotificationService_DisplayNotification_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::Notification_Data> notification;

 private:
  friend class mojo::internal::MessageFragment<MacNotificationService_DisplayNotification_Params_Data>;

  MacNotificationService_DisplayNotification_Params_Data();
  ~MacNotificationService_DisplayNotification_Params_Data() = delete;
};
static_assert(sizeof(MacNotificationService_DisplayNotification_Params_Data) == 16,
              "Bad sizeof(MacNotificationService_DisplayNotification_Params_Data)");
class  MacNotificationService_GetDisplayedNotifications_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ProfileIdentifier_Data> profile;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> origin;

 private:
  friend class mojo::internal::MessageFragment<MacNotificationService_GetDisplayedNotifications_Params_Data>;

  MacNotificationService_GetDisplayedNotifications_Params_Data();
  ~MacNotificationService_GetDisplayedNotifications_Params_Data() = delete;
};
static_assert(sizeof(MacNotificationService_GetDisplayedNotifications_Params_Data) == 24,
              "Bad sizeof(MacNotificationService_GetDisplayedNotifications_Params_Data)");
class  MacNotificationService_GetDisplayedNotifications_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::NotificationIdentifier_Data>>> notifications;

 private:
  friend class mojo::internal::MessageFragment<MacNotificationService_GetDisplayedNotifications_ResponseParams_Data>;

  MacNotificationService_GetDisplayedNotifications_ResponseParams_Data();
  ~MacNotificationService_GetDisplayedNotifications_ResponseParams_Data() = delete;
};
static_assert(sizeof(MacNotificationService_GetDisplayedNotifications_ResponseParams_Data) == 16,
              "Bad sizeof(MacNotificationService_GetDisplayedNotifications_ResponseParams_Data)");
class  MacNotificationService_CloseNotification_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::NotificationIdentifier_Data> identifier;

 private:
  friend class mojo::internal::MessageFragment<MacNotificationService_CloseNotification_Params_Data>;

  MacNotificationService_CloseNotification_Params_Data();
  ~MacNotificationService_CloseNotification_Params_Data() = delete;
};
static_assert(sizeof(MacNotificationService_CloseNotification_Params_Data) == 16,
              "Bad sizeof(MacNotificationService_CloseNotification_Params_Data)");
class  MacNotificationService_CloseNotificationsForProfile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ProfileIdentifier_Data> profile;

 private:
  friend class mojo::internal::MessageFragment<MacNotificationService_CloseNotificationsForProfile_Params_Data>;

  MacNotificationService_CloseNotificationsForProfile_Params_Data();
  ~MacNotificationService_CloseNotificationsForProfile_Params_Data() = delete;
};
static_assert(sizeof(MacNotificationService_CloseNotificationsForProfile_Params_Data) == 16,
              "Bad sizeof(MacNotificationService_CloseNotificationsForProfile_Params_Data)");
class  MacNotificationService_CloseAllNotifications_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MacNotificationService_CloseAllNotifications_Params_Data>;

  MacNotificationService_CloseAllNotifications_Params_Data();
  ~MacNotificationService_CloseAllNotifications_Params_Data() = delete;
};
static_assert(sizeof(MacNotificationService_CloseAllNotifications_Params_Data) == 8,
              "Bad sizeof(MacNotificationService_CloseAllNotifications_Params_Data)");
class  MacNotificationService_OkayToTerminateService_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MacNotificationService_OkayToTerminateService_Params_Data>;

  MacNotificationService_OkayToTerminateService_Params_Data();
  ~MacNotificationService_OkayToTerminateService_Params_Data() = delete;
};
static_assert(sizeof(MacNotificationService_OkayToTerminateService_Params_Data) == 8,
              "Bad sizeof(MacNotificationService_OkayToTerminateService_Params_Data)");
class  MacNotificationService_OkayToTerminateService_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t can_terminate : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<MacNotificationService_OkayToTerminateService_ResponseParams_Data>;

  MacNotificationService_OkayToTerminateService_ResponseParams_Data();
  ~MacNotificationService_OkayToTerminateService_ResponseParams_Data() = delete;
};
static_assert(sizeof(MacNotificationService_OkayToTerminateService_ResponseParams_Data) == 16,
              "Bad sizeof(MacNotificationService_OkayToTerminateService_ResponseParams_Data)");
class  MacNotificationActionHandler_OnNotificationAction_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::NotificationActionInfo_Data> info;

 private:
  friend class mojo::internal::MessageFragment<MacNotificationActionHandler_OnNotificationAction_Params_Data>;

  MacNotificationActionHandler_OnNotificationAction_Params_Data();
  ~MacNotificationActionHandler_OnNotificationAction_Params_Data() = delete;
};
static_assert(sizeof(MacNotificationActionHandler_OnNotificationAction_Params_Data) == 16,
              "Bad sizeof(MacNotificationActionHandler_OnNotificationAction_Params_Data)");
class  MacNotificationProvider_BindNotificationService_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data service;
  mojo::internal::Interface_Data handler;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MacNotificationProvider_BindNotificationService_Params_Data>;

  MacNotificationProvider_BindNotificationService_Params_Data();
  ~MacNotificationProvider_BindNotificationService_Params_Data() = delete;
};
static_assert(sizeof(MacNotificationProvider_BindNotificationService_Params_Data) == 24,
              "Bad sizeof(MacNotificationProvider_BindNotificationService_Params_Data)");

}  // namespace internal


class MacNotificationService_DisplayNotification_ParamsDataView {
 public:
  MacNotificationService_DisplayNotification_ParamsDataView() = default;

  MacNotificationService_DisplayNotification_ParamsDataView(
      internal::MacNotificationService_DisplayNotification_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNotificationDataView(
      NotificationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNotification(UserType* output) {
    
    auto* pointer = data_->notification.Get();
    return mojo::internal::Deserialize<::mac_notifications::mojom::NotificationDataView>(
        pointer, output, message_);
  }
 private:
  internal::MacNotificationService_DisplayNotification_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MacNotificationService_GetDisplayedNotifications_ParamsDataView {
 public:
  MacNotificationService_GetDisplayedNotifications_ParamsDataView() = default;

  MacNotificationService_GetDisplayedNotifications_ParamsDataView(
      internal::MacNotificationService_GetDisplayedNotifications_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProfileDataView(
      ProfileIdentifierDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mac_notifications::mojom::ProfileIdentifierDataView, UserType>(),
    "Attempting to read the optional `profile` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProfile` instead "
    "of `ReadProfile if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->profile.Get();
    return mojo::internal::Deserialize<::mac_notifications::mojom::ProfileIdentifierDataView>(
        pointer, output, message_);
  }
  inline void GetOriginDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOrigin` instead "
    "of `ReadOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::MacNotificationService_GetDisplayedNotifications_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MacNotificationService_GetDisplayedNotifications_ResponseParamsDataView {
 public:
  MacNotificationService_GetDisplayedNotifications_ResponseParamsDataView() = default;

  MacNotificationService_GetDisplayedNotifications_ResponseParamsDataView(
      internal::MacNotificationService_GetDisplayedNotifications_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNotificationsDataView(
      mojo::ArrayDataView<NotificationIdentifierDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNotifications(UserType* output) {
    
    auto* pointer = data_->notifications.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mac_notifications::mojom::NotificationIdentifierDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MacNotificationService_GetDisplayedNotifications_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MacNotificationService_CloseNotification_ParamsDataView {
 public:
  MacNotificationService_CloseNotification_ParamsDataView() = default;

  MacNotificationService_CloseNotification_ParamsDataView(
      internal::MacNotificationService_CloseNotification_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdentifierDataView(
      NotificationIdentifierDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdentifier(UserType* output) {
    
    auto* pointer = data_->identifier.Get();
    return mojo::internal::Deserialize<::mac_notifications::mojom::NotificationIdentifierDataView>(
        pointer, output, message_);
  }
 private:
  internal::MacNotificationService_CloseNotification_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MacNotificationService_CloseNotificationsForProfile_ParamsDataView {
 public:
  MacNotificationService_CloseNotificationsForProfile_ParamsDataView() = default;

  MacNotificationService_CloseNotificationsForProfile_ParamsDataView(
      internal::MacNotificationService_CloseNotificationsForProfile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProfileDataView(
      ProfileIdentifierDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) {
    
    auto* pointer = data_->profile.Get();
    return mojo::internal::Deserialize<::mac_notifications::mojom::ProfileIdentifierDataView>(
        pointer, output, message_);
  }
 private:
  internal::MacNotificationService_CloseNotificationsForProfile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MacNotificationService_CloseAllNotifications_ParamsDataView {
 public:
  MacNotificationService_CloseAllNotifications_ParamsDataView() = default;

  MacNotificationService_CloseAllNotifications_ParamsDataView(
      internal::MacNotificationService_CloseAllNotifications_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MacNotificationService_CloseAllNotifications_Params_Data* data_ = nullptr;
};


class MacNotificationService_OkayToTerminateService_ParamsDataView {
 public:
  MacNotificationService_OkayToTerminateService_ParamsDataView() = default;

  MacNotificationService_OkayToTerminateService_ParamsDataView(
      internal::MacNotificationService_OkayToTerminateService_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MacNotificationService_OkayToTerminateService_Params_Data* data_ = nullptr;
};


class MacNotificationService_OkayToTerminateService_ResponseParamsDataView {
 public:
  MacNotificationService_OkayToTerminateService_ResponseParamsDataView() = default;

  MacNotificationService_OkayToTerminateService_ResponseParamsDataView(
      internal::MacNotificationService_OkayToTerminateService_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool can_terminate() const {
    return data_->can_terminate;
  }
 private:
  internal::MacNotificationService_OkayToTerminateService_ResponseParams_Data* data_ = nullptr;
};


class MacNotificationActionHandler_OnNotificationAction_ParamsDataView {
 public:
  MacNotificationActionHandler_OnNotificationAction_ParamsDataView() = default;

  MacNotificationActionHandler_OnNotificationAction_ParamsDataView(
      internal::MacNotificationActionHandler_OnNotificationAction_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      NotificationActionInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::mac_notifications::mojom::NotificationActionInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::MacNotificationActionHandler_OnNotificationAction_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MacNotificationProvider_BindNotificationService_ParamsDataView {
 public:
  MacNotificationProvider_BindNotificationService_ParamsDataView() = default;

  MacNotificationProvider_BindNotificationService_ParamsDataView(
      internal::MacNotificationProvider_BindNotificationService_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeService() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::mac_notifications::mojom::MacNotificationServiceInterfaceBase>>(
            &data_->service, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::mac_notifications::mojom::MacNotificationActionHandlerInterfaceBase>>(
            &data_->handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MacNotificationProvider_BindNotificationService_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void MacNotificationService_DisplayNotification_ParamsDataView::GetNotificationDataView(
    NotificationDataView* output) {
  auto pointer = data_->notification.Get();
  *output = NotificationDataView(pointer, message_);
}


inline void MacNotificationService_GetDisplayedNotifications_ParamsDataView::GetProfileDataView(
    ProfileIdentifierDataView* output) {
  auto pointer = data_->profile.Get();
  *output = ProfileIdentifierDataView(pointer, message_);
}
inline void MacNotificationService_GetDisplayedNotifications_ParamsDataView::GetOriginDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void MacNotificationService_GetDisplayedNotifications_ResponseParamsDataView::GetNotificationsDataView(
    mojo::ArrayDataView<NotificationIdentifierDataView>* output) {
  auto pointer = data_->notifications.Get();
  *output = mojo::ArrayDataView<NotificationIdentifierDataView>(pointer, message_);
}


inline void MacNotificationService_CloseNotification_ParamsDataView::GetIdentifierDataView(
    NotificationIdentifierDataView* output) {
  auto pointer = data_->identifier.Get();
  *output = NotificationIdentifierDataView(pointer, message_);
}


inline void MacNotificationService_CloseNotificationsForProfile_ParamsDataView::GetProfileDataView(
    ProfileIdentifierDataView* output) {
  auto pointer = data_->profile.Get();
  *output = ProfileIdentifierDataView(pointer, message_);
}








inline void MacNotificationActionHandler_OnNotificationAction_ParamsDataView::GetInfoDataView(
    NotificationActionInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = NotificationActionInfoDataView(pointer, message_);
}





}  // mac_notifications::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_PARAMS_DATA_H_