// chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_DATA_VIEW_H_
#define CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace mac_notifications::mojom {
class ProfileIdentifierDataView;

class NotificationIdentifierDataView;

class NotificationMetadataDataView;

class NotificationActionInfoDataView;

class NotificationActionButtonDataView;

class NotificationDataView;



}  // mac_notifications::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mac_notifications::mojom::ProfileIdentifierDataView> {
  using Data = ::mac_notifications::mojom::internal::ProfileIdentifier_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mac_notifications::mojom::NotificationIdentifierDataView> {
  using Data = ::mac_notifications::mojom::internal::NotificationIdentifier_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mac_notifications::mojom::NotificationMetadataDataView> {
  using Data = ::mac_notifications::mojom::internal::NotificationMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mac_notifications::mojom::NotificationActionInfoDataView> {
  using Data = ::mac_notifications::mojom::internal::NotificationActionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mac_notifications::mojom::NotificationActionButtonDataView> {
  using Data = ::mac_notifications::mojom::internal::NotificationActionButton_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mac_notifications::mojom::NotificationDataView> {
  using Data = ::mac_notifications::mojom::internal::Notification_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mac_notifications::mojom {


enum class NotificationOperation : int32_t {
  
  kClick = 0,
  
  kClose = 1,
  
  kSettings = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, NotificationOperation value);
inline bool IsKnownEnumValue(NotificationOperation value) {
  return internal::NotificationOperation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RequestPermissionResult : int32_t {
  
  kRequestFailed = 0,
  
  kPermissionDenied = 1,
  
  kPermissionGranted = 2,
  
  kPermissionPreviouslyDenied = 3,
  
  kPermissionPreviouslyGranted = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, RequestPermissionResult value);
inline bool IsKnownEnumValue(RequestPermissionResult value) {
  return internal::RequestPermissionResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PermissionStatus : int32_t {
  
  kNotDetermined = 1,
  
  kPromptPending = 2,
  
  kDenied = 3,
  
  kGranted = 4,
  kMinValue = 1,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, PermissionStatus value);
inline bool IsKnownEnumValue(PermissionStatus value) {
  return internal::PermissionStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MacNotificationServiceInterfaceBase {};

using MacNotificationServicePtrDataView =
    mojo::InterfacePtrDataView<MacNotificationServiceInterfaceBase>;
using MacNotificationServiceRequestDataView =
    mojo::InterfaceRequestDataView<MacNotificationServiceInterfaceBase>;
using MacNotificationServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MacNotificationServiceInterfaceBase>;
using MacNotificationServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MacNotificationServiceInterfaceBase>;
class MacNotificationActionHandlerInterfaceBase {};

using MacNotificationActionHandlerPtrDataView =
    mojo::InterfacePtrDataView<MacNotificationActionHandlerInterfaceBase>;
using MacNotificationActionHandlerRequestDataView =
    mojo::InterfaceRequestDataView<MacNotificationActionHandlerInterfaceBase>;
using MacNotificationActionHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MacNotificationActionHandlerInterfaceBase>;
using MacNotificationActionHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MacNotificationActionHandlerInterfaceBase>;
class MacNotificationProviderInterfaceBase {};

using MacNotificationProviderPtrDataView =
    mojo::InterfacePtrDataView<MacNotificationProviderInterfaceBase>;
using MacNotificationProviderRequestDataView =
    mojo::InterfaceRequestDataView<MacNotificationProviderInterfaceBase>;
using MacNotificationProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MacNotificationProviderInterfaceBase>;
using MacNotificationProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MacNotificationProviderInterfaceBase>;


class ProfileIdentifierDataView {
 public:
  ProfileIdentifierDataView() = default;

  ProfileIdentifierDataView(
      internal::ProfileIdentifier_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool incognito() const {
    return data_->incognito;
  }
 private:
  internal::ProfileIdentifier_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NotificationIdentifierDataView {
 public:
  NotificationIdentifierDataView() = default;

  NotificationIdentifierDataView(
      internal::NotificationIdentifier_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetProfileDataView(
      ProfileIdentifierDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProfile(UserType* output) {
    
    auto* pointer = data_->profile.Get();
    return mojo::internal::Deserialize<::mac_notifications::mojom::ProfileIdentifierDataView>(
        pointer, output, message_);
  }
 private:
  internal::NotificationIdentifier_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NotificationMetadataDataView {
 public:
  NotificationMetadataDataView() = default;

  NotificationMetadataDataView(
      internal::NotificationMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      NotificationIdentifierDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mac_notifications::mojom::NotificationIdentifierDataView>(
        pointer, output, message_);
  }
  int32_t type() const {
    return data_->type;
  }
  inline void GetOriginUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginUrl(UserType* output) {
    
    auto* pointer = data_->origin_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUserDataDirDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserDataDir(UserType* output) {
    
    auto* pointer = data_->user_data_dir.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::NotificationMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NotificationActionInfoDataView {
 public:
  NotificationActionInfoDataView() = default;

  NotificationActionInfoDataView(
      internal::NotificationActionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMetaDataView(
      NotificationMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMeta(UserType* output) {
    
    auto* pointer = data_->meta.Get();
    return mojo::internal::Deserialize<::mac_notifications::mojom::NotificationMetadataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOperation(UserType* output) const {
    auto data_value = data_->operation;
    return mojo::internal::Deserialize<::mac_notifications::mojom::NotificationOperation>(
        data_value, output);
  }
  NotificationOperation operation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mac_notifications::mojom::NotificationOperation>(data_->operation));
  }
  int32_t button_index() const {
    return data_->button_index;
  }
  inline void GetReplyDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReply(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `reply` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReply` instead "
    "of `ReadReply if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reply.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::NotificationActionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NotificationActionButtonDataView {
 public:
  NotificationActionButtonDataView() = default;

  NotificationActionButtonDataView(
      internal::NotificationActionButton_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetPlaceholderDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlaceholder(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `placeholder` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPlaceholder` instead "
    "of `ReadPlaceholder if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->placeholder.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::NotificationActionButton_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NotificationDataView {
 public:
  NotificationDataView() = default;

  NotificationDataView(
      internal::Notification_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMetaDataView(
      NotificationMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMeta(UserType* output) {
    
    auto* pointer = data_->meta.Get();
    return mojo::internal::Deserialize<::mac_notifications::mojom::NotificationMetadataDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSubtitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubtitle(UserType* output) {
    
    auto* pointer = data_->subtitle.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetBodyDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBody(UserType* output) {
    
    auto* pointer = data_->body.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool renotify() const {
    return data_->renotify;
  }
  bool show_settings_button() const {
    return data_->show_settings_button;
  }
  inline void GetButtonsDataView(
      mojo::ArrayDataView<NotificationActionButtonDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadButtons(UserType* output) {
    
    auto* pointer = data_->buttons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mac_notifications::mojom::NotificationActionButtonDataView>>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::gfx::mojom::ImageSkiaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::ImageSkiaDataView, UserType>(),
    "Attempting to read the optional `icon` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIcon` instead "
    "of `ReadIcon if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ImageSkiaDataView>(
        pointer, output, message_);
  }
 private:
  internal::Notification_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mac_notifications::mojom

#endif  // CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_DATA_VIEW_H_