// chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SAFE_ARCHIVE_ANALYZER_MOJOM_H_
#define CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SAFE_ARCHIVE_ANALYZER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-features.h"  // IWYU pragma: export
#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-shared.h"  // IWYU pragma: export
#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "chrome/common/safe_browsing/archive_analyzer_results.h"




namespace chrome::mojom {

class SafeArchiveAnalyzerProxy;

template <typename ImplRefTraits>
class SafeArchiveAnalyzerStub;

class SafeArchiveAnalyzerRequestValidator;
class SafeArchiveAnalyzerResponseValidator;


class SafeArchiveAnalyzer
    : public SafeArchiveAnalyzerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.SafeArchiveAnalyzer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SafeArchiveAnalyzerInterfaceBase;
  using Proxy_ = SafeArchiveAnalyzerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SafeArchiveAnalyzerStub<ImplRefTraits>;

  using RequestValidator_ = SafeArchiveAnalyzerRequestValidator;
  using ResponseValidator_ = SafeArchiveAnalyzerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAnalyzeZipFileMinVersion = 0,
    kAnalyzeDmgFileMinVersion = 0,
    kAnalyzeRarFileMinVersion = 0,
    kAnalyzeSevenZipFileMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AnalyzeZipFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AnalyzeDmgFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AnalyzeRarFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AnalyzeSevenZipFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SafeArchiveAnalyzer() = default;

  using AnalyzeZipFileCallback = base::OnceCallback<void(const ::safe_browsing::ArchiveAnalyzerResults&)>;
  using AnalyzeZipFileMojoCallback = base::OnceCallback<void(const ::safe_browsing::ArchiveAnalyzerResults&)>;

  virtual void AnalyzeZipFile(::base::File zip_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeZipFileCallback callback) = 0;

  using AnalyzeDmgFileCallback = base::OnceCallback<void(const ::safe_browsing::ArchiveAnalyzerResults&)>;
  using AnalyzeDmgFileMojoCallback = base::OnceCallback<void(const ::safe_browsing::ArchiveAnalyzerResults&)>;

  virtual void AnalyzeDmgFile(::base::File dmg_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeDmgFileCallback callback) = 0;

  using AnalyzeRarFileCallback = base::OnceCallback<void(const ::safe_browsing::ArchiveAnalyzerResults&)>;
  using AnalyzeRarFileMojoCallback = base::OnceCallback<void(const ::safe_browsing::ArchiveAnalyzerResults&)>;

  virtual void AnalyzeRarFile(::base::File rar_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeRarFileCallback callback) = 0;

  using AnalyzeSevenZipFileCallback = base::OnceCallback<void(const ::safe_browsing::ArchiveAnalyzerResults&)>;
  using AnalyzeSevenZipFileMojoCallback = base::OnceCallback<void(const ::safe_browsing::ArchiveAnalyzerResults&)>;

  virtual void AnalyzeSevenZipFile(::base::File seven_zip_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeSevenZipFileCallback callback) = 0;
};

class TemporaryFileGetterProxy;

template <typename ImplRefTraits>
class TemporaryFileGetterStub;

class TemporaryFileGetterRequestValidator;
class TemporaryFileGetterResponseValidator;


class TemporaryFileGetter
    : public TemporaryFileGetterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.TemporaryFileGetter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TemporaryFileGetterInterfaceBase;
  using Proxy_ = TemporaryFileGetterProxy;

  template <typename ImplRefTraits>
  using Stub_ = TemporaryFileGetterStub<ImplRefTraits>;

  using RequestValidator_ = TemporaryFileGetterRequestValidator;
  using ResponseValidator_ = TemporaryFileGetterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestTemporaryFileMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestTemporaryFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TemporaryFileGetter() = default;

  using RequestTemporaryFileCallback = base::OnceCallback<void(::base::File)>;
  using RequestTemporaryFileMojoCallback = base::OnceCallback<void(::base::File)>;

  virtual void RequestTemporaryFile(RequestTemporaryFileCallback callback) = 0;
};



class  SafeArchiveAnalyzerProxy
    : public SafeArchiveAnalyzer {
 public:
  using InterfaceType = SafeArchiveAnalyzer;

  explicit SafeArchiveAnalyzerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AnalyzeZipFile(::base::File zip_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeZipFileCallback callback) final;
  
  void AnalyzeDmgFile(::base::File dmg_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeDmgFileCallback callback) final;
  
  void AnalyzeRarFile(::base::File rar_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeRarFileCallback callback) final;
  
  void AnalyzeSevenZipFile(::base::File seven_zip_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeSevenZipFileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  TemporaryFileGetterProxy
    : public TemporaryFileGetter {
 public:
  using InterfaceType = TemporaryFileGetter;

  explicit TemporaryFileGetterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestTemporaryFile(RequestTemporaryFileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SafeArchiveAnalyzerStubDispatch {
 public:
  static bool Accept(SafeArchiveAnalyzer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SafeArchiveAnalyzer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SafeArchiveAnalyzer>>
class SafeArchiveAnalyzerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SafeArchiveAnalyzerStub() = default;
  ~SafeArchiveAnalyzerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SafeArchiveAnalyzerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SafeArchiveAnalyzerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TemporaryFileGetterStubDispatch {
 public:
  static bool Accept(TemporaryFileGetter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TemporaryFileGetter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TemporaryFileGetter>>
class TemporaryFileGetterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TemporaryFileGetterStub() = default;
  ~TemporaryFileGetterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TemporaryFileGetterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TemporaryFileGetterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SafeArchiveAnalyzerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TemporaryFileGetterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SafeArchiveAnalyzerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TemporaryFileGetterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







}  // chrome::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SAFE_ARCHIVE_ANALYZER_MOJOM_H_