// chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SAFE_ARCHIVE_ANALYZER_MOJOM_TEST_UTILS_H_
#define CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SAFE_ARCHIVE_ANALYZER_MOJOM_TEST_UTILS_H_

#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom.h"


namespace chrome::mojom {


class  SafeArchiveAnalyzerInterceptorForTesting : public SafeArchiveAnalyzer {
  virtual SafeArchiveAnalyzer* GetForwardingInterface() = 0;
  void AnalyzeZipFile(::base::File zip_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeZipFileCallback callback) override;
  void AnalyzeDmgFile(::base::File dmg_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeDmgFileCallback callback) override;
  void AnalyzeRarFile(::base::File rar_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeRarFileCallback callback) override;
  void AnalyzeSevenZipFile(::base::File seven_zip_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, AnalyzeSevenZipFileCallback callback) override;
};
class  SafeArchiveAnalyzerAsyncWaiter {
 public:
  explicit SafeArchiveAnalyzerAsyncWaiter(SafeArchiveAnalyzer* proxy);

  SafeArchiveAnalyzerAsyncWaiter(const SafeArchiveAnalyzerAsyncWaiter&) = delete;
  SafeArchiveAnalyzerAsyncWaiter& operator=(const SafeArchiveAnalyzerAsyncWaiter&) = delete;

  ~SafeArchiveAnalyzerAsyncWaiter();
  void AnalyzeZipFile(
      ::base::File zip_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, ::safe_browsing::ArchiveAnalyzerResults* out_results);
  ::safe_browsing::ArchiveAnalyzerResults AnalyzeZipFile(::base::File zip_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter);
  void AnalyzeDmgFile(
      ::base::File dmg_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, ::safe_browsing::ArchiveAnalyzerResults* out_results);
  ::safe_browsing::ArchiveAnalyzerResults AnalyzeDmgFile(::base::File dmg_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter);
  void AnalyzeRarFile(
      ::base::File rar_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, ::safe_browsing::ArchiveAnalyzerResults* out_results);
  ::safe_browsing::ArchiveAnalyzerResults AnalyzeRarFile(::base::File rar_file, const std::optional<std::string>& password, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter);
  void AnalyzeSevenZipFile(
      ::base::File seven_zip_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter, ::safe_browsing::ArchiveAnalyzerResults* out_results);
  ::safe_browsing::ArchiveAnalyzerResults AnalyzeSevenZipFile(::base::File seven_zip_file, ::mojo::PendingRemote<TemporaryFileGetter> temp_file_getter);

 private:
  SafeArchiveAnalyzer* const proxy_;
};


class  TemporaryFileGetterInterceptorForTesting : public TemporaryFileGetter {
  virtual TemporaryFileGetter* GetForwardingInterface() = 0;
  void RequestTemporaryFile(RequestTemporaryFileCallback callback) override;
};
class  TemporaryFileGetterAsyncWaiter {
 public:
  explicit TemporaryFileGetterAsyncWaiter(TemporaryFileGetter* proxy);

  TemporaryFileGetterAsyncWaiter(const TemporaryFileGetterAsyncWaiter&) = delete;
  TemporaryFileGetterAsyncWaiter& operator=(const TemporaryFileGetterAsyncWaiter&) = delete;

  ~TemporaryFileGetterAsyncWaiter();
  void RequestTemporaryFile(
      ::base::File* out_temp_file);
  ::base::File RequestTemporaryFile();

 private:
  TemporaryFileGetter* const proxy_;
};




}  // chrome::mojom

#endif  // CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_SAFE_ARCHIVE_ANALYZER_MOJOM_TEST_UTILS_H_