// chrome/common/trusted_vault_encryption_keys_extension.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_TRUSTED_VAULT_ENCRYPTION_KEYS_EXTENSION_MOJOM_SHARED_H_
#define CHROME_COMMON_TRUSTED_VAULT_ENCRYPTION_KEYS_EXTENSION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/trusted_vault_encryption_keys_extension.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/common/trusted_vault_encryption_keys_extension.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::TrustedVaultKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::TrustedVaultKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::TrustedVaultKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->version = Traits::version(input);

    decltype(Traits::bytes(input)) in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bytes)::BaseType>
        bytes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bytes,
      bytes_fragment,
      &bytes_validate_params);

    fragment->bytes.Set(
        bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bytes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bytes in TrustedVaultKey struct");
  }

  static bool Deserialize(::chrome::mojom::internal::TrustedVaultKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::TrustedVaultKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace chrome::mojom {

inline void TrustedVaultKeyDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->bytes.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // chrome::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_COMMON_TRUSTED_VAULT_ENCRYPTION_KEYS_EXTENSION_MOJOM_SHARED_H_