// chrome/common/supervised_user_commands.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/supervised_user_commands.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/supervised_user_commands.mojom-params-data.h"
#include "chrome/common/supervised_user_commands.mojom-shared-message-ids.h"

#include "chrome/common/supervised_user_commands.mojom-import-headers.h"
#include "chrome/common/supervised_user_commands.mojom-test-utils.h"


namespace supervised_user::mojom {
// The declaration includes the definition on other builds.

SupervisedUserCommands::IPCStableHashFunction SupervisedUserCommands::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SupervisedUserCommands>(message.name())) {
    case messages::SupervisedUserCommands::kGoBack: {
      return &SupervisedUserCommands::GoBack_Sym::IPCStableHash;
    }
    case messages::SupervisedUserCommands::kRequestUrlAccessRemote: {
      return &SupervisedUserCommands::RequestUrlAccessRemote_Sym::IPCStableHash;
    }
    case messages::SupervisedUserCommands::kRequestUrlAccessLocal: {
      return &SupervisedUserCommands::RequestUrlAccessLocal_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SupervisedUserCommands::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SupervisedUserCommands>(message.name())) {
      case messages::SupervisedUserCommands::kGoBack:
            return "Receive supervised_user::mojom::SupervisedUserCommands::GoBack";
      case messages::SupervisedUserCommands::kRequestUrlAccessRemote:
            return "Receive supervised_user::mojom::SupervisedUserCommands::RequestUrlAccessRemote";
      case messages::SupervisedUserCommands::kRequestUrlAccessLocal:
            return "Receive supervised_user::mojom::SupervisedUserCommands::RequestUrlAccessLocal";
    }
  } else {
    switch (static_cast<messages::SupervisedUserCommands>(message.name())) {
      case messages::SupervisedUserCommands::kGoBack:
            return "Receive reply supervised_user::mojom::SupervisedUserCommands::GoBack";
      case messages::SupervisedUserCommands::kRequestUrlAccessRemote:
            return "Receive reply supervised_user::mojom::SupervisedUserCommands::RequestUrlAccessRemote";
      case messages::SupervisedUserCommands::kRequestUrlAccessLocal:
            return "Receive reply supervised_user::mojom::SupervisedUserCommands::RequestUrlAccessLocal";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SupervisedUserCommands::GoBack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8eff67e;  // IPCStableHash for supervised_user::mojom::SupervisedUserCommands::GoBack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SupervisedUserCommands::RequestUrlAccessRemote_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e64c685;  // IPCStableHash for supervised_user::mojom::SupervisedUserCommands::RequestUrlAccessRemote
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SupervisedUserCommands::RequestUrlAccessLocal_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4341e066;  // IPCStableHash for supervised_user::mojom::SupervisedUserCommands::RequestUrlAccessLocal
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SupervisedUserCommands_RequestUrlAccessRemote_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SupervisedUserCommands_RequestUrlAccessRemote_ForwardToCallback(
      SupervisedUserCommands::RequestUrlAccessRemoteCallback callback
      ) : callback_(std::move(callback)) {
  }

  SupervisedUserCommands_RequestUrlAccessRemote_ForwardToCallback(const SupervisedUserCommands_RequestUrlAccessRemote_ForwardToCallback&) = delete;
  SupervisedUserCommands_RequestUrlAccessRemote_ForwardToCallback& operator=(const SupervisedUserCommands_RequestUrlAccessRemote_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SupervisedUserCommands::RequestUrlAccessRemoteCallback callback_;
};

class SupervisedUserCommands_RequestUrlAccessLocal_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SupervisedUserCommands_RequestUrlAccessLocal_ForwardToCallback(
      SupervisedUserCommands::RequestUrlAccessLocalCallback callback
      ) : callback_(std::move(callback)) {
  }

  SupervisedUserCommands_RequestUrlAccessLocal_ForwardToCallback(const SupervisedUserCommands_RequestUrlAccessLocal_ForwardToCallback&) = delete;
  SupervisedUserCommands_RequestUrlAccessLocal_ForwardToCallback& operator=(const SupervisedUserCommands_RequestUrlAccessLocal_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SupervisedUserCommands::RequestUrlAccessLocalCallback callback_;
};

SupervisedUserCommandsProxy::SupervisedUserCommandsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SupervisedUserCommandsProxy::GoBack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send supervised_user::mojom::SupervisedUserCommands::GoBack");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SupervisedUserCommands::kGoBack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::supervised_user::mojom::internal::SupervisedUserCommands_GoBack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SupervisedUserCommands::Name_);
  message.set_method_name("GoBack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SupervisedUserCommandsProxy::RequestUrlAccessRemote(
    RequestUrlAccessRemoteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send supervised_user::mojom::SupervisedUserCommands::RequestUrlAccessRemote");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SupervisedUserCommands::kRequestUrlAccessRemote), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::supervised_user::mojom::internal::SupervisedUserCommands_RequestUrlAccessRemote_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SupervisedUserCommands::Name_);
  message.set_method_name("RequestUrlAccessRemote");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SupervisedUserCommands_RequestUrlAccessRemote_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SupervisedUserCommandsProxy::RequestUrlAccessLocal(
    RequestUrlAccessLocalCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send supervised_user::mojom::SupervisedUserCommands::RequestUrlAccessLocal");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SupervisedUserCommands::kRequestUrlAccessLocal), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::supervised_user::mojom::internal::SupervisedUserCommands_RequestUrlAccessLocal_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SupervisedUserCommands::Name_);
  message.set_method_name("RequestUrlAccessLocal");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SupervisedUserCommands_RequestUrlAccessLocal_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SupervisedUserCommands_RequestUrlAccessRemote_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SupervisedUserCommands::RequestUrlAccessRemoteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SupervisedUserCommands_RequestUrlAccessRemote_ProxyToResponder> proxy(
        new SupervisedUserCommands_RequestUrlAccessRemote_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SupervisedUserCommands_RequestUrlAccessRemote_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SupervisedUserCommands_RequestUrlAccessRemote_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SupervisedUserCommands_RequestUrlAccessRemote_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SupervisedUserCommands::RequestUrlAccessRemoteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_request_issued);
};

bool SupervisedUserCommands_RequestUrlAccessRemote_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SupervisedUserCommands_RequestUrlAccessRemote_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SupervisedUserCommands_RequestUrlAccessRemote_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SupervisedUserCommands.1
  bool success = true;
  bool p_request_issued{};
  SupervisedUserCommands_RequestUrlAccessRemote_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_request_issued = input_data_view.request_issued();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SupervisedUserCommands::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_request_issued));
  }
  return true;
}

void SupervisedUserCommands_RequestUrlAccessRemote_ProxyToResponder::Run(
    bool in_request_issued) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply supervised_user::mojom::SupervisedUserCommands::RequestUrlAccessRemote", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_issued"), in_request_issued,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SupervisedUserCommands::kRequestUrlAccessRemote), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::supervised_user::mojom::internal::SupervisedUserCommands_RequestUrlAccessRemote_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->request_issued = in_request_issued;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SupervisedUserCommands::Name_);
  message.set_method_name("RequestUrlAccessRemote");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SupervisedUserCommands_RequestUrlAccessLocal_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SupervisedUserCommands::RequestUrlAccessLocalCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SupervisedUserCommands_RequestUrlAccessLocal_ProxyToResponder> proxy(
        new SupervisedUserCommands_RequestUrlAccessLocal_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SupervisedUserCommands_RequestUrlAccessLocal_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SupervisedUserCommands_RequestUrlAccessLocal_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SupervisedUserCommands_RequestUrlAccessLocal_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SupervisedUserCommands::RequestUrlAccessLocalCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_request_issued);
};

bool SupervisedUserCommands_RequestUrlAccessLocal_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SupervisedUserCommands_RequestUrlAccessLocal_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SupervisedUserCommands_RequestUrlAccessLocal_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SupervisedUserCommands.2
  bool success = true;
  bool p_request_issued{};
  SupervisedUserCommands_RequestUrlAccessLocal_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_request_issued = input_data_view.request_issued();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SupervisedUserCommands::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_request_issued));
  }
  return true;
}

void SupervisedUserCommands_RequestUrlAccessLocal_ProxyToResponder::Run(
    bool in_request_issued) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply supervised_user::mojom::SupervisedUserCommands::RequestUrlAccessLocal", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_issued"), in_request_issued,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SupervisedUserCommands::kRequestUrlAccessLocal), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::supervised_user::mojom::internal::SupervisedUserCommands_RequestUrlAccessLocal_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->request_issued = in_request_issued;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SupervisedUserCommands::Name_);
  message.set_method_name("RequestUrlAccessLocal");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SupervisedUserCommandsStubDispatch::Accept(
    SupervisedUserCommands* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SupervisedUserCommands>(message->header()->name)) {
    case messages::SupervisedUserCommands::kGoBack: {
      DCHECK(message->is_serialized());
      internal::SupervisedUserCommands_GoBack_Params_Data* params =
          reinterpret_cast<internal::SupervisedUserCommands_GoBack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SupervisedUserCommands.0
      bool success = true;
      SupervisedUserCommands_GoBack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SupervisedUserCommands::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GoBack(        );
      return true;
    }
    case messages::SupervisedUserCommands::kRequestUrlAccessRemote: {
      break;
    }
    case messages::SupervisedUserCommands::kRequestUrlAccessLocal: {
      break;
    }
  }
  return false;
}

// static
bool SupervisedUserCommandsStubDispatch::AcceptWithResponder(
    SupervisedUserCommands* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SupervisedUserCommands>(message->header()->name)) {
    case messages::SupervisedUserCommands::kGoBack: {
      break;
    }
    case messages::SupervisedUserCommands::kRequestUrlAccessRemote: {
      internal::SupervisedUserCommands_RequestUrlAccessRemote_Params_Data* params =
          reinterpret_cast<
              internal::SupervisedUserCommands_RequestUrlAccessRemote_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SupervisedUserCommands.1
      bool success = true;
      SupervisedUserCommands_RequestUrlAccessRemote_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SupervisedUserCommands::Name_, 1, false);
        return false;
      }
      auto callback =
          SupervisedUserCommands_RequestUrlAccessRemote_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestUrlAccessRemote(std::move(callback));
      return true;
    }
    case messages::SupervisedUserCommands::kRequestUrlAccessLocal: {
      internal::SupervisedUserCommands_RequestUrlAccessLocal_Params_Data* params =
          reinterpret_cast<
              internal::SupervisedUserCommands_RequestUrlAccessLocal_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SupervisedUserCommands.2
      bool success = true;
      SupervisedUserCommands_RequestUrlAccessLocal_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SupervisedUserCommands::Name_, 2, false);
        return false;
      }
      auto callback =
          SupervisedUserCommands_RequestUrlAccessLocal_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestUrlAccessLocal(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSupervisedUserCommandsValidationInfo[] = {
    { &internal::SupervisedUserCommands_GoBack_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SupervisedUserCommands_RequestUrlAccessRemote_Params_Data::Validate,
     &internal::SupervisedUserCommands_RequestUrlAccessRemote_ResponseParams_Data::Validate},
    { &internal::SupervisedUserCommands_RequestUrlAccessLocal_Params_Data::Validate,
     &internal::SupervisedUserCommands_RequestUrlAccessLocal_ResponseParams_Data::Validate},
};

bool SupervisedUserCommandsRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::supervised_user::mojom::SupervisedUserCommands::Name_,
    kSupervisedUserCommandsValidationInfo);
}

bool SupervisedUserCommandsResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::supervised_user::mojom::SupervisedUserCommands::Name_,
    kSupervisedUserCommandsValidationInfo);
}


}  // supervised_user::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace supervised_user::mojom {


void SupervisedUserCommandsInterceptorForTesting::GoBack() {
  GetForwardingInterface()->GoBack();
}
void SupervisedUserCommandsInterceptorForTesting::RequestUrlAccessRemote(RequestUrlAccessRemoteCallback callback) {
  GetForwardingInterface()->RequestUrlAccessRemote(std::move(callback));
}
void SupervisedUserCommandsInterceptorForTesting::RequestUrlAccessLocal(RequestUrlAccessLocalCallback callback) {
  GetForwardingInterface()->RequestUrlAccessLocal(std::move(callback));
}
SupervisedUserCommandsAsyncWaiter::SupervisedUserCommandsAsyncWaiter(
    SupervisedUserCommands* proxy) : proxy_(proxy) {}

SupervisedUserCommandsAsyncWaiter::~SupervisedUserCommandsAsyncWaiter() = default;


void SupervisedUserCommandsAsyncWaiter::RequestUrlAccessRemote(
    bool* out_request_issued) {
  base::RunLoop loop;
  proxy_->RequestUrlAccessRemote(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_request_issued
,
             bool request_issued) {*out_request_issued = std::move(request_issued);
            loop->Quit();
          },
          &loop,
          out_request_issued));
  loop.Run();
}

bool SupervisedUserCommandsAsyncWaiter::RequestUrlAccessRemote(
    ) {
  bool async_wait_result;
  RequestUrlAccessRemote(&async_wait_result);
  return async_wait_result;
}

void SupervisedUserCommandsAsyncWaiter::RequestUrlAccessLocal(
    bool* out_request_issued) {
  base::RunLoop loop;
  proxy_->RequestUrlAccessLocal(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_request_issued
,
             bool request_issued) {*out_request_issued = std::move(request_issued);
            loop->Quit();
          },
          &loop,
          out_request_issued));
  loop.Run();
}

bool SupervisedUserCommandsAsyncWaiter::RequestUrlAccessLocal(
    ) {
  bool async_wait_result;
  RequestUrlAccessLocal(&async_wait_result);
  return async_wait_result;
}






}  // supervised_user::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif