// chrome/common/search/search.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_SEARCH_SEARCH_MOJOM_H_
#define CHROME_COMMON_SEARCH_SEARCH_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/search/search.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/search/search.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/search/search.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "chrome/common/search/instant_types.h"
#include "chrome/common/search/ntp_logging_events.h"
#include "components/omnibox/common/omnibox_focus_state.h"




namespace search::mojom {

class EmbeddedSearchConnectorProxy;

template <typename ImplRefTraits>
class EmbeddedSearchConnectorStub;

class EmbeddedSearchConnectorRequestValidator;


class EmbeddedSearchConnector
    : public EmbeddedSearchConnectorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "search.mojom.EmbeddedSearchConnector";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = EmbeddedSearchConnectorInterfaceBase;
  using Proxy_ = EmbeddedSearchConnectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = EmbeddedSearchConnectorStub<ImplRefTraits>;

  using RequestValidator_ = EmbeddedSearchConnectorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kConnectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Connect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~EmbeddedSearchConnector() = default;

  virtual void Connect(::mojo::PendingAssociatedReceiver<EmbeddedSearch> embedded_search, ::mojo::PendingAssociatedRemote<EmbeddedSearchClient> client) = 0;
};

class EmbeddedSearchProxy;

template <typename ImplRefTraits>
class EmbeddedSearchStub;

class EmbeddedSearchRequestValidator;


class EmbeddedSearch
    : public EmbeddedSearchInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "search.mojom.EmbeddedSearch";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = EmbeddedSearchInterfaceBase;
  using Proxy_ = EmbeddedSearchProxy;

  template <typename ImplRefTraits>
  using Stub_ = EmbeddedSearchStub<ImplRefTraits>;

  using RequestValidator_ = EmbeddedSearchRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kFocusOmniboxMinVersion = 0,
    kDeleteMostVisitedItemMinVersion = 0,
    kUndoAllMostVisitedDeletionsMinVersion = 0,
    kUndoMostVisitedDeletionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FocusOmnibox_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteMostVisitedItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UndoAllMostVisitedDeletions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UndoMostVisitedDeletion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~EmbeddedSearch() = default;

  virtual void FocusOmnibox(int32_t page_seq_no, bool focus) = 0;

  virtual void DeleteMostVisitedItem(int32_t page_seq_no, const ::GURL& url) = 0;

  virtual void UndoAllMostVisitedDeletions(int32_t page_seq_no) = 0;

  virtual void UndoMostVisitedDeletion(int32_t page_seq_no, const ::GURL& url) = 0;
};

class EmbeddedSearchClientProxy;

template <typename ImplRefTraits>
class EmbeddedSearchClientStub;

class EmbeddedSearchClientRequestValidator;


class EmbeddedSearchClient
    : public EmbeddedSearchClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "search.mojom.EmbeddedSearchClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = EmbeddedSearchClientInterfaceBase;
  using Proxy_ = EmbeddedSearchClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = EmbeddedSearchClientStub<ImplRefTraits>;

  using RequestValidator_ = EmbeddedSearchClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetPageSequenceNumberMinVersion = 0,
    kFocusChangedMinVersion = 0,
    kMostVisitedInfoChangedMinVersion = 0,
    kSetInputInProgressMinVersion = 0,
    kThemeChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetPageSequenceNumber_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FocusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MostVisitedInfoChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetInputInProgress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ThemeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~EmbeddedSearchClient() = default;

  virtual void SetPageSequenceNumber(int32_t page_seq_no) = 0;

  virtual void FocusChanged(::OmniboxFocusState new_focus_state, ::OmniboxFocusChangeReason reason) = 0;

  virtual void MostVisitedInfoChanged(const ::InstantMostVisitedInfo& most_visited_info) = 0;

  virtual void SetInputInProgress(bool input_in_progress) = 0;

  virtual void ThemeChanged(const ::NtpTheme& theme) = 0;
};



class  EmbeddedSearchConnectorProxy
    : public EmbeddedSearchConnector {
 public:
  using InterfaceType = EmbeddedSearchConnector;

  explicit EmbeddedSearchConnectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Connect(::mojo::PendingAssociatedReceiver<EmbeddedSearch> embedded_search, ::mojo::PendingAssociatedRemote<EmbeddedSearchClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  EmbeddedSearchProxy
    : public EmbeddedSearch {
 public:
  using InterfaceType = EmbeddedSearch;

  explicit EmbeddedSearchProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FocusOmnibox(int32_t page_seq_no, bool focus) final;
  
  void DeleteMostVisitedItem(int32_t page_seq_no, const ::GURL& url) final;
  
  void UndoAllMostVisitedDeletions(int32_t page_seq_no) final;
  
  void UndoMostVisitedDeletion(int32_t page_seq_no, const ::GURL& url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  EmbeddedSearchClientProxy
    : public EmbeddedSearchClient {
 public:
  using InterfaceType = EmbeddedSearchClient;

  explicit EmbeddedSearchClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetPageSequenceNumber(int32_t page_seq_no) final;
  
  void FocusChanged(::OmniboxFocusState new_focus_state, ::OmniboxFocusChangeReason reason) final;
  
  void MostVisitedInfoChanged(const ::InstantMostVisitedInfo& most_visited_info) final;
  
  void SetInputInProgress(bool input_in_progress) final;
  
  void ThemeChanged(const ::NtpTheme& theme) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  EmbeddedSearchConnectorStubDispatch {
 public:
  static bool Accept(EmbeddedSearchConnector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EmbeddedSearchConnector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EmbeddedSearchConnector>>
class EmbeddedSearchConnectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EmbeddedSearchConnectorStub() = default;
  ~EmbeddedSearchConnectorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedSearchConnectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedSearchConnectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  EmbeddedSearchStubDispatch {
 public:
  static bool Accept(EmbeddedSearch* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EmbeddedSearch* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EmbeddedSearch>>
class EmbeddedSearchStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EmbeddedSearchStub() = default;
  ~EmbeddedSearchStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedSearchStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedSearchStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  EmbeddedSearchClientStubDispatch {
 public:
  static bool Accept(EmbeddedSearchClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EmbeddedSearchClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EmbeddedSearchClient>>
class EmbeddedSearchClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EmbeddedSearchClientStub() = default;
  ~EmbeddedSearchClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedSearchClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedSearchClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  EmbeddedSearchConnectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  EmbeddedSearchRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  EmbeddedSearchClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









}  // search::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_COMMON_SEARCH_SEARCH_MOJOM_H_