// chrome/common/search/search.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_SEARCH_SEARCH_MOJOM_PARAMS_DATA_H_
#define CHROME_COMMON_SEARCH_SEARCH_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace search::mojom {
namespace internal {
class  EmbeddedSearchConnector_Connect_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedEndpointHandle_Data embedded_search;
  mojo::internal::AssociatedInterface_Data client;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<EmbeddedSearchConnector_Connect_Params_Data>;

  EmbeddedSearchConnector_Connect_Params_Data();
  ~EmbeddedSearchConnector_Connect_Params_Data() = delete;
};
static_assert(sizeof(EmbeddedSearchConnector_Connect_Params_Data) == 24,
              "Bad sizeof(EmbeddedSearchConnector_Connect_Params_Data)");
class  EmbeddedSearch_FocusOmnibox_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t page_seq_no;
  uint8_t focus : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<EmbeddedSearch_FocusOmnibox_Params_Data>;

  EmbeddedSearch_FocusOmnibox_Params_Data();
  ~EmbeddedSearch_FocusOmnibox_Params_Data() = delete;
};
static_assert(sizeof(EmbeddedSearch_FocusOmnibox_Params_Data) == 16,
              "Bad sizeof(EmbeddedSearch_FocusOmnibox_Params_Data)");
class  EmbeddedSearch_DeleteMostVisitedItem_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t page_seq_no;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  friend class mojo::internal::MessageFragment<EmbeddedSearch_DeleteMostVisitedItem_Params_Data>;

  EmbeddedSearch_DeleteMostVisitedItem_Params_Data();
  ~EmbeddedSearch_DeleteMostVisitedItem_Params_Data() = delete;
};
static_assert(sizeof(EmbeddedSearch_DeleteMostVisitedItem_Params_Data) == 24,
              "Bad sizeof(EmbeddedSearch_DeleteMostVisitedItem_Params_Data)");
class  EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t page_seq_no;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data>;

  EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data();
  ~EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data() = delete;
};
static_assert(sizeof(EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data) == 16,
              "Bad sizeof(EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data)");
class  EmbeddedSearch_UndoMostVisitedDeletion_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t page_seq_no;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  friend class mojo::internal::MessageFragment<EmbeddedSearch_UndoMostVisitedDeletion_Params_Data>;

  EmbeddedSearch_UndoMostVisitedDeletion_Params_Data();
  ~EmbeddedSearch_UndoMostVisitedDeletion_Params_Data() = delete;
};
static_assert(sizeof(EmbeddedSearch_UndoMostVisitedDeletion_Params_Data) == 24,
              "Bad sizeof(EmbeddedSearch_UndoMostVisitedDeletion_Params_Data)");
class  EmbeddedSearchClient_SetPageSequenceNumber_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t page_seq_no;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<EmbeddedSearchClient_SetPageSequenceNumber_Params_Data>;

  EmbeddedSearchClient_SetPageSequenceNumber_Params_Data();
  ~EmbeddedSearchClient_SetPageSequenceNumber_Params_Data() = delete;
};
static_assert(sizeof(EmbeddedSearchClient_SetPageSequenceNumber_Params_Data) == 16,
              "Bad sizeof(EmbeddedSearchClient_SetPageSequenceNumber_Params_Data)");
class  EmbeddedSearchClient_FocusChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t new_focus_state;
  int32_t reason;

 private:
  friend class mojo::internal::MessageFragment<EmbeddedSearchClient_FocusChanged_Params_Data>;

  EmbeddedSearchClient_FocusChanged_Params_Data();
  ~EmbeddedSearchClient_FocusChanged_Params_Data() = delete;
};
static_assert(sizeof(EmbeddedSearchClient_FocusChanged_Params_Data) == 16,
              "Bad sizeof(EmbeddedSearchClient_FocusChanged_Params_Data)");
class  EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::InstantMostVisitedInfo_Data> most_visited_info;

 private:
  friend class mojo::internal::MessageFragment<EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data>;

  EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data();
  ~EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data() = delete;
};
static_assert(sizeof(EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data) == 16,
              "Bad sizeof(EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data)");
class  EmbeddedSearchClient_SetInputInProgress_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t input_in_progress : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<EmbeddedSearchClient_SetInputInProgress_Params_Data>;

  EmbeddedSearchClient_SetInputInProgress_Params_Data();
  ~EmbeddedSearchClient_SetInputInProgress_Params_Data() = delete;
};
static_assert(sizeof(EmbeddedSearchClient_SetInputInProgress_Params_Data) == 16,
              "Bad sizeof(EmbeddedSearchClient_SetInputInProgress_Params_Data)");
class  EmbeddedSearchClient_ThemeChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::NtpTheme_Data> theme;

 private:
  friend class mojo::internal::MessageFragment<EmbeddedSearchClient_ThemeChanged_Params_Data>;

  EmbeddedSearchClient_ThemeChanged_Params_Data();
  ~EmbeddedSearchClient_ThemeChanged_Params_Data() = delete;
};
static_assert(sizeof(EmbeddedSearchClient_ThemeChanged_Params_Data) == 16,
              "Bad sizeof(EmbeddedSearchClient_ThemeChanged_Params_Data)");

}  // namespace internal


class EmbeddedSearchConnector_Connect_ParamsDataView {
 public:
  EmbeddedSearchConnector_Connect_ParamsDataView() = default;

  EmbeddedSearchConnector_Connect_ParamsDataView(
      internal::EmbeddedSearchConnector_Connect_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeEmbeddedSearch() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::search::mojom::EmbeddedSearchAssociatedRequestDataView>(
            &data_->embedded_search, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::search::mojom::EmbeddedSearchClientAssociatedPtrInfoDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::EmbeddedSearchConnector_Connect_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EmbeddedSearch_FocusOmnibox_ParamsDataView {
 public:
  EmbeddedSearch_FocusOmnibox_ParamsDataView() = default;

  EmbeddedSearch_FocusOmnibox_ParamsDataView(
      internal::EmbeddedSearch_FocusOmnibox_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t page_seq_no() const {
    return data_->page_seq_no;
  }
  bool focus() const {
    return data_->focus;
  }
 private:
  internal::EmbeddedSearch_FocusOmnibox_Params_Data* data_ = nullptr;
};


class EmbeddedSearch_DeleteMostVisitedItem_ParamsDataView {
 public:
  EmbeddedSearch_DeleteMostVisitedItem_ParamsDataView() = default;

  EmbeddedSearch_DeleteMostVisitedItem_ParamsDataView(
      internal::EmbeddedSearch_DeleteMostVisitedItem_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t page_seq_no() const {
    return data_->page_seq_no;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::EmbeddedSearch_DeleteMostVisitedItem_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EmbeddedSearch_UndoAllMostVisitedDeletions_ParamsDataView {
 public:
  EmbeddedSearch_UndoAllMostVisitedDeletions_ParamsDataView() = default;

  EmbeddedSearch_UndoAllMostVisitedDeletions_ParamsDataView(
      internal::EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t page_seq_no() const {
    return data_->page_seq_no;
  }
 private:
  internal::EmbeddedSearch_UndoAllMostVisitedDeletions_Params_Data* data_ = nullptr;
};


class EmbeddedSearch_UndoMostVisitedDeletion_ParamsDataView {
 public:
  EmbeddedSearch_UndoMostVisitedDeletion_ParamsDataView() = default;

  EmbeddedSearch_UndoMostVisitedDeletion_ParamsDataView(
      internal::EmbeddedSearch_UndoMostVisitedDeletion_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t page_seq_no() const {
    return data_->page_seq_no;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::EmbeddedSearch_UndoMostVisitedDeletion_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EmbeddedSearchClient_SetPageSequenceNumber_ParamsDataView {
 public:
  EmbeddedSearchClient_SetPageSequenceNumber_ParamsDataView() = default;

  EmbeddedSearchClient_SetPageSequenceNumber_ParamsDataView(
      internal::EmbeddedSearchClient_SetPageSequenceNumber_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t page_seq_no() const {
    return data_->page_seq_no;
  }
 private:
  internal::EmbeddedSearchClient_SetPageSequenceNumber_Params_Data* data_ = nullptr;
};


class EmbeddedSearchClient_FocusChanged_ParamsDataView {
 public:
  EmbeddedSearchClient_FocusChanged_ParamsDataView() = default;

  EmbeddedSearchClient_FocusChanged_ParamsDataView(
      internal::EmbeddedSearchClient_FocusChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadNewFocusState(UserType* output) const {
    auto data_value = data_->new_focus_state;
    return mojo::internal::Deserialize<::search::mojom::OmniboxFocusState>(
        data_value, output);
  }
  OmniboxFocusState new_focus_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::search::mojom::OmniboxFocusState>(data_->new_focus_state));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::search::mojom::OmniboxFocusChangeReason>(
        data_value, output);
  }
  OmniboxFocusChangeReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::search::mojom::OmniboxFocusChangeReason>(data_->reason));
  }
 private:
  internal::EmbeddedSearchClient_FocusChanged_Params_Data* data_ = nullptr;
};


class EmbeddedSearchClient_MostVisitedInfoChanged_ParamsDataView {
 public:
  EmbeddedSearchClient_MostVisitedInfoChanged_ParamsDataView() = default;

  EmbeddedSearchClient_MostVisitedInfoChanged_ParamsDataView(
      internal::EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMostVisitedInfoDataView(
      InstantMostVisitedInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMostVisitedInfo(UserType* output) {
    
    auto* pointer = data_->most_visited_info.Get();
    return mojo::internal::Deserialize<::search::mojom::InstantMostVisitedInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::EmbeddedSearchClient_MostVisitedInfoChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EmbeddedSearchClient_SetInputInProgress_ParamsDataView {
 public:
  EmbeddedSearchClient_SetInputInProgress_ParamsDataView() = default;

  EmbeddedSearchClient_SetInputInProgress_ParamsDataView(
      internal::EmbeddedSearchClient_SetInputInProgress_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool input_in_progress() const {
    return data_->input_in_progress;
  }
 private:
  internal::EmbeddedSearchClient_SetInputInProgress_Params_Data* data_ = nullptr;
};


class EmbeddedSearchClient_ThemeChanged_ParamsDataView {
 public:
  EmbeddedSearchClient_ThemeChanged_ParamsDataView() = default;

  EmbeddedSearchClient_ThemeChanged_ParamsDataView(
      internal::EmbeddedSearchClient_ThemeChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetThemeDataView(
      NtpThemeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTheme(UserType* output) {
    
    auto* pointer = data_->theme.Get();
    return mojo::internal::Deserialize<::search::mojom::NtpThemeDataView>(
        pointer, output, message_);
  }
 private:
  internal::EmbeddedSearchClient_ThemeChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};





inline void EmbeddedSearch_DeleteMostVisitedItem_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}




inline void EmbeddedSearch_UndoMostVisitedDeletion_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}






inline void EmbeddedSearchClient_MostVisitedInfoChanged_ParamsDataView::GetMostVisitedInfoDataView(
    InstantMostVisitedInfoDataView* output) {
  auto pointer = data_->most_visited_info.Get();
  *output = InstantMostVisitedInfoDataView(pointer, message_);
}




inline void EmbeddedSearchClient_ThemeChanged_ParamsDataView::GetThemeDataView(
    NtpThemeDataView* output) {
  auto pointer = data_->theme.Get();
  *output = NtpThemeDataView(pointer, message_);
}



}  // search::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_COMMON_SEARCH_SEARCH_MOJOM_PARAMS_DATA_H_