// chrome/common/renderer_configuration.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_H_
#define CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/renderer_configuration.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/renderer_configuration.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/renderer_configuration.mojom-forward.h"  // IWYU pragma: export
#include "components/content_settings/common/content_settings_manager.mojom-forward.h"
#include "components/content_settings/core/common/content_settings.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class BoundSessionRequestThrottledHandlerProxy;

template <typename ImplRefTraits>
class BoundSessionRequestThrottledHandlerStub;

class BoundSessionRequestThrottledHandlerRequestValidator;
class BoundSessionRequestThrottledHandlerResponseValidator;


class BoundSessionRequestThrottledHandler
    : public BoundSessionRequestThrottledHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.BoundSessionRequestThrottledHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BoundSessionRequestThrottledHandlerInterfaceBase;
  using Proxy_ = BoundSessionRequestThrottledHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = BoundSessionRequestThrottledHandlerStub<ImplRefTraits>;

  using RequestValidator_ = BoundSessionRequestThrottledHandlerRequestValidator;
  using ResponseValidator_ = BoundSessionRequestThrottledHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kHandleRequestBlockedOnCookieMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct HandleRequestBlockedOnCookie_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BoundSessionRequestThrottledHandler() = default;

  using HandleRequestBlockedOnCookieCallback = base::OnceCallback<void(ResumeBlockedRequestsTrigger)>;
  using HandleRequestBlockedOnCookieMojoCallback = base::OnceCallback<void(ResumeBlockedRequestsTrigger)>;

  virtual void HandleRequestBlockedOnCookie(const ::GURL& untrusted_request_url, HandleRequestBlockedOnCookieCallback callback) = 0;
};

class ChromeOSListenerProxy;

template <typename ImplRefTraits>
class ChromeOSListenerStub;

class ChromeOSListenerRequestValidator;


class ChromeOSListener
    : public ChromeOSListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.ChromeOSListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChromeOSListenerInterfaceBase;
  using Proxy_ = ChromeOSListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChromeOSListenerStub<ImplRefTraits>;

  using RequestValidator_ = ChromeOSListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ChromeOSListener() = default;
};

class RendererConfigurationProxy;

template <typename ImplRefTraits>
class RendererConfigurationStub;

class RendererConfigurationRequestValidator;


class RendererConfiguration
    : public RendererConfigurationInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.RendererConfiguration";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererConfigurationInterfaceBase;
  using Proxy_ = RendererConfigurationProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererConfigurationStub<ImplRefTraits>;

  using RequestValidator_ = RendererConfigurationRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetInitialConfigurationMinVersion = 0,
    kSetConfigurationMinVersion = 0,
    kSetConfigurationOnProcessLockUpdateMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetInitialConfiguration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetConfiguration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetConfigurationOnProcessLockUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RendererConfiguration() = default;

  virtual void SetInitialConfiguration(bool is_incognito_process, ::mojo::PendingReceiver<ChromeOSListener> chromeos_listener, ::mojo::PendingRemote<::content_settings::mojom::ContentSettingsManager> content_settings_manager, ::mojo::PendingRemote<BoundSessionRequestThrottledHandler> bound_session_request_throttled_handler) = 0;

  virtual void SetConfiguration(DynamicParamsPtr params) = 0;

  virtual void SetConfigurationOnProcessLockUpdate(StaticParamsPtr params) = 0;
};



class  BoundSessionRequestThrottledHandlerProxy
    : public BoundSessionRequestThrottledHandler {
 public:
  using InterfaceType = BoundSessionRequestThrottledHandler;

  explicit BoundSessionRequestThrottledHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void HandleRequestBlockedOnCookie(const ::GURL& untrusted_request_url, HandleRequestBlockedOnCookieCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ChromeOSListenerProxy
    : public ChromeOSListener {
 public:
  using InterfaceType = ChromeOSListener;

  explicit ChromeOSListenerProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  RendererConfigurationProxy
    : public RendererConfiguration {
 public:
  using InterfaceType = RendererConfiguration;

  explicit RendererConfigurationProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetInitialConfiguration(bool is_incognito_process, ::mojo::PendingReceiver<ChromeOSListener> chromeos_listener, ::mojo::PendingRemote<::content_settings::mojom::ContentSettingsManager> content_settings_manager, ::mojo::PendingRemote<BoundSessionRequestThrottledHandler> bound_session_request_throttled_handler) final;
  
  void SetConfiguration(DynamicParamsPtr params) final;
  
  void SetConfigurationOnProcessLockUpdate(StaticParamsPtr params) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  BoundSessionRequestThrottledHandlerStubDispatch {
 public:
  static bool Accept(BoundSessionRequestThrottledHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BoundSessionRequestThrottledHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BoundSessionRequestThrottledHandler>>
class BoundSessionRequestThrottledHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BoundSessionRequestThrottledHandlerStub() = default;
  ~BoundSessionRequestThrottledHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BoundSessionRequestThrottledHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BoundSessionRequestThrottledHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ChromeOSListenerStubDispatch {
 public:
  static bool Accept(ChromeOSListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChromeOSListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChromeOSListener>>
class ChromeOSListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChromeOSListenerStub() = default;
  ~ChromeOSListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChromeOSListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChromeOSListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RendererConfigurationStubDispatch {
 public:
  static bool Accept(RendererConfiguration* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererConfiguration* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererConfiguration>>
class RendererConfigurationStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererConfigurationStub() = default;
  ~RendererConfigurationStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererConfigurationStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererConfigurationStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BoundSessionRequestThrottledHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ChromeOSListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RendererConfigurationRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BoundSessionRequestThrottledHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class  StaticParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StaticParams, T>::value>;
  using DataView = StaticParamsDataView;
  using Data_ = internal::StaticParams_Data;

  template <typename... Args>
  static StaticParamsPtr New(Args&&... args) {
    return StaticParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StaticParamsPtr From(const U& u) {
    return mojo::TypeConverter<StaticParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StaticParams>::Convert(*this);
  }


  StaticParams();

  explicit StaticParams(
      bool is_instant_process);


  ~StaticParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StaticParamsPtr>
  StaticParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StaticParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StaticParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StaticParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StaticParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StaticParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StaticParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StaticParams_UnserializedMessageContext<
            UserType, StaticParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StaticParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StaticParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StaticParams_UnserializedMessageContext<
            UserType, StaticParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StaticParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_instant_process;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StaticParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StaticParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StaticParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StaticParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  BoundSessionThrottlerParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BoundSessionThrottlerParams, T>::value>;
  using DataView = BoundSessionThrottlerParamsDataView;
  using Data_ = internal::BoundSessionThrottlerParams_Data;

  template <typename... Args>
  static BoundSessionThrottlerParamsPtr New(Args&&... args) {
    return BoundSessionThrottlerParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BoundSessionThrottlerParamsPtr From(const U& u) {
    return mojo::TypeConverter<BoundSessionThrottlerParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BoundSessionThrottlerParams>::Convert(*this);
  }


  BoundSessionThrottlerParams();

  BoundSessionThrottlerParams(
      const std::string& domain,
      const std::string& path,
      ::base::Time cookie_expiry_date);


  ~BoundSessionThrottlerParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BoundSessionThrottlerParamsPtr>
  BoundSessionThrottlerParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BoundSessionThrottlerParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BoundSessionThrottlerParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BoundSessionThrottlerParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BoundSessionThrottlerParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BoundSessionThrottlerParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BoundSessionThrottlerParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BoundSessionThrottlerParams_UnserializedMessageContext<
            UserType, BoundSessionThrottlerParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BoundSessionThrottlerParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BoundSessionThrottlerParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BoundSessionThrottlerParams_UnserializedMessageContext<
            UserType, BoundSessionThrottlerParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BoundSessionThrottlerParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string domain;
  
  std::string path;
  
  ::base::Time cookie_expiry_date;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BoundSessionThrottlerParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BoundSessionThrottlerParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BoundSessionThrottlerParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BoundSessionThrottlerParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DynamicParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DynamicParams, T>::value>;
  using DataView = DynamicParamsDataView;
  using Data_ = internal::DynamicParams_Data;

  template <typename... Args>
  static DynamicParamsPtr New(Args&&... args) {
    return DynamicParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DynamicParamsPtr From(const U& u) {
    return mojo::TypeConverter<DynamicParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DynamicParams>::Convert(*this);
  }


  DynamicParams();

  DynamicParams(
      std::vector<BoundSessionThrottlerParamsPtr> bound_session_throttler_params,
      bool force_safe_search,
      int32_t youtube_restrict,
      const std::string& allowed_domains_for_apps);

DynamicParams(const DynamicParams&) = delete;
DynamicParams& operator=(const DynamicParams&) = delete;

  ~DynamicParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DynamicParamsPtr>
  DynamicParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DynamicParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DynamicParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DynamicParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DynamicParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DynamicParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DynamicParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DynamicParams_UnserializedMessageContext<
            UserType, DynamicParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DynamicParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DynamicParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DynamicParams_UnserializedMessageContext<
            UserType, DynamicParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DynamicParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<BoundSessionThrottlerParamsPtr> bound_session_throttler_params;
  
  bool force_safe_search;
  
  int32_t youtube_restrict;
  
  std::string allowed_domains_for_apps;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DynamicParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DynamicParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DynamicParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DynamicParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
BoundSessionThrottlerParamsPtr BoundSessionThrottlerParams::Clone() const {
  return New(
      mojo::Clone(domain),
      mojo::Clone(path),
      mojo::Clone(cookie_expiry_date)
  );
}

template <typename T, BoundSessionThrottlerParams::EnableIfSame<T>*>
bool BoundSessionThrottlerParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->domain, other_struct.domain))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->cookie_expiry_date, other_struct.cookie_expiry_date))
    return false;
  return true;
}

template <typename T, BoundSessionThrottlerParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.domain < rhs.domain)
    return true;
  if (rhs.domain < lhs.domain)
    return false;
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.cookie_expiry_date < rhs.cookie_expiry_date)
    return true;
  if (rhs.cookie_expiry_date < lhs.cookie_expiry_date)
    return false;
  return false;
}
template <typename StructPtrType>
DynamicParamsPtr DynamicParams::Clone() const {
  return New(
      mojo::Clone(bound_session_throttler_params),
      mojo::Clone(force_safe_search),
      mojo::Clone(youtube_restrict),
      mojo::Clone(allowed_domains_for_apps)
  );
}

template <typename T, DynamicParams::EnableIfSame<T>*>
bool DynamicParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bound_session_throttler_params, other_struct.bound_session_throttler_params))
    return false;
  if (!mojo::Equals(this->force_safe_search, other_struct.force_safe_search))
    return false;
  if (!mojo::Equals(this->youtube_restrict, other_struct.youtube_restrict))
    return false;
  if (!mojo::Equals(this->allowed_domains_for_apps, other_struct.allowed_domains_for_apps))
    return false;
  return true;
}

template <typename T, DynamicParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bound_session_throttler_params < rhs.bound_session_throttler_params)
    return true;
  if (rhs.bound_session_throttler_params < lhs.bound_session_throttler_params)
    return false;
  if (lhs.force_safe_search < rhs.force_safe_search)
    return true;
  if (rhs.force_safe_search < lhs.force_safe_search)
    return false;
  if (lhs.youtube_restrict < rhs.youtube_restrict)
    return true;
  if (rhs.youtube_restrict < lhs.youtube_restrict)
    return false;
  if (lhs.allowed_domains_for_apps < rhs.allowed_domains_for_apps)
    return true;
  if (rhs.allowed_domains_for_apps < lhs.allowed_domains_for_apps)
    return false;
  return false;
}
template <typename StructPtrType>
StaticParamsPtr StaticParams::Clone() const {
  return New(
      mojo::Clone(is_instant_process)
  );
}

template <typename T, StaticParams::EnableIfSame<T>*>
bool StaticParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_instant_process, other_struct.is_instant_process))
    return false;
  return true;
}

template <typename T, StaticParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_instant_process < rhs.is_instant_process)
    return true;
  if (rhs.is_instant_process < lhs.is_instant_process)
    return false;
  return false;
}


}  // chrome::mojom

namespace mojo {


template <>
struct  StructTraits<::chrome::mojom::BoundSessionThrottlerParams::DataView,
                                         ::chrome::mojom::BoundSessionThrottlerParamsPtr> {
  static bool IsNull(const ::chrome::mojom::BoundSessionThrottlerParamsPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::BoundSessionThrottlerParamsPtr* output) { output->reset(); }

  static const decltype(::chrome::mojom::BoundSessionThrottlerParams::domain)& domain(
      const ::chrome::mojom::BoundSessionThrottlerParamsPtr& input) {
    return input->domain;
  }

  static const decltype(::chrome::mojom::BoundSessionThrottlerParams::path)& path(
      const ::chrome::mojom::BoundSessionThrottlerParamsPtr& input) {
    return input->path;
  }

  static const decltype(::chrome::mojom::BoundSessionThrottlerParams::cookie_expiry_date)& cookie_expiry_date(
      const ::chrome::mojom::BoundSessionThrottlerParamsPtr& input) {
    return input->cookie_expiry_date;
  }

  static bool Read(::chrome::mojom::BoundSessionThrottlerParams::DataView input, ::chrome::mojom::BoundSessionThrottlerParamsPtr* output);
};


template <>
struct  StructTraits<::chrome::mojom::DynamicParams::DataView,
                                         ::chrome::mojom::DynamicParamsPtr> {
  static bool IsNull(const ::chrome::mojom::DynamicParamsPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::DynamicParamsPtr* output) { output->reset(); }

  static const decltype(::chrome::mojom::DynamicParams::bound_session_throttler_params)& bound_session_throttler_params(
      const ::chrome::mojom::DynamicParamsPtr& input) {
    return input->bound_session_throttler_params;
  }

  static decltype(::chrome::mojom::DynamicParams::force_safe_search) force_safe_search(
      const ::chrome::mojom::DynamicParamsPtr& input) {
    return input->force_safe_search;
  }

  static decltype(::chrome::mojom::DynamicParams::youtube_restrict) youtube_restrict(
      const ::chrome::mojom::DynamicParamsPtr& input) {
    return input->youtube_restrict;
  }

  static const decltype(::chrome::mojom::DynamicParams::allowed_domains_for_apps)& allowed_domains_for_apps(
      const ::chrome::mojom::DynamicParamsPtr& input) {
    return input->allowed_domains_for_apps;
  }

  static bool Read(::chrome::mojom::DynamicParams::DataView input, ::chrome::mojom::DynamicParamsPtr* output);
};


template <>
struct  StructTraits<::chrome::mojom::StaticParams::DataView,
                                         ::chrome::mojom::StaticParamsPtr> {
  static bool IsNull(const ::chrome::mojom::StaticParamsPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::StaticParamsPtr* output) { output->reset(); }

  static decltype(::chrome::mojom::StaticParams::is_instant_process) is_instant_process(
      const ::chrome::mojom::StaticParamsPtr& input) {
    return input->is_instant_process;
  }

  static bool Read(::chrome::mojom::StaticParams::DataView input, ::chrome::mojom::StaticParamsPtr* output);
};

}  // namespace mojo

#endif  // CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_H_