// chrome/common/renderer_configuration.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_SHARED_H_
#define CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/renderer_configuration.mojom-shared-internal.h"
#include "components/content_settings/common/content_settings_manager.mojom-shared.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/common/renderer_configuration.mojom-data-view.h"




namespace std {

template <>
struct hash<::chrome::mojom::ResumeBlockedRequestsTrigger>
    : public mojo::internal::EnumHashImpl<::chrome::mojom::ResumeBlockedRequestsTrigger> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::ResumeBlockedRequestsTrigger, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::chrome::mojom::ResumeBlockedRequestsTrigger, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::chrome::mojom::ResumeBlockedRequestsTrigger>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::BoundSessionThrottlerParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::BoundSessionThrottlerParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::BoundSessionThrottlerParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::domain(input)) in_domain = Traits::domain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain)::BaseType> domain_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_domain,
      domain_fragment);

    fragment->domain.Set(
        domain_fragment.is_null() ? nullptr : domain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->domain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domain in BoundSessionThrottlerParams struct");

    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_path,
      path_fragment);

    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in BoundSessionThrottlerParams struct");

    decltype(Traits::cookie_expiry_date(input)) in_cookie_expiry_date = Traits::cookie_expiry_date(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_expiry_date)::BaseType> cookie_expiry_date_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_cookie_expiry_date,
      cookie_expiry_date_fragment);

    fragment->cookie_expiry_date.Set(
        cookie_expiry_date_fragment.is_null() ? nullptr : cookie_expiry_date_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cookie_expiry_date.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie_expiry_date in BoundSessionThrottlerParams struct");
  }

  static bool Deserialize(::chrome::mojom::internal::BoundSessionThrottlerParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::BoundSessionThrottlerParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::DynamicParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::DynamicParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::DynamicParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bound_session_throttler_params(input)) in_bound_session_throttler_params = Traits::bound_session_throttler_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bound_session_throttler_params)::BaseType>
        bound_session_throttler_params_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bound_session_throttler_params_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::chrome::mojom::BoundSessionThrottlerParamsDataView>>(
      in_bound_session_throttler_params,
      bound_session_throttler_params_fragment,
      &bound_session_throttler_params_validate_params);

    fragment->bound_session_throttler_params.Set(
        bound_session_throttler_params_fragment.is_null() ? nullptr : bound_session_throttler_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bound_session_throttler_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bound_session_throttler_params in DynamicParams struct");

    fragment->force_safe_search = Traits::force_safe_search(input);

    fragment->youtube_restrict = Traits::youtube_restrict(input);

    decltype(Traits::allowed_domains_for_apps(input)) in_allowed_domains_for_apps = Traits::allowed_domains_for_apps(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allowed_domains_for_apps)::BaseType> allowed_domains_for_apps_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_allowed_domains_for_apps,
      allowed_domains_for_apps_fragment);

    fragment->allowed_domains_for_apps.Set(
        allowed_domains_for_apps_fragment.is_null() ? nullptr : allowed_domains_for_apps_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->allowed_domains_for_apps.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allowed_domains_for_apps in DynamicParams struct");
  }

  static bool Deserialize(::chrome::mojom::internal::DynamicParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::DynamicParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::chrome::mojom::StaticParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::StaticParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::StaticParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_instant_process = Traits::is_instant_process(input);
  }

  static bool Deserialize(::chrome::mojom::internal::StaticParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::chrome::mojom::StaticParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace chrome::mojom {

inline void BoundSessionThrottlerParamsDataView::GetDomainDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->domain.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BoundSessionThrottlerParamsDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BoundSessionThrottlerParamsDataView::GetCookieExpiryDateDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->cookie_expiry_date.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void DynamicParamsDataView::GetBoundSessionThrottlerParamsDataView(
    mojo::ArrayDataView<BoundSessionThrottlerParamsDataView>* output) {
  auto pointer = data_->bound_session_throttler_params.Get();
  *output = mojo::ArrayDataView<BoundSessionThrottlerParamsDataView>(pointer, message_);
}
inline void DynamicParamsDataView::GetAllowedDomainsForAppsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->allowed_domains_for_apps.Get();
  *output = mojo::StringDataView(pointer, message_);
}





}  // chrome::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::chrome::mojom::ResumeBlockedRequestsTrigger> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::chrome::mojom::ResumeBlockedRequestsTrigger value);
};

} // namespace perfetto

#endif  // CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_SHARED_H_