// chrome/common/renderer_configuration.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_SEND_VALIDATION_H_
#define CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_SEND_VALIDATION_H_

#include "chrome/common/renderer_configuration.mojom-shared-internal.h"
#include "components/content_settings/common/content_settings_manager.mojom-shared.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "chrome/common/renderer_configuration.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::chrome::mojom::ResumeBlockedRequestsTrigger, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome::mojom::BoundSessionThrottlerParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::BoundSessionThrottlerParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::BoundSessionThrottlerParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::domain(input)) in_domain = Traits::domain(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->domain)::BaseType> domain_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_domain,
        domain_fragment);

      fragment->domain.Set(
          domain_fragment.is_null() ? nullptr : domain_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->domain.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain in BoundSessionThrottlerParams struct");

      decltype(Traits::path(input)) in_path = Traits::path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->path)::BaseType> path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_path,
        path_fragment);

      fragment->path.Set(
          path_fragment.is_null() ? nullptr : path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in BoundSessionThrottlerParams struct");

      decltype(Traits::cookie_expiry_date(input)) in_cookie_expiry_date = Traits::cookie_expiry_date(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie_expiry_date)::BaseType> cookie_expiry_date_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_cookie_expiry_date,
        cookie_expiry_date_fragment);

      fragment->cookie_expiry_date.Set(
          cookie_expiry_date_fragment.is_null() ? nullptr : cookie_expiry_date_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cookie_expiry_date.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie_expiry_date in BoundSessionThrottlerParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome::mojom::DynamicParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::DynamicParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::DynamicParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::bound_session_throttler_params(input)) in_bound_session_throttler_params = Traits::bound_session_throttler_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bound_session_throttler_params)::BaseType>
          bound_session_throttler_params_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& bound_session_throttler_params_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::chrome::mojom::BoundSessionThrottlerParamsDataView>, send_validation>(
        in_bound_session_throttler_params,
        bound_session_throttler_params_fragment,
        &bound_session_throttler_params_validate_params);

      fragment->bound_session_throttler_params.Set(
          bound_session_throttler_params_fragment.is_null() ? nullptr : bound_session_throttler_params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bound_session_throttler_params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bound_session_throttler_params in DynamicParams struct");

      fragment->force_safe_search = Traits::force_safe_search(input);

      fragment->youtube_restrict = Traits::youtube_restrict(input);

      decltype(Traits::allowed_domains_for_apps(input)) in_allowed_domains_for_apps = Traits::allowed_domains_for_apps(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->allowed_domains_for_apps)::BaseType> allowed_domains_for_apps_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_allowed_domains_for_apps,
        allowed_domains_for_apps_fragment);

      fragment->allowed_domains_for_apps.Set(
          allowed_domains_for_apps_fragment.is_null() ? nullptr : allowed_domains_for_apps_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->allowed_domains_for_apps.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null allowed_domains_for_apps in DynamicParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome::mojom::StaticParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::StaticParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::StaticParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_instant_process = Traits::is_instant_process(input);
  }
};

}  // namespace mojo::internal

#endif  // CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_SEND_VALIDATION_H_