// chrome/common/renderer_configuration.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_PARAMS_DATA_H_
#define CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace chrome::mojom {
namespace internal {
class  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> untrusted_request_url;

 private:
  friend class mojo::internal::MessageFragment<BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data>;

  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data();
  ~BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data() = delete;
};
static_assert(sizeof(BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data) == 16,
              "Bad sizeof(BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data)");
class  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t resume_trigger;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data>;

  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data();
  ~BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data() = delete;
};
static_assert(sizeof(BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data) == 16,
              "Bad sizeof(BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data)");
class  RendererConfiguration_SetInitialConfiguration_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_incognito_process : 1;
  uint8_t pad0_[3];
  mojo::internal::Handle_Data chromeos_listener;
  mojo::internal::Interface_Data content_settings_manager;
  mojo::internal::Interface_Data bound_session_request_throttled_handler;

 private:
  friend class mojo::internal::MessageFragment<RendererConfiguration_SetInitialConfiguration_Params_Data>;

  RendererConfiguration_SetInitialConfiguration_Params_Data();
  ~RendererConfiguration_SetInitialConfiguration_Params_Data() = delete;
};
static_assert(sizeof(RendererConfiguration_SetInitialConfiguration_Params_Data) == 32,
              "Bad sizeof(RendererConfiguration_SetInitialConfiguration_Params_Data)");
class  RendererConfiguration_SetConfiguration_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::DynamicParams_Data> params;

 private:
  friend class mojo::internal::MessageFragment<RendererConfiguration_SetConfiguration_Params_Data>;

  RendererConfiguration_SetConfiguration_Params_Data();
  ~RendererConfiguration_SetConfiguration_Params_Data() = delete;
};
static_assert(sizeof(RendererConfiguration_SetConfiguration_Params_Data) == 16,
              "Bad sizeof(RendererConfiguration_SetConfiguration_Params_Data)");
class  RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::StaticParams_Data> params;

 private:
  friend class mojo::internal::MessageFragment<RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data>;

  RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data();
  ~RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data() = delete;
};
static_assert(sizeof(RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data) == 16,
              "Bad sizeof(RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data)");

}  // namespace internal


class BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ParamsDataView {
 public:
  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ParamsDataView() = default;

  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ParamsDataView(
      internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUntrustedRequestUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUntrustedRequestUrl(UserType* output) {
    
    auto* pointer = data_->untrusted_request_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParamsDataView {
 public:
  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParamsDataView() = default;

  BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParamsDataView(
      internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResumeTrigger(UserType* output) const {
    auto data_value = data_->resume_trigger;
    return mojo::internal::Deserialize<::chrome::mojom::ResumeBlockedRequestsTrigger>(
        data_value, output);
  }
  ResumeBlockedRequestsTrigger resume_trigger() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::chrome::mojom::ResumeBlockedRequestsTrigger>(data_->resume_trigger));
  }
 private:
  internal::BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ResponseParams_Data* data_ = nullptr;
};


class RendererConfiguration_SetInitialConfiguration_ParamsDataView {
 public:
  RendererConfiguration_SetInitialConfiguration_ParamsDataView() = default;

  RendererConfiguration_SetInitialConfiguration_ParamsDataView(
      internal::RendererConfiguration_SetInitialConfiguration_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_incognito_process() const {
    return data_->is_incognito_process;
  }
  template <typename UserType>
  UserType TakeChromeosListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::chrome::mojom::ChromeOSListenerInterfaceBase>>(
            &data_->chromeos_listener, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeContentSettingsManager() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::content_settings::mojom::ContentSettingsManagerInterfaceBase>>(
            &data_->content_settings_manager, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeBoundSessionRequestThrottledHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::chrome::mojom::BoundSessionRequestThrottledHandlerInterfaceBase>>(
            &data_->bound_session_request_throttled_handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RendererConfiguration_SetInitialConfiguration_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RendererConfiguration_SetConfiguration_ParamsDataView {
 public:
  RendererConfiguration_SetConfiguration_ParamsDataView() = default;

  RendererConfiguration_SetConfiguration_ParamsDataView(
      internal::RendererConfiguration_SetConfiguration_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      DynamicParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::chrome::mojom::DynamicParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::RendererConfiguration_SetConfiguration_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RendererConfiguration_SetConfigurationOnProcessLockUpdate_ParamsDataView {
 public:
  RendererConfiguration_SetConfigurationOnProcessLockUpdate_ParamsDataView() = default;

  RendererConfiguration_SetConfigurationOnProcessLockUpdate_ParamsDataView(
      internal::RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      StaticParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::chrome::mojom::StaticParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::RendererConfiguration_SetConfigurationOnProcessLockUpdate_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void BoundSessionRequestThrottledHandler_HandleRequestBlockedOnCookie_ParamsDataView::GetUntrustedRequestUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->untrusted_request_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}






inline void RendererConfiguration_SetConfiguration_ParamsDataView::GetParamsDataView(
    DynamicParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = DynamicParamsDataView(pointer, message_);
}


inline void RendererConfiguration_SetConfigurationOnProcessLockUpdate_ParamsDataView::GetParamsDataView(
    StaticParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = StaticParamsDataView(pointer, message_);
}



}  // chrome::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_PARAMS_DATA_H_