// chrome/common/renderer_configuration.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_DATA_VIEW_H_
#define CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/common/renderer_configuration.mojom-shared-internal.h"
#include "components/content_settings/common/content_settings_manager.mojom-shared.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace chrome::mojom {
class BoundSessionThrottlerParamsDataView;

class DynamicParamsDataView;

class StaticParamsDataView;



}  // chrome::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::chrome::mojom::BoundSessionThrottlerParamsDataView> {
  using Data = ::chrome::mojom::internal::BoundSessionThrottlerParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::chrome::mojom::DynamicParamsDataView> {
  using Data = ::chrome::mojom::internal::DynamicParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::chrome::mojom::StaticParamsDataView> {
  using Data = ::chrome::mojom::internal::StaticParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace chrome::mojom {


enum class ResumeBlockedRequestsTrigger : int32_t {
  
  kObservedFreshCookies = 0,
  
  kCookieRefreshFetchSuccess = 1,
  
  kCookieRefreshFetchFailure = 2,
  
  kTimeout = 4,
  
  kShutdownOrSessionTermination = 5,
  
  kCookieAlreadyFresh = 6,
  
  kRendererDisconnected = 7,
  
  kThrottlingRequestsPaused = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

 std::ostream& operator<<(std::ostream& os, ResumeBlockedRequestsTrigger value);
inline bool IsKnownEnumValue(ResumeBlockedRequestsTrigger value) {
  return internal::ResumeBlockedRequestsTrigger_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class BoundSessionRequestThrottledHandlerInterfaceBase {};

using BoundSessionRequestThrottledHandlerPtrDataView =
    mojo::InterfacePtrDataView<BoundSessionRequestThrottledHandlerInterfaceBase>;
using BoundSessionRequestThrottledHandlerRequestDataView =
    mojo::InterfaceRequestDataView<BoundSessionRequestThrottledHandlerInterfaceBase>;
using BoundSessionRequestThrottledHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BoundSessionRequestThrottledHandlerInterfaceBase>;
using BoundSessionRequestThrottledHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BoundSessionRequestThrottledHandlerInterfaceBase>;
class ChromeOSListenerInterfaceBase {};

using ChromeOSListenerPtrDataView =
    mojo::InterfacePtrDataView<ChromeOSListenerInterfaceBase>;
using ChromeOSListenerRequestDataView =
    mojo::InterfaceRequestDataView<ChromeOSListenerInterfaceBase>;
using ChromeOSListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ChromeOSListenerInterfaceBase>;
using ChromeOSListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ChromeOSListenerInterfaceBase>;
class RendererConfigurationInterfaceBase {};

using RendererConfigurationPtrDataView =
    mojo::InterfacePtrDataView<RendererConfigurationInterfaceBase>;
using RendererConfigurationRequestDataView =
    mojo::InterfaceRequestDataView<RendererConfigurationInterfaceBase>;
using RendererConfigurationAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RendererConfigurationInterfaceBase>;
using RendererConfigurationAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RendererConfigurationInterfaceBase>;


class BoundSessionThrottlerParamsDataView {
 public:
  BoundSessionThrottlerParamsDataView() = default;

  BoundSessionThrottlerParamsDataView(
      internal::BoundSessionThrottlerParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomain(UserType* output) {
    
    auto* pointer = data_->domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCookieExpiryDateDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieExpiryDate(UserType* output) {
    
    auto* pointer = data_->cookie_expiry_date.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::BoundSessionThrottlerParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DynamicParamsDataView {
 public:
  DynamicParamsDataView() = default;

  DynamicParamsDataView(
      internal::DynamicParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBoundSessionThrottlerParamsDataView(
      mojo::ArrayDataView<BoundSessionThrottlerParamsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBoundSessionThrottlerParams(UserType* output) {
    
    auto* pointer = data_->bound_session_throttler_params.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::chrome::mojom::BoundSessionThrottlerParamsDataView>>(
        pointer, output, message_);
  }
  bool force_safe_search() const {
    return data_->force_safe_search;
  }
  int32_t youtube_restrict() const {
    return data_->youtube_restrict;
  }
  inline void GetAllowedDomainsForAppsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowedDomainsForApps(UserType* output) {
    
    auto* pointer = data_->allowed_domains_for_apps.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DynamicParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StaticParamsDataView {
 public:
  StaticParamsDataView() = default;

  StaticParamsDataView(
      internal::StaticParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_instant_process() const {
    return data_->is_instant_process;
  }
 private:
  internal::StaticParams_Data* data_ = nullptr;
};


}  // chrome::mojom

#endif  // CHROME_COMMON_RENDERER_CONFIGURATION_MOJOM_DATA_VIEW_H_