// chrome/common/read_anything/read_anything.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/read_anything/read_anything.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/read_anything/read_anything.mojom-params-data.h"
namespace read_anything {
namespace mojom {

NOINLINE static const char* InstallationStateToStringHelper(InstallationState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InstallationState::kUnknown:
      return "kUnknown";
    case InstallationState::kNotInstalled:
      return "kNotInstalled";
    case InstallationState::kInstalling:
      return "kInstalling";
    case InstallationState::kInstalled:
      return "kInstalled";
    default:
      return nullptr;
  }
}

std::string InstallationStateToString(InstallationState value) {
  const char *str = InstallationStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InstallationState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InstallationState value) {
  return os << InstallationStateToString(value);
}

NOINLINE static const char* ErrorCodeToStringHelper(ErrorCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ErrorCode::kNone:
      return "kNone";
    case ErrorCode::kOther:
      return "kOther";
    case ErrorCode::kWrongId:
      return "kWrongId";
    case ErrorCode::kNeedReboot:
      return "kNeedReboot";
    case ErrorCode::kAllocation:
      return "kAllocation";
    case ErrorCode::kUnsupportedPlatform:
      return "kUnsupportedPlatform";
    case ErrorCode::kNotReached:
      return "kNotReached";
    default:
      return nullptr;
  }
}

std::string ErrorCodeToString(ErrorCode value) {
  const char *str = ErrorCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ErrorCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ErrorCode value) {
  return os << ErrorCodeToString(value);
}

NOINLINE static const char* ColorsToStringHelper(Colors value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Colors::kDefault:
      return "kDefault";
    case Colors::kLight:
      return "kLight";
    case Colors::kDark:
      return "kDark";
    case Colors::kYellow:
      return "kYellow";
    case Colors::kBlue:
      return "kBlue";
    case Colors::kHighContrast:
      return "kHighContrast";
    case Colors::kLowContrast:
      return "kLowContrast";
    case Colors::kSepiaLight:
      return "kSepiaLight";
    case Colors::kSepiaDark:
      return "kSepiaDark";
    default:
      return nullptr;
  }
}

std::string ColorsToString(Colors value) {
  const char *str = ColorsToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Colors value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Colors value) {
  return os << ColorsToString(value);
}

NOINLINE static const char* LetterSpacingToStringHelper(LetterSpacing value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LetterSpacing::kTightDeprecated:
      return "kTightDeprecated";
    case LetterSpacing::kStandard:
      return "kStandard";
    case LetterSpacing::kWide:
      return "kWide";
    case LetterSpacing::kVeryWide:
      return "kVeryWide";
    default:
      return nullptr;
  }
}

std::string LetterSpacingToString(LetterSpacing value) {
  const char *str = LetterSpacingToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LetterSpacing value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LetterSpacing value) {
  return os << LetterSpacingToString(value);
}

NOINLINE static const char* LineSpacingToStringHelper(LineSpacing value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LineSpacing::kTightDeprecated:
      return "kTightDeprecated";
    case LineSpacing::kStandard:
      return "kStandard";
    case LineSpacing::kLoose:
      return "kLoose";
    case LineSpacing::kVeryLoose:
      return "kVeryLoose";
    default:
      return nullptr;
  }
}

std::string LineSpacingToString(LineSpacing value) {
  const char *str = LineSpacingToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LineSpacing value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LineSpacing value) {
  return os << LineSpacingToString(value);
}

NOINLINE static const char* HighlightGranularityToStringHelper(HighlightGranularity value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HighlightGranularity::kOn:
      return "kOn";
    case HighlightGranularity::kOff:
      return "kOff";
    case HighlightGranularity::kWord:
      return "kWord";
    case HighlightGranularity::kPhrase:
      return "kPhrase";
    case HighlightGranularity::kSentence:
      return "kSentence";
    default:
      return nullptr;
  }
}

std::string HighlightGranularityToString(HighlightGranularity value) {
  const char *str = HighlightGranularityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HighlightGranularity value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HighlightGranularity value) {
  return os << HighlightGranularityToString(value);
}

NOINLINE static const char* DistillationStatusToStringHelper(DistillationStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DistillationStatus::kFailure:
      return "kFailure";
    case DistillationStatus::kSuccess:
      return "kSuccess";
    case DistillationStatus::kStillRunning:
      return "kStillRunning";
    case DistillationStatus::kRestarted:
      return "kRestarted";
    default:
      return nullptr;
  }
}

std::string DistillationStatusToString(DistillationStatus value) {
  const char *str = DistillationStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DistillationStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DistillationStatus value) {
  return os << DistillationStatusToString(value);
}

namespace internal {
// static
bool VoicePackInstallationState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const VoicePackInstallationState_Data* object = static_cast<const VoicePackInstallationState_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case VoicePackInstallationState_Tag::kInstallationState: {


      if (!::read_anything::mojom::internal::InstallationState_Data
            ::Validate(object->data.f_installation_state, validation_context))
        return false;
      return true;
    }
    case VoicePackInstallationState_Tag::kErrorCode: {


      if (!::read_anything::mojom::internal::ErrorCode_Data
            ::Validate(object->data.f_error_code, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in VoicePackInstallationState");
      return false;
    }
  }
}


// static
bool VoicePackInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VoicePackInfo_Data* object =
      static_cast<const VoicePackInfo_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->pack_state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->pack_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

VoicePackInfo_Data::VoicePackInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandlerFactory_CreateUntrustedPageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandlerFactory_CreateUntrustedPageHandler_Params_Data* object =
      static_cast<const UntrustedPageHandlerFactory_CreateUntrustedPageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

UntrustedPageHandlerFactory_CreateUntrustedPageHandler_Params_Data::UntrustedPageHandlerFactory_CreateUntrustedPageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandlerFactory_ShouldShowUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandlerFactory_ShouldShowUI_Params_Data* object =
      static_cast<const UntrustedPageHandlerFactory_ShouldShowUI_Params_Data*>(data);

  return true;
}

UntrustedPageHandlerFactory_ShouldShowUI_Params_Data::UntrustedPageHandlerFactory_ShouldShowUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_GetDependencyParserModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_GetDependencyParserModel_Params_Data* object =
      static_cast<const UntrustedPageHandler_GetDependencyParserModel_Params_Data*>(data);

  return true;
}

UntrustedPageHandler_GetDependencyParserModel_Params_Data::UntrustedPageHandler_GetDependencyParserModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_GetDependencyParserModel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_GetDependencyParserModel_ResponseParams_Data* object =
      static_cast<const UntrustedPageHandler_GetDependencyParserModel_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->model_file, validation_context))
    return false;

  return true;
}

UntrustedPageHandler_GetDependencyParserModel_ResponseParams_Data::UntrustedPageHandler_GetDependencyParserModel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_GetVoicePackInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_GetVoicePackInfo_Params_Data* object =
      static_cast<const UntrustedPageHandler_GetVoicePackInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

UntrustedPageHandler_GetVoicePackInfo_Params_Data::UntrustedPageHandler_GetVoicePackInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_InstallVoicePack_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_InstallVoicePack_Params_Data* object =
      static_cast<const UntrustedPageHandler_InstallVoicePack_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

UntrustedPageHandler_InstallVoicePack_Params_Data::UntrustedPageHandler_InstallVoicePack_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_UninstallVoice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_UninstallVoice_Params_Data* object =
      static_cast<const UntrustedPageHandler_UninstallVoice_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  return true;
}

UntrustedPageHandler_UninstallVoice_Params_Data::UntrustedPageHandler_UninstallVoice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnCopy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnCopy_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnCopy_Params_Data*>(data);

  return true;
}

UntrustedPageHandler_OnCopy_Params_Data::UntrustedPageHandler_OnCopy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnLineSpaceChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnLineSpaceChange_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnLineSpaceChange_Params_Data*>(data);


  if (!::read_anything::mojom::internal::LineSpacing_Data
        ::Validate(object->line_spacing, validation_context))
    return false;

  return true;
}

UntrustedPageHandler_OnLineSpaceChange_Params_Data::UntrustedPageHandler_OnLineSpaceChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnLetterSpaceChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnLetterSpaceChange_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnLetterSpaceChange_Params_Data*>(data);


  if (!::read_anything::mojom::internal::LetterSpacing_Data
        ::Validate(object->letter_spacing, validation_context))
    return false;

  return true;
}

UntrustedPageHandler_OnLetterSpaceChange_Params_Data::UntrustedPageHandler_OnLetterSpaceChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnFontChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnFontChange_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnFontChange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->font, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& font_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->font, validation_context,
                                         &font_validate_params)) {
    return false;
  }

  return true;
}

UntrustedPageHandler_OnFontChange_Params_Data::UntrustedPageHandler_OnFontChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnFontSizeChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnFontSizeChange_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnFontSizeChange_Params_Data*>(data);

  return true;
}

UntrustedPageHandler_OnFontSizeChange_Params_Data::UntrustedPageHandler_OnFontSizeChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnLinksEnabledChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnLinksEnabledChanged_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnLinksEnabledChanged_Params_Data*>(data);

  return true;
}

UntrustedPageHandler_OnLinksEnabledChanged_Params_Data::UntrustedPageHandler_OnLinksEnabledChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnImagesEnabledChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnImagesEnabledChanged_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnImagesEnabledChanged_Params_Data*>(data);

  return true;
}

UntrustedPageHandler_OnImagesEnabledChanged_Params_Data::UntrustedPageHandler_OnImagesEnabledChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnColorChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnColorChange_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnColorChange_Params_Data*>(data);


  if (!::read_anything::mojom::internal::Colors_Data
        ::Validate(object->color, validation_context))
    return false;

  return true;
}

UntrustedPageHandler_OnColorChange_Params_Data::UntrustedPageHandler_OnColorChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnSpeechRateChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnSpeechRateChange_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnSpeechRateChange_Params_Data*>(data);

  return true;
}

UntrustedPageHandler_OnSpeechRateChange_Params_Data::UntrustedPageHandler_OnSpeechRateChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnVoiceChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnVoiceChange_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnVoiceChange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->voice, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& voice_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->voice, validation_context,
                                         &voice_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lang, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& lang_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->lang, validation_context,
                                         &lang_validate_params)) {
    return false;
  }

  return true;
}

UntrustedPageHandler_OnVoiceChange_Params_Data::UntrustedPageHandler_OnVoiceChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnLanguagePrefChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnLanguagePrefChange_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnLanguagePrefChange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lang, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& lang_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->lang, validation_context,
                                         &lang_validate_params)) {
    return false;
  }

  return true;
}

UntrustedPageHandler_OnLanguagePrefChange_Params_Data::UntrustedPageHandler_OnLanguagePrefChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_LogExtensionState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_LogExtensionState_Params_Data* object =
      static_cast<const UntrustedPageHandler_LogExtensionState_Params_Data*>(data);

  return true;
}

UntrustedPageHandler_LogExtensionState_Params_Data::UntrustedPageHandler_LogExtensionState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnHighlightGranularityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnHighlightGranularityChanged_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnHighlightGranularityChanged_Params_Data*>(data);


  if (!::read_anything::mojom::internal::HighlightGranularity_Data
        ::Validate(object->granularity, validation_context))
    return false;

  return true;
}

UntrustedPageHandler_OnHighlightGranularityChanged_Params_Data::UntrustedPageHandler_OnHighlightGranularityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnReadAloudAudioStateChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnReadAloudAudioStateChange_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnReadAloudAudioStateChange_Params_Data*>(data);

  return true;
}

UntrustedPageHandler_OnReadAloudAudioStateChange_Params_Data::UntrustedPageHandler_OnReadAloudAudioStateChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnLinkClicked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnLinkClicked_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnLinkClicked_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->target_tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->target_tree_id, validation_context))
    return false;

  return true;
}

UntrustedPageHandler_OnLinkClicked_Params_Data::UntrustedPageHandler_OnLinkClicked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnImageDataRequested_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnImageDataRequested_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnImageDataRequested_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->target_tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->target_tree_id, validation_context))
    return false;

  return true;
}

UntrustedPageHandler_OnImageDataRequested_Params_Data::UntrustedPageHandler_OnImageDataRequested_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnSelectionChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnSelectionChange_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnSelectionChange_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->target_tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->target_tree_id, validation_context))
    return false;

  return true;
}

UntrustedPageHandler_OnSelectionChange_Params_Data::UntrustedPageHandler_OnSelectionChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnCollapseSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnCollapseSelection_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnCollapseSelection_Params_Data*>(data);

  return true;
}

UntrustedPageHandler_OnCollapseSelection_Params_Data::UntrustedPageHandler_OnCollapseSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnScreenshotRequested_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnScreenshotRequested_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnScreenshotRequested_Params_Data*>(data);

  return true;
}

UntrustedPageHandler_OnScreenshotRequested_Params_Data::UntrustedPageHandler_OnScreenshotRequested_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_OnDistillationStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_OnDistillationStatus_Params_Data* object =
      static_cast<const UntrustedPageHandler_OnDistillationStatus_Params_Data*>(data);


  if (!::read_anything::mojom::internal::DistillationStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

UntrustedPageHandler_OnDistillationStatus_Params_Data::UntrustedPageHandler_OnDistillationStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPageHandler_ScrollToTargetNode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPageHandler_ScrollToTargetNode_Params_Data* object =
      static_cast<const UntrustedPageHandler_ScrollToTargetNode_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->target_tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->target_tree_id, validation_context))
    return false;

  return true;
}

UntrustedPageHandler_ScrollToTargetNode_Params_Data::UntrustedPageHandler_ScrollToTargetNode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_AccessibilityEventReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_AccessibilityEventReceived_Params_Data* object =
      static_cast<const UntrustedPage_AccessibilityEventReceived_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->tree_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->updates, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& updates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->updates, validation_context,
                                         &updates_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->events, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& events_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->events, validation_context,
                                         &events_validate_params)) {
    return false;
  }

  return true;
}

UntrustedPage_AccessibilityEventReceived_Params_Data::UntrustedPage_AccessibilityEventReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_OnGetVoicePackInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_OnGetVoicePackInfo_Params_Data* object =
      static_cast<const UntrustedPage_OnGetVoicePackInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->voice_pack_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->voice_pack_info, validation_context))
    return false;

  return true;
}

UntrustedPage_OnGetVoicePackInfo_Params_Data::UntrustedPage_OnGetVoicePackInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_AccessibilityLocationChangesReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_AccessibilityLocationChangesReceived_Params_Data* object =
      static_cast<const UntrustedPage_AccessibilityLocationChangesReceived_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->tree_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  return true;
}

UntrustedPage_AccessibilityLocationChangesReceived_Params_Data::UntrustedPage_AccessibilityLocationChangesReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_OnActiveAXTreeIDChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_OnActiveAXTreeIDChanged_Params_Data* object =
      static_cast<const UntrustedPage_OnActiveAXTreeIDChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->tree_id, validation_context))
    return false;

  return true;
}

UntrustedPage_OnActiveAXTreeIDChanged_Params_Data::UntrustedPage_OnActiveAXTreeIDChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_OnAXTreeDestroyed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_OnAXTreeDestroyed_Params_Data* object =
      static_cast<const UntrustedPage_OnAXTreeDestroyed_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->tree_id, validation_context))
    return false;

  return true;
}

UntrustedPage_OnAXTreeDestroyed_Params_Data::UntrustedPage_OnAXTreeDestroyed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_SetLanguageCode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_SetLanguageCode_Params_Data* object =
      static_cast<const UntrustedPage_SetLanguageCode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->code, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& code_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->code, validation_context,
                                         &code_validate_params)) {
    return false;
  }

  return true;
}

UntrustedPage_SetLanguageCode_Params_Data::UntrustedPage_SetLanguageCode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_OnTtsEngineInstalled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_OnTtsEngineInstalled_Params_Data* object =
      static_cast<const UntrustedPage_OnTtsEngineInstalled_Params_Data*>(data);

  return true;
}

UntrustedPage_OnTtsEngineInstalled_Params_Data::UntrustedPage_OnTtsEngineInstalled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_SetDefaultLanguageCode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_SetDefaultLanguageCode_Params_Data* object =
      static_cast<const UntrustedPage_SetDefaultLanguageCode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->code, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& code_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->code, validation_context,
                                         &code_validate_params)) {
    return false;
  }

  return true;
}

UntrustedPage_SetDefaultLanguageCode_Params_Data::UntrustedPage_SetDefaultLanguageCode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_OnSettingsRestoredFromPrefs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_OnSettingsRestoredFromPrefs_Params_Data* object =
      static_cast<const UntrustedPage_OnSettingsRestoredFromPrefs_Params_Data*>(data);


  if (!::read_anything::mojom::internal::LineSpacing_Data
        ::Validate(object->line_spacing, validation_context))
    return false;


  if (!::read_anything::mojom::internal::LetterSpacing_Data
        ::Validate(object->letter_spacing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->font, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& font_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->font, validation_context,
                                         &font_validate_params)) {
    return false;
  }


  if (!::read_anything::mojom::internal::Colors_Data
        ::Validate(object->color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->voices, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->voices, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->languages_enabled_in_pref, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->languages_enabled_in_pref, validation_context))
    return false;


  if (!::read_anything::mojom::internal::HighlightGranularity_Data
        ::Validate(object->granularity, validation_context))
    return false;

  return true;
}

UntrustedPage_OnSettingsRestoredFromPrefs_Params_Data::UntrustedPage_OnSettingsRestoredFromPrefs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_ScreenAIServiceReady_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_ScreenAIServiceReady_Params_Data* object =
      static_cast<const UntrustedPage_ScreenAIServiceReady_Params_Data*>(data);

  return true;
}

UntrustedPage_ScreenAIServiceReady_Params_Data::UntrustedPage_ScreenAIServiceReady_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_OnReadingModeHidden_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_OnReadingModeHidden_Params_Data* object =
      static_cast<const UntrustedPage_OnReadingModeHidden_Params_Data*>(data);

  return true;
}

UntrustedPage_OnReadingModeHidden_Params_Data::UntrustedPage_OnReadingModeHidden_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_OnTabWillDetach_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_OnTabWillDetach_Params_Data* object =
      static_cast<const UntrustedPage_OnTabWillDetach_Params_Data*>(data);

  return true;
}

UntrustedPage_OnTabWillDetach_Params_Data::UntrustedPage_OnTabWillDetach_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_OnTabMuteStateChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_OnTabMuteStateChange_Params_Data* object =
      static_cast<const UntrustedPage_OnTabMuteStateChange_Params_Data*>(data);

  return true;
}

UntrustedPage_OnTabMuteStateChange_Params_Data::UntrustedPage_OnTabMuteStateChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool UntrustedPage_OnImageDataDownloaded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const UntrustedPage_OnImageDataDownloaded_Params_Data* object =
      static_cast<const UntrustedPage_OnImageDataDownloaded_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->tree_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

UntrustedPage_OnImageDataDownloaded_Params_Data::UntrustedPage_OnImageDataDownloaded_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace read_anything

namespace perfetto {

// static
void TraceFormatTraits<::read_anything::mojom::InstallationState>::WriteIntoTrace(
   perfetto::TracedValue context, ::read_anything::mojom::InstallationState value) {
  return std::move(context).WriteString(::read_anything::mojom::InstallationStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::read_anything::mojom::ErrorCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::read_anything::mojom::ErrorCode value) {
  return std::move(context).WriteString(::read_anything::mojom::ErrorCodeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::read_anything::mojom::Colors>::WriteIntoTrace(
   perfetto::TracedValue context, ::read_anything::mojom::Colors value) {
  return std::move(context).WriteString(::read_anything::mojom::ColorsToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::read_anything::mojom::LetterSpacing>::WriteIntoTrace(
   perfetto::TracedValue context, ::read_anything::mojom::LetterSpacing value) {
  return std::move(context).WriteString(::read_anything::mojom::LetterSpacingToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::read_anything::mojom::LineSpacing>::WriteIntoTrace(
   perfetto::TracedValue context, ::read_anything::mojom::LineSpacing value) {
  return std::move(context).WriteString(::read_anything::mojom::LineSpacingToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::read_anything::mojom::HighlightGranularity>::WriteIntoTrace(
   perfetto::TracedValue context, ::read_anything::mojom::HighlightGranularity value) {
  return std::move(context).WriteString(::read_anything::mojom::HighlightGranularityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::read_anything::mojom::DistillationStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::read_anything::mojom::DistillationStatus value) {
  return std::move(context).WriteString(::read_anything::mojom::DistillationStatusToString(value));
}

} // namespace perfetto