// chrome/common/plugin.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_PLUGIN_MOJOM_SEND_VALIDATION_H_
#define CHROME_COMMON_PLUGIN_MOJOM_SEND_VALIDATION_H_

#include "chrome/common/plugin.mojom-shared-internal.h"
#include "content/public/common/webplugininfo.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "chrome/common/plugin.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::chrome::mojom::PluginStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome::mojom::PluginInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::PluginInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::PluginInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::chrome::mojom::PluginStatus>(
        Traits::status(input),
        &fragment->status);

      decltype(Traits::plugin(input)) in_plugin = Traits::plugin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->plugin)::BaseType> plugin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::content::mojom::WebPluginInfoDataView, send_validation>(
        in_plugin,
        plugin_fragment);

      fragment->plugin.Set(
          plugin_fragment.is_null() ? nullptr : plugin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->plugin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null plugin in PluginInfo struct");

      decltype(Traits::actual_mime_type(input)) in_actual_mime_type = Traits::actual_mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->actual_mime_type)::BaseType> actual_mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_actual_mime_type,
        actual_mime_type_fragment);

      fragment->actual_mime_type.Set(
          actual_mime_type_fragment.is_null() ? nullptr : actual_mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->actual_mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null actual_mime_type in PluginInfo struct");

      decltype(Traits::group_identifier(input)) in_group_identifier = Traits::group_identifier(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group_identifier)::BaseType> group_identifier_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_group_identifier,
        group_identifier_fragment);

      fragment->group_identifier.Set(
          group_identifier_fragment.is_null() ? nullptr : group_identifier_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->group_identifier.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group_identifier in PluginInfo struct");

      decltype(Traits::group_name(input)) in_group_name = Traits::group_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group_name)::BaseType> group_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_group_name,
        group_name_fragment);

      fragment->group_name.Set(
          group_name_fragment.is_null() ? nullptr : group_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->group_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group_name in PluginInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::chrome::mojom::PluginParamDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::chrome::mojom::PluginParamDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::chrome::mojom::internal::PluginParam_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in PluginParam struct");

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in PluginParam struct");
  }
};

}  // namespace mojo::internal

#endif  // CHROME_COMMON_PLUGIN_MOJOM_SEND_VALIDATION_H_