// chrome/common/offline_page_auto_fetcher.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/offline_page_auto_fetcher.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/offline_page_auto_fetcher.mojom-params-data.h"
#include "chrome/common/offline_page_auto_fetcher.mojom-shared-message-ids.h"

#include "chrome/common/offline_page_auto_fetcher.mojom-import-headers.h"
#include "chrome/common/offline_page_auto_fetcher.mojom-test-utils.h"


namespace chrome::mojom {
// The declaration includes the definition on other builds.

OfflinePageAutoFetcher::IPCStableHashFunction OfflinePageAutoFetcher::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OfflinePageAutoFetcher>(message.name())) {
    case messages::OfflinePageAutoFetcher::kTrySchedule: {
      return &OfflinePageAutoFetcher::TrySchedule_Sym::IPCStableHash;
    }
    case messages::OfflinePageAutoFetcher::kCancelSchedule: {
      return &OfflinePageAutoFetcher::CancelSchedule_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OfflinePageAutoFetcher::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OfflinePageAutoFetcher>(message.name())) {
      case messages::OfflinePageAutoFetcher::kTrySchedule:
            return "Receive chrome::mojom::OfflinePageAutoFetcher::TrySchedule";
      case messages::OfflinePageAutoFetcher::kCancelSchedule:
            return "Receive chrome::mojom::OfflinePageAutoFetcher::CancelSchedule";
    }
  } else {
    switch (static_cast<messages::OfflinePageAutoFetcher>(message.name())) {
      case messages::OfflinePageAutoFetcher::kTrySchedule:
            return "Receive reply chrome::mojom::OfflinePageAutoFetcher::TrySchedule";
      case messages::OfflinePageAutoFetcher::kCancelSchedule:
            return "Receive reply chrome::mojom::OfflinePageAutoFetcher::CancelSchedule";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OfflinePageAutoFetcher::TrySchedule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8a64f5e;  // IPCStableHash for chrome::mojom::OfflinePageAutoFetcher::TrySchedule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OfflinePageAutoFetcher::CancelSchedule_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0fc270a2;  // IPCStableHash for chrome::mojom::OfflinePageAutoFetcher::CancelSchedule
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class OfflinePageAutoFetcher_TrySchedule_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OfflinePageAutoFetcher_TrySchedule_ForwardToCallback(
      OfflinePageAutoFetcher::TryScheduleCallback callback
      ) : callback_(std::move(callback)) {
  }

  OfflinePageAutoFetcher_TrySchedule_ForwardToCallback(const OfflinePageAutoFetcher_TrySchedule_ForwardToCallback&) = delete;
  OfflinePageAutoFetcher_TrySchedule_ForwardToCallback& operator=(const OfflinePageAutoFetcher_TrySchedule_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OfflinePageAutoFetcher::TryScheduleCallback callback_;
};

OfflinePageAutoFetcherProxy::OfflinePageAutoFetcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OfflinePageAutoFetcherProxy::TrySchedule(
    bool in_user_requested, TryScheduleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::OfflinePageAutoFetcher::TrySchedule", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_requested"), in_user_requested,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OfflinePageAutoFetcher::kTrySchedule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::OfflinePageAutoFetcher_TrySchedule_Params_Data> params(
          message);
  params.Allocate();

  params->user_requested = in_user_requested;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OfflinePageAutoFetcher::Name_);
  message.set_method_name("TrySchedule");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OfflinePageAutoFetcher_TrySchedule_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OfflinePageAutoFetcherProxy::CancelSchedule(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::OfflinePageAutoFetcher::CancelSchedule");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OfflinePageAutoFetcher::kCancelSchedule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::OfflinePageAutoFetcher_CancelSchedule_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OfflinePageAutoFetcher::Name_);
  message.set_method_name("CancelSchedule");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class OfflinePageAutoFetcher_TrySchedule_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OfflinePageAutoFetcher::TryScheduleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OfflinePageAutoFetcher_TrySchedule_ProxyToResponder> proxy(
        new OfflinePageAutoFetcher_TrySchedule_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OfflinePageAutoFetcher_TrySchedule_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OfflinePageAutoFetcher_TrySchedule_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OfflinePageAutoFetcher_TrySchedule_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OfflinePageAutoFetcher::TryScheduleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      OfflinePageAutoFetcherScheduleResult in_out);
};

bool OfflinePageAutoFetcher_TrySchedule_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OfflinePageAutoFetcher_TrySchedule_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OfflinePageAutoFetcher_TrySchedule_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OfflinePageAutoFetcher.0
  bool success = true;
  OfflinePageAutoFetcherScheduleResult p_out{};
  OfflinePageAutoFetcher_TrySchedule_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadOut(&p_out))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OfflinePageAutoFetcher::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_out));
  }
  return true;
}

void OfflinePageAutoFetcher_TrySchedule_ProxyToResponder::Run(
    OfflinePageAutoFetcherScheduleResult in_out) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::OfflinePageAutoFetcher::TrySchedule", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("out"), in_out,
                        "<value of type OfflinePageAutoFetcherScheduleResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OfflinePageAutoFetcher::kTrySchedule), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::OfflinePageAutoFetcher_TrySchedule_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::chrome::mojom::OfflinePageAutoFetcherScheduleResult>(
    in_out,
    &params->out);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OfflinePageAutoFetcher::Name_);
  message.set_method_name("TrySchedule");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OfflinePageAutoFetcherStubDispatch::Accept(
    OfflinePageAutoFetcher* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OfflinePageAutoFetcher>(message->header()->name)) {
    case messages::OfflinePageAutoFetcher::kTrySchedule: {
      break;
    }
    case messages::OfflinePageAutoFetcher::kCancelSchedule: {
      DCHECK(message->is_serialized());
      internal::OfflinePageAutoFetcher_CancelSchedule_Params_Data* params =
          reinterpret_cast<internal::OfflinePageAutoFetcher_CancelSchedule_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OfflinePageAutoFetcher.1
      bool success = true;
      OfflinePageAutoFetcher_CancelSchedule_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OfflinePageAutoFetcher::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelSchedule(        );
      return true;
    }
  }
  return false;
}

// static
bool OfflinePageAutoFetcherStubDispatch::AcceptWithResponder(
    OfflinePageAutoFetcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OfflinePageAutoFetcher>(message->header()->name)) {
    case messages::OfflinePageAutoFetcher::kTrySchedule: {
      internal::OfflinePageAutoFetcher_TrySchedule_Params_Data* params =
          reinterpret_cast<
              internal::OfflinePageAutoFetcher_TrySchedule_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OfflinePageAutoFetcher.0
      bool success = true;
      bool p_user_requested{};
      OfflinePageAutoFetcher_TrySchedule_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_user_requested = input_data_view.user_requested();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OfflinePageAutoFetcher::Name_, 0, false);
        return false;
      }
      auto callback =
          OfflinePageAutoFetcher_TrySchedule_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TrySchedule(        
        std::move(p_user_requested), std::move(callback));
      return true;
    }
    case messages::OfflinePageAutoFetcher::kCancelSchedule: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOfflinePageAutoFetcherValidationInfo[] = {
    { &internal::OfflinePageAutoFetcher_TrySchedule_Params_Data::Validate,
     &internal::OfflinePageAutoFetcher_TrySchedule_ResponseParams_Data::Validate},
    { &internal::OfflinePageAutoFetcher_CancelSchedule_Params_Data::Validate,
     nullptr /* no response */},
};

bool OfflinePageAutoFetcherRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::OfflinePageAutoFetcher::Name_,
    kOfflinePageAutoFetcherValidationInfo);
}

bool OfflinePageAutoFetcherResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::OfflinePageAutoFetcher::Name_,
    kOfflinePageAutoFetcherValidationInfo);
}


}  // chrome::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void OfflinePageAutoFetcherInterceptorForTesting::TrySchedule(bool user_requested, TryScheduleCallback callback) {
  GetForwardingInterface()->TrySchedule(
    std::move(user_requested)
    , std::move(callback));
}
void OfflinePageAutoFetcherInterceptorForTesting::CancelSchedule() {
  GetForwardingInterface()->CancelSchedule();
}
OfflinePageAutoFetcherAsyncWaiter::OfflinePageAutoFetcherAsyncWaiter(
    OfflinePageAutoFetcher* proxy) : proxy_(proxy) {}

OfflinePageAutoFetcherAsyncWaiter::~OfflinePageAutoFetcherAsyncWaiter() = default;


void OfflinePageAutoFetcherAsyncWaiter::TrySchedule(
    bool user_requested, OfflinePageAutoFetcherScheduleResult* out_out) {
  base::RunLoop loop;
  proxy_->TrySchedule(
      std::move(user_requested),
      base::BindOnce(
          [](base::RunLoop* loop,
             OfflinePageAutoFetcherScheduleResult* out_out
,
             OfflinePageAutoFetcherScheduleResult out) {*out_out = std::move(out);
            loop->Quit();
          },
          &loop,
          out_out));
  loop.Run();
}

OfflinePageAutoFetcherScheduleResult OfflinePageAutoFetcherAsyncWaiter::TrySchedule(
    bool user_requested) {
  OfflinePageAutoFetcherScheduleResult async_wait_result;
  TrySchedule(std::move(user_requested),&async_wait_result);
  return async_wait_result;
}






}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif