// chrome/common/net_benchmarking.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_NET_BENCHMARKING_MOJOM_H_
#define CHROME_COMMON_NET_BENCHMARKING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/net_benchmarking.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/net_benchmarking.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/net_benchmarking.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class NetBenchmarkingProxy;

template <typename ImplRefTraits>
class NetBenchmarkingStub;

class NetBenchmarkingRequestValidator;
class NetBenchmarkingResponseValidator;


class NetBenchmarking
    : public NetBenchmarkingInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.NetBenchmarking";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1, 
    2, 
    3
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetBenchmarkingInterfaceBase;
  using Proxy_ = NetBenchmarkingProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetBenchmarkingStub<ImplRefTraits>;

  using RequestValidator_ = NetBenchmarkingRequestValidator;
  using ResponseValidator_ = NetBenchmarkingResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCloseCurrentConnectionsMinVersion = 0,
    kClearCacheMinVersion = 0,
    kClearHostResolverCacheMinVersion = 0,
    kClearPredictorCacheMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CloseCurrentConnections_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearHostResolverCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearPredictorCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NetBenchmarking() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CloseCurrentConnections();
  using CloseCurrentConnectionsCallback = base::OnceCallback<void()>;
  using CloseCurrentConnectionsMojoCallback = base::OnceCallback<void()>;

  virtual void CloseCurrentConnections(CloseCurrentConnectionsCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ClearCache();
  using ClearCacheCallback = base::OnceCallback<void()>;
  using ClearCacheMojoCallback = base::OnceCallback<void()>;

  virtual void ClearCache(ClearCacheCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ClearHostResolverCache();
  using ClearHostResolverCacheCallback = base::OnceCallback<void()>;
  using ClearHostResolverCacheMojoCallback = base::OnceCallback<void()>;

  virtual void ClearHostResolverCache(ClearHostResolverCacheCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ClearPredictorCache();
  using ClearPredictorCacheCallback = base::OnceCallback<void()>;
  using ClearPredictorCacheMojoCallback = base::OnceCallback<void()>;

  virtual void ClearPredictorCache(ClearPredictorCacheCallback callback) = 0;
};



class  NetBenchmarkingProxy
    : public NetBenchmarking {
 public:
  using InterfaceType = NetBenchmarking;

  explicit NetBenchmarkingProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool CloseCurrentConnections() final;
  
  void CloseCurrentConnections(CloseCurrentConnectionsCallback callback) final;
  
  bool ClearCache() final;
  
  void ClearCache(ClearCacheCallback callback) final;
  
  bool ClearHostResolverCache() final;
  
  void ClearHostResolverCache(ClearHostResolverCacheCallback callback) final;
  
  bool ClearPredictorCache() final;
  
  void ClearPredictorCache(ClearPredictorCacheCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NetBenchmarkingStubDispatch {
 public:
  static bool Accept(NetBenchmarking* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetBenchmarking* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetBenchmarking>>
class NetBenchmarkingStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetBenchmarkingStub() = default;
  ~NetBenchmarkingStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetBenchmarkingStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetBenchmarkingStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetBenchmarkingRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetBenchmarkingResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // chrome::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_COMMON_NET_BENCHMARKING_MOJOM_H_