// chrome/common/mac/app_shim.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/mac/app_shim.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/mac/app_shim.mojom-params-data.h"
#include "chrome/common/mac/app_shim.mojom-shared-message-ids.h"

#include "chrome/common/mac/app_shim.mojom-import-headers.h"
#include "chrome/common/mac/app_shim.mojom-test-utils.h"


namespace chrome::mojom {
ProfileMenuItem::ProfileMenuItem()
    : name(),
      icon(),
      menu_index(),
      active(),
      profile_path() {}

ProfileMenuItem::ProfileMenuItem(
    const ::std::u16string& name_in,
    const ::gfx::ImageSkia& icon_in,
    uint32_t menu_index_in,
    bool active_in,
    const ::base::FilePath& profile_path_in)
    : name(std::move(name_in)),
      icon(std::move(icon_in)),
      menu_index(std::move(menu_index_in)),
      active(std::move(active_in)),
      profile_path(std::move(profile_path_in)) {}

ProfileMenuItem::~ProfileMenuItem() = default;

void ProfileMenuItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ImageSkia&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "menu_index"), this->menu_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active"), this->active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile_path"), this->profile_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProfileMenuItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ApplicationDockMenuItem::ApplicationDockMenuItem()
    : name(),
      url() {}

ApplicationDockMenuItem::ApplicationDockMenuItem(
    const ::std::u16string& name_in,
    const ::GURL& url_in)
    : name(std::move(name_in)),
      url(std::move(url_in)) {}

ApplicationDockMenuItem::~ApplicationDockMenuItem() = default;

void ApplicationDockMenuItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ApplicationDockMenuItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AppShimInfo::AppShimInfo()
    : profile_path(),
      app_id(),
      app_url(),
      launch_type(),
      files(),
      login_item_restore_state(),
      urls(),
      notification_action_handler() {}

AppShimInfo::AppShimInfo(
    const ::base::FilePath& profile_path_in,
    const std::string& app_id_in,
    const ::GURL& app_url_in,
    AppShimLaunchType launch_type_in,
    std::vector<::base::FilePath> files_in,
    AppShimLoginItemRestoreState login_item_restore_state_in,
    std::vector<::GURL> urls_in,
    ::mojo::PendingReceiver<::mac_notifications::mojom::MacNotificationActionHandler> notification_action_handler_in)
    : profile_path(std::move(profile_path_in)),
      app_id(std::move(app_id_in)),
      app_url(std::move(app_url_in)),
      launch_type(std::move(launch_type_in)),
      files(std::move(files_in)),
      login_item_restore_state(std::move(login_item_restore_state_in)),
      urls(std::move(urls_in)),
      notification_action_handler(std::move(notification_action_handler_in)) {}

AppShimInfo::~AppShimInfo() = default;

void AppShimInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile_path"), this->profile_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_id"), this->app_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_url"), this->app_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "launch_type"), this->launch_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AppShimLaunchType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "files"), this->files,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "login_item_restore_state"), this->login_item_restore_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AppShimLoginItemRestoreState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "urls"), this->urls,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "notification_action_handler"), this->notification_action_handler,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::mac_notifications::mojom::MacNotificationActionHandler>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AppShimInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FeatureState::FeatureState()
    : field_trial_states(),
      field_trial_params(),
      enable_features(),
      disable_features() {}

FeatureState::FeatureState(
    const std::string& field_trial_states_in,
    const std::string& field_trial_params_in,
    const std::string& enable_features_in,
    const std::string& disable_features_in)
    : field_trial_states(std::move(field_trial_states_in)),
      field_trial_params(std::move(field_trial_params_in)),
      enable_features(std::move(enable_features_in)),
      disable_features(std::move(disable_features_in)) {}

FeatureState::~FeatureState() = default;

void FeatureState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "field_trial_states"), this->field_trial_states,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "field_trial_params"), this->field_trial_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_features"), this->enable_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_features"), this->disable_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FeatureState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AppShim::IPCStableHashFunction AppShim::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AppShim>(message.name())) {
    case messages::AppShim::kCreateRemoteCocoaApplication: {
      return &AppShim::CreateRemoteCocoaApplication_Sym::IPCStableHash;
    }
    case messages::AppShim::kCreateCommandDispatcherForWidget: {
      return &AppShim::CreateCommandDispatcherForWidget_Sym::IPCStableHash;
    }
    case messages::AppShim::kSetUserAttention: {
      return &AppShim::SetUserAttention_Sym::IPCStableHash;
    }
    case messages::AppShim::kSetBadgeLabel: {
      return &AppShim::SetBadgeLabel_Sym::IPCStableHash;
    }
    case messages::AppShim::kUpdateProfileMenu: {
      return &AppShim::UpdateProfileMenu_Sym::IPCStableHash;
    }
    case messages::AppShim::kUpdateApplicationDockMenu: {
      return &AppShim::UpdateApplicationDockMenu_Sym::IPCStableHash;
    }
    case messages::AppShim::kBindNotificationProvider: {
      return &AppShim::BindNotificationProvider_Sym::IPCStableHash;
    }
    case messages::AppShim::kRequestNotificationPermission: {
      return &AppShim::RequestNotificationPermission_Sym::IPCStableHash;
    }
    case messages::AppShim::kBindChildHistogramFetcherFactory: {
      return &AppShim::BindChildHistogramFetcherFactory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AppShim::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AppShim>(message.name())) {
      case messages::AppShim::kCreateRemoteCocoaApplication:
            return "Receive chrome::mojom::AppShim::CreateRemoteCocoaApplication";
      case messages::AppShim::kCreateCommandDispatcherForWidget:
            return "Receive chrome::mojom::AppShim::CreateCommandDispatcherForWidget";
      case messages::AppShim::kSetUserAttention:
            return "Receive chrome::mojom::AppShim::SetUserAttention";
      case messages::AppShim::kSetBadgeLabel:
            return "Receive chrome::mojom::AppShim::SetBadgeLabel";
      case messages::AppShim::kUpdateProfileMenu:
            return "Receive chrome::mojom::AppShim::UpdateProfileMenu";
      case messages::AppShim::kUpdateApplicationDockMenu:
            return "Receive chrome::mojom::AppShim::UpdateApplicationDockMenu";
      case messages::AppShim::kBindNotificationProvider:
            return "Receive chrome::mojom::AppShim::BindNotificationProvider";
      case messages::AppShim::kRequestNotificationPermission:
            return "Receive chrome::mojom::AppShim::RequestNotificationPermission";
      case messages::AppShim::kBindChildHistogramFetcherFactory:
            return "Receive chrome::mojom::AppShim::BindChildHistogramFetcherFactory";
    }
  } else {
    switch (static_cast<messages::AppShim>(message.name())) {
      case messages::AppShim::kCreateRemoteCocoaApplication:
            return "Receive reply chrome::mojom::AppShim::CreateRemoteCocoaApplication";
      case messages::AppShim::kCreateCommandDispatcherForWidget:
            return "Receive reply chrome::mojom::AppShim::CreateCommandDispatcherForWidget";
      case messages::AppShim::kSetUserAttention:
            return "Receive reply chrome::mojom::AppShim::SetUserAttention";
      case messages::AppShim::kSetBadgeLabel:
            return "Receive reply chrome::mojom::AppShim::SetBadgeLabel";
      case messages::AppShim::kUpdateProfileMenu:
            return "Receive reply chrome::mojom::AppShim::UpdateProfileMenu";
      case messages::AppShim::kUpdateApplicationDockMenu:
            return "Receive reply chrome::mojom::AppShim::UpdateApplicationDockMenu";
      case messages::AppShim::kBindNotificationProvider:
            return "Receive reply chrome::mojom::AppShim::BindNotificationProvider";
      case messages::AppShim::kRequestNotificationPermission:
            return "Receive reply chrome::mojom::AppShim::RequestNotificationPermission";
      case messages::AppShim::kBindChildHistogramFetcherFactory:
            return "Receive reply chrome::mojom::AppShim::BindChildHistogramFetcherFactory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AppShim::CreateRemoteCocoaApplication_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5f4d2002;  // IPCStableHash for chrome::mojom::AppShim::CreateRemoteCocoaApplication
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShim::CreateCommandDispatcherForWidget_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b9d6bd5;  // IPCStableHash for chrome::mojom::AppShim::CreateCommandDispatcherForWidget
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShim::SetUserAttention_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb944ceed;  // IPCStableHash for chrome::mojom::AppShim::SetUserAttention
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShim::SetBadgeLabel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8eb087c6;  // IPCStableHash for chrome::mojom::AppShim::SetBadgeLabel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShim::UpdateProfileMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb732d0cc;  // IPCStableHash for chrome::mojom::AppShim::UpdateProfileMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShim::UpdateApplicationDockMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x58b91b1f;  // IPCStableHash for chrome::mojom::AppShim::UpdateApplicationDockMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShim::BindNotificationProvider_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbeee340c;  // IPCStableHash for chrome::mojom::AppShim::BindNotificationProvider
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShim::RequestNotificationPermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1cc57e95;  // IPCStableHash for chrome::mojom::AppShim::RequestNotificationPermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShim::BindChildHistogramFetcherFactory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf98d2683;  // IPCStableHash for chrome::mojom::AppShim::BindChildHistogramFetcherFactory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AppShim_RequestNotificationPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AppShim_RequestNotificationPermission_ForwardToCallback(
      AppShim::RequestNotificationPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }

  AppShim_RequestNotificationPermission_ForwardToCallback(const AppShim_RequestNotificationPermission_ForwardToCallback&) = delete;
  AppShim_RequestNotificationPermission_ForwardToCallback& operator=(const AppShim_RequestNotificationPermission_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AppShim::RequestNotificationPermissionCallback callback_;
};

AppShimProxy::AppShimProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AppShimProxy::CreateRemoteCocoaApplication(
    ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> in_application) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShim::CreateRemoteCocoaApplication", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("application"), in_application,
                        "<value of type ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShim::kCreateRemoteCocoaApplication), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShim_CreateRemoteCocoaApplication_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::remote_cocoa::mojom::ApplicationAssociatedRequestDataView>(
    in_application,
    &params->application,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->application)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid application in AppShim.CreateRemoteCocoaApplication request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShim::Name_);
  message.set_method_name("CreateRemoteCocoaApplication");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimProxy::CreateCommandDispatcherForWidget(
    uint64_t in_widget_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShim::CreateCommandDispatcherForWidget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("widget_id"), in_widget_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShim::kCreateCommandDispatcherForWidget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShim_CreateCommandDispatcherForWidget_Params_Data> params(
          message);
  params.Allocate();

  params->widget_id = in_widget_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShim::Name_);
  message.set_method_name("CreateCommandDispatcherForWidget");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimProxy::SetUserAttention(
    AppShimAttentionType in_attention_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShim::SetUserAttention", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attention_type"), in_attention_type,
                        "<value of type AppShimAttentionType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShim::kSetUserAttention), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShim_SetUserAttention_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::chrome::mojom::AppShimAttentionType>(
    in_attention_type,
    &params->attention_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShim::Name_);
  message.set_method_name("SetUserAttention");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimProxy::SetBadgeLabel(
    const std::string& in_badge_label) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShim::SetBadgeLabel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("badge_label"), in_badge_label,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShim::kSetBadgeLabel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShim_SetBadgeLabel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->badge_label)::BaseType> badge_label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_badge_label,
    badge_label_fragment);

  params->badge_label.Set(
      badge_label_fragment.is_null() ? nullptr : badge_label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->badge_label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null badge_label in AppShim.SetBadgeLabel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShim::Name_);
  message.set_method_name("SetBadgeLabel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimProxy::UpdateProfileMenu(
    std::vector<ProfileMenuItemPtr> in_profile_menu_items) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShim::UpdateProfileMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile_menu_items"), in_profile_menu_items,
                        "<value of type std::vector<ProfileMenuItemPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShim::kUpdateProfileMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShim_UpdateProfileMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile_menu_items)::BaseType>
      profile_menu_items_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& profile_menu_items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::chrome::mojom::ProfileMenuItemDataView>>(
    in_profile_menu_items,
    profile_menu_items_fragment,
    &profile_menu_items_validate_params);

  params->profile_menu_items.Set(
      profile_menu_items_fragment.is_null() ? nullptr : profile_menu_items_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->profile_menu_items.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null profile_menu_items in AppShim.UpdateProfileMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShim::Name_);
  message.set_method_name("UpdateProfileMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimProxy::UpdateApplicationDockMenu(
    std::vector<ApplicationDockMenuItemPtr> in_dock_menu_items) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShim::UpdateApplicationDockMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dock_menu_items"), in_dock_menu_items,
                        "<value of type std::vector<ApplicationDockMenuItemPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShim::kUpdateApplicationDockMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShim_UpdateApplicationDockMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dock_menu_items)::BaseType>
      dock_menu_items_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& dock_menu_items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::chrome::mojom::ApplicationDockMenuItemDataView>>(
    in_dock_menu_items,
    dock_menu_items_fragment,
    &dock_menu_items_validate_params);

  params->dock_menu_items.Set(
      dock_menu_items_fragment.is_null() ? nullptr : dock_menu_items_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dock_menu_items.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dock_menu_items in AppShim.UpdateApplicationDockMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShim::Name_);
  message.set_method_name("UpdateApplicationDockMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimProxy::BindNotificationProvider(
    ::mojo::PendingReceiver<::mac_notifications::mojom::MacNotificationProvider> in_provider) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShim::BindNotificationProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("provider"), in_provider,
                        "<value of type ::mojo::PendingReceiver<::mac_notifications::mojom::MacNotificationProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShim::kBindNotificationProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShim_BindNotificationProvider_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::mac_notifications::mojom::MacNotificationProviderInterfaceBase>>(
    in_provider,
    &params->provider,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->provider)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid provider in AppShim.BindNotificationProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShim::Name_);
  message.set_method_name("BindNotificationProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimProxy::RequestNotificationPermission(
    RequestNotificationPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::AppShim::RequestNotificationPermission");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShim::kRequestNotificationPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShim_RequestNotificationPermission_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShim::Name_);
  message.set_method_name("RequestNotificationPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AppShim_RequestNotificationPermission_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AppShimProxy::BindChildHistogramFetcherFactory(
    ::mojo::PendingReceiver<::metrics::mojom::ChildHistogramFetcherFactory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShim::BindChildHistogramFetcherFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::metrics::mojom::ChildHistogramFetcherFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShim::kBindChildHistogramFetcherFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShim_BindChildHistogramFetcherFactory_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::metrics::mojom::ChildHistogramFetcherFactoryInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in AppShim.BindChildHistogramFetcherFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShim::Name_);
  message.set_method_name("BindChildHistogramFetcherFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class AppShim_RequestNotificationPermission_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AppShim::RequestNotificationPermissionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AppShim_RequestNotificationPermission_ProxyToResponder> proxy(
        new AppShim_RequestNotificationPermission_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AppShim_RequestNotificationPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AppShim_RequestNotificationPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AppShim_RequestNotificationPermission_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AppShim::RequestNotificationPermissionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mac_notifications::mojom::RequestPermissionResult in_result);
};

bool AppShim_RequestNotificationPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AppShim_RequestNotificationPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AppShim_RequestNotificationPermission_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AppShim.7
  bool success = true;
  ::mac_notifications::mojom::RequestPermissionResult p_result{};
  AppShim_RequestNotificationPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AppShim::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void AppShim_RequestNotificationPermission_ProxyToResponder::Run(
    ::mac_notifications::mojom::RequestPermissionResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::AppShim::RequestNotificationPermission", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::mac_notifications::mojom::RequestPermissionResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShim::kRequestNotificationPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShim_RequestNotificationPermission_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mac_notifications::mojom::RequestPermissionResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShim::Name_);
  message.set_method_name("RequestNotificationPermission");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AppShimStubDispatch::Accept(
    AppShim* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AppShim>(message->header()->name)) {
    case messages::AppShim::kCreateRemoteCocoaApplication: {
      DCHECK(message->is_serialized());
      internal::AppShim_CreateRemoteCocoaApplication_Params_Data* params =
          reinterpret_cast<internal::AppShim_CreateRemoteCocoaApplication_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShim.0
      bool success = true;
      ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> p_application{};
      AppShim_CreateRemoteCocoaApplication_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_application =
            input_data_view.TakeApplication<decltype(p_application)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShim::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRemoteCocoaApplication(        
        std::move(p_application));
      return true;
    }
    case messages::AppShim::kCreateCommandDispatcherForWidget: {
      DCHECK(message->is_serialized());
      internal::AppShim_CreateCommandDispatcherForWidget_Params_Data* params =
          reinterpret_cast<internal::AppShim_CreateCommandDispatcherForWidget_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShim.1
      bool success = true;
      uint64_t p_widget_id{};
      AppShim_CreateCommandDispatcherForWidget_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_widget_id = input_data_view.widget_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShim::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCommandDispatcherForWidget(        
        std::move(p_widget_id));
      return true;
    }
    case messages::AppShim::kSetUserAttention: {
      DCHECK(message->is_serialized());
      internal::AppShim_SetUserAttention_Params_Data* params =
          reinterpret_cast<internal::AppShim_SetUserAttention_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShim.2
      bool success = true;
      AppShimAttentionType p_attention_type{};
      AppShim_SetUserAttention_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAttentionType(&p_attention_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShim::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserAttention(        
        std::move(p_attention_type));
      return true;
    }
    case messages::AppShim::kSetBadgeLabel: {
      DCHECK(message->is_serialized());
      internal::AppShim_SetBadgeLabel_Params_Data* params =
          reinterpret_cast<internal::AppShim_SetBadgeLabel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShim.3
      bool success = true;
      std::string p_badge_label{};
      AppShim_SetBadgeLabel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBadgeLabel(&p_badge_label))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShim::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBadgeLabel(        
        std::move(p_badge_label));
      return true;
    }
    case messages::AppShim::kUpdateProfileMenu: {
      DCHECK(message->is_serialized());
      internal::AppShim_UpdateProfileMenu_Params_Data* params =
          reinterpret_cast<internal::AppShim_UpdateProfileMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShim.4
      bool success = true;
      std::vector<ProfileMenuItemPtr> p_profile_menu_items{};
      AppShim_UpdateProfileMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProfileMenuItems(&p_profile_menu_items))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShim::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateProfileMenu(        
        std::move(p_profile_menu_items));
      return true;
    }
    case messages::AppShim::kUpdateApplicationDockMenu: {
      DCHECK(message->is_serialized());
      internal::AppShim_UpdateApplicationDockMenu_Params_Data* params =
          reinterpret_cast<internal::AppShim_UpdateApplicationDockMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShim.5
      bool success = true;
      std::vector<ApplicationDockMenuItemPtr> p_dock_menu_items{};
      AppShim_UpdateApplicationDockMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDockMenuItems(&p_dock_menu_items))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShim::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateApplicationDockMenu(        
        std::move(p_dock_menu_items));
      return true;
    }
    case messages::AppShim::kBindNotificationProvider: {
      DCHECK(message->is_serialized());
      internal::AppShim_BindNotificationProvider_Params_Data* params =
          reinterpret_cast<internal::AppShim_BindNotificationProvider_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShim.6
      bool success = true;
      ::mojo::PendingReceiver<::mac_notifications::mojom::MacNotificationProvider> p_provider{};
      AppShim_BindNotificationProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_provider =
            input_data_view.TakeProvider<decltype(p_provider)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShim::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindNotificationProvider(        
        std::move(p_provider));
      return true;
    }
    case messages::AppShim::kRequestNotificationPermission: {
      break;
    }
    case messages::AppShim::kBindChildHistogramFetcherFactory: {
      DCHECK(message->is_serialized());
      internal::AppShim_BindChildHistogramFetcherFactory_Params_Data* params =
          reinterpret_cast<internal::AppShim_BindChildHistogramFetcherFactory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShim.8
      bool success = true;
      ::mojo::PendingReceiver<::metrics::mojom::ChildHistogramFetcherFactory> p_receiver{};
      AppShim_BindChildHistogramFetcherFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShim::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindChildHistogramFetcherFactory(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool AppShimStubDispatch::AcceptWithResponder(
    AppShim* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AppShim>(message->header()->name)) {
    case messages::AppShim::kCreateRemoteCocoaApplication: {
      break;
    }
    case messages::AppShim::kCreateCommandDispatcherForWidget: {
      break;
    }
    case messages::AppShim::kSetUserAttention: {
      break;
    }
    case messages::AppShim::kSetBadgeLabel: {
      break;
    }
    case messages::AppShim::kUpdateProfileMenu: {
      break;
    }
    case messages::AppShim::kUpdateApplicationDockMenu: {
      break;
    }
    case messages::AppShim::kBindNotificationProvider: {
      break;
    }
    case messages::AppShim::kRequestNotificationPermission: {
      internal::AppShim_RequestNotificationPermission_Params_Data* params =
          reinterpret_cast<
              internal::AppShim_RequestNotificationPermission_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AppShim.7
      bool success = true;
      AppShim_RequestNotificationPermission_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShim::Name_, 7, false);
        return false;
      }
      auto callback =
          AppShim_RequestNotificationPermission_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNotificationPermission(std::move(callback));
      return true;
    }
    case messages::AppShim::kBindChildHistogramFetcherFactory: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAppShimValidationInfo[] = {
    { &internal::AppShim_CreateRemoteCocoaApplication_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShim_CreateCommandDispatcherForWidget_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShim_SetUserAttention_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShim_SetBadgeLabel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShim_UpdateProfileMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShim_UpdateApplicationDockMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShim_BindNotificationProvider_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShim_RequestNotificationPermission_Params_Data::Validate,
     &internal::AppShim_RequestNotificationPermission_ResponseParams_Data::Validate},
    { &internal::AppShim_BindChildHistogramFetcherFactory_Params_Data::Validate,
     nullptr /* no response */},
};

bool AppShimRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::AppShim::Name_,
    kAppShimValidationInfo);
}

bool AppShimResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::AppShim::Name_,
    kAppShimValidationInfo);
}
// The declaration includes the definition on other builds.

AppShimHost::IPCStableHashFunction AppShimHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AppShimHost>(message.name())) {
    case messages::AppShimHost::kFocusApp: {
      return &AppShimHost::FocusApp_Sym::IPCStableHash;
    }
    case messages::AppShimHost::kReopenApp: {
      return &AppShimHost::ReopenApp_Sym::IPCStableHash;
    }
    case messages::AppShimHost::kFilesOpened: {
      return &AppShimHost::FilesOpened_Sym::IPCStableHash;
    }
    case messages::AppShimHost::kProfileSelectedFromMenu: {
      return &AppShimHost::ProfileSelectedFromMenu_Sym::IPCStableHash;
    }
    case messages::AppShimHost::kOpenAppSettings: {
      return &AppShimHost::OpenAppSettings_Sym::IPCStableHash;
    }
    case messages::AppShimHost::kUrlsOpened: {
      return &AppShimHost::UrlsOpened_Sym::IPCStableHash;
    }
    case messages::AppShimHost::kOpenAppWithOverrideUrl: {
      return &AppShimHost::OpenAppWithOverrideUrl_Sym::IPCStableHash;
    }
    case messages::AppShimHost::kEnableAccessibilitySupport: {
      return &AppShimHost::EnableAccessibilitySupport_Sym::IPCStableHash;
    }
    case messages::AppShimHost::kApplicationWillTerminate: {
      return &AppShimHost::ApplicationWillTerminate_Sym::IPCStableHash;
    }
    case messages::AppShimHost::kNotificationPermissionStatusChanged: {
      return &AppShimHost::NotificationPermissionStatusChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AppShimHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AppShimHost>(message.name())) {
      case messages::AppShimHost::kFocusApp:
            return "Receive chrome::mojom::AppShimHost::FocusApp";
      case messages::AppShimHost::kReopenApp:
            return "Receive chrome::mojom::AppShimHost::ReopenApp";
      case messages::AppShimHost::kFilesOpened:
            return "Receive chrome::mojom::AppShimHost::FilesOpened";
      case messages::AppShimHost::kProfileSelectedFromMenu:
            return "Receive chrome::mojom::AppShimHost::ProfileSelectedFromMenu";
      case messages::AppShimHost::kOpenAppSettings:
            return "Receive chrome::mojom::AppShimHost::OpenAppSettings";
      case messages::AppShimHost::kUrlsOpened:
            return "Receive chrome::mojom::AppShimHost::UrlsOpened";
      case messages::AppShimHost::kOpenAppWithOverrideUrl:
            return "Receive chrome::mojom::AppShimHost::OpenAppWithOverrideUrl";
      case messages::AppShimHost::kEnableAccessibilitySupport:
            return "Receive chrome::mojom::AppShimHost::EnableAccessibilitySupport";
      case messages::AppShimHost::kApplicationWillTerminate:
            return "Receive chrome::mojom::AppShimHost::ApplicationWillTerminate";
      case messages::AppShimHost::kNotificationPermissionStatusChanged:
            return "Receive chrome::mojom::AppShimHost::NotificationPermissionStatusChanged";
    }
  } else {
    switch (static_cast<messages::AppShimHost>(message.name())) {
      case messages::AppShimHost::kFocusApp:
            return "Receive reply chrome::mojom::AppShimHost::FocusApp";
      case messages::AppShimHost::kReopenApp:
            return "Receive reply chrome::mojom::AppShimHost::ReopenApp";
      case messages::AppShimHost::kFilesOpened:
            return "Receive reply chrome::mojom::AppShimHost::FilesOpened";
      case messages::AppShimHost::kProfileSelectedFromMenu:
            return "Receive reply chrome::mojom::AppShimHost::ProfileSelectedFromMenu";
      case messages::AppShimHost::kOpenAppSettings:
            return "Receive reply chrome::mojom::AppShimHost::OpenAppSettings";
      case messages::AppShimHost::kUrlsOpened:
            return "Receive reply chrome::mojom::AppShimHost::UrlsOpened";
      case messages::AppShimHost::kOpenAppWithOverrideUrl:
            return "Receive reply chrome::mojom::AppShimHost::OpenAppWithOverrideUrl";
      case messages::AppShimHost::kEnableAccessibilitySupport:
            return "Receive reply chrome::mojom::AppShimHost::EnableAccessibilitySupport";
      case messages::AppShimHost::kApplicationWillTerminate:
            return "Receive reply chrome::mojom::AppShimHost::ApplicationWillTerminate";
      case messages::AppShimHost::kNotificationPermissionStatusChanged:
            return "Receive reply chrome::mojom::AppShimHost::NotificationPermissionStatusChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AppShimHost::FocusApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x874e298c;  // IPCStableHash for chrome::mojom::AppShimHost::FocusApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShimHost::ReopenApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7be23ee1;  // IPCStableHash for chrome::mojom::AppShimHost::ReopenApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShimHost::FilesOpened_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb0f53f86;  // IPCStableHash for chrome::mojom::AppShimHost::FilesOpened
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShimHost::ProfileSelectedFromMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x213f4749;  // IPCStableHash for chrome::mojom::AppShimHost::ProfileSelectedFromMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShimHost::OpenAppSettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7ebeb2d;  // IPCStableHash for chrome::mojom::AppShimHost::OpenAppSettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShimHost::UrlsOpened_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcfa3432f;  // IPCStableHash for chrome::mojom::AppShimHost::UrlsOpened
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShimHost::OpenAppWithOverrideUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaf275fe9;  // IPCStableHash for chrome::mojom::AppShimHost::OpenAppWithOverrideUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShimHost::EnableAccessibilitySupport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb2d1386a;  // IPCStableHash for chrome::mojom::AppShimHost::EnableAccessibilitySupport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShimHost::ApplicationWillTerminate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5f4bc396;  // IPCStableHash for chrome::mojom::AppShimHost::ApplicationWillTerminate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AppShimHost::NotificationPermissionStatusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x877a627d;  // IPCStableHash for chrome::mojom::AppShimHost::NotificationPermissionStatusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AppShimHostProxy::AppShimHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AppShimHostProxy::FocusApp(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::AppShimHost::FocusApp");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHost::kFocusApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHost_FocusApp_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHost::Name_);
  message.set_method_name("FocusApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimHostProxy::ReopenApp(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::AppShimHost::ReopenApp");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHost::kReopenApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHost_ReopenApp_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHost::Name_);
  message.set_method_name("ReopenApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimHostProxy::FilesOpened(
    const std::vector<::base::FilePath>& in_files) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShimHost::FilesOpened", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("files"), in_files,
                        "<value of type const std::vector<::base::FilePath>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHost::kFilesOpened), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHost_FilesOpened_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->files)::BaseType>
      files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
    in_files,
    files_fragment,
    &files_validate_params);

  params->files.Set(
      files_fragment.is_null() ? nullptr : files_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->files.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null files in AppShimHost.FilesOpened request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHost::Name_);
  message.set_method_name("FilesOpened");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimHostProxy::ProfileSelectedFromMenu(
    const ::base::FilePath& in_profile_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShimHost::ProfileSelectedFromMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile_path"), in_profile_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHost::kProfileSelectedFromMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHost_ProfileSelectedFromMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile_path)::BaseType> profile_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_profile_path,
    profile_path_fragment);

  params->profile_path.Set(
      profile_path_fragment.is_null() ? nullptr : profile_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->profile_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null profile_path in AppShimHost.ProfileSelectedFromMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHost::Name_);
  message.set_method_name("ProfileSelectedFromMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimHostProxy::OpenAppSettings(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::AppShimHost::OpenAppSettings");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHost::kOpenAppSettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHost_OpenAppSettings_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHost::Name_);
  message.set_method_name("OpenAppSettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimHostProxy::UrlsOpened(
    const std::vector<::GURL>& in_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShimHost::UrlsOpened", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHost::kUrlsOpened), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHost_UrlsOpened_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_urls,
    urls_fragment,
    &urls_validate_params);

  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null urls in AppShimHost.UrlsOpened request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHost::Name_);
  message.set_method_name("UrlsOpened");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimHostProxy::OpenAppWithOverrideUrl(
    const ::GURL& in_override_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShimHost::OpenAppWithOverrideUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("override_url"), in_override_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHost::kOpenAppWithOverrideUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHost_OpenAppWithOverrideUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->override_url)::BaseType> override_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_override_url,
    override_url_fragment);

  params->override_url.Set(
      override_url_fragment.is_null() ? nullptr : override_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->override_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null override_url in AppShimHost.OpenAppWithOverrideUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHost::Name_);
  message.set_method_name("OpenAppWithOverrideUrl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimHostProxy::EnableAccessibilitySupport(
    AppShimScreenReaderSupportMode in_mode) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShimHost::EnableAccessibilitySupport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type AppShimScreenReaderSupportMode>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHost::kEnableAccessibilitySupport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHost_EnableAccessibilitySupport_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::chrome::mojom::AppShimScreenReaderSupportMode>(
    in_mode,
    &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHost::Name_);
  message.set_method_name("EnableAccessibilitySupport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimHostProxy::ApplicationWillTerminate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::AppShimHost::ApplicationWillTerminate");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHost::kApplicationWillTerminate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHost_ApplicationWillTerminate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHost::Name_);
  message.set_method_name("ApplicationWillTerminate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AppShimHostProxy::NotificationPermissionStatusChanged(
    ::mac_notifications::mojom::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShimHost::NotificationPermissionStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::mac_notifications::mojom::PermissionStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHost::kNotificationPermissionStatusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHost_NotificationPermissionStatusChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mac_notifications::mojom::PermissionStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHost::Name_);
  message.set_method_name("NotificationPermissionStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AppShimHostStubDispatch::Accept(
    AppShimHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AppShimHost>(message->header()->name)) {
    case messages::AppShimHost::kFocusApp: {
      DCHECK(message->is_serialized());
      internal::AppShimHost_FocusApp_Params_Data* params =
          reinterpret_cast<internal::AppShimHost_FocusApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShimHost.0
      bool success = true;
      AppShimHost_FocusApp_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShimHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusApp(        );
      return true;
    }
    case messages::AppShimHost::kReopenApp: {
      DCHECK(message->is_serialized());
      internal::AppShimHost_ReopenApp_Params_Data* params =
          reinterpret_cast<internal::AppShimHost_ReopenApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShimHost.1
      bool success = true;
      AppShimHost_ReopenApp_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShimHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReopenApp(        );
      return true;
    }
    case messages::AppShimHost::kFilesOpened: {
      DCHECK(message->is_serialized());
      internal::AppShimHost_FilesOpened_Params_Data* params =
          reinterpret_cast<internal::AppShimHost_FilesOpened_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShimHost.2
      bool success = true;
      std::vector<::base::FilePath> p_files{};
      AppShimHost_FilesOpened_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFiles(&p_files))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShimHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FilesOpened(        
        std::move(p_files));
      return true;
    }
    case messages::AppShimHost::kProfileSelectedFromMenu: {
      DCHECK(message->is_serialized());
      internal::AppShimHost_ProfileSelectedFromMenu_Params_Data* params =
          reinterpret_cast<internal::AppShimHost_ProfileSelectedFromMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShimHost.3
      bool success = true;
      ::base::FilePath p_profile_path{};
      AppShimHost_ProfileSelectedFromMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProfilePath(&p_profile_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShimHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProfileSelectedFromMenu(        
        std::move(p_profile_path));
      return true;
    }
    case messages::AppShimHost::kOpenAppSettings: {
      DCHECK(message->is_serialized());
      internal::AppShimHost_OpenAppSettings_Params_Data* params =
          reinterpret_cast<internal::AppShimHost_OpenAppSettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShimHost.4
      bool success = true;
      AppShimHost_OpenAppSettings_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShimHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenAppSettings(        );
      return true;
    }
    case messages::AppShimHost::kUrlsOpened: {
      DCHECK(message->is_serialized());
      internal::AppShimHost_UrlsOpened_Params_Data* params =
          reinterpret_cast<internal::AppShimHost_UrlsOpened_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShimHost.5
      bool success = true;
      std::vector<::GURL> p_urls{};
      AppShimHost_UrlsOpened_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShimHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UrlsOpened(        
        std::move(p_urls));
      return true;
    }
    case messages::AppShimHost::kOpenAppWithOverrideUrl: {
      DCHECK(message->is_serialized());
      internal::AppShimHost_OpenAppWithOverrideUrl_Params_Data* params =
          reinterpret_cast<internal::AppShimHost_OpenAppWithOverrideUrl_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShimHost.6
      bool success = true;
      ::GURL p_override_url{};
      AppShimHost_OpenAppWithOverrideUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOverrideUrl(&p_override_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShimHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenAppWithOverrideUrl(        
        std::move(p_override_url));
      return true;
    }
    case messages::AppShimHost::kEnableAccessibilitySupport: {
      DCHECK(message->is_serialized());
      internal::AppShimHost_EnableAccessibilitySupport_Params_Data* params =
          reinterpret_cast<internal::AppShimHost_EnableAccessibilitySupport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShimHost.7
      bool success = true;
      AppShimScreenReaderSupportMode p_mode{};
      AppShimHost_EnableAccessibilitySupport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShimHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableAccessibilitySupport(        
        std::move(p_mode));
      return true;
    }
    case messages::AppShimHost::kApplicationWillTerminate: {
      DCHECK(message->is_serialized());
      internal::AppShimHost_ApplicationWillTerminate_Params_Data* params =
          reinterpret_cast<internal::AppShimHost_ApplicationWillTerminate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShimHost.8
      bool success = true;
      AppShimHost_ApplicationWillTerminate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShimHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplicationWillTerminate(        );
      return true;
    }
    case messages::AppShimHost::kNotificationPermissionStatusChanged: {
      DCHECK(message->is_serialized());
      internal::AppShimHost_NotificationPermissionStatusChanged_Params_Data* params =
          reinterpret_cast<internal::AppShimHost_NotificationPermissionStatusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AppShimHost.9
      bool success = true;
      ::mac_notifications::mojom::PermissionStatus p_status{};
      AppShimHost_NotificationPermissionStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShimHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotificationPermissionStatusChanged(        
        std::move(p_status));
      return true;
    }
  }
  return false;
}

// static
bool AppShimHostStubDispatch::AcceptWithResponder(
    AppShimHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AppShimHost>(message->header()->name)) {
    case messages::AppShimHost::kFocusApp: {
      break;
    }
    case messages::AppShimHost::kReopenApp: {
      break;
    }
    case messages::AppShimHost::kFilesOpened: {
      break;
    }
    case messages::AppShimHost::kProfileSelectedFromMenu: {
      break;
    }
    case messages::AppShimHost::kOpenAppSettings: {
      break;
    }
    case messages::AppShimHost::kUrlsOpened: {
      break;
    }
    case messages::AppShimHost::kOpenAppWithOverrideUrl: {
      break;
    }
    case messages::AppShimHost::kEnableAccessibilitySupport: {
      break;
    }
    case messages::AppShimHost::kApplicationWillTerminate: {
      break;
    }
    case messages::AppShimHost::kNotificationPermissionStatusChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAppShimHostValidationInfo[] = {
    { &internal::AppShimHost_FocusApp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShimHost_ReopenApp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShimHost_FilesOpened_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShimHost_ProfileSelectedFromMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShimHost_OpenAppSettings_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShimHost_UrlsOpened_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShimHost_OpenAppWithOverrideUrl_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShimHost_EnableAccessibilitySupport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShimHost_ApplicationWillTerminate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AppShimHost_NotificationPermissionStatusChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool AppShimHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::AppShimHost::Name_,
    kAppShimHostValidationInfo);
}

// The declaration includes the definition on other builds.

AppShimHostBootstrap::IPCStableHashFunction AppShimHostBootstrap::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AppShimHostBootstrap>(message.name())) {
    case messages::AppShimHostBootstrap::kOnShimConnected: {
      return &AppShimHostBootstrap::OnShimConnected_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AppShimHostBootstrap::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AppShimHostBootstrap>(message.name())) {
      case messages::AppShimHostBootstrap::kOnShimConnected:
            return "Receive chrome::mojom::AppShimHostBootstrap::OnShimConnected";
    }
  } else {
    switch (static_cast<messages::AppShimHostBootstrap>(message.name())) {
      case messages::AppShimHostBootstrap::kOnShimConnected:
            return "Receive reply chrome::mojom::AppShimHostBootstrap::OnShimConnected";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AppShimHostBootstrap::OnShimConnected_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3cb75ec7;  // IPCStableHash for chrome::mojom::AppShimHostBootstrap::OnShimConnected
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AppShimHostBootstrap_OnShimConnected_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AppShimHostBootstrap_OnShimConnected_ForwardToCallback(
      AppShimHostBootstrap::OnShimConnectedCallback callback
      ) : callback_(std::move(callback)) {
  }

  AppShimHostBootstrap_OnShimConnected_ForwardToCallback(const AppShimHostBootstrap_OnShimConnected_ForwardToCallback&) = delete;
  AppShimHostBootstrap_OnShimConnected_ForwardToCallback& operator=(const AppShimHostBootstrap_OnShimConnected_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AppShimHostBootstrap::OnShimConnectedCallback callback_;
};

AppShimHostBootstrapProxy::AppShimHostBootstrapProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AppShimHostBootstrapProxy::OnShimConnected(
    ::mojo::PendingReceiver<AppShimHost> in_host_receiver, AppShimInfoPtr in_app_shim_info, OnShimConnectedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::AppShimHostBootstrap::OnShimConnected", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_receiver"), in_host_receiver,
                        "<value of type ::mojo::PendingReceiver<AppShimHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_shim_info"), in_app_shim_info,
                        "<value of type AppShimInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHostBootstrap::kOnShimConnected), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHostBootstrap_OnShimConnected_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::chrome::mojom::AppShimHostInterfaceBase>>(
    in_host_receiver,
    &params->host_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host_receiver in AppShimHostBootstrap.OnShimConnected request");
  mojo::internal::MessageFragment<
      typename decltype(params->app_shim_info)::BaseType> app_shim_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::AppShimInfoDataView>(
    in_app_shim_info,
    app_shim_info_fragment);

  params->app_shim_info.Set(
      app_shim_info_fragment.is_null() ? nullptr : app_shim_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_shim_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_shim_info in AppShimHostBootstrap.OnShimConnected request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHostBootstrap::Name_);
  message.set_method_name("OnShimConnected");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AppShimHostBootstrap_OnShimConnected_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AppShimHostBootstrap_OnShimConnected_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AppShimHostBootstrap::OnShimConnectedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AppShimHostBootstrap_OnShimConnected_ProxyToResponder> proxy(
        new AppShimHostBootstrap_OnShimConnected_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AppShimHostBootstrap_OnShimConnected_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AppShimHostBootstrap_OnShimConnected_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AppShimHostBootstrap_OnShimConnected_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AppShimHostBootstrap::OnShimConnectedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      AppShimLaunchResult in_launch_result, ::variations::VariationsCommandLine in_feature_state, ::mojo::PendingReceiver<AppShim> in_app_shim_receiver);
};

bool AppShimHostBootstrap_OnShimConnected_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AppShimHostBootstrap_OnShimConnected_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AppShimHostBootstrap_OnShimConnected_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AppShimHostBootstrap.0
  bool success = true;
  AppShimLaunchResult p_launch_result{};
  ::variations::VariationsCommandLine p_feature_state{};
  ::mojo::PendingReceiver<AppShim> p_app_shim_receiver{};
  AppShimHostBootstrap_OnShimConnected_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadLaunchResult(&p_launch_result))
    success = false;
  if (success && !input_data_view.ReadFeatureState(&p_feature_state))
    success = false;
  if (success) {
    p_app_shim_receiver =
        input_data_view.TakeAppShimReceiver<decltype(p_app_shim_receiver)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AppShimHostBootstrap::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_launch_result), 
std::move(p_feature_state), 
std::move(p_app_shim_receiver));
  }
  return true;
}

void AppShimHostBootstrap_OnShimConnected_ProxyToResponder::Run(
    AppShimLaunchResult in_launch_result, ::variations::VariationsCommandLine in_feature_state, ::mojo::PendingReceiver<AppShim> in_app_shim_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::AppShimHostBootstrap::OnShimConnected", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("launch_result"), in_launch_result,
                        "<value of type AppShimLaunchResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature_state"), in_feature_state,
                        "<value of type ::variations::VariationsCommandLine>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_shim_receiver"), in_app_shim_receiver,
                        "<value of type ::mojo::PendingReceiver<AppShim>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppShimHostBootstrap::kOnShimConnected), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::AppShimHostBootstrap_OnShimConnected_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::chrome::mojom::AppShimLaunchResult>(
    in_launch_result,
    &params->launch_result);
  mojo::internal::MessageFragment<
      typename decltype(params->feature_state)::BaseType> feature_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::chrome::mojom::FeatureStateDataView>(
    in_feature_state,
    feature_state_fragment);

  params->feature_state.Set(
      feature_state_fragment.is_null() ? nullptr : feature_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->feature_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null feature_state in ");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::chrome::mojom::AppShimInterfaceBase>>(
    in_app_shim_receiver,
    &params->app_shim_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->app_shim_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid app_shim_receiver in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppShimHostBootstrap::Name_);
  message.set_method_name("OnShimConnected");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AppShimHostBootstrapStubDispatch::Accept(
    AppShimHostBootstrap* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AppShimHostBootstrap>(message->header()->name)) {
    case messages::AppShimHostBootstrap::kOnShimConnected: {
      break;
    }
  }
  return false;
}

// static
bool AppShimHostBootstrapStubDispatch::AcceptWithResponder(
    AppShimHostBootstrap* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AppShimHostBootstrap>(message->header()->name)) {
    case messages::AppShimHostBootstrap::kOnShimConnected: {
      internal::AppShimHostBootstrap_OnShimConnected_Params_Data* params =
          reinterpret_cast<
              internal::AppShimHostBootstrap_OnShimConnected_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AppShimHostBootstrap.0
      bool success = true;
      ::mojo::PendingReceiver<AppShimHost> p_host_receiver{};
      AppShimInfoPtr p_app_shim_info{};
      AppShimHostBootstrap_OnShimConnected_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_host_receiver =
            input_data_view.TakeHostReceiver<decltype(p_host_receiver)>();
      }
      if (success && !input_data_view.ReadAppShimInfo(&p_app_shim_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppShimHostBootstrap::Name_, 0, false);
        return false;
      }
      auto callback =
          AppShimHostBootstrap_OnShimConnected_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnShimConnected(        
        std::move(p_host_receiver), 
        std::move(p_app_shim_info), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAppShimHostBootstrapValidationInfo[] = {
    { &internal::AppShimHostBootstrap_OnShimConnected_Params_Data::Validate,
     &internal::AppShimHostBootstrap_OnShimConnected_ResponseParams_Data::Validate},
};

bool AppShimHostBootstrapRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::AppShimHostBootstrap::Name_,
    kAppShimHostBootstrapValidationInfo);
}

bool AppShimHostBootstrapResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::AppShimHostBootstrap::Name_,
    kAppShimHostBootstrapValidationInfo);
}


}  // chrome::mojom


namespace mojo {


// static
bool StructTraits<::chrome::mojom::ProfileMenuItem::DataView, ::chrome::mojom::ProfileMenuItemPtr>::Read(
    ::chrome::mojom::ProfileMenuItem::DataView input,
    ::chrome::mojom::ProfileMenuItemPtr* output) {
  bool success = true;
  ::chrome::mojom::ProfileMenuItemPtr result(::chrome::mojom::ProfileMenuItem::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
      if (success)
        result->menu_index = input.menu_index();
      if (success)
        result->active = input.active();
      if (success && !input.ReadProfilePath(&result->profile_path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::chrome::mojom::ApplicationDockMenuItem::DataView, ::chrome::mojom::ApplicationDockMenuItemPtr>::Read(
    ::chrome::mojom::ApplicationDockMenuItem::DataView input,
    ::chrome::mojom::ApplicationDockMenuItemPtr* output) {
  bool success = true;
  ::chrome::mojom::ApplicationDockMenuItemPtr result(::chrome::mojom::ApplicationDockMenuItem::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::chrome::mojom::AppShimInfo::DataView, ::chrome::mojom::AppShimInfoPtr>::Read(
    ::chrome::mojom::AppShimInfo::DataView input,
    ::chrome::mojom::AppShimInfoPtr* output) {
  bool success = true;
  ::chrome::mojom::AppShimInfoPtr result(::chrome::mojom::AppShimInfo::New());
  
      if (success && !input.ReadProfilePath(&result->profile_path))
        success = false;
      if (success && !input.ReadAppId(&result->app_id))
        success = false;
      if (success && !input.ReadAppUrl(&result->app_url))
        success = false;
      if (success && !input.ReadLaunchType(&result->launch_type))
        success = false;
      if (success && !input.ReadFiles(&result->files))
        success = false;
      if (success && !input.ReadLoginItemRestoreState(&result->login_item_restore_state))
        success = false;
      if (success && !input.ReadUrls(&result->urls))
        success = false;
      if (success) {
        result->notification_action_handler =
            input.TakeNotificationActionHandler<decltype(result->notification_action_handler)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::chrome::mojom::FeatureState::DataView, ::chrome::mojom::FeatureStatePtr>::Read(
    ::chrome::mojom::FeatureState::DataView input,
    ::chrome::mojom::FeatureStatePtr* output) {
  bool success = true;
  ::chrome::mojom::FeatureStatePtr result(::chrome::mojom::FeatureState::New());
  
      if (success && !input.ReadFieldTrialStates(&result->field_trial_states))
        success = false;
      if (success && !input.ReadFieldTrialParams(&result->field_trial_params))
        success = false;
      if (success && !input.ReadEnableFeatures(&result->enable_features))
        success = false;
      if (success && !input.ReadDisableFeatures(&result->disable_features))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void AppShimInterceptorForTesting::CreateRemoteCocoaApplication(::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> application) {
  GetForwardingInterface()->CreateRemoteCocoaApplication(
    std::move(application)
    );
}
void AppShimInterceptorForTesting::CreateCommandDispatcherForWidget(uint64_t widget_id) {
  GetForwardingInterface()->CreateCommandDispatcherForWidget(
    std::move(widget_id)
    );
}
void AppShimInterceptorForTesting::SetUserAttention(AppShimAttentionType attention_type) {
  GetForwardingInterface()->SetUserAttention(
    std::move(attention_type)
    );
}
void AppShimInterceptorForTesting::SetBadgeLabel(const std::string& badge_label) {
  GetForwardingInterface()->SetBadgeLabel(
    std::move(badge_label)
    );
}
void AppShimInterceptorForTesting::UpdateProfileMenu(std::vector<ProfileMenuItemPtr> profile_menu_items) {
  GetForwardingInterface()->UpdateProfileMenu(
    std::move(profile_menu_items)
    );
}
void AppShimInterceptorForTesting::UpdateApplicationDockMenu(std::vector<ApplicationDockMenuItemPtr> dock_menu_items) {
  GetForwardingInterface()->UpdateApplicationDockMenu(
    std::move(dock_menu_items)
    );
}
void AppShimInterceptorForTesting::BindNotificationProvider(::mojo::PendingReceiver<::mac_notifications::mojom::MacNotificationProvider> provider) {
  GetForwardingInterface()->BindNotificationProvider(
    std::move(provider)
    );
}
void AppShimInterceptorForTesting::RequestNotificationPermission(RequestNotificationPermissionCallback callback) {
  GetForwardingInterface()->RequestNotificationPermission(std::move(callback));
}
void AppShimInterceptorForTesting::BindChildHistogramFetcherFactory(::mojo::PendingReceiver<::metrics::mojom::ChildHistogramFetcherFactory> receiver) {
  GetForwardingInterface()->BindChildHistogramFetcherFactory(
    std::move(receiver)
    );
}
AppShimAsyncWaiter::AppShimAsyncWaiter(
    AppShim* proxy) : proxy_(proxy) {}

AppShimAsyncWaiter::~AppShimAsyncWaiter() = default;


void AppShimAsyncWaiter::RequestNotificationPermission(
    ::mac_notifications::mojom::RequestPermissionResult* out_result) {
  base::RunLoop loop;
  proxy_->RequestNotificationPermission(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mac_notifications::mojom::RequestPermissionResult* out_result
,
             ::mac_notifications::mojom::RequestPermissionResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::mac_notifications::mojom::RequestPermissionResult AppShimAsyncWaiter::RequestNotificationPermission(
    ) {
  ::mac_notifications::mojom::RequestPermissionResult async_wait_result;
  RequestNotificationPermission(&async_wait_result);
  return async_wait_result;
}




void AppShimHostInterceptorForTesting::FocusApp() {
  GetForwardingInterface()->FocusApp();
}
void AppShimHostInterceptorForTesting::ReopenApp() {
  GetForwardingInterface()->ReopenApp();
}
void AppShimHostInterceptorForTesting::FilesOpened(const std::vector<::base::FilePath>& files) {
  GetForwardingInterface()->FilesOpened(
    std::move(files)
    );
}
void AppShimHostInterceptorForTesting::ProfileSelectedFromMenu(const ::base::FilePath& profile_path) {
  GetForwardingInterface()->ProfileSelectedFromMenu(
    std::move(profile_path)
    );
}
void AppShimHostInterceptorForTesting::OpenAppSettings() {
  GetForwardingInterface()->OpenAppSettings();
}
void AppShimHostInterceptorForTesting::UrlsOpened(const std::vector<::GURL>& urls) {
  GetForwardingInterface()->UrlsOpened(
    std::move(urls)
    );
}
void AppShimHostInterceptorForTesting::OpenAppWithOverrideUrl(const ::GURL& override_url) {
  GetForwardingInterface()->OpenAppWithOverrideUrl(
    std::move(override_url)
    );
}
void AppShimHostInterceptorForTesting::EnableAccessibilitySupport(AppShimScreenReaderSupportMode mode) {
  GetForwardingInterface()->EnableAccessibilitySupport(
    std::move(mode)
    );
}
void AppShimHostInterceptorForTesting::ApplicationWillTerminate() {
  GetForwardingInterface()->ApplicationWillTerminate();
}
void AppShimHostInterceptorForTesting::NotificationPermissionStatusChanged(::mac_notifications::mojom::PermissionStatus status) {
  GetForwardingInterface()->NotificationPermissionStatusChanged(
    std::move(status)
    );
}
AppShimHostAsyncWaiter::AppShimHostAsyncWaiter(
    AppShimHost* proxy) : proxy_(proxy) {}

AppShimHostAsyncWaiter::~AppShimHostAsyncWaiter() = default;





void AppShimHostBootstrapInterceptorForTesting::OnShimConnected(::mojo::PendingReceiver<AppShimHost> host_receiver, AppShimInfoPtr app_shim_info, OnShimConnectedCallback callback) {
  GetForwardingInterface()->OnShimConnected(
    std::move(host_receiver)
    , 
    std::move(app_shim_info)
    , std::move(callback));
}
AppShimHostBootstrapAsyncWaiter::AppShimHostBootstrapAsyncWaiter(
    AppShimHostBootstrap* proxy) : proxy_(proxy) {}

AppShimHostBootstrapAsyncWaiter::~AppShimHostBootstrapAsyncWaiter() = default;


void AppShimHostBootstrapAsyncWaiter::OnShimConnected(
    ::mojo::PendingReceiver<AppShimHost> host_receiver, AppShimInfoPtr app_shim_info, AppShimLaunchResult* out_launch_result, ::variations::VariationsCommandLine* out_feature_state, ::mojo::PendingReceiver<AppShim>* out_app_shim_receiver) {
  base::RunLoop loop;
  proxy_->OnShimConnected(
      std::move(host_receiver),
      std::move(app_shim_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             AppShimLaunchResult* out_launch_result
,
             ::variations::VariationsCommandLine* out_feature_state
,
             ::mojo::PendingReceiver<AppShim>* out_app_shim_receiver
,
             AppShimLaunchResult launch_result,
             ::variations::VariationsCommandLine feature_state,
             ::mojo::PendingReceiver<AppShim> app_shim_receiver) {*out_launch_result = std::move(launch_result);*out_feature_state = std::move(feature_state);*out_app_shim_receiver = std::move(app_shim_receiver);
            loop->Quit();
          },
          &loop,
          out_launch_result,
          out_feature_state,
          out_app_shim_receiver));
  loop.Run();
}








}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif