// chrome/common/mac/app_shim.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_MAC_APP_SHIM_MOJOM_PARAMS_DATA_H_
#define CHROME_COMMON_MAC_APP_SHIM_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace chrome::mojom {
namespace internal {
class  AppShim_CreateRemoteCocoaApplication_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedEndpointHandle_Data application;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AppShim_CreateRemoteCocoaApplication_Params_Data>;

  AppShim_CreateRemoteCocoaApplication_Params_Data();
  ~AppShim_CreateRemoteCocoaApplication_Params_Data() = delete;
};
static_assert(sizeof(AppShim_CreateRemoteCocoaApplication_Params_Data) == 16,
              "Bad sizeof(AppShim_CreateRemoteCocoaApplication_Params_Data)");
class  AppShim_CreateCommandDispatcherForWidget_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t widget_id;

 private:
  friend class mojo::internal::MessageFragment<AppShim_CreateCommandDispatcherForWidget_Params_Data>;

  AppShim_CreateCommandDispatcherForWidget_Params_Data();
  ~AppShim_CreateCommandDispatcherForWidget_Params_Data() = delete;
};
static_assert(sizeof(AppShim_CreateCommandDispatcherForWidget_Params_Data) == 16,
              "Bad sizeof(AppShim_CreateCommandDispatcherForWidget_Params_Data)");
class  AppShim_SetUserAttention_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t attention_type;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AppShim_SetUserAttention_Params_Data>;

  AppShim_SetUserAttention_Params_Data();
  ~AppShim_SetUserAttention_Params_Data() = delete;
};
static_assert(sizeof(AppShim_SetUserAttention_Params_Data) == 16,
              "Bad sizeof(AppShim_SetUserAttention_Params_Data)");
class  AppShim_SetBadgeLabel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> badge_label;

 private:
  friend class mojo::internal::MessageFragment<AppShim_SetBadgeLabel_Params_Data>;

  AppShim_SetBadgeLabel_Params_Data();
  ~AppShim_SetBadgeLabel_Params_Data() = delete;
};
static_assert(sizeof(AppShim_SetBadgeLabel_Params_Data) == 16,
              "Bad sizeof(AppShim_SetBadgeLabel_Params_Data)");
class  AppShim_UpdateProfileMenu_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ProfileMenuItem_Data>>> profile_menu_items;

 private:
  friend class mojo::internal::MessageFragment<AppShim_UpdateProfileMenu_Params_Data>;

  AppShim_UpdateProfileMenu_Params_Data();
  ~AppShim_UpdateProfileMenu_Params_Data() = delete;
};
static_assert(sizeof(AppShim_UpdateProfileMenu_Params_Data) == 16,
              "Bad sizeof(AppShim_UpdateProfileMenu_Params_Data)");
class  AppShim_UpdateApplicationDockMenu_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ApplicationDockMenuItem_Data>>> dock_menu_items;

 private:
  friend class mojo::internal::MessageFragment<AppShim_UpdateApplicationDockMenu_Params_Data>;

  AppShim_UpdateApplicationDockMenu_Params_Data();
  ~AppShim_UpdateApplicationDockMenu_Params_Data() = delete;
};
static_assert(sizeof(AppShim_UpdateApplicationDockMenu_Params_Data) == 16,
              "Bad sizeof(AppShim_UpdateApplicationDockMenu_Params_Data)");
class  AppShim_BindNotificationProvider_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data provider;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AppShim_BindNotificationProvider_Params_Data>;

  AppShim_BindNotificationProvider_Params_Data();
  ~AppShim_BindNotificationProvider_Params_Data() = delete;
};
static_assert(sizeof(AppShim_BindNotificationProvider_Params_Data) == 16,
              "Bad sizeof(AppShim_BindNotificationProvider_Params_Data)");
class  AppShim_RequestNotificationPermission_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AppShim_RequestNotificationPermission_Params_Data>;

  AppShim_RequestNotificationPermission_Params_Data();
  ~AppShim_RequestNotificationPermission_Params_Data() = delete;
};
static_assert(sizeof(AppShim_RequestNotificationPermission_Params_Data) == 8,
              "Bad sizeof(AppShim_RequestNotificationPermission_Params_Data)");
class  AppShim_RequestNotificationPermission_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AppShim_RequestNotificationPermission_ResponseParams_Data>;

  AppShim_RequestNotificationPermission_ResponseParams_Data();
  ~AppShim_RequestNotificationPermission_ResponseParams_Data() = delete;
};
static_assert(sizeof(AppShim_RequestNotificationPermission_ResponseParams_Data) == 16,
              "Bad sizeof(AppShim_RequestNotificationPermission_ResponseParams_Data)");
class  AppShim_BindChildHistogramFetcherFactory_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AppShim_BindChildHistogramFetcherFactory_Params_Data>;

  AppShim_BindChildHistogramFetcherFactory_Params_Data();
  ~AppShim_BindChildHistogramFetcherFactory_Params_Data() = delete;
};
static_assert(sizeof(AppShim_BindChildHistogramFetcherFactory_Params_Data) == 16,
              "Bad sizeof(AppShim_BindChildHistogramFetcherFactory_Params_Data)");
class  AppShimHost_FocusApp_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AppShimHost_FocusApp_Params_Data>;

  AppShimHost_FocusApp_Params_Data();
  ~AppShimHost_FocusApp_Params_Data() = delete;
};
static_assert(sizeof(AppShimHost_FocusApp_Params_Data) == 8,
              "Bad sizeof(AppShimHost_FocusApp_Params_Data)");
class  AppShimHost_ReopenApp_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AppShimHost_ReopenApp_Params_Data>;

  AppShimHost_ReopenApp_Params_Data();
  ~AppShimHost_ReopenApp_Params_Data() = delete;
};
static_assert(sizeof(AppShimHost_ReopenApp_Params_Data) == 8,
              "Bad sizeof(AppShimHost_ReopenApp_Params_Data)");
class  AppShimHost_FilesOpened_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data>>> files;

 private:
  friend class mojo::internal::MessageFragment<AppShimHost_FilesOpened_Params_Data>;

  AppShimHost_FilesOpened_Params_Data();
  ~AppShimHost_FilesOpened_Params_Data() = delete;
};
static_assert(sizeof(AppShimHost_FilesOpened_Params_Data) == 16,
              "Bad sizeof(AppShimHost_FilesOpened_Params_Data)");
class  AppShimHost_ProfileSelectedFromMenu_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> profile_path;

 private:
  friend class mojo::internal::MessageFragment<AppShimHost_ProfileSelectedFromMenu_Params_Data>;

  AppShimHost_ProfileSelectedFromMenu_Params_Data();
  ~AppShimHost_ProfileSelectedFromMenu_Params_Data() = delete;
};
static_assert(sizeof(AppShimHost_ProfileSelectedFromMenu_Params_Data) == 16,
              "Bad sizeof(AppShimHost_ProfileSelectedFromMenu_Params_Data)");
class  AppShimHost_OpenAppSettings_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AppShimHost_OpenAppSettings_Params_Data>;

  AppShimHost_OpenAppSettings_Params_Data();
  ~AppShimHost_OpenAppSettings_Params_Data() = delete;
};
static_assert(sizeof(AppShimHost_OpenAppSettings_Params_Data) == 8,
              "Bad sizeof(AppShimHost_OpenAppSettings_Params_Data)");
class  AppShimHost_UrlsOpened_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::url::mojom::internal::Url_Data>>> urls;

 private:
  friend class mojo::internal::MessageFragment<AppShimHost_UrlsOpened_Params_Data>;

  AppShimHost_UrlsOpened_Params_Data();
  ~AppShimHost_UrlsOpened_Params_Data() = delete;
};
static_assert(sizeof(AppShimHost_UrlsOpened_Params_Data) == 16,
              "Bad sizeof(AppShimHost_UrlsOpened_Params_Data)");
class  AppShimHost_OpenAppWithOverrideUrl_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> override_url;

 private:
  friend class mojo::internal::MessageFragment<AppShimHost_OpenAppWithOverrideUrl_Params_Data>;

  AppShimHost_OpenAppWithOverrideUrl_Params_Data();
  ~AppShimHost_OpenAppWithOverrideUrl_Params_Data() = delete;
};
static_assert(sizeof(AppShimHost_OpenAppWithOverrideUrl_Params_Data) == 16,
              "Bad sizeof(AppShimHost_OpenAppWithOverrideUrl_Params_Data)");
class  AppShimHost_EnableAccessibilitySupport_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t mode;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AppShimHost_EnableAccessibilitySupport_Params_Data>;

  AppShimHost_EnableAccessibilitySupport_Params_Data();
  ~AppShimHost_EnableAccessibilitySupport_Params_Data() = delete;
};
static_assert(sizeof(AppShimHost_EnableAccessibilitySupport_Params_Data) == 16,
              "Bad sizeof(AppShimHost_EnableAccessibilitySupport_Params_Data)");
class  AppShimHost_ApplicationWillTerminate_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<AppShimHost_ApplicationWillTerminate_Params_Data>;

  AppShimHost_ApplicationWillTerminate_Params_Data();
  ~AppShimHost_ApplicationWillTerminate_Params_Data() = delete;
};
static_assert(sizeof(AppShimHost_ApplicationWillTerminate_Params_Data) == 8,
              "Bad sizeof(AppShimHost_ApplicationWillTerminate_Params_Data)");
class  AppShimHost_NotificationPermissionStatusChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<AppShimHost_NotificationPermissionStatusChanged_Params_Data>;

  AppShimHost_NotificationPermissionStatusChanged_Params_Data();
  ~AppShimHost_NotificationPermissionStatusChanged_Params_Data() = delete;
};
static_assert(sizeof(AppShimHost_NotificationPermissionStatusChanged_Params_Data) == 16,
              "Bad sizeof(AppShimHost_NotificationPermissionStatusChanged_Params_Data)");
class  AppShimHostBootstrap_OnShimConnected_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data host_receiver;
  uint8_t pad0_[4];
  mojo::internal::Pointer<internal::AppShimInfo_Data> app_shim_info;

 private:
  friend class mojo::internal::MessageFragment<AppShimHostBootstrap_OnShimConnected_Params_Data>;

  AppShimHostBootstrap_OnShimConnected_Params_Data();
  ~AppShimHostBootstrap_OnShimConnected_Params_Data() = delete;
};
static_assert(sizeof(AppShimHostBootstrap_OnShimConnected_Params_Data) == 24,
              "Bad sizeof(AppShimHostBootstrap_OnShimConnected_Params_Data)");
class  AppShimHostBootstrap_OnShimConnected_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t launch_result;
  mojo::internal::Handle_Data app_shim_receiver;
  mojo::internal::Pointer<internal::FeatureState_Data> feature_state;

 private:
  friend class mojo::internal::MessageFragment<AppShimHostBootstrap_OnShimConnected_ResponseParams_Data>;

  AppShimHostBootstrap_OnShimConnected_ResponseParams_Data();
  ~AppShimHostBootstrap_OnShimConnected_ResponseParams_Data() = delete;
};
static_assert(sizeof(AppShimHostBootstrap_OnShimConnected_ResponseParams_Data) == 24,
              "Bad sizeof(AppShimHostBootstrap_OnShimConnected_ResponseParams_Data)");

}  // namespace internal


class AppShim_CreateRemoteCocoaApplication_ParamsDataView {
 public:
  AppShim_CreateRemoteCocoaApplication_ParamsDataView() = default;

  AppShim_CreateRemoteCocoaApplication_ParamsDataView(
      internal::AppShim_CreateRemoteCocoaApplication_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeApplication() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::remote_cocoa::mojom::ApplicationAssociatedRequestDataView>(
            &data_->application, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::AppShim_CreateRemoteCocoaApplication_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShim_CreateCommandDispatcherForWidget_ParamsDataView {
 public:
  AppShim_CreateCommandDispatcherForWidget_ParamsDataView() = default;

  AppShim_CreateCommandDispatcherForWidget_ParamsDataView(
      internal::AppShim_CreateCommandDispatcherForWidget_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t widget_id() const {
    return data_->widget_id;
  }
 private:
  internal::AppShim_CreateCommandDispatcherForWidget_Params_Data* data_ = nullptr;
};


class AppShim_SetUserAttention_ParamsDataView {
 public:
  AppShim_SetUserAttention_ParamsDataView() = default;

  AppShim_SetUserAttention_ParamsDataView(
      internal::AppShim_SetUserAttention_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAttentionType(UserType* output) const {
    auto data_value = data_->attention_type;
    return mojo::internal::Deserialize<::chrome::mojom::AppShimAttentionType>(
        data_value, output);
  }
  AppShimAttentionType attention_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::chrome::mojom::AppShimAttentionType>(data_->attention_type));
  }
 private:
  internal::AppShim_SetUserAttention_Params_Data* data_ = nullptr;
};


class AppShim_SetBadgeLabel_ParamsDataView {
 public:
  AppShim_SetBadgeLabel_ParamsDataView() = default;

  AppShim_SetBadgeLabel_ParamsDataView(
      internal::AppShim_SetBadgeLabel_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBadgeLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBadgeLabel(UserType* output) {
    
    auto* pointer = data_->badge_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AppShim_SetBadgeLabel_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShim_UpdateProfileMenu_ParamsDataView {
 public:
  AppShim_UpdateProfileMenu_ParamsDataView() = default;

  AppShim_UpdateProfileMenu_ParamsDataView(
      internal::AppShim_UpdateProfileMenu_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProfileMenuItemsDataView(
      mojo::ArrayDataView<ProfileMenuItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProfileMenuItems(UserType* output) {
    
    auto* pointer = data_->profile_menu_items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::chrome::mojom::ProfileMenuItemDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AppShim_UpdateProfileMenu_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShim_UpdateApplicationDockMenu_ParamsDataView {
 public:
  AppShim_UpdateApplicationDockMenu_ParamsDataView() = default;

  AppShim_UpdateApplicationDockMenu_ParamsDataView(
      internal::AppShim_UpdateApplicationDockMenu_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDockMenuItemsDataView(
      mojo::ArrayDataView<ApplicationDockMenuItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDockMenuItems(UserType* output) {
    
    auto* pointer = data_->dock_menu_items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::chrome::mojom::ApplicationDockMenuItemDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AppShim_UpdateApplicationDockMenu_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShim_BindNotificationProvider_ParamsDataView {
 public:
  AppShim_BindNotificationProvider_ParamsDataView() = default;

  AppShim_BindNotificationProvider_ParamsDataView(
      internal::AppShim_BindNotificationProvider_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::mac_notifications::mojom::MacNotificationProviderInterfaceBase>>(
            &data_->provider, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::AppShim_BindNotificationProvider_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShim_RequestNotificationPermission_ParamsDataView {
 public:
  AppShim_RequestNotificationPermission_ParamsDataView() = default;

  AppShim_RequestNotificationPermission_ParamsDataView(
      internal::AppShim_RequestNotificationPermission_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AppShim_RequestNotificationPermission_Params_Data* data_ = nullptr;
};


class AppShim_RequestNotificationPermission_ResponseParamsDataView {
 public:
  AppShim_RequestNotificationPermission_ResponseParamsDataView() = default;

  AppShim_RequestNotificationPermission_ResponseParamsDataView(
      internal::AppShim_RequestNotificationPermission_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::mac_notifications::mojom::RequestPermissionResult>(
        data_value, output);
  }
  ::mac_notifications::mojom::RequestPermissionResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mac_notifications::mojom::RequestPermissionResult>(data_->result));
  }
 private:
  internal::AppShim_RequestNotificationPermission_ResponseParams_Data* data_ = nullptr;
};


class AppShim_BindChildHistogramFetcherFactory_ParamsDataView {
 public:
  AppShim_BindChildHistogramFetcherFactory_ParamsDataView() = default;

  AppShim_BindChildHistogramFetcherFactory_ParamsDataView(
      internal::AppShim_BindChildHistogramFetcherFactory_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::metrics::mojom::ChildHistogramFetcherFactoryInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::AppShim_BindChildHistogramFetcherFactory_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShimHost_FocusApp_ParamsDataView {
 public:
  AppShimHost_FocusApp_ParamsDataView() = default;

  AppShimHost_FocusApp_ParamsDataView(
      internal::AppShimHost_FocusApp_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AppShimHost_FocusApp_Params_Data* data_ = nullptr;
};


class AppShimHost_ReopenApp_ParamsDataView {
 public:
  AppShimHost_ReopenApp_ParamsDataView() = default;

  AppShimHost_ReopenApp_ParamsDataView(
      internal::AppShimHost_ReopenApp_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AppShimHost_ReopenApp_Params_Data* data_ = nullptr;
};


class AppShimHost_FilesOpened_ParamsDataView {
 public:
  AppShimHost_FilesOpened_ParamsDataView() = default;

  AppShimHost_FilesOpened_ParamsDataView(
      internal::AppShimHost_FilesOpened_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFiles(UserType* output) {
    
    auto* pointer = data_->files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AppShimHost_FilesOpened_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShimHost_ProfileSelectedFromMenu_ParamsDataView {
 public:
  AppShimHost_ProfileSelectedFromMenu_ParamsDataView() = default;

  AppShimHost_ProfileSelectedFromMenu_ParamsDataView(
      internal::AppShimHost_ProfileSelectedFromMenu_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProfilePathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProfilePath(UserType* output) {
    
    auto* pointer = data_->profile_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::AppShimHost_ProfileSelectedFromMenu_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShimHost_OpenAppSettings_ParamsDataView {
 public:
  AppShimHost_OpenAppSettings_ParamsDataView() = default;

  AppShimHost_OpenAppSettings_ParamsDataView(
      internal::AppShimHost_OpenAppSettings_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AppShimHost_OpenAppSettings_Params_Data* data_ = nullptr;
};


class AppShimHost_UrlsOpened_ParamsDataView {
 public:
  AppShimHost_UrlsOpened_ParamsDataView() = default;

  AppShimHost_UrlsOpened_ParamsDataView(
      internal::AppShimHost_UrlsOpened_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrls(UserType* output) {
    
    auto* pointer = data_->urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AppShimHost_UrlsOpened_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShimHost_OpenAppWithOverrideUrl_ParamsDataView {
 public:
  AppShimHost_OpenAppWithOverrideUrl_ParamsDataView() = default;

  AppShimHost_OpenAppWithOverrideUrl_ParamsDataView(
      internal::AppShimHost_OpenAppWithOverrideUrl_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOverrideUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverrideUrl(UserType* output) {
    
    auto* pointer = data_->override_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::AppShimHost_OpenAppWithOverrideUrl_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShimHost_EnableAccessibilitySupport_ParamsDataView {
 public:
  AppShimHost_EnableAccessibilitySupport_ParamsDataView() = default;

  AppShimHost_EnableAccessibilitySupport_ParamsDataView(
      internal::AppShimHost_EnableAccessibilitySupport_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::chrome::mojom::AppShimScreenReaderSupportMode>(
        data_value, output);
  }
  AppShimScreenReaderSupportMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::chrome::mojom::AppShimScreenReaderSupportMode>(data_->mode));
  }
 private:
  internal::AppShimHost_EnableAccessibilitySupport_Params_Data* data_ = nullptr;
};


class AppShimHost_ApplicationWillTerminate_ParamsDataView {
 public:
  AppShimHost_ApplicationWillTerminate_ParamsDataView() = default;

  AppShimHost_ApplicationWillTerminate_ParamsDataView(
      internal::AppShimHost_ApplicationWillTerminate_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::AppShimHost_ApplicationWillTerminate_Params_Data* data_ = nullptr;
};


class AppShimHost_NotificationPermissionStatusChanged_ParamsDataView {
 public:
  AppShimHost_NotificationPermissionStatusChanged_ParamsDataView() = default;

  AppShimHost_NotificationPermissionStatusChanged_ParamsDataView(
      internal::AppShimHost_NotificationPermissionStatusChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::mac_notifications::mojom::PermissionStatus>(
        data_value, output);
  }
  ::mac_notifications::mojom::PermissionStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mac_notifications::mojom::PermissionStatus>(data_->status));
  }
 private:
  internal::AppShimHost_NotificationPermissionStatusChanged_Params_Data* data_ = nullptr;
};


class AppShimHostBootstrap_OnShimConnected_ParamsDataView {
 public:
  AppShimHostBootstrap_OnShimConnected_ParamsDataView() = default;

  AppShimHostBootstrap_OnShimConnected_ParamsDataView(
      internal::AppShimHostBootstrap_OnShimConnected_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeHostReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::chrome::mojom::AppShimHostInterfaceBase>>(
            &data_->host_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetAppShimInfoDataView(
      AppShimInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppShimInfo(UserType* output) {
    
    auto* pointer = data_->app_shim_info.Get();
    return mojo::internal::Deserialize<::chrome::mojom::AppShimInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::AppShimHostBootstrap_OnShimConnected_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShimHostBootstrap_OnShimConnected_ResponseParamsDataView {
 public:
  AppShimHostBootstrap_OnShimConnected_ResponseParamsDataView() = default;

  AppShimHostBootstrap_OnShimConnected_ResponseParamsDataView(
      internal::AppShimHostBootstrap_OnShimConnected_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadLaunchResult(UserType* output) const {
    auto data_value = data_->launch_result;
    return mojo::internal::Deserialize<::chrome::mojom::AppShimLaunchResult>(
        data_value, output);
  }
  AppShimLaunchResult launch_result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::chrome::mojom::AppShimLaunchResult>(data_->launch_result));
  }
  inline void GetFeatureStateDataView(
      FeatureStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatureState(UserType* output) {
    
    auto* pointer = data_->feature_state.Get();
    return mojo::internal::Deserialize<::chrome::mojom::FeatureStateDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeAppShimReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::chrome::mojom::AppShimInterfaceBase>>(
            &data_->app_shim_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::AppShimHostBootstrap_OnShimConnected_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};







inline void AppShim_SetBadgeLabel_ParamsDataView::GetBadgeLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->badge_label.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AppShim_UpdateProfileMenu_ParamsDataView::GetProfileMenuItemsDataView(
    mojo::ArrayDataView<ProfileMenuItemDataView>* output) {
  auto pointer = data_->profile_menu_items.Get();
  *output = mojo::ArrayDataView<ProfileMenuItemDataView>(pointer, message_);
}


inline void AppShim_UpdateApplicationDockMenu_ParamsDataView::GetDockMenuItemsDataView(
    mojo::ArrayDataView<ApplicationDockMenuItemDataView>* output) {
  auto pointer = data_->dock_menu_items.Get();
  *output = mojo::ArrayDataView<ApplicationDockMenuItemDataView>(pointer, message_);
}














inline void AppShimHost_FilesOpened_ParamsDataView::GetFilesDataView(
    mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output) {
  auto pointer = data_->files.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>(pointer, message_);
}


inline void AppShimHost_ProfileSelectedFromMenu_ParamsDataView::GetProfilePathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->profile_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}




inline void AppShimHost_UrlsOpened_ParamsDataView::GetUrlsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->urls.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}


inline void AppShimHost_OpenAppWithOverrideUrl_ParamsDataView::GetOverrideUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->override_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}








inline void AppShimHostBootstrap_OnShimConnected_ParamsDataView::GetAppShimInfoDataView(
    AppShimInfoDataView* output) {
  auto pointer = data_->app_shim_info.Get();
  *output = AppShimInfoDataView(pointer, message_);
}


inline void AppShimHostBootstrap_OnShimConnected_ResponseParamsDataView::GetFeatureStateDataView(
    FeatureStateDataView* output) {
  auto pointer = data_->feature_state.Get();
  *output = FeatureStateDataView(pointer, message_);
}



}  // chrome::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_COMMON_MAC_APP_SHIM_MOJOM_PARAMS_DATA_H_