// chrome/common/mac/app_shim.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_MAC_APP_SHIM_MOJOM_DATA_VIEW_H_
#define CHROME_COMMON_MAC_APP_SHIM_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "chrome/common/mac/app_shim.mojom-shared-internal.h"
#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-shared.h"
#include "components/remote_cocoa/common/application.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/metrics/public/mojom/histogram_fetcher.mojom-shared.h"


namespace chrome::mojom {
class ProfileMenuItemDataView;

class ApplicationDockMenuItemDataView;

class AppShimInfoDataView;

class FeatureStateDataView;



}  // chrome::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::chrome::mojom::ProfileMenuItemDataView> {
  using Data = ::chrome::mojom::internal::ProfileMenuItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::chrome::mojom::ApplicationDockMenuItemDataView> {
  using Data = ::chrome::mojom::internal::ApplicationDockMenuItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::chrome::mojom::AppShimInfoDataView> {
  using Data = ::chrome::mojom::internal::AppShimInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::chrome::mojom::FeatureStateDataView> {
  using Data = ::chrome::mojom::internal::FeatureState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace chrome::mojom {


enum class AppShimLaunchType : int32_t {
  
  kRegisterOnly = 0,
  
  kNormal = 1,
  
  kNotificationAction = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, AppShimLaunchType value);
inline bool IsKnownEnumValue(AppShimLaunchType value) {
  return internal::AppShimLaunchType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AppShimLaunchResult : int32_t {
  
  kSuccess = 0,
  
  kSuccessAndDisconnect = 1,
  
  kDuplicateHost = 2,
  
  kProfileNotFound = 3,
  
  kAppNotFound = 4,
  
  kProfileLocked = 5,
  
  kFailedValidation = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, AppShimLaunchResult value);
inline bool IsKnownEnumValue(AppShimLaunchResult value) {
  return internal::AppShimLaunchResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AppShimAttentionType : int32_t {
  
  kCancel = 0,
  
  kCritical = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, AppShimAttentionType value);
inline bool IsKnownEnumValue(AppShimAttentionType value) {
  return internal::AppShimAttentionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AppShimLoginItemRestoreState : int32_t {
  
  kNone = 0,
  
  kWindowed = 1,
  
  kHidden = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, AppShimLoginItemRestoreState value);
inline bool IsKnownEnumValue(AppShimLoginItemRestoreState value) {
  return internal::AppShimLoginItemRestoreState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AppShimScreenReaderSupportMode : int32_t {
  
  kPartial = 0,
  
  kComplete = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, AppShimScreenReaderSupportMode value);
inline bool IsKnownEnumValue(AppShimScreenReaderSupportMode value) {
  return internal::AppShimScreenReaderSupportMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AppShimInterfaceBase {};

using AppShimPtrDataView =
    mojo::InterfacePtrDataView<AppShimInterfaceBase>;
using AppShimRequestDataView =
    mojo::InterfaceRequestDataView<AppShimInterfaceBase>;
using AppShimAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AppShimInterfaceBase>;
using AppShimAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AppShimInterfaceBase>;
class AppShimHostInterfaceBase {};

using AppShimHostPtrDataView =
    mojo::InterfacePtrDataView<AppShimHostInterfaceBase>;
using AppShimHostRequestDataView =
    mojo::InterfaceRequestDataView<AppShimHostInterfaceBase>;
using AppShimHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AppShimHostInterfaceBase>;
using AppShimHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AppShimHostInterfaceBase>;
class AppShimHostBootstrapInterfaceBase {};

using AppShimHostBootstrapPtrDataView =
    mojo::InterfacePtrDataView<AppShimHostBootstrapInterfaceBase>;
using AppShimHostBootstrapRequestDataView =
    mojo::InterfaceRequestDataView<AppShimHostBootstrapInterfaceBase>;
using AppShimHostBootstrapAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AppShimHostBootstrapInterfaceBase>;
using AppShimHostBootstrapAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AppShimHostBootstrapInterfaceBase>;


class ProfileMenuItemDataView {
 public:
  ProfileMenuItemDataView() = default;

  ProfileMenuItemDataView(
      internal::ProfileMenuItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::gfx::mojom::ImageSkiaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::ImageSkiaDataView, UserType>(),
    "Attempting to read the optional `icon` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIcon` instead "
    "of `ReadIcon if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ImageSkiaDataView>(
        pointer, output, message_);
  }
  uint32_t menu_index() const {
    return data_->menu_index;
  }
  bool active() const {
    return data_->active;
  }
  inline void GetProfilePathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProfilePath(UserType* output) {
    
    auto* pointer = data_->profile_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProfileMenuItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ApplicationDockMenuItemDataView {
 public:
  ApplicationDockMenuItemDataView() = default;

  ApplicationDockMenuItemDataView(
      internal::ApplicationDockMenuItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::ApplicationDockMenuItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppShimInfoDataView {
 public:
  AppShimInfoDataView() = default;

  AppShimInfoDataView(
      internal::AppShimInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProfilePathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProfilePath(UserType* output) {
    
    auto* pointer = data_->profile_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetAppIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppId(UserType* output) {
    
    auto* pointer = data_->app_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAppUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppUrl(UserType* output) {
    
    auto* pointer = data_->app_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLaunchType(UserType* output) const {
    auto data_value = data_->launch_type;
    return mojo::internal::Deserialize<::chrome::mojom::AppShimLaunchType>(
        data_value, output);
  }
  AppShimLaunchType launch_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::chrome::mojom::AppShimLaunchType>(data_->launch_type));
  }
  inline void GetFilesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFiles(UserType* output) {
    
    auto* pointer = data_->files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLoginItemRestoreState(UserType* output) const {
    auto data_value = data_->login_item_restore_state;
    return mojo::internal::Deserialize<::chrome::mojom::AppShimLoginItemRestoreState>(
        data_value, output);
  }
  AppShimLoginItemRestoreState login_item_restore_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::chrome::mojom::AppShimLoginItemRestoreState>(data_->login_item_restore_state));
  }
  inline void GetUrlsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrls(UserType* output) {
    
    auto* pointer = data_->urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeNotificationActionHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::mac_notifications::mojom::MacNotificationActionHandlerInterfaceBase>>(
            &data_->notification_action_handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::AppShimInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FeatureStateDataView {
 public:
  FeatureStateDataView() = default;

  FeatureStateDataView(
      internal::FeatureState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFieldTrialStatesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFieldTrialStates(UserType* output) {
    
    auto* pointer = data_->field_trial_states.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFieldTrialParamsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFieldTrialParams(UserType* output) {
    
    auto* pointer = data_->field_trial_params.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEnableFeaturesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnableFeatures(UserType* output) {
    
    auto* pointer = data_->enable_features.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDisableFeaturesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisableFeatures(UserType* output) {
    
    auto* pointer = data_->disable_features.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FeatureState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // chrome::mojom

#endif  // CHROME_COMMON_MAC_APP_SHIM_MOJOM_DATA_VIEW_H_